/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.communication.ReturnChannelHandler;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

class ReturnChannelHandlerTest {
    private MockUI ui = new MockUI();
    private AtomicReference<JsonNode> observedArguments = new AtomicReference();
    private SerializableConsumer<ArrayNode> observingConsumer = (SerializableConsumer & Serializable)arguments -> {
        Assertions.assertNotNull((Object)arguments, (String)"Arguments should not be null");
        Assertions.assertNull((Object)this.observedArguments.getAndSet((JsonNode)arguments), (String)"There should be no previous arguments");
    };
    private ArrayNode args = JacksonUtils.createArrayNode();

    ReturnChannelHandlerTest() {
    }

    @Test
    public void happyPath_everythingWorks() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        this.handleMessage(registration);
        Assertions.assertSame((Object)this.args, (Object)this.observedArguments.get(), (String)"Handler should have been invoked with the given arguments.");
    }

    @Test
    public void noReturnChannelMap_invocationIgnored() {
        StateNode nodeWithoutMap = new StateNode(new Class[0]);
        ((ElementChildrenList)this.ui.getElement().getNode().getFeature(ElementChildrenList.class)).add(0, nodeWithoutMap);
        this.handleMessage(nodeWithoutMap.getId(), 0);
    }

    @Test
    public void returnChannelMapNotInitialized_noInitializedAfterInvocation() {
        this.handleMessage(this.ui.getElement().getNode().getId(), 0);
        Assertions.assertFalse((boolean)this.ui.getElement().getNode().getFeatureIfInitialized(ReturnChannelMap.class).isPresent(), (String)"Feature should not be initialized");
    }

    @Test
    public void unregisteredChannel_invocationIgnored() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        registration.remove();
        this.handleMessage(registration);
        Assertions.assertNull((Object)this.observedArguments.get(), (String)"Channel handler should not be called");
    }

    @Test
    public void disabledElement_defaultRegistration_invocationIgnored() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        this.ui.setEnabled(false);
        this.handleMessage(registration);
        Assertions.assertNull((Object)this.observedArguments.get(), (String)"Channel handler should not be called");
    }

    @Test
    public void disabledElement_registrationAlwaysAllowed_invocationProcessed() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        registration.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        this.ui.setEnabled(false);
        this.handleMessage(registration);
        Assertions.assertNotNull((Object)this.observedArguments.get(), (String)"Channel handler should be called");
    }

    @Test
    public void modalComponent_registrationExists_invocationProcessed() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        Div modal = new Div();
        this.ui.addModal(modal);
        this.handleMessage(registration);
        Assertions.assertNotNull((Object)this.observedArguments.get(), (String)"Channel handler should be called");
    }

    @Test
    public void modalComponent_unregisteredChannel_invocationIgnored() {
        ReturnChannelRegistration registration = this.registerUiChannel();
        registration.remove();
        Div modal = new Div();
        this.ui.addModal(modal);
        this.handleMessage(registration);
        Assertions.assertNull((Object)this.observedArguments.get(), (String)"Channel handler should not be called");
    }

    private void handleMessage(ReturnChannelRegistration registration) {
        this.handleMessage(registration.getStateNodeId(), registration.getChannelId());
    }

    private ReturnChannelRegistration registerUiChannel() {
        ReturnChannelRegistration registration = ((ReturnChannelMap)this.ui.getElement().getNode().getFeature(ReturnChannelMap.class)).registerChannel(this.observingConsumer);
        return registration;
    }

    private void handleMessage(int nodeId, int channelId) {
        JsonNode invocationJson = this.createInvocationJson(nodeId, channelId);
        new ReturnChannelHandler().handle((UI)this.ui, invocationJson);
    }

    private JsonNode createInvocationJson(int stateNodeId, int channelId) {
        ObjectNode invocationJson = JacksonUtils.createObjectNode();
        invocationJson.put("node", stateNodeId);
        invocationJson.put("channel", channelId);
        invocationJson.set("args", (JsonNode)this.args);
        return invocationJson;
    }

    @Tag(value="div")
    private class Div
    extends Component {
        private Div() {
        }
    }
}

