/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PwaHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PwaHandlerTest {
    private final VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
    private final VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
    private final VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);

    PwaHandlerTest() {
    }

    @Test
    public void handleRequest_noPwaRegistry_returnsFalse() throws IOException {
        PwaHandler handler = new PwaHandler((SerializableSupplier & Serializable)() -> null);
        Assertions.assertFalse((boolean)handler.handleRequest(this.session, this.request, this.response));
    }

    @Test
    public void handleRequest_pwaRegistryConfigIsDisabled_returnsFalse() throws IOException {
        PwaRegistry registry = (PwaRegistry)Mockito.mock(PwaRegistry.class);
        PwaConfiguration configuration = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)registry.getPwaConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.isEnabled()).thenReturn((Object)false);
        PwaHandler handler = new PwaHandler((SerializableSupplier & Serializable)() -> registry);
        Assertions.assertFalse((boolean)handler.handleRequest(this.session, this.request, this.response));
    }

    @Test
    public void handleRequest_pwaRegistryConfigIsEnabled_pathIsPwaResource_returnsTrue() throws IOException {
        PwaRegistry registry = (PwaRegistry)Mockito.mock(PwaRegistry.class);
        PwaConfiguration configuration = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)registry.getPwaConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.isEnabled()).thenReturn((Object)true);
        PwaHandler handler = new PwaHandler((SerializableSupplier & Serializable)() -> registry);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        Mockito.when((Object)registry.getRuntimeServiceWorkerJs()).thenReturn((Object)"");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/sw-runtime-resources-precache.js");
        Assertions.assertTrue((boolean)handler.handleRequest(this.session, this.request, this.response));
    }

    @Test
    public void handleRequest_pwaRegistryConfigIsEnabled_handlerIsInitializedOnce() throws IOException {
        PwaRegistry registry = (PwaRegistry)Mockito.mock(PwaRegistry.class);
        PwaConfiguration configuration = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)registry.getPwaConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.isEnabled()).thenReturn((Object)true);
        PwaHandler handler = new PwaHandler((SerializableSupplier & Serializable)() -> registry);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        Mockito.when((Object)registry.getRuntimeServiceWorkerJs()).thenReturn((Object)"");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/sw-runtime-resources-precache.js");
        Assertions.assertTrue((boolean)handler.handleRequest(this.session, this.request, this.response));
        Assertions.assertTrue((boolean)handler.handleRequest(this.session, this.request, this.response));
        ((PwaRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)1))).getIcons();
    }

    @Test
    public void handleRequest_writeIconOnResponseFailure_doesNotThrow() throws Exception {
        PwaRegistry registry = (PwaRegistry)Mockito.mock(PwaRegistry.class);
        PwaConfiguration configuration = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)registry.getPwaConfiguration()).thenReturn((Object)configuration);
        PwaHandler handler = new PwaHandler((SerializableSupplier & Serializable)() -> registry);
        PwaIcon icon = (PwaIcon)Mockito.spy((Object)this.createIcon(registry, 100));
        Mockito.when((Object)registry.getIcons()).thenReturn(List.of(icon));
        Mockito.when((Object)configuration.isEnabled()).thenReturn((Object)true);
        ((PwaIcon)Mockito.doAnswer(i -> {
            throw new UncheckedIOException("Failed to store the icon image into the stream provided", new IOException("Broken pipe"));
        }).when((Object)icon)).write((OutputStream)ArgumentMatchers.any());
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/icons/icon-100x100.png");
        Assertions.assertTrue((boolean)handler.handleRequest(this.session, this.request, this.response));
    }

    private PwaIcon createIcon(PwaRegistry registry, int size) throws Exception {
        Constructor ctor = PwaIcon.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, String.class);
        ctor.setAccessible(true);
        PwaIcon icon = (PwaIcon)ctor.newInstance(size, size, "icons/icon.png");
        icon.setRegistry(registry);
        icon.setImage(new BufferedImage(16, 16, 2));
        return icon;
    }
}

