/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.SessionLockCheckStrategy;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

class VaadinSessionTest {
    private VaadinSessionWithMockLogger session;
    private VaadinServlet mockServlet;
    private VaadinServletService mockService;
    private HttpSession mockHttpSession;
    private WrappedSession mockWrappedSession;
    private VaadinServletRequest vaadinRequest;
    private UI ui;
    private Lock httpSessionLock;

    VaadinSessionTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.httpSessionLock = new ReentrantLock();
        this.mockService = new MockVaadinServletService();
        this.mockServlet = this.mockService.getServlet();
        this.mockHttpSession = (HttpSession)Mockito.mock(HttpSession.class);
        this.mockWrappedSession = new WrappedHttpSession(this.mockHttpSession){
            final ReentrantLock lock;
            {
                this.lock = new ReentrantLock();
                this.lock.lock();
            }

            public Object getAttribute(String name) {
                Object res;
                try {
                    Thread.sleep(100L);
                    Assertions.assertTrue((boolean)VaadinSessionTest.this.httpSessionLock.tryLock(5L, TimeUnit.SECONDS), (String)"Deadlock detected");
                    String lockAttribute = VaadinSessionTest.this.mockService.getServiceName() + ".lock";
                    res = lockAttribute.equals(name) ? this.lock : ((VaadinSession.class.getName() + ".Mock Servlet").equals(name) ? VaadinSessionTest.this.session : super.getAttribute(name));
                    VaadinSessionTest.this.httpSessionLock.unlock();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return res;
            }
        };
        this.session = new VaadinSessionWithMockLogger((VaadinService)this.mockService);
        this.mockService.storeSession((VaadinSession)this.session, this.mockWrappedSession);
        this.ui = new UI();
        this.vaadinRequest = new VaadinServletRequest((HttpServletRequest)Mockito.mock(HttpServletRequest.class), this.mockService){

            public String getParameter(String name) {
                if ("restartApplication".equals(name) || "ignoreRestart".equals(name) || "closeApplication".equals(name)) {
                    return null;
                }
                return "1";
            }

            public String getPathInfo() {
                return "/APP/";
            }

            public String getMethod() {
                return "POST";
            }

            public WrappedSession getWrappedSession(boolean allowSessionCreation) {
                return VaadinSessionTest.this.mockWrappedSession;
            }

            public Map<String, String[]> getParameterMap() {
                return new HashMap<String, String[]>();
            }
        };
        this.ui.getInternals().setSession((VaadinSession)this.session);
        this.ui.doInit((VaadinRequest)this.vaadinRequest, this.session.getNextUIid(), "foo");
        this.session.addUI(this.ui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentInstancePollution() throws InterruptedException {
        AtomicInteger state = new AtomicInteger();
        Runnable napper = () -> {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        };
        this.session.unlock();
        try {
            Thread thread = new Thread(() -> this.session.accessSynchronously((Command & Serializable)() -> {
                state.incrementAndGet();
                while (state.get() == 1) {
                    napper.run();
                }
            }));
            thread.start();
            while (state.get() == 0) {
                napper.run();
            }
            this.session.access((Command & Serializable)() -> {
                UI.setCurrent((UI)this.ui);
                state.incrementAndGet();
            });
            AtomicReference uiRef = new AtomicReference();
            this.session.access((Command & Serializable)() -> {
                uiRef.set(UI.getCurrent());
                state.incrementAndGet();
            });
            state.incrementAndGet();
            while (state.get() < 4) {
                napper.run();
            }
            Assertions.assertNull(uiRef.get());
        }
        finally {
            this.session.lock();
        }
    }

    @Test
    @Tag(value="com.vaadin.flow.testcategory.SlowTests")
    public void testInvalidationDeadlock() {
        new Thread(() -> {
            try {
                Thread.sleep(150L);
                this.httpSessionLock.lock();
                this.mockService.fireSessionDestroy((VaadinSession)this.session);
                this.httpSessionLock.unlock();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).start();
        try {
            this.mockService.findVaadinSession((VaadinRequest)this.vaadinRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void threadLocalsAfterUnderlyingSessionTimeout() throws InterruptedException {
        AtomicBoolean detachCalled = new AtomicBoolean(false);
        this.ui.addDetachListener((ComponentEventListener & Serializable)e -> {
            detachCalled.set(true);
            Assertions.assertEquals((Object)this.ui, (Object)UI.getCurrent());
            Assertions.assertEquals((Object)((Object)this.session), (Object)VaadinSession.getCurrent());
            Assertions.assertEquals((Object)this.mockService, (Object)VaadinService.getCurrent());
            Assertions.assertEquals((Object)this.mockServlet, (Object)VaadinServlet.getCurrent());
        });
        this.session.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
        this.mockService.runPendingAccessTasks((VaadinSession)this.session);
        Assertions.assertTrue((boolean)detachCalled.get());
    }

    @Test
    @Tag(value="com.vaadin.flow.testcategory.SlowTests")
    public void threadLocalsAfterSessionDestroy() throws InterruptedException {
        AtomicBoolean detachCalled = new AtomicBoolean(false);
        this.ui.addDetachListener((ComponentEventListener & Serializable)e -> {
            detachCalled.set(true);
            Assertions.assertEquals((Object)this.ui, (Object)UI.getCurrent());
            Assertions.assertEquals((Object)((Object)this.session), (Object)VaadinSession.getCurrent());
            Assertions.assertEquals((Object)this.mockService, (Object)VaadinService.getCurrent());
            Assertions.assertEquals((Object)this.mockServlet, (Object)VaadinServlet.getCurrent());
        });
        CurrentInstance.clearAll();
        this.session.close();
        this.mockService.cleanupSession((VaadinSession)this.session);
        this.mockService.runPendingAccessTasks((VaadinSession)this.session);
        Assertions.assertTrue((boolean)detachCalled.get());
    }

    @Test
    public void testValueUnbound() {
        MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)this.mockService);
        vaadinSession.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
        Assertions.assertEquals((int)1, (int)vaadinSession.getCloseCount(), (String)"'valueUnbound' method doesn't call 'close' for the session");
        vaadinSession.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
        Assertions.assertEquals((int)1, (int)vaadinSession.getCloseCount(), (String)"'valueUnbound' method may not call 'close' method for closing session");
    }

    @Test
    @Tag(value="com.vaadin.flow.testcategory.SlowTests")
    public void threadLocalsWhenDeserializing() throws Exception {
        ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)configuration.isDevModeSessionSerializationEnabled()).thenReturn((Object)true);
        this.mockServlet.getServletContext().setAttribute(ApplicationConfiguration.class.getName(), (Object)configuration);
        VaadinSession.setCurrent((VaadinSession)this.session);
        this.session.lock();
        SerializationPushConnection pc = new SerializationPushConnection(this.ui);
        Assertions.assertEquals((Object)((Object)this.session), (Object)pc.session, (String)"Session should be set when instance is created");
        this.ui.getPushConfiguration().setPushMode(PushMode.MANUAL);
        this.ui.getInternals().setPushConnection((PushConnection)pc);
        int uiId = this.ui.getUIId();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject((Object)this.session);
        out.close();
        this.session.unlock();
        CurrentInstance.clearAll();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        VaadinSession deserializedSession = (VaadinSession)in.readObject();
        Assertions.assertNull((Object)VaadinSession.getCurrent(), (String)"Current session shouldn't leak from deserialisation");
        Assertions.assertNotSame((Object)((Object)this.session), (Object)deserializedSession, (String)"Should get a new session");
        deserializedSession.refreshTransients(this.mockWrappedSession, (VaadinService)this.mockService);
        deserializedSession.lock();
        UI deserializedUi = deserializedSession.getUIById(uiId);
        SerializationPushConnection deserializedPc = (SerializationPushConnection)deserializedUi.getInternals().getPushConnection();
        Assertions.assertEquals((Object)deserializedSession, (Object)deserializedPc.session, (String)"Current session should be available in SerializationTestLabel.readObject");
        deserializedSession.unlock();
    }

    @Test
    public void setLocale_setLocaleForAllUIs() {
        UI anotherUI = new UI();
        anotherUI.getInternals().setSession((VaadinSession)this.session);
        anotherUI.doInit((VaadinRequest)this.vaadinRequest, this.session.getNextUIid(), "foo");
        this.session.addUI(anotherUI);
        Assertions.assertEquals((int)2, (int)this.session.getUIs().size());
        Set locales = this.session.getUIs().stream().map(UI::getLocale).collect(Collectors.toSet());
        Optional<Locale> newLocale = Stream.of(Locale.getAvailableLocales()).filter(locale -> !locales.contains(locale) && !locale.toString().trim().isEmpty()).findFirst();
        this.session.setLocale(newLocale.get());
        Locale expectedlocale = newLocale.get();
        Iterator uis = this.session.getUIs().iterator();
        Assertions.assertEquals((Object)expectedlocale, (Object)((UI)uis.next()).getLocale());
        Assertions.assertEquals((Object)expectedlocale, (Object)((UI)uis.next()).getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void valueUnbound_explicitVaadinSessionClose_wrappedSessionIsNotCleanedUp() {
        final ReentrantLock lock = (ReentrantLock)Mockito.mock(ReentrantLock.class);
        Mockito.when((Object)lock.isHeldByCurrentThread()).thenReturn((Object)true);
        this.mockService = new MockVaadinServletService(){

            protected Lock getSessionLock(WrappedSession wrappedSession) {
                return lock;
            }
        };
        VaadinSession vaadinSession = new VaadinSession((VaadinService)this.mockService){

            public boolean hasLock() {
                return true;
            }
        };
        vaadinSession.sessionClosedExplicitly = true;
        WrappedSession httpSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        vaadinSession.refreshTransients(httpSession, (VaadinService)this.mockService);
        VaadinSession.setCurrent((VaadinSession)vaadinSession);
        this.mockService.setCurrentInstances((VaadinRequest)Mockito.mock(VaadinRequest.class), (VaadinResponse)Mockito.mock(VaadinResponse.class));
        try {
            vaadinSession.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
            Assertions.assertNotNull((Object)vaadinSession.getSession());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void valueUnbound_implicitVaadinSessionClose_wrappedSessionIsCleanedUp() {
        final ReentrantLock lock = (ReentrantLock)Mockito.mock(ReentrantLock.class);
        Mockito.when((Object)lock.isHeldByCurrentThread()).thenReturn((Object)true);
        this.mockService = new MockVaadinServletService(){

            protected Lock getSessionLock(WrappedSession wrappedSession) {
                return lock;
            }
        };
        VaadinSession vaadinSession = new VaadinSession((VaadinService)this.mockService){

            public boolean hasLock() {
                return true;
            }
        };
        WrappedSession httpSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        vaadinSession.refreshTransients(httpSession, (VaadinService)this.mockService);
        VaadinSession.setCurrent((VaadinSession)vaadinSession);
        this.mockService.setCurrentInstances((VaadinRequest)Mockito.mock(VaadinRequest.class), (VaadinResponse)Mockito.mock(VaadinResponse.class));
        try {
            vaadinSession.valueUnbound((HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class));
            Assertions.assertNull((Object)vaadinSession.getSession());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void setState_closedState_sessionFieldIsCleanedUp() {
        final ReentrantLock lock = (ReentrantLock)Mockito.mock(ReentrantLock.class);
        Mockito.when((Object)lock.isHeldByCurrentThread()).thenReturn((Object)true);
        this.mockService = new MockVaadinServletService(){

            protected Lock getSessionLock(WrappedSession wrappedSession) {
                return lock;
            }
        };
        VaadinSession vaadinSession = new VaadinSession((VaadinService)this.mockService);
        WrappedSession httpSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        vaadinSession.refreshTransients(httpSession, (VaadinService)this.mockService);
        vaadinSession.setState(VaadinSessionState.CLOSING);
        vaadinSession.setState(VaadinSessionState.CLOSED);
        Assertions.assertNull((Object)vaadinSession.getSession());
    }

    @Test
    public void valueUnbound_sessionIsNotInitialized_noAnyInteractions() {
        VaadinSession session = (VaadinSession)Mockito.spy(TestVaadinSession.class);
        try {
            Field serviceField = VaadinSession.class.getDeclaredField("service");
            serviceField.setAccessible(true);
            serviceField.set(session, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        HttpSessionBindingEvent event = (HttpSessionBindingEvent)Mockito.mock(HttpSessionBindingEvent.class);
        session.valueUnbound(null);
        ((VaadinSession)Mockito.verify((Object)session)).valueUnbound(null);
        ((VaadinSession)Mockito.verify((Object)session)).getLogger();
        Mockito.verifyNoInteractions((Object[])new Object[]{event});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{session});
    }

    @Test
    public void findComponent_existingComponentFound() {
        ComponentTest.TestComponent testComponent = this.createTestComponentInSession();
        int nodeId = testComponent.getElement().getNode().getId();
        int uiId = ((UI)testComponent.getUI().get()).getUIId();
        VaadinSession session = ((UI)testComponent.getUI().get()).getSession();
        Assertions.assertSame((Object)testComponent, session.findElement(uiId, nodeId).getComponent().get());
    }

    @Test
    public void findComponent_nonExistingNodeIdThrows() {
        ComponentTest.TestComponent testComponent = this.createTestComponentInSession();
        int nodeId = testComponent.getElement().getNode().getId();
        int uiId = ((UI)testComponent.getUI().get()).getUIId();
        VaadinSession session = ((UI)testComponent.getUI().get()).getSession();
        Assertions.assertThrows(IllegalArgumentException.class, () -> session.findElement(uiId, nodeId * 10));
    }

    @Test
    public void findComponent_nonExistingAppIdThrows() {
        ComponentTest.TestComponent testComponent = this.createTestComponentInSession();
        int nodeId = testComponent.getElement().getNode().getId();
        VaadinSession session = ((UI)testComponent.getUI().get()).getSession();
        Assertions.assertThrows(IllegalArgumentException.class, () -> session.findElement(123, nodeId));
    }

    private ComponentTest.TestComponent createTestComponentInSession() {
        ComponentTest.TestComponent testComponent = new ComponentTest.TestComponent();
        this.ui.add(new Component[]{testComponent});
        return testComponent;
    }

    @Test
    public void checkHasLock_noCheckInDevMode() {
        Assumptions.assumeTrue((boolean)this.session.hasLock());
        Assumptions.assumeFalse((boolean)this.session.getConfiguration().isProductionMode());
        Assertions.assertEquals((Object)SessionLockCheckStrategy.ASSERT, (Object)this.session.getConfiguration().getSessionLockCheckStrategy());
        MockDeploymentConfiguration configuration = (MockDeploymentConfiguration)this.session.getConfiguration();
        this.session.checkHasLock();
        configuration.setLockCheckStrategy(SessionLockCheckStrategy.LOG);
        this.session.mockLogger.clearLogs();
        this.session.checkHasLock();
        Assertions.assertEquals((Object)"", (Object)this.session.mockLogger.getLogs());
        configuration.setLockCheckStrategy(SessionLockCheckStrategy.ASSERT);
        this.session.checkHasLock();
    }

    @Test
    public void checkHasLock_assert() {
        MockDeploymentConfiguration configuration = (MockDeploymentConfiguration)this.session.getConfiguration();
        configuration.setProductionMode(true);
        this.session.lock();
        this.session.refreshTransients(this.mockWrappedSession, (VaadinService)this.mockService);
        this.session.unlock();
        Assumptions.assumeFalse((boolean)this.session.hasLock());
        try {
            this.session.checkHasLock();
            throw new RuntimeException("lock check passed");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void checkHasLock_throw() {
        MockDeploymentConfiguration configuration = (MockDeploymentConfiguration)this.session.getConfiguration();
        configuration.setProductionMode(true);
        configuration.setLockCheckStrategy(SessionLockCheckStrategy.THROW);
        this.session.lock();
        this.session.refreshTransients(this.mockWrappedSession, (VaadinService)this.mockService);
        this.session.unlock();
        Assumptions.assumeFalse((boolean)this.session.hasLock());
        try {
            this.session.checkHasLock();
            Assertions.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkHasLock_log() {
        MockDeploymentConfiguration configuration = (MockDeploymentConfiguration)this.session.getConfiguration();
        configuration.setProductionMode(true);
        configuration.setLockCheckStrategy(SessionLockCheckStrategy.LOG);
        this.session.lock();
        this.session.refreshTransients(this.mockWrappedSession, (VaadinService)this.mockService);
        this.session.unlock();
        Assumptions.assumeFalse((boolean)this.session.hasLock());
        this.session.checkHasLock();
        Assertions.assertTrue((boolean)this.session.mockLogger.getLogs().contains("[Warning] Cannot access state in VaadinSession or UI without locking the session.\njava.lang.IllegalStateException: Cannot access state in VaadinSession or UI without locking the session.\n\tat com.vaadin.flow.server.SessionLockCheckStrategy$2.checkHasLock(SessionLockCheckStrategy.java:"));
    }

    public static class VaadinSessionWithMockLogger
    extends VaadinSession {
        public final MockLogger mockLogger = new MockLogger();
        private DeploymentConfiguration config;

        public VaadinSessionWithMockLogger(VaadinService service) {
            super(service);
            this.mockLogger.includeStackTrace = true;
        }

        Logger getLogger() {
            return this.mockLogger;
        }

        public DeploymentConfiguration getConfiguration() {
            if (this.config == null) {
                this.config = new MockDeploymentConfiguration();
            }
            return this.config;
        }
    }

    private static class SerializationPushConnection
    extends AtmospherePushConnection {
        private transient VaadinSession session = VaadinSession.getCurrent();

        public SerializationPushConnection(UI ui) {
            super(ui);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.session = VaadinSession.getCurrent();
        }
    }

    public static class TestVaadinSession
    extends VaadinSession {
        public TestVaadinSession() {
            super((VaadinService)new MockVaadinServletService());
        }
    }

    public static class UIDetachEvent
    extends EventObject {
        public UIDetachEvent(UI source) {
            super(source);
        }
    }
}

