/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@NotThreadSafe
class VaadinServiceSignalsInitializationTest {
    VaadinServiceSignalsInitializationTest() {
    }

    @BeforeEach
    @AfterEach
    public void clearTestEnvironment() {
        CurrentInstance.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void init_flowSignalEnvironmentInitialized() throws InterruptedException, TimeoutException {
        record EffectExecution(UI ui, String threadName) {
        }
        EffectExecution execution;
        MockVaadinServletService service = new MockVaadinServletService();
        VaadinService.setCurrent((VaadinService)service);
        Phaser phaser = new Phaser(1);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        MockUI ui = new MockUI(session);
        Assertions.assertSame((Object)((Object)ui), (Object)UI.getCurrent());
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList invocations = new ArrayList();
        try {
            Signal.unboundEffect((EffectAction & Serializable)() -> {
                invocations.add(new EffectExecution(UI.getCurrent(), Thread.currentThread().getName()));
                signal.get();
                phaser.arrive();
            });
            phaser.awaitAdvanceInterruptibly(0, 500L, TimeUnit.MILLISECONDS);
            Assertions.assertEquals((int)1, (int)invocations.size(), (String)"Expected effect to be executed");
            execution = (EffectExecution)invocations.get(0);
            Assertions.assertEquals(null, (Object)execution.ui, (String)"Expected UI to not be available during effect execution");
            Assertions.assertTrue((boolean)execution.threadName.startsWith("VaadinTaskExecutor-thread-"), (String)"Expected effect to be executed in Vaadin Executor thread");
        }
        finally {
            session.unlock();
            UI.setCurrent(null);
        }
        signal.insertLast((Object)"update");
        phaser.awaitAdvanceInterruptibly(1, 500L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((int)2, (int)invocations.size(), (String)"Expected effect to be executed twice");
        execution = (EffectExecution)invocations.get(1);
        Assertions.assertEquals(null, (Object)execution.ui, (String)"Expected UI to not be available during effect execution");
        Assertions.assertTrue((boolean)execution.threadName.startsWith("VaadinTaskExecutor-thread-"), (String)"Expected effect to be executed in Vaadin Executor thread");
    }
}

