/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class PropertyDeploymentConfigurationTest {
    @TempDir
    Path tempFolder;

    PropertyDeploymentConfigurationTest() {
    }

    @Test
    public void isProductionMode_modeIsProvidedViaParentOnly_valueFromParentIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)true);
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isProductionMode());
        Assertions.assertTrue((boolean)config.getInitParameters().isEmpty());
    }

    @Test
    public void isProductionMode_modeIsProvidedViaPropertiesAndParent_valueFromPropertiesIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)false);
        Properties properties = new Properties();
        properties.put("productionMode", Boolean.TRUE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, properties);
        Assertions.assertTrue((boolean)config.isProductionMode());
        Assertions.assertEquals((Object)properties, (Object)config.getInitParameters());
    }

    @Test
    public void reuseDevServer_valueIsProvidedViaPropertiesAndParent_valueFromPropertiesIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.reuseDevServer()).thenReturn((Object)false);
        Properties properties = new Properties();
        properties.put("reuseDevServer", Boolean.TRUE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, properties);
        Assertions.assertTrue((boolean)config.reuseDevServer());
        Assertions.assertEquals((Object)properties, (Object)config.getInitParameters());
    }

    @Test
    public void reuseDevServer_valueIsProvidedViaParentOnly_valueFromParentIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.reuseDevServer()).thenReturn((Object)true);
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.reuseDevServer());
        Assertions.assertTrue((boolean)config.getInitParameters().isEmpty());
    }

    @Test
    public void isPnpmEnabled_valueIsProvidedViaParentOnly_valueFromParentIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isPnpmEnabled()).thenReturn((Object)true);
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isPnpmEnabled());
        Assertions.assertTrue((boolean)config.getInitParameters().isEmpty());
    }

    @Test
    public void isPnpmEnabled_valueIsProvidedViaPropertiesAndParent_valueFromPropertiesIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isPnpmEnabled()).thenReturn((Object)false);
        Properties properties = new Properties();
        properties.put("pnpm.enable", Boolean.TRUE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, properties);
        Assertions.assertTrue((boolean)config.isPnpmEnabled());
        Assertions.assertEquals((Object)properties, (Object)config.getInitParameters());
    }

    @Test
    public void isXsrfProtectionEnabled_valueIsProvidedViaParentOnly_valueFromParentIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isXsrfProtectionEnabled()).thenReturn((Object)true);
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isXsrfProtectionEnabled());
        Assertions.assertTrue((boolean)config.getInitParameters().isEmpty());
    }

    @Test
    public void isXsrfProtectionEnabled_valueIsProvidedViaPropertiesAndParent_valueFromPropertiesIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isXsrfProtectionEnabled()).thenReturn((Object)false);
        Properties properties = new Properties();
        properties.put("disable-xsrf-protection", Boolean.FALSE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, properties);
        Assertions.assertTrue((boolean)config.isXsrfProtectionEnabled());
        Assertions.assertEquals((Object)properties, (Object)config.getInitParameters());
    }

    @Test
    public void getApplicationProperty_propertyIsDefinedInParentOnly_valueFromParentIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.getStringProperty("foo", null)).thenReturn((Object)"bar");
        PropertyDeploymentConfiguration configuration = this.createConfiguration(appConfig, new Properties());
        Assertions.assertEquals((Object)"bar", (Object)configuration.getApplicationProperty("foo"));
        Assertions.assertTrue((boolean)configuration.getInitParameters().isEmpty());
    }

    @Test
    public void getApplicationProperty_propertyIsDefinedInPropertiesAndParent_valueFromPropertiesIsReturned() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.getStringProperty("foo", null)).thenReturn((Object)"bar");
        Properties properties = new Properties();
        properties.put("foo", "baz");
        PropertyDeploymentConfiguration configuration = this.createConfiguration(appConfig, properties);
        Assertions.assertEquals((Object)"baz", (Object)configuration.getApplicationProperty("foo"));
        Assertions.assertEquals((Object)properties, (Object)configuration.getInitParameters());
    }

    @Test
    public void isProductionMode_modeIsProvidedViaParentOnly_propertyIsSetToAnotherValue_valueFromParentIsReturnedViaAPI() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.enumeration(Collections.singleton("productionMode")));
        Mockito.when((Object)appConfig.getStringProperty("productionMode", null)).thenReturn((Object)Boolean.FALSE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isProductionMode());
        Assertions.assertTrue((boolean)config.getInitParameters().containsKey("productionMode"));
    }

    @Test
    public void isPnpmEnabled_valueIsProvidedViaParentOnly_propertyIsSetToAnotherValue_valueFromParentIsReturnedViaAPI() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isPnpmEnabled()).thenReturn((Object)true);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.enumeration(Collections.singleton("pnpm.enable")));
        Mockito.when((Object)appConfig.getStringProperty("pnpm.enable", null)).thenReturn((Object)Boolean.FALSE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isPnpmEnabled());
        Assertions.assertTrue((boolean)config.getInitParameters().containsKey("pnpm.enable"));
    }

    @Test
    public void reuseDevServer_valueIsProvidedViaParentOnly_propertyIsSetToAnotherValue_valueFromParentIsReturnedViaAPI() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.reuseDevServer()).thenReturn((Object)true);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.enumeration(Collections.singleton("reuseDevServer")));
        Mockito.when((Object)appConfig.getStringProperty("reuseDevServer", null)).thenReturn((Object)Boolean.FALSE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.reuseDevServer());
        Assertions.assertTrue((boolean)config.getInitParameters().containsKey("reuseDevServer"));
    }

    @Test
    public void isXsrfProtectionEnabled_valueIsProvidedViaParentOnly_propertyIsSetToAnotherValue_valueFromParentIsReturnedViaAPI() {
        ApplicationConfiguration appConfig = this.mockAppConfig();
        Mockito.when((Object)appConfig.isXsrfProtectionEnabled()).thenReturn((Object)true);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.enumeration(Collections.singleton("disable-xsrf-protection")));
        Mockito.when((Object)appConfig.getStringProperty("disable-xsrf-protection", null)).thenReturn((Object)Boolean.TRUE.toString());
        PropertyDeploymentConfiguration config = this.createConfiguration(appConfig, new Properties());
        Assertions.assertTrue((boolean)config.isXsrfProtectionEnabled());
        Assertions.assertTrue((boolean)config.getInitParameters().containsKey("disable-xsrf-protection"));
    }

    @Test
    public void getInitParameters_prorprtiesAreMergedFromParentAndDeploymentConfig() {
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.enumeration(Collections.singleton("foo")));
        Mockito.when((Object)appConfig.getStringProperty("foo", null)).thenReturn((Object)"foobar");
        Properties properties = new Properties();
        properties.put("bar", "baz");
        PropertyDeploymentConfiguration configuration = this.createConfiguration(appConfig, properties);
        Properties initParameters = configuration.getInitParameters();
        Assertions.assertEquals((Object)"foobar", (Object)initParameters.get("foo"));
        Assertions.assertEquals((Object)"baz", (Object)initParameters.get("bar"));
    }

    @Test
    public void allDefaultAbstractConfigurationMethodsAreOverridden() {
        Method[] methods;
        for (Method method : methods = PropertyDeploymentConfiguration.class.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getProjectFolder") || methodName.equals("getMode")) continue;
            Assertions.assertNotEquals(AbstractConfiguration.class, method.getDeclaringClass(), (String)("There is a method '" + methodName + "' which is declared in  " + String.valueOf(AbstractConfiguration.class) + " interface but it's not overriden in the " + String.valueOf(PropertyDeploymentConfiguration.class) + ". That's most likely a mistake because every method implementation in " + String.valueOf(PropertyDeploymentConfiguration.class) + " must take into account parent " + String.valueOf(ApplicationConfiguration.class) + " API which shares the same interface " + String.valueOf(AbstractConfiguration.class) + " with " + String.valueOf(PropertyDeploymentConfiguration.class) + ", so every API method should call parent config and may not use just default implementation of " + String.valueOf(AbstractConfiguration.class)));
        }
    }

    private ApplicationConfiguration mockAppConfig() {
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)appConfig.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        return appConfig;
    }

    private PropertyDeploymentConfiguration createConfiguration(ApplicationConfiguration appConfig, Properties properties) {
        return new PropertyDeploymentConfiguration(appConfig, Object.class, properties);
    }
}

