/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionExpiredException;
import com.vaadin.flow.server.TestProvider;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedHttpSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@NotThreadSafe
public class I18NProviderTest {
    private VaadinServletService service;
    private MockDeploymentConfiguration config = new MockDeploymentConfiguration();

    @Test
    public void no_property_defined_should_leave_with_default_locale() throws ServletException, ServiceException {
        this.initServletAndService((DeploymentConfiguration)this.config);
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)VaadinSession.getCurrent().getLocale(), (String)"Locale was not the expected default locale");
    }

    @Test
    public void property_defined_should_init_registry_with_provider() throws ServletException, ServiceException {
        this.config.setApplicationOrSystemProperty("i18n.provider", TestProvider.class.getName());
        this.initServletAndService((DeploymentConfiguration)this.config);
        Instantiator instantiator = VaadinService.getCurrent().getInstantiator();
        Assertions.assertEquals(TestProvider.class, (Object)instantiator.getI18NProvider().getClass(), (String)"Found wrong registry");
    }

    @Test
    public void with_defined_provider_locale_should_be_the_available_one() throws ServletException, ServiceException {
        this.config.setApplicationOrSystemProperty("i18n.provider", TestProvider.class.getName());
        this.initServletAndService((DeploymentConfiguration)this.config);
        Instantiator instantiator = VaadinService.getCurrent().getInstantiator();
        I18NProvider i18NProvider = instantiator.getI18NProvider();
        Assertions.assertNotNull((Object)i18NProvider, (String)"No provider for ");
        Assertions.assertEquals(i18NProvider.getProvidedLocales().get(0), (Object)VaadinSession.getCurrent().getLocale(), (String)"Locale was not the defined locale");
    }

    @Test
    public void translate_calls_provider() throws ServletException, ServiceException {
        this.config.setApplicationOrSystemProperty("i18n.provider", TestProvider.class.getName());
        this.initServletAndService((DeploymentConfiguration)this.config);
        Assertions.assertEquals((Object)"!foo.bar!", (Object)I18NProvider.translate((String)"foo.bar", (Object[])new Object[0]), (String)"translate method should return a value");
    }

    @Test
    public void translate_withoutProvider_returnsKey() throws ServletException, ServiceException {
        this.initServletAndService((DeploymentConfiguration)this.config);
        Assertions.assertEquals((Object)"!{foo.bar}!", (Object)I18NProvider.translate((String)"foo.bar", (Object[])new Object[0]), (String)"Should return the key with !{}! to show no translation available");
    }

    @Test
    public void translate_withoutVaadinService_throwIllegalStateException() throws ServletException, ServiceException {
        this.config.setApplicationOrSystemProperty("i18n.provider", TestProvider.class.getName());
        this.initServletAndService((DeploymentConfiguration)this.config);
        VaadinService.setCurrent(null);
        Assertions.assertThrows(IllegalStateException.class, () -> I18NProvider.translate((String)"foo.bar", (Object[])new Object[0]), (String)"Should throw exception without active VaadinService");
    }

    @Test
    public void translate_withoutInstantiator_throwIllegalStateException() throws ServletException, ServiceException {
        this.config.setApplicationOrSystemProperty("i18n.provider", TestProvider.class.getName());
        this.initServletAndService((DeploymentConfiguration)this.config);
        this.service = new MockVaadinServletService((DeploymentConfiguration)this.config){

            public Instantiator getInstantiator() {
                return null;
            }
        };
        VaadinService.setCurrent((VaadinService)this.service);
        Assertions.assertThrows(IllegalStateException.class, () -> I18NProvider.translate((String)"foo.bar", (Object[])new Object[0]), (String)"Should throw exception without active VaadinService");
    }

    @BeforeEach
    public void initState() throws NoSuchFieldException, IllegalAccessException {
        I18NProviderTest.clearI18NProviderField();
    }

    @AfterEach
    public void clearCurrentInstances() throws NoSuchFieldException, IllegalAccessException {
        CurrentInstance.clearAll();
        I18NProviderTest.clearI18NProviderField();
    }

    public static void clearI18NProviderField() throws NoSuchFieldException, IllegalAccessException {
        Field field = DefaultInstantiator.class.getDeclaredField("i18nProvider");
        field.setAccessible(true);
        ((AtomicReference)field.get(null)).set(null);
        field.setAccessible(false);
    }

    private void initServletAndService(DeploymentConfiguration config) throws ServletException, ServiceException {
        this.service = new MockVaadinServletService(config){

            public Instantiator getInstantiator() {
                return new DefaultInstantiator((VaadinService)I18NProviderTest.this.service);
            }
        };
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpSession mockHttpSession = (HttpSession)Mockito.mock(HttpSession.class);
        WrappedHttpSession mockWrappedSession = new WrappedHttpSession(mockHttpSession){
            final ReentrantLock lock;
            {
                this.lock = new ReentrantLock();
                this.lock.lock();
            }

            public Object getAttribute(String name) {
                String lockAttribute = I18NProviderTest.this.service.getServiceName() + ".lock";
                Object res = lockAttribute.equals(name) ? this.lock : super.getAttribute(name);
                return res;
            }
        };
        VaadinServletRequest request = new VaadinServletRequest(this, httpServletRequest, this.service, (WrappedSession)mockWrappedSession){
            final /* synthetic */ WrappedSession val$mockWrappedSession;
            {
                this.val$mockWrappedSession = wrappedSession;
                super(arg0, arg1);
            }

            public String getParameter(String name) {
                if ("v-r".equals(name)) {
                    return null;
                }
                return "1";
            }

            public WrappedSession getWrappedSession(boolean allowSessionCreation) {
                return this.val$mockWrappedSession;
            }
        };
        try {
            this.service.findVaadinSession((VaadinRequest)request);
        }
        catch (SessionExpiredException e) {
            throw new RuntimeException(e);
        }
        VaadinService.setCurrent((VaadinService)this.service);
    }
}

