/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AppShellRegistryAuraAutoLoadTest {
    private VaadinServletContext context;
    private Document document;
    private VaadinServletService service;

    AppShellRegistryAuraAutoLoadTest() {
    }

    @BeforeEach
    public void setup() {
        HashMap<String, Lookup> attributeMap = new HashMap<String, Lookup>();
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttribute(Mockito.anyString())).then(invocation -> attributeMap.get(invocation.getArguments()[0].toString()));
        ((ServletContext)Mockito.doAnswer(invocation -> attributeMap.put(invocation.getArguments()[0].toString(), (Lookup)invocation.getArguments()[1])).when((Object)servletContext)).setAttribute(Mockito.anyString(), Mockito.any());
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        attributeMap.put(Lookup.class.getName(), lookup);
        this.context = new VaadinServletContext(servletContext);
        this.document = Document.createShell((String)"");
        this.service = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        DeploymentConfiguration deploymentConfig = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)deploymentConfig.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)deploymentConfig);
        Mockito.when((Object)this.service.getInstantiator()).thenReturn((Object)((Instantiator)Mockito.mock(Instantiator.class)));
        Mockito.when((Object)this.service.getContext()).thenReturn((Object)this.context);
    }

    @AfterEach
    public void teardown() {
        AppShellRegistry.getInstance((VaadinContext)this.context).reset();
    }

    @Test
    public void noAppShellConfigurator_auraAvailable_auraIsAutoLoaded() {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        Mockito.when((Object)this.service.isResourceAvailable("aura/aura.css")).thenReturn((Object)true);
        VaadinServletRequest request = this.createRequest("/", "");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assertions.assertEquals((int)1, (int)links.size(), (String)"Expected Aura stylesheet to be auto-loaded");
        Element aura = (Element)links.get(0);
        Assertions.assertEquals((Object)"aura/aura.css", (Object)aura.attr("data-file-path"));
        Assertions.assertTrue((boolean)aura.attr("href").contains("aura.css"), (String)"Aura href should contain aura.css");
    }

    @Test
    public void noAppShellConfigurator_auraNotAvailable_auraNotLoaded() {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        Mockito.when((Object)this.service.isResourceAvailable("aura/aura.css")).thenReturn((Object)false);
        VaadinServletRequest request = this.createRequest("/", "");
        registry.modifyIndexHtml(this.document, (VaadinRequest)request);
        Elements links = this.document.head().select("link[rel=stylesheet]");
        Assertions.assertEquals((int)0, (int)links.size(), (String)"Aura should NOT be auto-loaded when not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appShellConfiguratorExists_auraNotAutoLoaded() {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(MyAppShell.class);
        VaadinService.setCurrent((VaadinService)this.service);
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        Mockito.when((Object)this.service.getInstantiator()).thenReturn((Object)instantiator);
        Mockito.when((Object)((MyAppShell)instantiator.getOrCreate(MyAppShell.class))).thenReturn((Object)new MyAppShell());
        try {
            VaadinServletRequest request = this.createRequest("/", "");
            registry.modifyIndexHtml(this.document, (VaadinRequest)request);
            Elements links = this.document.head().select("link[rel=stylesheet]");
            Assertions.assertEquals((int)0, (int)links.size(), (String)"Aura should NOT be auto-loaded when AppShellConfigurator exists");
        }
        finally {
            VaadinService.setCurrent(null);
        }
    }

    private VaadinServletRequest createRequest(String pathInfo, String contextPath) {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getServletPath()).thenReturn((Object)"");
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer(pathInfo));
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)contextPath);
        return new VaadinServletRequest(req, this.service);
    }

    public static class MyAppShell
    implements AppShellConfigurator {
    }
}

