/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParameterDeserializerTest {
    ParameterDeserializerTest() {
    }

    @Test
    public void testSimple() {
        Assertions.assertFalse((boolean)ParameterDeserializer.isAnnotatedParameter(Simple.class, OptionalParameter.class));
        Assertions.assertTrue((boolean)ParameterDeserializer.isAnnotatedParameter(SimpleAnnotated.class, OptionalParameter.class));
    }

    @Test
    public void testInterface() {
        Assertions.assertFalse((boolean)ParameterDeserializer.isAnnotatedParameter(Normal.class, OptionalParameter.class));
        Assertions.assertTrue((boolean)ParameterDeserializer.isAnnotatedParameter(NormalAnnotated.class, OptionalParameter.class));
    }

    @Test
    public void parameterizedViaClass() {
        Assertions.assertFalse((boolean)ParameterDeserializer.isAnnotatedParameter(ParameterizedViaSuperClass.class, OptionalParameter.class));
        Assertions.assertTrue((boolean)ParameterDeserializer.isAnnotatedParameter(ParameterizedAnnotatedViaSuperClass.class, OptionalParameter.class));
    }

    @Test
    public void parameterizedViaInterface() {
        Assertions.assertFalse((boolean)ParameterDeserializer.isAnnotatedParameter(ParameterizedClass.class, OptionalParameter.class));
        Assertions.assertTrue((boolean)ParameterDeserializer.isAnnotatedParameter(ParameterizedAnnotatedClass.class, OptionalParameter.class));
    }

    @Test
    public void testGenericInterface() {
        Assertions.assertFalse((boolean)ParameterDeserializer.isAnnotatedParameter(Generic.class, OptionalParameter.class));
        Assertions.assertTrue((boolean)ParameterDeserializer.isAnnotatedParameter(GenericAnnotated.class, OptionalParameter.class));
    }

    @Test
    public void getClassType_concreteClass_parameterFromInterface() {
        Class type = ParameterDeserializer.getClassType(Simple.class);
        Assertions.assertEquals(String.class, (Object)type);
        type = ParameterDeserializer.getClassType(SimpleAnnotated.class);
        Assertions.assertEquals(String.class, (Object)type);
    }

    @Test
    public void getClassType_concreteClass_parameterFromExtendedInterface() {
        Class type = ParameterDeserializer.getClassType(Normal.class);
        Assertions.assertEquals(String.class, (Object)type);
        type = ParameterDeserializer.getClassType(NormalAnnotated.class);
        Assertions.assertEquals(String.class, (Object)type);
    }

    @Test
    public void getClassType_concreteClass_parameterFromSuperclass() {
        Class type = ParameterDeserializer.getClassType(ParameterizedViaSuperClass.class);
        Assertions.assertEquals(String.class, (Object)type);
        type = ParameterDeserializer.getClassType(ParameterizedAnnotatedClass.class);
        Assertions.assertEquals(String.class, (Object)type);
    }

    @Test
    public void getClassType_parameterizedClass_parameterFromInterface() {
        Class type = ParameterDeserializer.getClassType(ParameterizedClass.class);
        Assertions.assertEquals(String.class, (Object)type);
        type = ParameterDeserializer.getClassType(ParameterizedAnnotatedClass.class);
        Assertions.assertEquals(String.class, (Object)type);
    }

    @Test
    public void getClassType_parameterizedClass_parameterFromParameterizedInterface() {
        Class type = ParameterDeserializer.getClassType(Generic.class);
        Assertions.assertEquals(String.class, (Object)type);
        type = ParameterDeserializer.getClassType(GenericAnnotated.class);
        Assertions.assertEquals(String.class, (Object)type);
    }

    public static class Simple
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    public static class SimpleAnnotated
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    public static class Normal
    implements NormalInterface {
    }

    public static class NormalAnnotated
    implements NormalInterfaceAnnotated {
    }

    public static class ParameterizedViaSuperClass<T>
    extends ParameterizedSuperClass<T> {
    }

    public static class ParameterizedAnnotatedViaSuperClass<T>
    extends ParameterizedSuperClass<T> {
        @Override
        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    public static class ParameterizedClass<T>
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    public static class ParameterizedAnnotatedClass<T>
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    public static class Generic
    implements GenericInterface<String> {
    }

    public static class GenericAnnotated
    implements GenericInterfaceAnnotated<String> {
    }

    public static interface GenericInterfaceAnnotated<T>
    extends HasUrlParameter<T> {
        default public void setParameter(BeforeEvent event, @OptionalParameter T parameter) {
        }
    }

    public static interface GenericInterface<T>
    extends HasUrlParameter<T> {
        default public void setParameter(BeforeEvent event, T parameter) {
        }
    }

    public static interface NormalInterfaceAnnotated
    extends HasUrlParameter<String> {
        default public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    public static interface NormalInterface
    extends HasUrlParameter<String> {
        default public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    public static class ParameterizedSuperClass<T>
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }
}

