/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ListFeatureSetViewTest {
    private TestFeature feature;
    private NodeList.SetView<String> set;

    ListFeatureSetViewTest() {
    }

    @BeforeEach
    void setup() {
        this.feature = new TestFeature();
        this.set = new TestSetView((NodeList<String>)this.feature);
    }

    @Test
    void testSetViewAdd() {
        this.set.add((Serializable)((Object)"0"));
        this.assertContents("0");
        this.set.add((Serializable)((Object)"1"));
        this.assertContents("0", "1");
        this.set.add((Serializable)((Object)"2"));
        this.assertContents("0", "1", "2");
    }

    @Test
    void testSetViewSize() {
        this.set.add((Serializable)((Object)"0"));
        Assertions.assertEquals((int)1, (int)this.set.size());
        this.set.add((Serializable)((Object)"1"));
        Assertions.assertEquals((int)2, (int)this.set.size());
        this.set.remove((Object)"1");
        Assertions.assertEquals((int)1, (int)this.set.size());
        this.set.remove((Object)"1");
        Assertions.assertEquals((int)1, (int)this.set.size());
        this.set.remove((Object)"0");
        Assertions.assertEquals((int)0, (int)this.set.size());
    }

    @Test
    void testSetViewRemove() {
        this.set.add((Serializable)((Object)"0"));
        this.set.add((Serializable)((Object)"1"));
        this.set.remove((Object)"0");
        this.assertContents("1");
        this.set.remove((Object)"1");
        this.assertContents(new String[0]);
    }

    @Test
    void testSetViewValidateAdd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.add((Serializable)((Object)"as89w4573")));
    }

    @Test
    void testSetViewClear() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        this.set.clear();
        this.assertContents(new String[0]);
        this.set.clear();
    }

    @Test
    void testSetViewIteratorIterate() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Iterator i = this.set.iterator();
        Assertions.assertEquals((Object)"a", i.next());
        Assertions.assertEquals((Object)"b", i.next());
        Assertions.assertEquals((Object)"c", i.next());
        Assertions.assertFalse((boolean)i.hasNext());
    }

    @Test
    void testSetViewIteratorRemove() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Iterator i = this.set.iterator();
        i.next();
        i.next();
        i.remove();
        this.assertContents("a", "c");
    }

    @Test
    void testSetViewContains() {
        this.set.add((Serializable)((Object)"a"));
        this.set.add((Serializable)((Object)"b"));
        this.set.add((Serializable)((Object)"c"));
        Assertions.assertTrue((boolean)this.set.contains((Object)"a"));
        Assertions.assertTrue((boolean)this.set.contains((Object)"b"));
        Assertions.assertTrue((boolean)this.set.contains((Object)"c"));
        Assertions.assertFalse((boolean)this.set.contains((Object)"d"));
    }

    @Test
    void testSetViewSameFeatureEquals() {
        this.set.add((Serializable)((Object)"a"));
        TestSetView otherSet = new TestSetView((NodeList<String>)this.feature);
        Assertions.assertEquals(this.set, (Object)((Object)otherSet));
        Assertions.assertEquals((int)this.set.hashCode(), (int)otherSet.hashCode());
    }

    @Test
    void testSetViewDifferentFeatureEquals() {
        this.set.add((Serializable)((Object)"a"));
        TestFeature otherFeature = new TestFeature();
        TestSetView otherSet = new TestSetView((NodeList<String>)otherFeature);
        otherSet.add((Serializable)((Object)"a"));
        Assertions.assertEquals(this.set, (Object)((Object)otherSet));
        Assertions.assertEquals((int)this.set.hashCode(), (int)otherSet.hashCode());
    }

    private void assertContents(String ... expected) {
        Object[] actual = new String[this.feature.size()];
        for (int i = 0; i < this.feature.size(); ++i) {
            actual[i] = (String)((Object)this.feature.get(i));
        }
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    private static class TestFeature
    extends SerializableNodeList<String> {
        private final ArrayList<AbstractListChange<String>> changes = new ArrayList();

        public TestFeature() {
            super((StateNode)Mockito.mock(StateNode.class));
        }

        protected List<AbstractListChange<String>> getChangeTracker() {
            return this.changes;
        }
    }

    private static class TestSetView
    extends NodeList.SetView<String> {
        public TestSetView(NodeList<String> list) {
            super(list);
        }

        protected void validate(String string) {
            if (string.length() > 5) {
                throw new IllegalArgumentException("All strings must be less than 5 characters");
            }
        }
    }
}

