/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.change.NodeDetachChange;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StateNodeTest {
    @Test
    public void newNodeState() {
        StateNode node = StateNodeTest.createEmptyNode();
        NodeOwner owner = node.getOwner();
        Assertions.assertNotNull((Object)owner, (String)"New node should have an owner");
        Assertions.assertEquals((int)-1, (int)node.getId(), (String)"New node shold have unassigned id");
        Assertions.assertFalse((boolean)node.isAttached(), (String)"Node should not be attached");
    }

    @Test
    public void nodeContainsDefinedFeatures() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        Assertions.assertTrue((boolean)node.hasFeature(ElementData.class), (String)"Should have feature defined in constructor");
        ElementData feature = (ElementData)node.getFeature(ElementData.class);
        Assertions.assertNotNull((Object)feature, (String)"Existing feature should also be available");
        Assertions.assertFalse((boolean)node.hasFeature(ElementPropertyMap.class), (String)"Should not have a feature that wasn't defined in constructor");
    }

    @Test
    public void getMissingFeatureThrows() {
        StateNode node = new StateNode(new Class[]{ElementData.class});
        Assertions.assertThrows(IllegalStateException.class, () -> node.getFeature(ElementPropertyMap.class));
    }

    @Test
    public void attachDetachChangeCollection() {
        StateNode node = StateNodeTest.createEmptyNode();
        ArrayList changes = new ArrayList();
        Consumer<NodeChange> collector = changes::add;
        node.collectChanges(collector);
        Assertions.assertTrue((boolean)changes.isEmpty(), (String)"Node should have no changes");
        StateNodeTest.setParent(node, this.createStateTree().getRootNode());
        node.collectChanges(collector);
        Assertions.assertEquals((int)1, (int)changes.size(), (String)"Should have 1 change");
        Assertions.assertTrue((boolean)(changes.get(0) instanceof NodeAttachChange), (String)"Should have attach change");
        changes.clear();
        node.collectChanges(collector);
        Assertions.assertTrue((boolean)changes.isEmpty(), (String)"Node should have no changes");
        StateNodeTest.setParent(node, null);
        node.collectChanges(collector);
        Assertions.assertEquals((int)1, (int)changes.size(), (String)"Should have 1 change");
        Assertions.assertTrue((boolean)(changes.get(0) instanceof NodeDetachChange), (String)"Should have detach change");
        changes.clear();
    }

    @Test
    public void appendChildBeforeParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNode grandchild = StateNodeTest.createEmptyNode("grandchild");
        StateNode root = this.createStateTree().getRootNode();
        StateNodeTest.setParent(grandchild, child);
        StateNodeTest.setParent(child, parent);
        StateNodeTest.setParent(parent, root);
        Assertions.assertNotEquals((int)-1, (int)parent.getId());
        Assertions.assertNotEquals((int)-1, (int)child.getId());
        Assertions.assertNotEquals((int)-1, (int)grandchild.getId());
    }

    @Test
    public void appendParentBeforeChild() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNode grandchild = StateNodeTest.createEmptyNode("grandchild");
        StateNode root = this.createStateTree().getRootNode();
        StateNodeTest.setParent(parent, root);
        StateNodeTest.setParent(child, parent);
        StateNodeTest.setParent(grandchild, child);
        Assertions.assertNotEquals((int)-1, (int)parent.getId());
        Assertions.assertNotEquals((int)-1, (int)child.getId());
        Assertions.assertNotEquals((int)-1, (int)grandchild.getId());
    }

    @Test
    public void setChildAsParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        StateNode child = StateNodeTest.createParentNode("child");
        StateNodeTest.setParent(child, parent);
        Assertions.assertThrows(IllegalStateException.class, () -> StateNodeTest.setParent(parent, child));
    }

    @Test
    public void setAsOwnParent() {
        StateNode parent = StateNodeTest.createParentNode("parent");
        Assertions.assertThrows(IllegalStateException.class, () -> StateNodeTest.setParent(parent, parent));
    }

    @Test
    public void recursiveTreeNavigation_resilienceInDepth() {
        TestStateNode childOfRoot = new TestStateNode();
        TestStateNode node = this.createTree(childOfRoot, 3000);
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(childOfRoot, tree.getRootNode());
        Set set = IntStream.range(-1, node.getData() + 1).boxed().collect(Collectors.toSet());
        childOfRoot.visitNodeTree(n -> this.visit((TestStateNode)((Object)n), tree, set));
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void recursiveTreeNavigation_resilienceInSize() {
        TestStateNode childOfRoot = new TestStateNode();
        int count = 300;
        TestStateNode node = this.createTree(childOfRoot, count);
        while (node.getParent() != null) {
            node = node.getParent();
            for (int i = 1; i < 50; ++i) {
                TestStateNode child = new TestStateNode();
                StateNodeTest.setParent(child, node);
                child.setData(count);
                ++count;
            }
        }
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(childOfRoot, tree.getRootNode());
        Set set = IntStream.range(-1, count).boxed().collect(Collectors.toSet());
        childOfRoot.visitNodeTree(n -> this.visit((TestStateNode)((Object)n), (StateTree)childOfRoot.getOwner(), set));
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void nodeTreeOnAttach_bottomUpTraversing_correctOrder() {
        TestStateNode root = new TestStateNode();
        LinkedList<Integer> data = new LinkedList<Integer>();
        data.add(0);
        root.setData(0);
        int count = 1;
        for (int i = 0; i < 5; ++i) {
            TestStateNode childOfRoot = new TestStateNode();
            childOfRoot.setData(count);
            data.add(count);
            if (i % 2 == 0) {
                for (int j = 0; j < 5; ++j) {
                    TestStateNode child = new TestStateNode();
                    StateNodeTest.setParent(child, childOfRoot);
                    child.setData(count);
                    data.add(count);
                    ++count;
                }
            }
            StateNodeTest.setParent(childOfRoot, root);
        }
        root.visitNodeTreeBottomUp(node -> Assertions.assertEquals((Integer)((TestStateNode)((Object)node)).getData(), (Integer)((Integer)data.removeLast())));
    }

    @Test
    public void nodeTreeOnAttach_bottomUpTraversing_brokenParentInChildDoesNotEndInLoop() throws NoSuchFieldException, IllegalAccessException {
        TestStateNode root = new TestStateNode();
        root.setData(0);
        ArrayList count = new ArrayList();
        Field parent = StateNode.class.getDeclaredField("parent");
        parent.setAccessible(true);
        TestStateNode childOfRoot = new TestStateNode();
        childOfRoot.setData(1);
        TestStateNode child = new TestStateNode();
        child.setData(2);
        StateNodeTest.setParent(child, childOfRoot);
        parent.set((Object)child, null);
        StateNodeTest.setParent(childOfRoot, root);
        root.visitNodeTreeBottomUp(node -> count.add(1));
        Assertions.assertEquals((int)3, (int)count.size(), (String)"Each node should be visited once");
    }

    @Test
    public void attachListener_onSetParent_listenerTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        Assertions.assertFalse((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addAttachListener((Command & Serializable)() -> triggered.set(true));
        StateNodeTest.setParent(child, root);
        Assertions.assertTrue((boolean)triggered.get());
    }

    @Test
    public void attachListener_listenerRemoved_listenerNotTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        Assertions.assertFalse((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        Registration registrationHandle = child.addAttachListener((Command & Serializable)() -> triggered.set(true));
        registrationHandle.remove();
        StateNodeTest.setParent(child, root);
        Assertions.assertFalse((boolean)triggered.get());
    }

    @Test
    public void detachListener_onSetParent_listenerTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assertions.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addDetachListener((Command & Serializable)() -> triggered.set(true));
        StateNodeTest.setParent(child, null);
        Assertions.assertTrue((boolean)triggered.get(), (String)"Detach listener was not triggered.");
    }

    @Test
    public void detachListener_listenerRemoved_listenerNotTriggered() {
        StateNode root = new TestStateTree().getRootNode();
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assertions.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        Registration registrationHandle = child.addDetachListener((Command & Serializable)() -> triggered.set(true));
        registrationHandle.remove();
        StateNodeTest.setParent(child, null);
        Assertions.assertFalse((boolean)triggered.get(), (String)"Detach listener was triggered even though handler was removed.");
    }

    @Test
    public void detachListener_removesNode_notUnregisteredTwice() {
        StateTree tree = this.createStateTree();
        StateNode root = StateNodeTest.createParentNode("");
        StateNodeTest.setParent(root, tree.getRootNode());
        TestStateNode child = new TestStateNode();
        StateNodeTest.setParent(child, root);
        Assertions.assertTrue((boolean)child.isAttached());
        AtomicBoolean triggered = new AtomicBoolean(false);
        child.addDetachListener((Command & Serializable)() -> {
            Assertions.assertTrue((boolean)child.isAttached(), (String)"Child node should still have a parent and be been seen as attached");
            Assertions.assertFalse((boolean)tree.hasNode((StateNode)child), (String)"Child node should have been unregistered");
            child.setParent(null);
            Assertions.assertTrue((child.getParent() == null ? 1 : 0) != 0, (String)"Child's parent should be null");
            triggered.set(true);
        });
        StateNodeTest.setParent(child, null);
        Assertions.assertTrue((boolean)triggered.get(), (String)"Detach listener was not triggered.");
    }

    public static StateNode createEmptyNode() {
        return StateNodeTest.createEmptyNode("Empty node");
    }

    public static StateNode createEmptyNode(String toString) {
        return StateNodeTest.createTestNode(toString, new Class[0]);
    }

    public static StateNode createParentNode(String toString) {
        return StateNodeTest.createTestNode(toString, ElementChildrenList.class);
    }

    @SafeVarargs
    public static StateNode createTestNode(final String toString, Class<? extends NodeFeature> ... features) {
        return new StateNode(features){

            public String toString() {
                if (toString != null) {
                    return toString;
                }
                return super.toString();
            }

            public boolean hasFeature(Class<? extends NodeFeature> featureType) {
                if (featureType.isAssignableFrom(ElementData.class)) {
                    return false;
                }
                return super.hasFeature(featureType);
            }
        };
    }

    public static void setParent(StateNode child, StateNode parent) {
        if (parent == null) {
            parent = child.getParent();
            ElementChildrenList children = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            children.remove(children.indexOf(child));
        } else {
            assert (child.getParent() == null);
            ElementChildrenList children = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            children.add(children.size(), child);
        }
    }

    private TestStateNode createTree(TestStateNode root, int depth) {
        TestStateNode node = root;
        for (int i = 0; i < depth; ++i) {
            TestStateNode child = new TestStateNode();
            child.setData(i);
            ((ElementChildrenList)node.getFeature(ElementChildrenList.class)).add(0, (StateNode)child);
            node = child;
        }
        return node;
    }

    private void visit(TestStateNode node, StateTree tree, Set<Integer> set) {
        Assertions.assertEquals((Object)tree, (Object)node.getOwner());
        set.remove(node.getData());
    }

    private StateTree createStateTree() {
        StateTree stateTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        return stateTree;
    }

    @Test
    public void runWhenAttachedNodeNotAttached() {
        StateTree tree = this.createStateTree();
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assertions.assertEquals((int)0, (int)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assertions.assertEquals((int)1, (int)commandRun.get());
        StateNodeTest.setParent(node, null);
        StateNodeTest.setParent(node, tree.getRootNode());
        Assertions.assertEquals((int)1, (int)commandRun.get());
    }

    @Test
    public void runMultipleWhenAttachedNodeNotAttached() {
        StateTree tree = this.createStateTree();
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assertions.assertEquals((int)0, (int)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assertions.assertEquals((int)2, (int)commandRun.get());
    }

    @Test
    public void runWhenAttachedNodeAttached() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(node, tree.getRootNode());
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        });
        Assertions.assertEquals((int)1, (int)commandRun.get());
    }

    @Test
    public void runWhenAttached_detachingNode_schedulesCommandOnAttach() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode node = StateNodeTest.createEmptyNode();
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(node, tree.getRootNode());
        node.addDetachListener((Command & Serializable)() -> node.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        }));
        StateNodeTest.setParent(node, null);
        Assertions.assertEquals((int)0, (int)commandRun.get());
        StateNodeTest.setParent(node, tree.getRootNode());
        Assertions.assertEquals((int)1, (int)commandRun.get());
    }

    @Test
    public void runWhenAttached_detachingNode_childNodeSchedulesCommandOnAttach() {
        AtomicInteger commandRun = new AtomicInteger(0);
        StateNode parent = StateNodeTest.createParentNode("PARENT");
        StateNode child = StateNodeTest.createEmptyNode("CHILD");
        StateTree tree = this.createStateTree();
        StateNodeTest.setParent(parent, tree.getRootNode());
        StateNodeTest.setParent(child, parent);
        child.addDetachListener((Command & Serializable)() -> child.runWhenAttached((SerializableConsumer & Serializable)ui -> {
            Assertions.assertEquals((Object)tree.getUI(), (Object)ui);
            commandRun.incrementAndGet();
        }));
        StateNodeTest.setParent(parent, null);
        Assertions.assertEquals((int)0, (int)commandRun.get());
        StateNodeTest.setParent(parent, tree.getRootNode());
        Assertions.assertEquals((int)1, (int)commandRun.get());
    }

    @Test
    public void requiredFeatures() {
        StateNode stateNode = new StateNode(Arrays.asList(ElementClassList.class, ElementPropertyMap.class), new Class[]{ElementAttributeMap.class});
        Assertions.assertTrue((boolean)stateNode.hasFeature(ElementClassList.class));
        Assertions.assertTrue((boolean)stateNode.hasFeature(ElementPropertyMap.class));
        Assertions.assertTrue((boolean)stateNode.hasFeature(ElementAttributeMap.class));
        Assertions.assertTrue((boolean)stateNode.isReportedFeature(ElementClassList.class));
        Assertions.assertTrue((boolean)stateNode.isReportedFeature(ElementPropertyMap.class));
        Assertions.assertFalse((boolean)stateNode.isReportedFeature(ElementAttributeMap.class));
    }

    @Test
    public void collectChanges_initiallyActiveElement_sendOnlyDisalowFeatureChangesWhenInactive() {
        StateNode stateNode = StateNodeTest.createTestNode("Active node", ElementPropertyMap.class, ElementData.class);
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, stateNode);
        this.assertCollectChanges_initiallyVisible(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            stateNode.updateActiveState();
        });
    }

    @Test
    public void collectChanges_inertElement_inertChangesCollected() {
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementChildrenList.class, InertData.class);
        StateNode child = StateNodeTest.createTestNode("Child node", ElementChildrenList.class, InertData.class);
        StateNode grandchild = StateNodeTest.createTestNode("Grandchild node", InertData.class);
        ((ElementChildrenList)new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class}).getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, child);
        ((ElementChildrenList)child.getFeature(ElementChildrenList.class)).add(0, grandchild);
        Assertions.assertFalse((boolean)parent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)grandchild.isInert());
        ((InertData)parent.getFeature(InertData.class)).setInertSelf(true);
        Assertions.assertFalse((boolean)parent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assertions.assertTrue((boolean)parent.isInert());
        Assertions.assertTrue((boolean)child.isInert());
        Assertions.assertTrue((boolean)grandchild.isInert());
        ((InertData)child.getFeature(InertData.class)).setIgnoreParentInert(true);
        Assertions.assertTrue((boolean)parent.isInert());
        Assertions.assertTrue((boolean)child.isInert());
        Assertions.assertTrue((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assertions.assertTrue((boolean)parent.isInert());
        Assertions.assertTrue((boolean)child.isInert());
        Assertions.assertTrue((boolean)grandchild.isInert());
        child.collectChanges(nodeChange -> {});
        Assertions.assertTrue((boolean)parent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)grandchild.isInert());
        ((InertData)parent.getFeature(InertData.class)).setInertSelf(false);
        ((InertData)child.getFeature(InertData.class)).setIgnoreParentInert(false);
        Assertions.assertTrue((boolean)parent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)grandchild.isInert());
        parent.collectChanges(nodeChange -> {});
        Assertions.assertFalse((boolean)parent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)grandchild.isInert());
    }

    @Test
    public void collectChanges_inertChildMoved_inertStateInherited() {
        StateNode inertParent = StateNodeTest.createTestNode("Inert parent", ElementChildrenList.class, InertData.class);
        StateNode child = StateNodeTest.createTestNode("Child", InertData.class);
        StateNode parent = StateNodeTest.createTestNode("Non-inert parent", ElementChildrenList.class, InertData.class);
        ElementChildrenList feature = (ElementChildrenList)new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class}).getRootNode().getFeature(ElementChildrenList.class);
        feature.add(0, parent);
        feature.add(1, inertParent);
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).add(0, child);
        ((InertData)inertParent.getFeature(InertData.class)).setInertSelf(true);
        inertParent.collectChanges(node -> {});
        Assertions.assertTrue((boolean)inertParent.isInert());
        Assertions.assertTrue((boolean)child.isInert());
        Assertions.assertFalse((boolean)parent.isInert());
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).remove(0);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, child);
        Assertions.assertTrue((boolean)inertParent.isInert());
        Assertions.assertFalse((boolean)child.isInert());
        Assertions.assertFalse((boolean)parent.isInert());
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).remove(0);
        ((ElementChildrenList)inertParent.getFeature(ElementChildrenList.class)).add(0, child);
        Assertions.assertTrue((boolean)inertParent.isInert());
        Assertions.assertTrue((boolean)child.isInert());
        Assertions.assertFalse((boolean)parent.isInert());
    }

    @Test
    public void collectChanges_inactivateViaParent_initiallyActiveElement_sendOnlyDisalowFeatureChangesWhenInactive() {
        StateNode stateNode = StateNodeTest.createTestNode("Active node", ElementPropertyMap.class, ElementData.class);
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementPropertyMap.class, ElementData.class, ElementChildrenList.class);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        ElementData visibility = (ElementData)parent.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        this.assertCollectChanges_initiallyVisible(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            parent.updateActiveState();
        });
    }

    @Test
    public void collectChanges_initiallyInactiveElement_sendOnlyDisalowAndReportedFeatures_sendAllChangesWhenActive() {
        Element element = ElementFactory.createAnchor();
        StateNode stateNode = element.getNode();
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, stateNode);
        this.assertCollectChanges_initiallyInactive(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            stateNode.updateActiveState();
        });
    }

    @Test
    public void collectChanges_initiallyInactiveViaParentElement_sendOnlyDisalowAndReportedFeatures_sendAllChangesWhenActive() {
        Element element = ElementFactory.createAnchor();
        StateNode stateNode = element.getNode();
        StateNode parent = StateNodeTest.createTestNode("Parent node", ElementPropertyMap.class, ElementData.class, ElementChildrenList.class);
        ((ElementChildrenList)parent.getFeature(ElementChildrenList.class)).add(0, stateNode);
        ElementData visibility = (ElementData)parent.getFeature(ElementData.class);
        ElementPropertyMap properties = (ElementPropertyMap)stateNode.getFeature(ElementPropertyMap.class);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parent);
        this.assertCollectChanges_initiallyInactive(stateNode, properties, isVisible -> {
            visibility.setVisible(isVisible.booleanValue());
            parent.updateActiveState();
        });
    }

    @Test
    public void recursiveAndStandAloneVisibility() {
        StateNode parentNode = new StateNode(new Class[]{ElementPropertyMap.class, ElementData.class, ElementChildrenList.class});
        StateNode childNode = new StateNode(new Class[]{ElementPropertyMap.class, ElementData.class});
        ((ElementChildrenList)parentNode.getFeature(ElementChildrenList.class)).add(0, childNode);
        Assertions.assertTrue((boolean)childNode.isVisible());
        ((ElementData)childNode.getFeature(ElementData.class)).setVisible(false);
        Assertions.assertFalse((boolean)childNode.isVisible());
        ((ElementData)childNode.getFeature(ElementData.class)).setVisible(true);
        Assertions.assertTrue((boolean)parentNode.isVisible());
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(false);
        Assertions.assertFalse((boolean)parentNode.isVisible());
        Assertions.assertFalse((boolean)childNode.isVisible());
    }

    @Test
    public void invisibleNodeNoExtraChanges() {
        Element element = ElementFactory.createAnchor();
        StateNode node = element.getNode();
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        ArrayList changes = new ArrayList();
        ((ElementPropertyMap)node.getFeature(ElementPropertyMap.class)).setProperty("foo", (Serializable)((Object)"bar"));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        node.collectChanges(changes::add);
        Assertions.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof NodeAttachChange).count());
        Assertions.assertEquals((long)2L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        List changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)changedMapKeys.contains("visible"));
        Assertions.assertTrue((boolean)changedMapKeys.contains("tag"));
        changes.clear();
        ((ElementData)node.getFeature(ElementData.class)).setVisible(true);
        node.collectChanges(changes::add);
        Assertions.assertEquals((long)2L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)changedMapKeys.contains("visible"));
        Assertions.assertTrue((boolean)changedMapKeys.contains("foo"));
    }

    @Test
    public void invisibleParentNodeNoExtraChanges() {
        Element parentElement = ElementFactory.createDiv();
        StateNode parentNode = parentElement.getNode();
        Element childElement = ElementFactory.createAnchor();
        StateNode childNode = childElement.getNode();
        ((ElementChildrenList)parentNode.getFeature(ElementChildrenList.class)).add(0, childNode);
        TestStateTree tree = new TestStateTree();
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add(0, parentNode);
        ArrayList changes = new ArrayList();
        ((ElementPropertyMap)childNode.getFeature(ElementPropertyMap.class)).setProperty("foo", (Serializable)((Object)"bar"));
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(false);
        childNode.collectChanges(changes::add);
        Assertions.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof NodeAttachChange).count());
        Assertions.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        List changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)changedMapKeys.contains("tag"));
        changes.clear();
        ((ElementData)parentNode.getFeature(ElementData.class)).setVisible(true);
        childNode.collectChanges(changes::add);
        Assertions.assertEquals((long)1L, (long)changes.stream().filter(c -> c instanceof MapPutChange).count());
        changedMapKeys = changes.stream().filter(c -> c instanceof MapPutChange).map(c -> ((MapPutChange)c).getKey()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)changedMapKeys.contains("foo"));
    }

    @Test
    public void modifyNodeTreeInAttachListener_firstAsParent_lastAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "a", "c", false);
    }

    @Test
    public void modifyNodeTreeInAttachListener_lastAsParent_firstAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "c", "a", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_middleAsParent_firstAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "b", "a", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_firstAsParent_middleAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "a", "b", true);
    }

    @Test
    public void modifyNodeTreeInAttachListener_middleAsParent_lastAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "b", "c", false);
    }

    @Test
    public void modifyNodeTreeInAttachListener_lastAsParent_middleAsChild() {
        this.assertAttachDetachEvents(this.createNodes(), "c", "b", false);
    }

    @Test
    public void detachParent_detachFirstChildOnDetachLast_oneDetachEvent() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger detachEvents = new AtomicInteger();
        childB.addDetachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childA.addDetachListener((Command & Serializable)() -> detachEvents.incrementAndGet());
        this.removeFromParent(parent);
        Assertions.assertEquals((int)1, (int)detachEvents.get());
    }

    @Test
    public void detachParent_detachLastChildOnDetachFirst_oneDetachEvent() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger detachEvents = new AtomicInteger();
        childA.addDetachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childB.addDetachListener((Command & Serializable)() -> detachEvents.incrementAndGet());
        this.removeFromParent(parent);
        Assertions.assertEquals((int)1, (int)detachEvents.get());
    }

    @Test
    public void detachParent_appendChildOnDetach_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger events = new AtomicInteger();
        childA.addDetachListener((Command & Serializable)() -> {
            StateNode b = StateNodeTest.createEmptyNode("b");
            b.addAttachListener(events::incrementAndGet);
            b.addDetachListener(events::incrementAndGet);
            this.addChild(parent, b);
        });
        this.removeFromParent(parent);
        Assertions.assertEquals((int)0, (int)events.get());
    }

    @Test
    public void detachParent_insertChildAsFirstOnDetach_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode child = StateNodeTest.createEmptyNode("a");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, child);
        this.addChild(tree.getRootNode(), parent);
        AtomicInteger events = new AtomicInteger();
        child.addDetachListener((Command & Serializable)() -> {
            StateNode b = StateNodeTest.createEmptyNode("b");
            b.addAttachListener(events::incrementAndGet);
            b.addDetachListener(events::incrementAndGet);
            ElementChildrenList list = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
            list.add(0, b);
        });
        this.removeFromParent(parent);
        Assertions.assertEquals((int)0, (int)events.get());
    }

    @Test
    public void attachParent_detachFirstOnAttachLast_noEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        AtomicInteger events = new AtomicInteger();
        childB.addAttachListener((Command & Serializable)() -> this.removeFromParent(childA));
        childA.addAttachListener(events::incrementAndGet);
        childA.addDetachListener(events::incrementAndGet);
        this.addChild(tree.getRootNode(), parent);
        Assertions.assertEquals((int)0, (int)events.get());
    }

    @Test
    public void attachParent_detachLastOnAttachFirst_attachDetachEvents() {
        TestStateTree tree = new TestStateTree();
        StateNode childA = StateNodeTest.createEmptyNode("a");
        StateNode childB = StateNodeTest.createEmptyNode("b");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        childA.addAttachListener((Command & Serializable)() -> this.removeFromParent(childB));
        ArrayList attachDetachEvents = new ArrayList();
        childB.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(true));
        childB.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        this.addChild(tree.getRootNode(), parent);
        Assertions.assertEquals((int)2, (int)attachDetachEvents.size());
        Assertions.assertTrue((boolean)((Boolean)attachDetachEvents.get(0)));
        Assertions.assertFalse((boolean)((Boolean)attachDetachEvents.get(1)));
    }

    @Test
    public void modifyNodeTreeInDetachListener_firstAsParent_lastAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "a", "c");
    }

    @Test
    public void modifyNodeTreeInDetachListener_lastAsParent_firstAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "c", "a");
    }

    @Test
    public void modifyNodeTreeInDetachListener_middleAsParent_firstAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "b", "a");
    }

    @Test
    public void modifyNodeTreeInDetachListener_firstAsParent_middleAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "a", "b");
    }

    @Test
    public void modifyNodeTreeInDetachListener_middleAsParent_lastAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "b", "c");
    }

    @Test
    public void modifyNodeTreeInDetachListener_lastAsParent_middleAsChild() {
        this.assertDetachAttachEvents(this.createNodes(), "c", "b");
    }

    @Test
    public void removeFromTree_nodeAttached_detachedAndDescendantsReset() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        StateNode child = StateNodeTest.createEmptyNode("child");
        this.addChild(parent, child);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.removeFromTree();
        Assertions.assertNull((Object)parent.getParent());
        this.assertNodesReset(parent, child);
    }

    @Test
    public void removeFromTree_nodeAttachedThenDetached_detachEventCollected() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.collectChanges(change -> Assertions.assertTrue((boolean)(change instanceof NodeAttachChange), (String)"Expected attach event for node"));
        parent.removeFromTree(true);
        Assertions.assertNull((Object)parent.getParent());
        Assertions.assertNotEquals((int)parent.getId(), (int)-1);
        parent.collectChanges(change -> Assertions.assertTrue((boolean)(change instanceof NodeDetachChange), (String)"Expected detach event for reset node"));
    }

    @Test
    public void removeFromTree_nodeAttached_detachedFullReset_noDetachEventCollected() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.collectChanges(change -> Assertions.assertTrue((boolean)(change instanceof NodeAttachChange), (String)"Expected attach event for node"));
        parent.removeFromTree();
        Assertions.assertNull((Object)parent.getParent());
        Assertions.assertEquals((int)parent.getId(), (int)-1);
        parent.collectChanges(change -> Assertions.fail((String)"No changes should be collected for detached reset node."));
    }

    @Test
    public void removeFromTree_nodeAttachedAndInDetachListener_detachedAndDescendantsReset() {
        StateNode grandParent = StateNodeTest.createParentNode("grandParent");
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(grandParent, parent);
        StateNode child = StateNodeTest.createEmptyNode("child");
        this.addChild(parent, child);
        TestStateTree tree = new TestStateTree();
        this.addChild(tree.getRootNode(), grandParent);
        parent.addDetachListener((Command & Serializable)() -> parent.removeFromTree());
        parent.setParent(null);
        this.assertNodesReset(parent, child);
    }

    @Test
    public void removeFromTree_closeUI_allowsToSetANewTree() {
        UI ui = new UI();
        final AtomicBoolean isRootAttached = new AtomicBoolean();
        isRootAttached.set(true);
        final StateNode root = new StateNode(new Class[]{ElementChildrenList.class}){

            public boolean isAttached() {
                return isRootAttached.get();
            }
        };
        StateTree stateTree = new StateTree(ui.getInternals(), new Class[]{ElementChildrenList.class}){

            public StateNode getRootNode() {
                return root;
            }

            public boolean hasNode(StateNode node) {
                if (this.getRootNode().equals(node)) {
                    return true;
                }
                return super.hasNode(node);
            }
        };
        root.setTree(stateTree);
        StateNode child = StateNodeTest.createEmptyNode("child");
        StateNode anotherChild = StateNodeTest.createEmptyNode("anotherChild");
        this.addChild(root, child);
        this.addChild(root, anotherChild);
        this.removeFromParent(anotherChild);
        Assertions.assertNotEquals((int)-1, (int)anotherChild.getId());
        child.removeFromTree();
        isRootAttached.set(false);
        anotherChild.setTree((StateTree)new TestStateTree());
        Assertions.assertEquals((int)-1, (int)anotherChild.getId());
    }

    private void assertNodesReset(StateNode ... nodes) {
        for (StateNode node : nodes) {
            Assertions.assertEquals((int)-1, (int)node.getId());
            Assertions.assertFalse((boolean)node.isAttached());
            Assertions.assertEquals((Object)NullOwner.get(), (Object)node.getOwner());
            node.collectChanges(c -> Assertions.fail((String)"No changes expected"));
        }
    }

    private void assertAttachDetachEvents(Map<String, StateNode> nodes, String newParent, String child, boolean expectSingleEvent) {
        TestStateTree tree = new TestStateTree();
        StateNode childA = nodes.get("a");
        StateNode childB = nodes.get("b");
        StateNode childC = nodes.get("c");
        StateNode newParentNode = nodes.remove(newParent);
        StateNode childNode = nodes.remove(child);
        StateNode nodeWithListener = nodes.values().iterator().next();
        nodeWithListener.addAttachListener((Command & Serializable)() -> this.addChild(newParentNode, childNode));
        ArrayList attachDetachEvents = new ArrayList();
        childNode.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(childNode.getParent()));
        childNode.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(parent, childC);
        this.addChild(tree.getRootNode(), parent);
        if (expectSingleEvent) {
            Assertions.assertEquals((int)1, (int)attachDetachEvents.size());
            Assertions.assertEquals((Object)newParentNode, attachDetachEvents.get(0));
        } else {
            Assertions.assertEquals((int)3, (int)attachDetachEvents.size());
            Assertions.assertEquals((Object)parent, attachDetachEvents.get(0));
            Assertions.assertEquals((Object)Boolean.FALSE, attachDetachEvents.get(1));
            Assertions.assertEquals((Object)newParentNode, attachDetachEvents.get(2));
        }
        Assertions.assertEquals((Object)newParentNode, (Object)childNode.getParent());
    }

    private void assertDetachAttachEvents(Map<String, StateNode> nodes, String newParent, String child) {
        TestStateTree tree = new TestStateTree();
        StateNode childA = nodes.get("a");
        StateNode childB = nodes.get("b");
        StateNode childC = nodes.get("c");
        StateNode newParentNode = nodes.remove(newParent);
        StateNode childNode = nodes.remove(child);
        StateNode nodeWithListener = nodes.values().iterator().next();
        nodeWithListener.addDetachListener((Command & Serializable)() -> this.addChild(newParentNode, childNode));
        StateNode parent = StateNodeTest.createParentNode("parent");
        this.addChild(parent, childA);
        this.addChild(parent, childB);
        this.addChild(parent, childC);
        this.addChild(tree.getRootNode(), parent);
        ArrayList attachDetachEvents = new ArrayList();
        childNode.addAttachListener((Command & Serializable)() -> attachDetachEvents.add(childNode.getParent()));
        childNode.addDetachListener((Command & Serializable)() -> attachDetachEvents.add(false));
        this.removeFromParent(parent);
        Assertions.assertEquals((int)1, (int)attachDetachEvents.size());
        Assertions.assertFalse((boolean)((Boolean)attachDetachEvents.get(0)));
    }

    private Map<String, StateNode> createNodes() {
        return Stream.of(StateNodeTest.createParentNode("a"), StateNodeTest.createParentNode("b"), StateNodeTest.createParentNode("c")).collect(Collectors.toMap(node -> node.toString(), Function.identity()));
    }

    private void addChild(StateNode parent, StateNode node) {
        this.removeFromParent(node);
        ElementChildrenList list = (ElementChildrenList)parent.getFeature(ElementChildrenList.class);
        list.add(list.size(), node);
    }

    private void removeFromParent(StateNode node) {
        if (node.getParent() == null) {
            return;
        }
        ElementChildrenList list = (ElementChildrenList)node.getParent().getFeature(ElementChildrenList.class);
        for (int i = 0; i < list.size(); ++i) {
            StateNode child = list.get(i);
            if (!node.equals(child)) continue;
            list.remove(i);
            break;
        }
    }

    private void assertCollectChanges_initiallyInactive(StateNode stateNode, ElementPropertyMap properties, Consumer<Boolean> activityUpdater) {
        TestStateTree tree = (TestStateTree)stateNode.getOwner();
        tree.dirtyNodes.clear();
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        activityUpdater.accept(false);
        properties.setProperty("foo", (Serializable)((Object)"bar"));
        boolean visibilityChanged = !visibility.isVisible();
        ArrayList changes = new ArrayList();
        stateNode.collectChanges(changes::add);
        if (visibilityChanged) {
            Assertions.assertEquals((int)1, (int)tree.dirtyNodes.size());
            MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)stateNode));
        } else {
            Assertions.assertEquals((int)2, (int)tree.dirtyNodes.size());
            stateNode.visitNodeTree(node -> MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)node)));
        }
        Assertions.assertEquals((int)(visibilityChanged ? 3 : 2), (int)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        Optional<MapPutChange> tagFound = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals("tag")).findFirst();
        Assertions.assertTrue((boolean)tagFound.isPresent(), (String)"No tag change found");
        MapPutChange tagChange = tagFound.get();
        MapPutChange change = (MapPutChange)changes.get(1);
        if (visibilityChanged) {
            MatcherAssert.assertThat((Object)((NodeChange)changes.get(2)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
            change = tagChange.equals(change) ? (MapPutChange)changes.get(2) : change;
        }
        Assertions.assertEquals((Object)Element.get((StateNode)stateNode).getTag(), (Object)tagChange.getValue());
        if (visibilityChanged) {
            Assertions.assertEquals((Object)Boolean.FALSE, (Object)change.getValue());
        }
        changes.clear();
        activityUpdater.accept(true);
        properties.setProperty("baz", (Serializable)((Object)"foo"));
        stateNode.collectChanges(changes::add);
        Assertions.assertEquals((int)(visibilityChanged ? 3 : 2), (int)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        Optional<MapPutChange> visibilityChange = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getFeature().equals(ElementData.class)).findFirst();
        if (visibilityChanged) {
            Assertions.assertTrue((boolean)visibilityChange.isPresent());
            Assertions.assertTrue((boolean)((Boolean)visibilityChange.get().getValue()));
            changes.remove(visibilityChange.get());
        }
        Optional<MapPutChange> fooUpdate = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals("foo")).findFirst();
        Assertions.assertTrue((boolean)fooUpdate.isPresent());
        Assertions.assertEquals((Object)"bar", (Object)fooUpdate.get().getValue());
        changes.remove(fooUpdate.get());
        change = (MapPutChange)changes.get(0);
        Assertions.assertEquals((Object)"foo", (Object)change.getValue());
        Assertions.assertEquals((Object)"baz", (Object)change.getKey());
        changes.clear();
        stateNode.collectChanges(changes::add);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    private void assertCollectChanges_initiallyVisible(StateNode stateNode, ElementPropertyMap properties, Consumer<Boolean> activityUpdater) {
        MapPutChange propertyChange;
        MapPutChange change;
        ElementData visibility = (ElementData)stateNode.getFeature(ElementData.class);
        properties.setProperty("foo", (Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        stateNode.collectChanges(changes::add);
        Assertions.assertEquals((int)2, (int)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        changes.clear();
        TestStateTree tree = (TestStateTree)stateNode.getOwner();
        tree.dirtyNodes.clear();
        activityUpdater.accept(false);
        properties.setProperty("foo", (Serializable)((Object)"baz"));
        stateNode.collectChanges(changes::add);
        boolean visibilityChanged = !visibility.isVisible();
        Assertions.assertEquals((int)(visibilityChanged ? 1 : 0), (int)changes.size());
        if (visibilityChanged) {
            Assertions.assertEquals((int)1, (int)tree.dirtyNodes.size());
            MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)stateNode));
            MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
            change = (MapPutChange)changes.get(0);
            Assertions.assertEquals(ElementData.class, (Object)change.getFeature());
        } else {
            Assertions.assertEquals((int)2, (int)tree.dirtyNodes.size());
            stateNode.visitNodeTree(node -> MatcherAssert.assertThat(tree.dirtyNodes, (Matcher)CoreMatchers.hasItem((Object)node)));
        }
        changes.clear();
        activityUpdater.accept(true);
        stateNode.collectChanges(changes::add);
        Assertions.assertEquals((int)(visibilityChanged ? 2 : 1), (int)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(MapPutChange.class));
        change = (MapPutChange)changes.get(0);
        if (visibilityChanged) {
            MapPutChange visibilityChange = ElementData.class.equals((Object)change.getFeature()) ? change : (MapPutChange)changes.get(1);
            propertyChange = change.equals(visibilityChange) ? (MapPutChange)changes.get(1) : change;
        } else {
            propertyChange = change;
        }
        Assertions.assertEquals(ElementPropertyMap.class, (Object)propertyChange.getFeature());
        Assertions.assertEquals((Object)"baz", (Object)propertyChange.getValue());
        changes.clear();
        stateNode.collectChanges(changes::add);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    private static class TestStateNode
    extends StateNode {
        private int i = -1;

        public TestStateNode() {
            super(new Class[]{ElementChildrenList.class});
        }

        public void setData(int data) {
            this.i = data;
        }

        public int getData() {
            return this.i;
        }

        public String toString() {
            return Integer.toString(this.getData());
        }
    }

    private static class TestStateTree
    extends StateTree {
        private Set<StateNode> dirtyNodes;

        public TestStateTree() {
            super(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        }

        public void markAsDirty(StateNode node) {
            super.markAsDirty(node);
            if (this.dirtyNodes == null) {
                this.dirtyNodes = new HashSet<StateNode>();
            }
            this.dirtyNodes.add(node);
        }
    }
}

