/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.dom.Element;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ElementStateProviderDeserializationTest {
    ElementStateProviderDeserializationTest() {
    }

    @Test
    public void shouldRemoveChildComponentFromDeserializedParent() throws Exception {
        TestParentComponent parent = (TestParentComponent)((Object)this.deserialize(this.serialize((Object)new TestParentComponent(new TestChildComponent()))));
        Component child = (Component)parent.getChildren().findFirst().orElseThrow(IllegalStateException::new);
        parent.remove(new Component[]{child});
        Assertions.assertEquals((long)0L, (long)parent.getChildren().count(), (String)"Child component should have been removed.");
    }

    private byte[] serialize(Object object) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(object);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
    }

    private static class TestParentComponent
    extends Component
    implements HasComponents {
        private static final long serialVersionUID = 1L;

        public TestParentComponent(Component ... components) {
            super(new Element("div"));
            this.add(components);
        }
    }

    private static class TestChildComponent
    extends Component {
        private static final long serialVersionUID = 1L;

        public TestChildComponent() {
            super(new Element("div"));
        }
    }
}

