/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ElementEffectTest {
    private static TestService service;

    ElementEffectTest() {
    }

    @BeforeAll
    public static void init() {
        service = new TestService();
    }

    @AfterAll
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Test
    public void effect_triggeredWithOwnerUILocked_effectRunSynchronously() {
        CurrentInstance.clearAll();
        MockUI ui = new MockUI();
        AtomicReference currentThread = new AtomicReference();
        AtomicReference currentUI = new AtomicReference();
        ValueSignal dependency = new ValueSignal(null);
        Signal.effect((Component)ui, (EffectAction & Serializable)() -> {
            dependency.get();
            currentThread.set(Thread.currentThread());
            currentUI.set(UI.getCurrent());
        });
        Assertions.assertSame((Object)Thread.currentThread(), currentThread.get());
        Assertions.assertSame((Object)((Object)ui), currentUI.get());
    }

    @Test
    public void effect_triggeredWithNoUILocked_effectRunAsynchronously() {
        CurrentInstance.clearAll();
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        session.unlock();
        UI.setCurrent(null);
        AtomicReference currentUI = new AtomicReference();
        ValueSignal dependency = new ValueSignal(null);
        Signal.effect((Component)ui, (EffectAction & Serializable)() -> {
            dependency.get();
            currentUI.set(UI.getCurrent());
        });
        service.flushExecutorAndAccessTasks(session);
        Assertions.assertSame((Object)((Object)ui), currentUI.get(), (String)"Effect should run with correct UI context");
    }

    @Test
    public void effect_triggeredWithOtherUILocked_effectRunAsynchronously() {
        CurrentInstance.clearAll();
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        session.unlock();
        VaadinSession.setCurrent(null);
        UI.setCurrent(null);
        MockVaadinSession otherSession = new MockVaadinSession((VaadinService)service);
        otherSession.lock();
        MockUI otherUi = new MockUI(otherSession);
        otherSession.unlock();
        UI.setCurrent((UI)otherUi);
        AtomicReference currentUI = new AtomicReference();
        ValueSignal dependency = new ValueSignal(null);
        Signal.effect((Component)ui, (EffectAction & Serializable)() -> {
            dependency.get();
            currentUI.set(UI.getCurrent());
        });
        service.flushExecutorAndAccessTasks(session);
        Assertions.assertSame((Object)((Object)ui), currentUI.get(), (String)"Effect should run with correct UI context");
    }

    @Test
    public void effect_throwExceptionWhenRunningDirectly_delegatedToErrorHandler() {
        CurrentInstance.clearAll();
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        ArrayList events = new ArrayList();
        session.setErrorHandler(events::add);
        ValueSignal dependency = new ValueSignal(null);
        Signal.effect((Component)ui, (EffectAction & Serializable)() -> {
            dependency.get();
            throw new RuntimeException("Expected exception");
        });
        Assertions.assertEquals((int)1, (int)events.size());
        Throwable throwable = ((ErrorEvent)events.get(0)).getThrowable();
        Assertions.assertEquals(RuntimeException.class, throwable.getClass());
    }

    @Test
    public void effect_throwExceptionWhenRunningAsynchronously_delegatedToErrorHandler() {
        CurrentInstance.clearAll();
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        ArrayList events = new ArrayList();
        session.setErrorHandler(events::add);
        UI.setCurrent(null);
        session.unlock();
        ValueSignal dependency = new ValueSignal(null);
        Signal.effect((Component)ui, (EffectAction & Serializable)() -> {
            dependency.get();
            throw new RuntimeException("Expected exception");
        });
        service.flushExecutorAndAccessTasks(session);
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Error handler should have been called");
        Throwable throwable = ((ErrorEvent)events.get(0)).getThrowable();
        Assertions.assertEquals(RuntimeException.class, throwable.getClass());
    }

    @Test
    public void effect_componentAttachedAndDetached_effectEnabledAndDisabled() {
        CurrentInstance.clearAll();
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"initial");
        AtomicInteger count = new AtomicInteger();
        Registration registration = Signal.effect((Component)component, (EffectAction & Serializable)() -> {
            signal.get();
            count.incrementAndGet();
        });
        Assertions.assertEquals((int)0, (int)count.get(), (String)"Effect should not be run until component is attached");
        signal.set((Object)"test");
        Assertions.assertEquals((int)0, (int)count.get(), (String)"Effect should not be run until component is attached even after signal value change");
        MockUI ui = new MockUI();
        ui.add(new Component[]{component});
        Assertions.assertEquals((int)1, (int)count.get(), (String)"Effect should be run once component is attached");
        signal.set((Object)"test2");
        Assertions.assertEquals((int)2, (int)count.get(), (String)"Effect should be run when signal value is chaged");
        ui.remove(new Component[]{component});
        signal.set((Object)"test3");
        Assertions.assertEquals((int)2, (int)count.get(), (String)"Effect should not be run after detach");
        ui.add(new Component[]{component});
        Assertions.assertEquals((int)3, (int)count.get(), (String)"Effect should be run after attach");
        registration.remove();
        signal.set((Object)"test4");
        Assertions.assertEquals((int)3, (int)count.get(), (String)"Effect should not be run after remove");
    }

    @Test
    public void elementEffect_signalValueChanges_componentUpdated() {
        CurrentInstance.clearAll();
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"initial");
        MockUI ui = new MockUI();
        ui.add(new Component[]{component});
        Registration & Serializable registration = () -> ((ElementEffect)new ElementEffect(component.getElement(), (EffectAction & Serializable)() -> component.setValue((String)signal.get()))).close();
        Assertions.assertEquals((Object)"initial", (Object)component.getValue(), (String)"Initial value should be set");
        signal.set((Object)"new value");
        Assertions.assertEquals((Object)"new value", (Object)component.getValue(), (String)"Component should be updated with new value");
        signal.set((Object)"another value");
        Assertions.assertEquals((Object)"another value", (Object)component.getValue(), (String)"Component should be updated with another value");
        registration.remove();
        signal.set((Object)"final value");
        Assertions.assertEquals((Object)"another value", (Object)component.getValue(), (String)"Component should not be updated after registration is removed");
    }

    @Test
    public void bindChildren_nullArguments_throws() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        TestLayout parentComponent = new TestLayout();
        new MockUI();
        Assertions.assertThrows(NullPointerException.class, () -> parentComponent.bindChildren(null, (SerializableFunction & Serializable)valueSignal -> null));
        Assertions.assertThrows(NullPointerException.class, () -> parentComponent.bindChildren((Signal)taskList, null));
    }

    @Test
    public void bindChildren_emptySharedListSignal_emptyParent() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        Assertions.assertEquals((int)0, (int)parentComponent.getComponentCount());
    }

    @Test
    public void bindChildren_emptySharedListSignalWithNotInitiallyEmptyParent_throw() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        TestLayout parentComponent = new TestLayout();
        TestComponent initialComponent = new TestComponent("initial");
        parentComponent.add(new Component[]{initialComponent});
        new MockUI().add(new Component[]{parentComponent});
        Assertions.assertThrows(IllegalStateException.class, () -> parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            Assertions.fail((String)"Should not call element factory");
            return null;
        }));
        Assertions.assertEquals((int)1, (int)parentComponent.getComponentCount());
    }

    @Test
    public void bindChildren_listSignalWithItem_parentUpdated() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        TestLayout parentComponent = new TestLayout();
        TestComponent expectedComponent = new TestComponent();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            expectedComponent.setValue((String)valueSignal.get());
            return expectedComponent;
        });
        Assertions.assertEquals((int)1, (int)parentComponent.getComponentCount());
        Assertions.assertEquals((Object)((Object)expectedComponent), parentComponent.getChildren().findFirst().orElse(null));
        Assertions.assertEquals((Object)"first", (Object)expectedComponent.getValue());
        Assertions.assertEquals((int)1, (int)expectedComponent.attachCounter);
        Assertions.assertEquals((int)0, (int)expectedComponent.detachCounter);
    }

    @Test
    public void bindChildren_addItem_parentUpdated() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        Assertions.assertEquals((int)1, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        taskList.insertLast((Object)"last");
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"last", (Object)children.get(1).getValue());
        Assertions.assertEquals((int)1, (int)children.get((int)0).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)0).detachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)1).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).detachCounter);
    }

    @Test
    public void bindChildren_removeItem_parentUpdated() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        taskList.remove((SharedValueSignal)taskList.peek().get(0));
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"middle", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"last", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
        Assertions.assertEquals((int)1, (int)children.get((int)0).attachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)0).detachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)1).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).detachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)2).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)2).detachCounter);
    }

    @Test
    public void bindChildren_moveItem_parentUpdated() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        taskList.moveTo((AbstractSignal)taskList.peek().get(2), SharedListSignal.ListPosition.first());
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"last", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        taskList.moveTo((AbstractSignal)taskList.peek().get(0), SharedListSignal.ListPosition.last());
        Assertions.assertEquals((Object)"last", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(2))).getValue());
        taskList.moveTo((AbstractSignal)taskList.peek().get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)taskList.peek().get(0)), (AbstractSignal)((AbstractSignal)taskList.peek().get(1))));
        Assertions.assertEquals((Object)"last", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
    }

    @Test
    public void bindChildren_moveLastToFirst_verifyElementAttachDetachCount() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
        taskList.moveTo((AbstractSignal)taskList.peek().get(2), SharedListSignal.ListPosition.first());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)1, (int)children.get((int)0).attachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)0).detachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).detachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)2).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)2).detachCounter);
    }

    @Test
    public void bindChildren_moveFirstToLast_verifyElementAttachDetachCount() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
        taskList.moveTo((AbstractSignal)taskList.peek().get(0), SharedListSignal.ListPosition.last());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)0, (int)children.get((int)0).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)0).detachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).detachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)2).attachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)2).detachCounter);
    }

    @Test
    public void bindChildren_moveLastBetweenFirstAndSecond_verifyElementAttachDetachCount() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = this.prepareTestLayout((SharedListSignal<String>)taskList);
        taskList.moveTo((AbstractSignal)taskList.peek().get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)taskList.peek().get(0)), (AbstractSignal)((AbstractSignal)taskList.peek().get(1))));
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)0, (int)children.get((int)0).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)0).detachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).attachCounter);
        Assertions.assertEquals((int)0, (int)children.get((int)1).detachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)2).attachCounter);
        Assertions.assertEquals((int)1, (int)children.get((int)2).detachCounter);
    }

    @Test
    public void bindChildren_addToParentComponentAndAddItem_throw() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        ElementEffect.bindChildren((Element)parentComponent.getElement(), (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()).getElement());
        TestComponent expectedComponent = new TestComponent("added directly");
        parentComponent.add(new Component[]{expectedComponent});
        taskList.insertLast((Object)"last");
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"added directly", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
    }

    @Test
    public void bindChildren_directParentComponentChanges_sameChildrenSizeBeforeAfter_throw() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertLast((Object)"first");
        taskList.insertLast((Object)"middle");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        ElementEffect.bindChildren((Element)parentComponent.getElement(), (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()).getElement());
        TestComponent directlyAddedComponent1 = new TestComponent("added directly 1");
        TestComponent directlyAddedComponent2 = new TestComponent("added directly 2");
        parentComponent.removeAll();
        parentComponent.add(new Component[]{directlyAddedComponent1});
        parentComponent.add(new Component[]{directlyAddedComponent2});
        taskList.insertLast((Object)"last");
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)5, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"first", (Object)children.get(0).getValue());
        Assertions.assertEquals((Object)"middle", (Object)children.get(1).getValue());
        Assertions.assertEquals((Object)"last", (Object)children.get(2).getValue());
        Assertions.assertEquals((Object)"added directly 1", (Object)children.get(3).getValue());
        Assertions.assertEquals((Object)"added directly 2", (Object)children.get(4).getValue());
    }

    @Test
    public void bindChildren_directParentComponentChangeByFactory_throw() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertLast((Object)"first");
        taskList.insertLast((Object)"middle");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            String value = (String)valueSignal.get();
            TestComponent component = new TestComponent(value);
            if ("middle".equals(value)) {
                parentComponent.add(new Component[]{new TestComponent("added directly")});
            }
            return component;
        });
        taskList.insertLast((Object)"last");
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        Assertions.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 2: <div></div>, expected: none", (Object)event.getThrowable().getMessage());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"first", (Object)children.get(0).getValue());
        Assertions.assertEquals((Object)"middle", (Object)children.get(1).getValue());
        Assertions.assertEquals((Object)"added directly", (Object)children.get(2).getValue());
    }

    @Test
    public void bindChildren_directParentComponentChangeByCustomAttach_throw() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertLast((Object)"first");
        taskList.insertLast((Object)"middle");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            String value = (String)valueSignal.get();
            TestComponent component = new TestComponent(value);
            if ("middle".equals(value)) {
                component.addAttachListener((ComponentEventListener & Serializable)event -> {
                    parentComponent.add(new Component[]{new TestComponent("added directly")});
                    event.unregisterListener();
                });
            }
            return component;
        });
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        Assertions.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 2: <div></div>, expected: none", (Object)event.getThrowable().getMessage());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"first", (Object)children.get(0).getValue());
        Assertions.assertEquals((Object)"middle", (Object)children.get(1).getValue());
        Assertions.assertEquals((Object)"added directly", (Object)children.get(2).getValue());
    }

    @Test
    public void bindChildren_directParentComponentChildOrderChanges_throw() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertLast((Object)"first");
        taskList.insertLast((Object)"middle");
        taskList.insertLast((Object)"last");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            String value = (String)valueSignal.get();
            TestComponent component = new TestComponent(value);
            component.getElement().setText(value);
            if ("last".equals(value)) {
                parentComponent.getElement().insertChild(0, new Element[]{parentComponent.getElement().getChild(1)});
            }
            return component;
        });
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        List<TestComponent> children = parentComponent.getChildren().map(TestComponent.class::cast).toList();
        Assertions.assertEquals((Object)"Parent element must have children matching the list signal. Unexpected child at index 0: <div>middle</div>, expected: <div>first</div>", (Object)event.getThrowable().getMessage());
        Assertions.assertEquals((int)3, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"middle", (Object)children.get(0).getValue());
        Assertions.assertEquals((Object)"first", (Object)children.get(1).getValue());
        Assertions.assertEquals((Object)"last", (Object)children.get(2).getValue());
    }

    @Test
    public void bindChildren_runInTransaction_effectRunOnce() {
        CurrentInstance.clearAll();
        ArrayList<Element> expectedMockedElements = new ArrayList<Element>();
        SharedListSignal taskList = new SharedListSignal(String.class);
        TestLayout parentComponent = new TestLayout(expectedMockedElements);
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> {
            TestComponent component = new TestComponent((String)valueSignal.get(), parentComponent.getElement(), null);
            expectedMockedElements.add(component.getElement());
            return component;
        });
        Mockito.clearInvocations((Object[])expectedMockedElements.toArray());
        Mockito.clearInvocations((Object[])new Element[]{parentComponent.getElement()});
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            taskList.insertFirst((Object)"first");
            taskList.insertLast((Object)"last");
            taskList.insertLast((Object)"middle");
            taskList.moveTo((AbstractSignal)taskList.get().get(2), SharedListSignal.ListPosition.between((AbstractSignal)((AbstractSignal)taskList.get().get(0)), (AbstractSignal)((AbstractSignal)taskList.get().get(1))));
            taskList.remove((SharedValueSignal)taskList.get().get(0));
        });
        ((Element)Mockito.verify((Object)parentComponent.getElement(), (VerificationMode)Mockito.times((int)2))).getChildren();
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent component children count is wrong");
        Assertions.assertEquals((Object)"middle", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"last", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
    }

    @Test
    public void bindChildren_withNullFromChildFactory_throws() {
        CurrentInstance.clearAll();
        LinkedList<ErrorEvent> events = this.mockLockedSessionWithErrorHandler();
        UI ui = UI.getCurrent();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        TestLayout parentComponent = new TestLayout();
        ui.add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)taskList, (SerializableFunction & Serializable)valueSignal -> null);
        ErrorEvent event = events.pollFirst();
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals(IllegalStateException.class, event.getThrowable().getClass());
        Assertions.assertEquals((Object)"HasComponents.bindChildren childFactory must not return null", (Object)event.getThrowable().getMessage());
    }

    @Test
    public void bindChildren_registrationRemove_effectRemoved() {
        CurrentInstance.clearAll();
        SharedListSignal taskList = new SharedListSignal(String.class);
        taskList.insertFirst((Object)"first");
        taskList.insertLast((Object)"second");
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        Registration registration = ElementEffect.bindChildren((Element)parentComponent.getElement(), (Signal)taskList, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()).getElement());
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent should have initial children");
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"second", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
        registration.remove();
        taskList.insertLast((Object)"third");
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount(), (String)"Parent should still have only 2 children");
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"second", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
    }

    @Test
    public void bindChildren_withLocalValueSignalList_parentUpdated() {
        CurrentInstance.clearAll();
        ValueSignal first = new ValueSignal((Object)"first");
        ValueSignal second = new ValueSignal((Object)"second");
        ValueSignal listSignal = new ValueSignal(new ArrayList<ValueSignal>(List.of(first)));
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)listSignal, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        Assertions.assertEquals((int)1, (int)parentComponent.getComponentCount());
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        listSignal.set(new ArrayList<ValueSignal>(List.of(first, second)));
        Assertions.assertEquals((int)2, (int)parentComponent.getComponentCount());
        Assertions.assertEquals((Object)"first", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        Assertions.assertEquals((Object)"second", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(1))).getValue());
        listSignal.set(new ArrayList<ValueSignal>(List.of(second)));
        Assertions.assertEquals((int)1, (int)parentComponent.getComponentCount());
        Assertions.assertEquals((Object)"second", (Object)((TestComponent)((Object)parentComponent.getChildren().toList().get(0))).getValue());
        listSignal.set(new ArrayList());
        Assertions.assertEquals((int)0, (int)parentComponent.getComponentCount());
    }

    private TestLayout prepareTestLayout(SharedListSignal<String> listSignal) {
        TestLayout parentComponent = new TestLayout();
        new MockUI().add(new Component[]{parentComponent});
        parentComponent.bindChildren((Signal)listSignal, (SerializableFunction & Serializable)valueSignal -> new TestComponent((String)valueSignal.get()));
        parentComponent.getChildren().map(TestComponent.class::cast).forEach(TestComponent::resetCounters);
        return parentComponent;
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    private static class TestService
    extends MockVaadinServletService {
        private FlushableExecutor executor;

        private TestService() {
        }

        protected Executor createDefaultExecutor() {
            this.executor = new FlushableExecutor();
            return this.executor;
        }

        public void flushExecutorAndAccessTasks(VaadinSession session) {
            this.executor.flush();
            session.lock();
            try {
                this.runPendingAccessTasks(session);
            }
            finally {
                session.unlock();
            }
        }
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        String value;
        int attachCounter;
        int detachCounter;

        public TestComponent() {
            super(new Element("div"));
            this.getElement().addAttachListener((ElementAttachListener & Serializable)event -> ++this.attachCounter);
            this.getElement().addDetachListener((ElementDetachListener & Serializable)event -> ++this.detachCounter);
        }

        public TestComponent(final Element expectedParentElementMock, final List<Element> expectedMockedChildren) {
            super((Element)Mockito.spy((Object)new Element("div"){

                public Node getParentNode() {
                    Node actualParent = super.getParentNode();
                    if (actualParent != null && expectedParentElementMock != null) {
                        return expectedParentElementMock;
                    }
                    return super.getParentNode();
                }

                public Element getChild(int index) {
                    if (expectedMockedChildren != null) {
                        return (Element)expectedMockedChildren.get(index);
                    }
                    return super.getChild(index);
                }
            }));
        }

        public TestComponent(String initialValue) {
            this();
            this.setValue(initialValue);
        }

        public TestComponent(String initialValue, Element expectedParentElementMock, List<Element> expectedMockedChildren) {
            this(expectedParentElementMock, expectedMockedChildren);
            this.setValue(initialValue);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        void resetCounters() {
            this.attachCounter = 0;
            this.detachCounter = 0;
        }
    }

    @Tag(value="div")
    private static class TestLayout
    extends TestComponent
    implements HasOrderedComponents {
        public TestLayout() {
        }

        public TestLayout(List<Element> expectedMockedChildren) {
            super(null, expectedMockedChildren);
        }
    }

    private static class FlushableExecutor
    implements Executor {
        private final List<Runnable> pendingTasks = new ArrayList<Runnable>();

        private FlushableExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.pendingTasks.add(command);
        }

        public void flush() {
            while (!this.pendingTasks.isEmpty()) {
                ArrayList<Runnable> tasks = new ArrayList<Runnable>(this.pendingTasks);
                this.pendingTasks.clear();
                tasks.forEach(Runnable::run);
            }
        }
    }
}

