/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.LinkedList;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ElementBindAttributeTest {
    private static MockVaadinServletService service;
    private LinkedList<ErrorEvent> events;

    ElementBindAttributeTest() {
    }

    @BeforeAll
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterAll
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @BeforeEach
    public void before() {
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @AfterEach
    public void after() {
        CurrentInstance.clearAll();
        this.events = null;
    }

    @Test
    public void bindAttribute_nullAttribute_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindAttribute(null, (Signal)signal));
    }

    @Test
    public void bindAttribute_illegalAttribute_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindAttribute("\"foo\"", (Signal)signal));
    }

    @Test
    public void bindAttribute_notComponent_doNotThrowException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"bar");
        element.bindAttribute("foobar", (Signal)signal);
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assertions.assertNull((Object)component.getElement().getAttribute("foo"));
    }

    @Test
    public void bindAttribute_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        component.removeFromParent();
        signal.set((Object)"baz");
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
    }

    @Test
    public void bindAttribute_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        component.removeFromParent();
        signal.set((Object)"baz");
        Assertions.assertEquals((Object)"baz", (Object)signal.peek());
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("foo"));
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((Object)"baz", (Object)component.getElement().getAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_setAttributeWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> component.getElement().setAttribute("foo", "baz"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_removeAttributeWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> component.getElement().removeAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_updateSignal_attributeChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", (Signal)signal);
        signal.set((Object)"baz");
        Assertions.assertEquals((Object)"baz", (Object)component.getElement().getAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.getElement().bindAttribute("foo", null));
    }

    @Test
    public void bindAttribute_withTwoAttributesWithSameSignal_attributesChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindAttribute("attr1", (Signal)signal);
        component.getElement().bindAttribute("attr2", (Signal)signal);
        Assertions.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr1"));
        Assertions.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr2"));
        signal.set((Object)"foobar");
        Assertions.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr1"));
        Assertions.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr2"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_withTwoAttributesAndSignals_attributesChanged() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal1 = new ValueSignal((Object)"foo");
        ValueSignal signal2 = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("attr1", (Signal)signal1);
        component.getElement().bindAttribute("attr2", (Signal)signal2);
        Assertions.assertEquals((Object)"foo", (Object)component.getElement().getAttribute("attr1"));
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getAttribute("attr2"));
        signal1.set((Object)"foobar");
        signal2.set((Object)"barfoo");
        Assertions.assertEquals((Object)"foobar", (Object)component.getElement().getAttribute("attr1"));
        Assertions.assertEquals((Object)"barfoo", (Object)component.getElement().getAttribute("attr2"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_simpleComputedSignal_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindAttribute("foo", signal.map((SignalMapper & Serializable)v -> "mapped-" + v));
        Assertions.assertEquals((Object)"mapped-bar", (Object)component.getElement().getAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_computedSignal_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal dependency = new ValueSignal(null);
        Signal signal = Signal.computed((SignalComputation & Serializable)() -> {
            dependency.get();
            return "bar";
        });
        Signal computedSignal = Signal.computed((SignalComputation & Serializable)() -> "computed-" + (String)signal.get());
        component.getElement().bindAttribute("foo", computedSignal);
        Assertions.assertEquals((Object)"computed-bar", (Object)component.getElement().getAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindAttribute_nullAttributeValue_attributeRemoved() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindAttribute("foo", signal.map((SignalMapper & Serializable)value -> value != false ? "" : null));
        Assertions.assertEquals((Object)"", (Object)component.getElement().getAttribute("foo"));
        signal.set((Object)false);
        Assertions.assertNull((Object)component.getElement().getAttribute("foo"));
        Assertions.assertFalse((boolean)component.getElement().hasAttribute("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

