/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

class HistoryTest {
    private TestUI ui = new TestUI();
    private TestPage page = new TestPage(this.ui);
    private History history;
    private VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
    private VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
    private DeploymentConfiguration configuration;
    private static final String PUSH_STATE_JS = "setTimeout(() => { window.history.pushState($0, '', $1); window.dispatchEvent(new CustomEvent('vaadin-navigated')); })";
    private static final String REPLACE_STATE_JS = "setTimeout(() => { window.history.replaceState($0, '', $1); window.dispatchEvent(new CustomEvent('vaadin-navigated')); })";
    private static final String PUSH_STATE_REACT = "window.dispatchEvent(new CustomEvent('vaadin-navigate', { detail: { state: $0, url: $1, replace: false, callback: $2 } }));";
    private static final String REPLACE_STATE_REACT = "window.dispatchEvent(new CustomEvent('vaadin-navigate', { detail: { state: $0, url: $1, replace: true, callback: $2 } }));";

    HistoryTest() {
    }

    @BeforeEach
    public void setup() {
        this.history = new History((UI)this.ui);
        this.configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)this.session.getService()).thenReturn((Object)this.service);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)this.session.getConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)false);
    }

    @Test
    public void pushState_locationWithQueryParameters_queryParametersRetained() {
        this.history.pushState((BaseJsonNode)JacksonUtils.readTree((String)"{'foo':'bar'}"), "context/view?param=4");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)((JsonNode)this.page.parameters[0]).toString(), (String)"push state not included");
        Assertions.assertEquals((Object)"context/view?param=4", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.pushState((BaseJsonNode)JacksonUtils.readTree((String)"{'foo':'bar'}"), "context/view/?param=4");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)((JsonNode)this.page.parameters[0]).toString(), (String)"push state not included");
        Assertions.assertEquals((Object)"context/view/?param=4", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void pushState_locationWithFragment_fragmentRetained() {
        this.history.pushState(null, "context/view#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view#foobar", (Object)this.page.parameters[1], (String)"fragment not retained");
        this.history.pushState(null, "context/view/#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/#foobar", (Object)this.page.parameters[1], (String)"fragment not retained");
    }

    @Test
    public void pushState_locationWithQueryParametersAndFragment_QueryParametersAndFragmentRetained() {
        this.history.pushState(null, "context/view?foo=bar#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.pushState(null, "context/view/?foo=bar#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_JS, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void replaceState_locationWithQueryParametersAndFragment_QueryParametersAndFragmentRetained() {
        this.history.replaceState(null, "context/view?foo=bar#foobar");
        Assertions.assertEquals((Object)REPLACE_STATE_JS, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.replaceState(null, "context/view/?foo=bar#foobar");
        Assertions.assertEquals((Object)REPLACE_STATE_JS, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void replaceState_locationEmpty_pushesPeriod() {
        this.history.replaceState(null, "");
        Assertions.assertEquals((Object)REPLACE_STATE_JS, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)".", (Object)this.page.parameters[1], (String)"location should be '.'");
    }

    @Test
    public void pushState_locationWithQueryParameters_queryParametersRetained_react() {
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)true);
        this.history.pushState((BaseJsonNode)JacksonUtils.readTree((String)"{'foo':'bar'}"), "context/view?param=4");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)((JsonNode)this.page.parameters[0]).toString(), (String)"push state not included");
        Assertions.assertEquals((Object)"context/view?param=4", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.pushState((BaseJsonNode)JacksonUtils.readTree((String)"{'foo':'bar'}"), "context/view/?param=4");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)((JsonNode)this.page.parameters[0]).toString(), (String)"push state not included");
        Assertions.assertEquals((Object)"context/view/?param=4", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void pushState_locationWithFragment_fragmentRetained_react() {
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)true);
        this.history.pushState(null, "context/view#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view#foobar", (Object)this.page.parameters[1], (String)"fragment not retained");
        this.history.pushState(null, "context/view/#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/#foobar", (Object)this.page.parameters[1], (String)"fragment not retained");
    }

    @Test
    public void pushState_locationWithQueryParametersAndFragment_QueryParametersAndFragmentRetained_react() {
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)true);
        this.history.pushState(null, "context/view?foo=bar#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.pushState(null, "context/view/?foo=bar#foobar");
        Assertions.assertEquals((Object)PUSH_STATE_REACT, (Object)this.page.expression, (String)"push state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void replaceState_locationWithQueryParametersAndFragment_QueryParametersAndFragmentRetained_react() {
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)true);
        this.history.replaceState(null, "context/view?foo=bar#foobar");
        Assertions.assertEquals((Object)REPLACE_STATE_REACT, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
        this.history.replaceState(null, "context/view/?foo=bar#foobar");
        Assertions.assertEquals((Object)REPLACE_STATE_REACT, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)"context/view/?foo=bar#foobar", (Object)this.page.parameters[1], (String)"invalid location");
    }

    @Test
    public void replaceState_locationEmpty_pushesPeriod_react() {
        Mockito.when((Object)this.configuration.isReactEnabled()).thenReturn((Object)true);
        this.history.replaceState(null, "");
        Assertions.assertEquals((Object)REPLACE_STATE_REACT, (Object)this.page.expression, (String)"replace state JS not included");
        Assertions.assertEquals(null, (Object)this.page.parameters[0]);
        Assertions.assertEquals((Object)".", (Object)this.page.parameters[1], (String)"location should be '.'");
    }

    private class TestUI
    extends UI {
        private TestUI() {
        }

        public Page getPage() {
            return HistoryTest.this.page;
        }

        public VaadinSession getSession() {
            return HistoryTest.this.session;
        }
    }

    private class TestPage
    extends Page {
        private String expression;
        private Object[] parameters;

        public TestPage(UI ui) {
            super(ui);
        }

        public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
            this.expression = expression;
            this.parameters = parameters;
            return null;
        }
    }
}

