/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TextTest {
    TextTest() {
    }

    @Test
    void elementAttached() {
        new Text("Foo").getParent();
    }

    @Test
    void nullText_transformsToEmptyAndDoesNotThrowException() {
        Assertions.assertEquals((Object)"", (Object)new Text(null).getText());
    }

    @Test
    void emptyText() {
        Assertions.assertEquals((Object)"", (Object)new Text("").getText());
    }

    @Test
    void setText_emptyTextCanBeChangedLater() {
        Text text = new Text(null);
        text.setText("Non Empty");
        Assertions.assertEquals((Object)"Non Empty", (Object)text.getText());
    }

    @Test
    void setText_nullIsChangedToEmptyAndDoesNotThrowException() {
        Text text = new Text("Default");
        text.setText(null);
        Assertions.assertEquals((Object)"", (Object)text.getText());
    }

    @Test
    void setGetText() {
        Assertions.assertEquals((Object)"Simple", (Object)new Text("Simple").getText());
        Assertions.assertEquals((Object)"\u00e5\u00e4\u00f6 \u20ac#%\u00b0#", (Object)new Text("\u00e5\u00e4\u00f6 \u20ac#%\u00b0#").getText());
    }

    @Test
    void setId_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.setId("foo"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot set 'id' "));
        Assertions.assertTrue((boolean)ex.getMessage().contains("component because it doesn't represent an HTML Element"));
    }

    @Test
    void setFooProperty_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        PropertyDescriptor property = PropertyDescriptors.propertyWithDefault((String)"foo", (Boolean)true);
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.set(property, (Object)false));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot set 'foo' "));
        Assertions.assertTrue((boolean)ex.getMessage().contains("component because it doesn't represent an HTML Element"));
    }

    @Test
    void setVisibility_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.setVisible(false));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot change Text component visibility"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void addClassName_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.addClassName("foo"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot add a class to the Text"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void addClassNames_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.addClassNames(new String[]{"foor", "bar"}));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot add classes to the Text"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void removeClassName_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.removeClassName("foo"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot remove a class from the Text"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void removeClassNames_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.removeClassNames(new String[]{"foo", "bar"}));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot remove classes from the Text"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void setClassName_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.setClassName("foo"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot set the Text component class"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }

    @Test
    void setClassName_withBooleanParameter_throwsWithMeaningfulMessage() {
        Text text = new Text("");
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> text.setClassName("foo", true));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Cannot set the Text component class"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("because it doesn't represent an HTML Element"));
    }
}

