/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.Tag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HasPlaceholderTest {
    HasPlaceholderTest() {
    }

    @Test
    public void withoutPlaceholderComponent_getPlaceholderReturnsNull() {
        TestComponent component = new TestComponent();
        Assertions.assertNull((Object)component.getPlaceholder());
    }

    @Test
    public void withNullPlaceholder_getPlaceholderReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setPlaceholder(null);
        Assertions.assertEquals((Object)"", (Object)component.getPlaceholder());
    }

    @Test
    public void withEmptyPlaceholder_getPlaceholderReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setPlaceholder("");
        Assertions.assertEquals((Object)"", (Object)component.getPlaceholder());
    }

    @Test
    public void setPlaceholder() {
        TestComponent component = new TestComponent();
        component.setPlaceholder("test Placeholder");
        Assertions.assertEquals((Object)"test Placeholder", (Object)component.getPlaceholder());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasPlaceholder {
        private TestComponent() {
        }
    }
}

