/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.communication.UidlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class UidlRequestHandler
extends SynchronizedRequestHandler
implements SessionExpiredHandler {
    private AtomicReference<ServerRpcHandler> rpcHandler = new AtomicReference();
    public static final Pattern HASH_PATTERN = Pattern.compile("window.location.hash ?= ?'(.*?)'");
    public static final Pattern URL_PATTERN = Pattern.compile("^(.*)#(.+)$");
    public static final String PUSH_STATE_HASH = "setTimeout(() => history.pushState(null, null, location.pathname + location.search + '#%s'));";
    public static final String PUSH_STATE_LOCATION = "setTimeout(() => history.pushState(null, null, '%s'));";
    private static final String SYNC_ID = "\"syncId\"";
    private static final String RPC = "rpc";
    private static final String LOCATION = "location";
    private static final String CHANGES = "changes";
    private static final String EXECUTE = "execute";

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL);
    }

    protected ServerRpcHandler createRpcHandler() {
        return new ServerRpcHandler();
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        String requestBody = SynchronizedRequestHandler.getRequestBody(request.getReader());
        Optional<SynchronizedRequestHandler.ResponseWriter> responseWriter = this.synchronizedHandleRequest(session, request, response, requestBody);
        if (responseWriter.isPresent()) {
            responseWriter.get().writeResponse();
        }
        return responseWriter.isPresent();
    }

    @Override
    public boolean isReadAndWriteOutsideSessionLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SynchronizedRequestHandler.ResponseWriter> synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, String requestBody) throws IOException, UnsupportedOperationException {
        UI uI = session.getService().findUI(request);
        if (uI == null) {
            return Optional.of(() -> UidlRequestHandler.commitJsonResponse(response, VaadinService.createUINotFoundJSON(false)));
        }
        try (StringWriter stringWriter = new StringWriter();){
            this.getRpcHandler().handleRpc(uI, requestBody, request);
            this.writeUidl(uI, stringWriter, false);
        }
        return Optional.of(() -> UidlRequestHandler.commitJsonResponse(response, stringWriter.toString()));
    }

    private void writeRefresh(VaadinResponse response) throws IOException {
        String json = VaadinService.createCriticalNotificationJSON(null, null, null, null);
        UidlRequestHandler.commitJsonResponse(response, json);
    }

    private void writeSyncError(SystemMessages systemMessages, VaadinResponse response) throws IOException {
        String json = VaadinService.createCriticalNotificationJSON(systemMessages.getSyncErrorCaption(), systemMessages.getSyncErrorMessage(), null, systemMessages.getSyncErrorURL());
        UidlRequestHandler.commitJsonResponse(response, json);
    }

    void writeUidl(UI ui, Writer writer, boolean resync) throws IOException {
        ObjectNode uidl = this.createUidl(ui, resync);
        this.removeOffendingMprHashFragment(uidl);
        String responseString = uidl.toString();
        ui.getInternals().setLastRequestResponse(responseString);
        writer.write(responseString);
    }

    ObjectNode createUidl(UI ui, boolean resync) {
        return new UidlWriter().createUidl(ui, false, resync);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UidlRequestHandler.class.getName());
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL)) {
            return false;
        }
        VaadinService service = request.getService();
        service.writeUncachedStringResponse(response, "application/json; charset=UTF-8", VaadinService.createSessionExpiredJSON(false));
        return true;
    }

    private ServerRpcHandler getRpcHandler() {
        ServerRpcHandler handler = this.rpcHandler.get();
        if (handler == null) {
            this.rpcHandler.compareAndSet(null, this.createRpcHandler());
            handler = this.rpcHandler.get();
        }
        return handler;
    }

    public static void commitJsonResponse(VaadinResponse response, String json) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        byte[] b = json.getBytes(StandardCharsets.UTF_8);
        response.setContentLength(b.length);
        OutputStream outputStream = response.getOutputStream();
        outputStream.write(b);
        outputStream.flush();
    }

    private void removeOffendingMprHashFragment(ObjectNode uidl) {
        if (!uidl.has(EXECUTE)) {
            return;
        }
        ArrayNode exec = (ArrayNode)uidl.get(EXECUTE);
        String location = null;
        int idx = -1;
        for (int i = 0; i < exec.size(); ++i) {
            ArrayNode arr = (ArrayNode)exec.get(i);
            for (int j = 0; j < arr.size(); ++j) {
                ObjectNode json;
                if (!arr.get(j).getNodeType().equals((Object)JsonNodeType.STRING)) continue;
                String script = arr.get(j).asString();
                if (script.contains("history.pushState")) {
                    idx = i;
                    continue;
                }
                if (!script.startsWith(SYNC_ID) || (location = this.removeHashInV7Uidl(json = JacksonUtils.readTree("{" + script + "}"))) == null) continue;
                script = json.toPrettyString();
                script = script.substring(1, script.length() - 1);
                arr.set(j, script);
            }
        }
        if (location != null) {
            ArrayNode arr = JacksonUtils.createArrayNode();
            arr.add("");
            arr.add(String.format(location.startsWith("http") ? PUSH_STATE_LOCATION : PUSH_STATE_HASH, location));
            if (idx >= 0) {
                exec.set(idx, (JsonNode)arr);
            } else {
                exec.add((JsonNode)arr);
            }
        }
    }

    private String removeHashInV7Uidl(ObjectNode json) {
        String removed = null;
        ArrayNode changes = (ArrayNode)json.get(CHANGES);
        for (int i = 0; i < changes.size(); ++i) {
            String hash = this.removeHashInChange((ArrayNode)changes.get(i));
            if (hash == null) continue;
            removed = hash;
        }
        ArrayNode rpcs = (ArrayNode)json.get(RPC);
        for (int i = 0; i < rpcs.size(); ++i) {
            String hash = this.removeHashInRpc((ArrayNode)rpcs.get(i));
            if (removed != null || hash == null) continue;
            removed = hash;
        }
        return removed;
    }

    private String removeHashInChange(ArrayNode change) {
        if (change.size() < 3 || !change.get(2).getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            return null;
        }
        ArrayNode value = (ArrayNode)change.get(2);
        if (value.size() < 2 || !value.get(1).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            return null;
        }
        ObjectNode location = (ObjectNode)value.get(1);
        if (!location.has(LOCATION)) {
            return null;
        }
        String url = location.get(LOCATION).asString();
        Matcher match = URL_PATTERN.matcher(url);
        if (match.find()) {
            location.put(LOCATION, match.group(1));
            return url;
        }
        return null;
    }

    private String removeHashInRpc(ArrayNode rpc) {
        if (!(rpc.size() == 4 && rpc.get(1).getNodeType().equals((Object)JsonNodeType.STRING) && rpc.get(2).getNodeType().equals((Object)JsonNodeType.STRING) && rpc.get(3).getNodeType().equals((Object)JsonNodeType.ARRAY) && "com.vaadin.shared.extension.javascriptmanager.ExecuteJavaScriptRpc".equals(rpc.get(1).asString()) && "executeJavaScript".equals(rpc.get(2).asString()))) {
            return null;
        }
        ArrayNode scripts = (ArrayNode)rpc.get(3);
        for (int j = 0; j < scripts.size(); ++j) {
            String exec = scripts.get(j).asString();
            Matcher match = HASH_PATTERN.matcher(exec);
            if (!match.find()) continue;
            scripts.set(j, ";");
            return match.group(1);
        }
        return null;
    }

    private static /* synthetic */ void lambda$synchronizedHandleRequest$5c533d33$1(VaadinResponse response, String json) throws IOException {
        UidlRequestHandler.commitJsonResponse(response, json);
    }

    private /* synthetic */ void lambda$synchronizedHandleRequest$1f85e9a1$1(SystemMessages systemMessages, VaadinResponse response) throws IOException {
        this.writeSyncError(systemMessages, response);
    }

    private /* synthetic */ void lambda$synchronizedHandleRequest$c7ea7c85$3(VaadinResponse response) throws IOException {
        this.writeRefresh(response);
    }

    private /* synthetic */ void lambda$synchronizedHandleRequest$c7ea7c85$2(VaadinResponse response) throws IOException {
        this.writeRefresh(response);
    }
}

