/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.SharedValueSignalTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EffectTest
extends SignalTestBase {
    @Test
    void newEffect_actionIsRunOnce() {
        AtomicInteger count = new AtomicInteger();
        Signal.unboundEffect((EffectAction & Serializable)() -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void newEffect_closeImmediately_actionIsRunOnce() {
        AtomicInteger count = new AtomicInteger();
        Signal.unboundEffect((EffectAction & Serializable)() -> count.incrementAndGet()).remove();
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    void changeTracking_effectReadsValue_effectRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals(List.of(""), invocations);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("", "update"), invocations);
        signal.set((Object)"again");
        Assertions.assertEquals(List.of("", "update", "again"), invocations);
    }

    @Test
    void changeTracking_changeListStructure_effectRunAgain() {
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add(signal.get().size()));
        Assertions.assertEquals(List.of(Integer.valueOf(0)), invocations);
        SharedValueSignal child = (SharedValueSignal)signal.insertLast((Object)"one").signal();
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1)), invocations);
        signal.remove(child);
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0)), invocations);
    }

    @Test
    void changeTracking_changeMapStructure_effectRunAgain() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add(signal.get().size()));
        Assertions.assertEquals(List.of(Integer.valueOf(0)), invocations);
        signal.put("key", (Object)"value");
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1)), invocations);
        signal.remove("key");
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0)), invocations);
    }

    @Test
    void changeTracking_effectStopsReadingValue_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        AtomicBoolean read = new AtomicBoolean(true);
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            if (read.get()) {
                invocations.add((String)signal.get());
            } else {
                invocations.add("ignored");
            }
        });
        read.set(false);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("", "ignored"), invocations);
        read.set(true);
        signal.set((Object)"again");
        Assertions.assertEquals(List.of("", "ignored"), invocations, (String)"The effect should no longer depend on the signal");
    }

    @Test
    void changeTracking_effectReadsThrougUntracked_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        AtomicBoolean read = new AtomicBoolean(true);
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            if (read.get()) {
                invocations.add((String)signal.get());
            } else {
                invocations.add((String)Signal.untracked((ValueSupplier & Serializable)() -> "untracked: " + (String)signal.get()));
            }
        });
        read.set(false);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("", "untracked: update"), invocations);
        read.set(true);
        signal.set((Object)"again");
        Assertions.assertEquals(List.of("", "untracked: update"), invocations, (String)"The effect should no longer depend on the signal");
    }

    @Test
    void changeTracking_failedWrite_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        signal.replace((Object)"foo", (Object)"bar");
        Assertions.assertEquals(List.of(""), invocations);
    }

    @Test
    void changeTracking_multipleWritesInTransaction_effectRunOnce() {
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal.set((Object)"first");
            signal.set((Object)"second");
        });
        Assertions.assertEquals(List.of("", "second"), invocations);
    }

    @Test
    void changeTracking_multipleSignalsInTransaction_effectRunOnce() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal1.get() + (String)signal2.get()));
        Signal.runInTransaction((TransactionTask & Serializable)() -> {
            signal1.set((Object)"one ");
            signal2.set((Object)"two");
        });
        Assertions.assertEquals(List.of("", "one two"), invocations);
    }

    @Test
    void changeTracking_changeOtherPartOfNode_effectNotRunAgain() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals(List.of("value"), invocations);
        signal.asNode().putChildWithValue("key", (Object)"value");
        Assertions.assertEquals(List.of("value"), invocations);
    }

    @Test
    void changeTracking_asyncSignal_effectUsesSubmittedValue() {
        SharedValueSignalTest.AsyncSharedValueSignal signal = new SharedValueSignalTest.AsyncSharedValueSignal();
        signal.set("");
        signal.tree().confirmSubmitted();
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals(List.of(""), invocations);
        signal.replace("", "update");
        Assertions.assertEquals(List.of("", "update"), invocations);
        signal.tree().confirm(List.of(TestUtil.writeRootValueCommand("conflict")));
        Assertions.assertEquals(List.of("", "update", "conflict"), invocations);
        signal.tree().confirmSubmitted();
        Assertions.assertEquals(List.of("", "update", "conflict"), invocations);
    }

    @Test
    void changeTracking_noOpChange_effectNotRunButRemainsActive() {
        SharedValueSignal signal = new SharedValueSignal((Object)"value");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals(List.of("value"), invocations);
        signal.set((Object)"value");
        Assertions.assertEquals(List.of("value"), invocations);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("value", "update"), invocations);
    }

    @Test
    void changeTracking_readChildNodes_coveredByNextEffectInvocation() {
        SharedListSignal signal = new SharedListSignal(String.class);
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            List<String> values = signal.get().stream().map(Signal::get).toList();
            invocations.add(values);
        });
        Assertions.assertEquals(List.of(List.of()), invocations);
        signal.insertLast((Object)"One");
        Assertions.assertEquals(List.of(List.of(), List.of("One")), invocations);
        signal.insertLast((Object)"Two");
        Assertions.assertEquals(List.of(List.of(), List.of("One"), List.of("One", "Two")), invocations);
    }

    @Test
    void changeTracking_changeValueToNull_effectTriggered() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        Assertions.assertEquals(Arrays.asList("initial"), invocations);
        signal.set(null);
        Assertions.assertEquals(Arrays.asList("initial", null), invocations);
    }

    @Test
    void changeTracking_lambdaSignal_changeTracked() {
        SharedValueSignal signal = new SharedValueSignal((Object)1);
        Signal & Serializable doubled = (Signal & Serializable)() -> (Integer)signal.get() * 2;
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((Integer)doubled.get()));
        Assertions.assertEquals(List.of(Integer.valueOf(2)), invocations);
        signal.set((Object)2);
        Assertions.assertEquals(List.of(Integer.valueOf(2), Integer.valueOf(4)), invocations);
    }

    @Test
    void close_effectReadsValue_affectNotRunAfterClose() {
        ArrayList invocations = new ArrayList();
        SharedValueSignal signal = new SharedValueSignal((Object)"");
        Registration closer = Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        closer.remove();
        signal.set((Object)"update");
        Assertions.assertEquals(List.of(""), invocations);
    }

    @Test
    void dispatcher_multipleWrites_singleUpdateWhenDispatcherTriggers() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
        signal.set((Object)"update1");
        signal.set((Object)"update2");
        Assertions.assertEquals(List.of("initial"), invocations);
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial", "update2"), invocations);
    }

    @Test
    void dispatcher_closeWithPendingUpdate_noUpdate() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        Registration closer = Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("initial"), invocations);
        closer.remove();
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("initial"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsException_effectRemainsFunctional() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        RuntimeException exception = new RuntimeException("Expected exception");
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            invocations.add((String)signal.get());
            throw exception;
        });
        this.assertUncaughtException(exception);
        signal.set((Object)"update");
        this.assertUncaughtException(exception);
        Assertions.assertEquals(List.of("initial", "update"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsException_otherEffectsWork() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        RuntimeException exception = new RuntimeException("Expected exception");
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            throw exception;
        });
        this.assertUncaughtException(exception);
        ArrayList invocations = new ArrayList();
        Signal.unboundEffect((EffectAction & Serializable)() -> invocations.add((String)signal.get()));
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("initial", "update"), invocations);
    }

    @Test
    void exceptionHandling_effectThrowsError_effectClosed() {
        SharedValueSignal signal = new SharedValueSignal((Object)"initial");
        ArrayList invocations = new ArrayList();
        Error error = new Error("Expected error");
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            invocations.add((String)signal.get());
            throw error;
        });
        Assertions.assertEquals(List.of("initial"), invocations);
        this.assertUncaughtException((Throwable caught) -> caught.getCause() == error);
        signal.set((Object)"update");
        Assertions.assertEquals(List.of("initial"), invocations);
    }

    @Test
    void infiniteLoopDetection_writeUnrelatedSignal_noError() {
        SharedValueSignal other = new SharedValueSignal((Object)"other");
        SharedValueSignal signal = new SharedValueSignal((Object)"signal");
        Signal.unboundEffect((EffectAction & Serializable)() -> other.set((Object)((String)signal.get())));
        Assertions.assertEquals((Object)"signal", (Object)other.get());
        signal.set((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)other.get());
    }

    @Test
    void infiniteLoopDetection_writeOwnSignal_loopDetected() {
        SharedValueSignal signal = new SharedValueSignal((Object)"signal");
        SharedValueSignal trigger = new SharedValueSignal((Object)"trigger");
        AtomicInteger count = new AtomicInteger();
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            count.incrementAndGet();
            trigger.get();
            signal.get();
            Assertions.assertThrows(IllegalStateException.class, () -> signal.set((Object)"update"));
        });
        Assertions.assertEquals((int)1, (int)count.get());
        trigger.set((Object)"update");
        Assertions.assertEquals((int)1, (int)count.get(), (String)"Signal should have been disabled");
    }

    @Test
    void infiniteLoopDetection_loopBetweenEffects_loopDetectedFromSetter() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        AtomicInteger throwCount = new AtomicInteger();
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            String value = (String)signal2.get() + " update";
            try {
                signal1.set((Object)value);
            }
            catch (IllegalStateException e) {
                throwCount.incrementAndGet();
            }
        });
        Assertions.assertEquals((int)0, (int)throwCount.get(), (String)"Should not fail with only one effect active");
        Signal.unboundEffect((EffectAction & Serializable)() -> signal2.set((Object)((String)signal1.get() + " update")));
        Assertions.assertEquals((int)1, (int)throwCount.get(), (String)"Should fail when the other effect is created");
    }

    @Test
    void infiniteLoopDetection_loopBetweenConditionalEffects_loopDetected() {
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        SharedValueSignal trigger = new SharedValueSignal((Object)false);
        Signal.unboundEffect((EffectAction & Serializable)() -> signal1.set((Object)((String)signal2.get() + " update")));
        Signal.unboundEffect((EffectAction & Serializable)() -> {
            if (((Boolean)trigger.get()).booleanValue()) {
                signal2.set((Object)((String)signal1.get() + " update"));
            }
        });
        this.assertNoUncaughtException();
        trigger.set((Object)true);
        this.assertUncaughtException(IllegalStateException.class);
    }

    @Test
    void infiniteLoopDetection_loopBetweenAsyncEffects_loopDetected() {
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        SharedValueSignal signal1 = new SharedValueSignal((Object)"signal");
        SharedValueSignal signal2 = new SharedValueSignal((Object)"signal");
        Signal.unboundEffect((EffectAction & Serializable)() -> signal1.set((Object)((String)signal2.get() + " update")));
        dispatcher.runPendingTasks();
        Signal.unboundEffect((EffectAction & Serializable)() -> signal2.set((Object)((String)signal1.get() + " update")));
        dispatcher.runPendingTasks();
        this.assertNoUncaughtException();
        dispatcher.runPendingTasks();
        this.assertUncaughtException(IllegalStateException.class);
    }

    @Test
    void infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop() {
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        ArrayList invocations = new ArrayList();
        SharedValueSignal<String> signal = new SharedValueSignal<String>("signal"){

            protected UsageTracker.Usage createUsage(Transaction transaction) {
                final UsageTracker.Usage usage = super.createUsage(transaction);
                return new UsageTracker.Usage(){

                    public boolean hasChanges() {
                        return usage.hasChanges();
                    }

                    public Registration onNextChange(TransientListener listener) {
                        this.set("update");
                        return usage.onNextChange(listener);
                    }
                };
            }
        };
        Signal.unboundEffect(() -> EffectTest.lambda$infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop$993b51ad$1(invocations, (SharedValueSignal)signal));
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("signal"), invocations);
        dispatcher.runPendingTasks();
        Assertions.assertEquals(List.of("signal", "update"), invocations);
    }

    private static /* synthetic */ void lambda$infiniteLoopDetection_concurrentSignalWrite_notDetectedAsLoop$993b51ad$1(List invocations, SharedValueSignal signal) {
        invocations.add((String)signal.get());
    }
}

