/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@NotThreadSafe
class WebComponentConfigurationRegistryTest {
    private static final String MY_COMPONENT_TAG = "my-component";
    private static final String USER_BOX_TAG = "user-box";
    protected WebComponentConfigurationRegistry registry;
    protected VaadinContext context;

    WebComponentConfigurationRegistryTest() {
    }

    protected WebComponentConfigurationRegistry createRegistry() {
        return new WebComponentConfigurationRegistry(){};
    }

    @BeforeEach
    public void init() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinService.setCurrent((VaadinService)service);
        Mockito.when((Object)service.getContext()).thenReturn((Object)this.context);
        WebComponentConfigurationRegistry instance = this.createRegistry();
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute(WebComponentConfigurationRegistry.class))).thenReturn((Object)instance);
        Mockito.when((Object)((WebComponentConfigurationRegistry)this.context.getAttribute((Class)ArgumentMatchers.eq(WebComponentConfigurationRegistry.class), (Supplier)ArgumentMatchers.any()))).thenReturn((Object)instance);
        this.registry = WebComponentConfigurationRegistry.getInstance((VaadinContext)this.context);
    }

    @Test
    public void assertWebComponentRegistry() {
        Assertions.assertNotNull((Object)this.registry);
    }

    @Test
    public void assertRegistryIsSingleton() {
        Assertions.assertSame((Object)this.registry, (Object)WebComponentConfigurationRegistry.getInstance((VaadinContext)this.context), (String)"WebComponentConfigurationRegistry instance should be singleton");
    }

    @Test
    public void setConfigurations_allCanBeFoundInRegistry() {
        Assertions.assertTrue((boolean)this.registry.setConfigurations(this.createConfigurations(MyComponentExporter.class, UserBoxExporter.class)), (String)"Registry should have accepted the webComponents");
        Assertions.assertEquals((int)2, (int)this.registry.getConfigurations().size(), (String)"Expected two targets to be registered");
        Assertions.assertEquals(MyComponent.class, (Object)((WebComponentConfiguration)this.registry.getConfiguration(MY_COMPONENT_TAG).get()).getComponentClass(), (String)"Tag 'my-component' should have returned 'WebComponentBuilder' matching MyComponent");
        Assertions.assertEquals(UserBox.class, (Object)((WebComponentConfiguration)this.registry.getConfiguration(USER_BOX_TAG).get()).getComponentClass(), (String)"Tag 'user-box' should have returned 'WebComponentBuilder' matching UserBox");
    }

    @Test
    public void setConfigurations_getConfigurationsCallDoesNotChangeSetProtection() {
        this.registry.setConfigurations(this.createConfigurations(MyComponentExporter.class));
        WebComponentConfiguration conf1 = (WebComponentConfiguration)this.registry.getConfiguration(MY_COMPONENT_TAG).get();
        Assertions.assertNotNull((Object)conf1);
        Assertions.assertFalse((boolean)this.registry.setConfigurations(this.createConfigurations(UserBoxExporter.class)));
        WebComponentConfiguration conf2 = (WebComponentConfiguration)this.registry.getConfiguration(MY_COMPONENT_TAG).get();
        Assertions.assertEquals((Object)conf1, (Object)conf2);
    }

    @Test
    public void getWebComponentConfigurationsForComponent() {
        this.registry.setConfigurations(this.createConfigurations(MyComponentExporter.class, MyComponentExporter2.class, UserBoxExporter.class));
        Set set = this.registry.getConfigurationsByComponentType(MyComponent.class);
        Assertions.assertEquals((int)2, (int)set.size(), (String)"Set should contain two configurations");
        Assertions.assertTrue((boolean)set.stream().map(WebComponentConfiguration::getComponentClass).allMatch(clazz -> clazz.equals(MyComponent.class)), (String)"Both configurations should have component class MyComponent.class");
    }

    @Test
    public void setConfigurationsTwice_onlyFirstSetIsAccepted() {
        Set<WebComponentConfiguration<? extends Component>> configs1st = this.createConfigurations(MyComponentExporter.class);
        Set<WebComponentConfiguration<? extends Component>> configs2nd = this.createConfigurations(UserBoxExporter.class);
        Assertions.assertTrue((boolean)this.registry.setConfigurations(configs1st), (String)"Registry should have accepted the configurations");
        Assertions.assertFalse((boolean)this.registry.setConfigurations(configs2nd), (String)"Registry should not accept a second set of configurations.");
        Assertions.assertEquals(MyComponent.class, (Object)((WebComponentConfiguration)this.registry.getConfiguration(MY_COMPONENT_TAG).get()).getComponentClass(), (String)"Builders from the first Set should have been added");
        Assertions.assertFalse((boolean)this.registry.getConfiguration(USER_BOX_TAG).isPresent(), (String)"Components from the second Set should not have been added");
    }

    @Test
    public void getConfigurations_uninitializedReturnsEmptySet() {
        WebComponentConfigurationRegistry uninitializedRegistry = new WebComponentConfigurationRegistry();
        Set set = uninitializedRegistry.getConfigurations();
        Assertions.assertEquals((int)0, (int)set.size(), (String)"Configuration set should be empty");
    }

    @Test
    public void hasConfigurations() {
        this.registry.setConfigurations(this.createConfigurations(MyComponentExporter.class, MyComponentExporter2.class, UserBoxExporter.class));
        Assertions.assertTrue((boolean)this.registry.hasConfigurations(), (String)"Should have configurations, when 3 were set");
    }

    @Test
    public void hasConfigurations_noConfigurations() {
        Assertions.assertFalse((boolean)this.registry.hasConfigurations(), (String)"New registry should have no configurations");
        this.registry.setConfigurations(Collections.emptySet());
        Assertions.assertFalse((boolean)this.registry.hasConfigurations(), (String)"Should not have configurations, when empty set is given");
    }

    @Test
    public void setSameRouteValueFromDifferentThreads_ConcurrencyTest() throws InterruptedException, ExecutionException {
        int THREADS = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        List callables = IntStream.range(0, 10).mapToObj(i -> {
            Callable<AtomicBoolean> callable = () -> {
                Thread.sleep(new Random().nextInt(200));
                return new AtomicBoolean(this.registry.setConfigurations(this.createConfigurations(MyComponentExporter.class)));
            };
            return callable;
        }).collect(Collectors.toList());
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        Assertions.assertEquals((int)10, (int)futures.size(), (String)"Expected a result for all threads");
        ArrayList<AtomicBoolean> results = new ArrayList<AtomicBoolean>();
        for (Future resultFuture : futures) {
            results.add((AtomicBoolean)resultFuture.get());
        }
        Assertions.assertEquals((long)9L, (long)results.stream().filter(result -> !result.get()).count(), (String)"Expected all except one thread to return false");
    }

    protected Set<WebComponentConfiguration<? extends Component>> createConfigurations(Class<? extends WebComponentExporter<? extends Component>> ... exporters) {
        WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();
        HashSet<WebComponentConfiguration<? extends Component>> configurations = new HashSet<WebComponentConfiguration<? extends Component>>();
        for (Class<? extends WebComponentExporter<? extends Component>> exporter : exporters) {
            configurations.add((WebComponentConfiguration<? extends Component>)factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(exporter).create()));
        }
        return configurations;
    }

    protected static class MyComponentExporter
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter() {
            super(WebComponentConfigurationRegistryTest.MY_COMPONENT_TAG);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    protected static class UserBoxExporter
    extends WebComponentExporter<UserBox> {
        public UserBoxExporter() {
            super(WebComponentConfigurationRegistryTest.USER_BOX_TAG);
        }

        public void configureInstance(WebComponent<UserBox> webComponent, UserBox component) {
        }
    }

    protected class MyComponent
    extends Component {
        protected MyComponent() {
        }
    }

    protected class UserBox
    extends Component {
        protected UserBox() {
        }
    }

    protected static class MyComponentExporter2
    extends WebComponentExporter<MyComponent> {
        public MyComponentExporter2() {
            super("my-component-2");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }
}

