/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.PropertyData;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropertyConfigurationImplTest {
    PropertyConfigurationImpl<MyComponent, Integer> intPropertyConf;

    PropertyConfigurationImplTest() {
    }

    @BeforeEach
    public void init() {
        this.intPropertyConf = new PropertyConfigurationImpl(MyComponent.class, "int", Integer.class, (Serializable)Integer.valueOf(1));
    }

    @Test
    public void onChange() {
        this.intPropertyConf.onChange(MyComponent::setInt);
        MyComponent myComponent = new MyComponent();
        this.intPropertyConf.getOnChangeHandler().accept((Object)myComponent, (Object)5);
        Assertions.assertEquals((int)5, (int)myComponent.value, (String)"onChangeHandler should have been set and value updated");
    }

    @Test
    public void onChange_throwsIfCalledTwice() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this.intPropertyConf.onChange(MyComponent::setInt);
            this.intPropertyConf.onChange(MyComponent::setInt);
        });
    }

    @Test
    public void readOnly() {
        this.intPropertyConf.readOnly();
        PropertyData data = this.intPropertyConf.getPropertyData();
        Assertions.assertEquals((int)1, (int)((Integer)data.getDefaultValue()), (String)"default value is 1");
        Assertions.assertTrue((boolean)data.isReadOnly(), (String)"read-only flag should have been set to true");
    }

    @Tag(value="for-reasons")
    private static final class MyComponent
    extends Component {
        private int value;

        private MyComponent() {
        }

        public void setInt(int newValue) {
            this.value = newValue;
        }
    }
}

