/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.internal.EncodeUtil;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.DownloadEvent;
import java.io.IOException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DownloadEventTest {
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;

    DownloadEventTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
    }

    @Test
    public void setFileName_nonEmptyFileName_setsContentDispositionFilenameQuotedToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "test.txt";
        downloadEvent.setFileName(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    @Test
    public void setFileName_nonEmptyFileName_setsContentDispositionEncodedFilenameQuotedToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "test \u00fc\u00f1\u00ee\u00e7\u00f8d\u00eb.txt";
        downloadEvent.setFileName(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "attachment; filename=\"" + EncodeUtil.rfc2047Encode((String)fileName) + "\"; filename*=UTF-8''" + EncodeUtil.rfc5987Encode((String)fileName));
    }

    @Test
    public void setFileName_emptyFileName_setsContentDispositionToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "";
        downloadEvent.setFileName(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "attachment");
    }

    @Test
    public void setFileName_blankFileName_setsContentDispositionToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "   ";
        downloadEvent.setFileName(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "attachment");
    }

    @Test
    public void setFileName_nullFileName_doesNotSetContentDispositionToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.setFileName(null);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setHeader(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void setFileName_headerAlreadySet_doesNotOverrideHeader() {
        Mockito.when((Object)this.response.containsHeader("Content-Disposition")).thenReturn((Object)true);
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.setFileName("test.txt");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setHeader((String)Mockito.eq((Object)"Content-Disposition"), Mockito.anyString());
    }

    @Test
    public void inline_noFileName_setsContentDispositionInlineToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline();
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline");
    }

    @Test
    public void inline_withASCIIFileName_setsContentDispositionInlineWithFilenameToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "document.pdf";
        downloadEvent.inline(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
    }

    @Test
    public void inline_withNonASCIIFileName_setsContentDispositionInlineWithEncodedFilenameToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String fileName = "d\u00f6k\u00fcm\u00e4nt \u00fc\u00f1\u00ee\u00e7\u00f8d\u00eb.pdf";
        downloadEvent.inline(fileName);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline; filename=\"" + EncodeUtil.rfc2047Encode((String)fileName) + "\"; filename*=UTF-8''" + EncodeUtil.rfc5987Encode((String)fileName));
    }

    @Test
    public void inline_nullFileName_setsContentDispositionInlineToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline(null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline");
    }

    @Test
    public void inline_emptyFileName_setsContentDispositionInlineToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline("");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline");
    }

    @Test
    public void inline_blankFileName_setsContentDispositionInlineToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline("   ");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setHeader("Content-Disposition", "inline");
    }

    @Test
    public void inline_headerAlreadySet_doesNotOverrideHeader() {
        Mockito.when((Object)this.response.containsHeader("Content-Disposition")).thenReturn((Object)true);
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline();
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setHeader((String)Mockito.eq((Object)"Content-Disposition"), Mockito.anyString());
    }

    @Test
    public void inline_withFileNameHeaderAlreadySet_doesNotOverrideHeader() {
        Mockito.when((Object)this.response.containsHeader("Content-Disposition")).thenReturn((Object)true);
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        downloadEvent.inline("test.pdf");
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setHeader((String)Mockito.eq((Object)"Content-Disposition"), Mockito.anyString());
    }

    @Test
    public void setContentType_setsContentTypeToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        String contentType = "application/pdf";
        downloadEvent.setContentType(contentType);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentType(contentType);
    }

    @Test
    public void setContentLenght_setsContentLengthToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        int contentLength = 1024;
        downloadEvent.setContentLength((long)contentLength);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setContentLengthLong((long)contentLength);
    }

    @Test
    public void setContentLenght_unknownLength_doesNotSetContentLengthToResponse() {
        DownloadEvent downloadEvent = new DownloadEvent(this.request, this.response, this.session, null);
        int contentLength = -1;
        downloadEvent.setContentLength((long)contentLength);
        ((VaadinResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).setContentLengthLong((long)contentLength);
    }
}

