/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.OneTimeInitializerPredicate;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RouterTest;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.DuplicateNavigationTitleException;
import com.vaadin.flow.server.startup.NavigationTargetFilter;
import com.vaadin.flow.server.startup.RouteRegistryInitializer;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RouteRegistryInitializerTest {
    private RouteRegistryInitializer routeRegistryInitializer;
    private ApplicationRouteRegistry registry;
    private ServletContext servletContext;
    private VaadinServletContext vaadinContext;
    private Lookup lookup;
    private RoutePathProvider pathProvider;

    RouteRegistryInitializerTest() {
    }

    @BeforeEach
    public void init() {
        this.pathProvider = (RoutePathProvider)Mockito.mock(RoutePathProvider.class);
        this.routeRegistryInitializer = new RouteRegistryInitializer();
        this.registry = new TestRouteRegistry();
        this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        this.lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)this.servletContext.getAttribute(Lookup.class.getName())).thenReturn((Object)this.lookup);
        this.vaadinContext = new VaadinServletContext(this.servletContext);
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        Mockito.when((Object)((ApplicationRouteRegistry.ApplicationRouteRegistryWrapper)this.vaadinContext.getAttribute(ApplicationRouteRegistry.ApplicationRouteRegistryWrapper.class))).thenReturn((Object)new ApplicationRouteRegistry.ApplicationRouteRegistryWrapper(this.registry));
        Mockito.when((Object)((RoutePathProvider)this.lookup.lookup(RoutePathProvider.class))).thenReturn((Object)this.pathProvider);
        ((RoutePathProvider)Mockito.doAnswer(invocation -> {
            Class clazz = (Class)invocation.getArgument(0, Class.class);
            Route route = clazz.getAnnotation(Route.class);
            return route.value();
        }).when((Object)this.pathProvider)).getRoutePath((Class)Mockito.any());
    }

    @Test
    public void process() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationTargetFoo.class, NavigationTargetBar.class).collect(Collectors.toSet()), this.servletContext);
        Assertions.assertEquals(NavigationTarget.class, this.registry.getNavigationTarget("").get(), (String)"Route '' registered to NavigationTarget.class");
        Assertions.assertEquals(NavigationTargetFoo.class, this.registry.getNavigationTarget("foo").get(), (String)"Route 'foo' registered to NavigationTargetFoo.class");
        Assertions.assertEquals(NavigationTargetBar.class, this.registry.getNavigationTarget("bar").get(), (String)"Route 'bar' registered to NavigationTargetBar.class");
    }

    @Test
    public void process_no_exception_with_null_arguments() {
        try {
            this.routeRegistryInitializer.process(null, this.servletContext);
        }
        catch (Exception e) {
            Assertions.fail((String)"RouteRegistryInitializer.process should not throw with null arguments");
        }
    }

    @Test
    public void process_duplicate_routes_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> this.routeRegistryInitializer.process(Stream.of(NavigationTargetFoo.class, NavigationTargetFoo2.class).collect(Collectors.toSet()), this.servletContext));
    }

    @Test
    public void process_duplicate_routesViaAlias_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> this.routeRegistryInitializer.process(Stream.of(NavigationTargetBar.class, NavigationTargetBar2.class).collect(Collectors.toSet()), this.servletContext));
    }

    @Test
    public void routeRegistry_fails_for_multiple_registration_of_same_route() {
        InvalidRouteConfigurationException thrown = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> {
            RouteConfiguration.forRegistry((RouteRegistry)this.registry).setAnnotatedRoute(NavigationTargetFoo.class);
            Assertions.assertTrue((boolean)this.registry.hasNavigationTargets(), (String)"RouteRegistry should be initialized");
            RouteConfiguration.forRegistry((RouteRegistry)this.registry).setAnnotatedRoute(NavigationTargetFoo2.class);
        });
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", "com.vaadin.flow.server.startup.RouteRegistryInitializerTest$NavigationTargetFoo", "com.vaadin.flow.server.startup.RouteRegistryInitializerTest$NavigationTargetFoo2")));
    }

    @Test
    public void routeRegistry_registers_correctly_route_with_parentLayout() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationTargetFoo.class, MiddleParentWithRoute.class).collect(Collectors.toSet()), this.servletContext);
        Optional navigationTarget = this.registry.getNavigationTarget("middle_parent");
        Assertions.assertTrue((boolean)navigationTarget.isPresent(), (String)"Couldn't find navigation target for `middle_parent`");
    }

    @Test
    public void routeRegistry_fails_on_aloneRouteAlias() throws ServletException {
        Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationTargetFoo.class, RouteAliasAlone.class).collect(Collectors.toSet()), this.servletContext));
    }

    @Test
    public void routeRegistry_stores_whole_path_with_parent_route_prefix() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(ExtendingPrefix.class).collect(Collectors.toSet()), this.servletContext);
        Optional navigationTarget = this.registry.getNavigationTarget("parent/prefix");
        Assertions.assertTrue((boolean)navigationTarget.isPresent(), (String)"Couldn't find navigation target for `parent/prefix`");
        Assertions.assertEquals(ExtendingPrefix.class, navigationTarget.get(), (String)"Route 'parent/prefix' was not registered to ExtendingPrefix.class");
    }

    @Test
    public void routeRegistry_route_with_absolute_ignores_parent_route_prefix() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(AbsoluteRoute.class).collect(Collectors.toSet()), this.servletContext);
        Optional navigationTarget = this.registry.getNavigationTarget("absolute");
        Assertions.assertTrue((boolean)navigationTarget.isPresent(), (String)"Could not find navigation target for `absolute`");
        Assertions.assertEquals(AbsoluteRoute.class, navigationTarget.get(), (String)"Route 'absolute' was not registered correctly");
    }

    @Test
    public void routeRegistry_route_with_absolute_parent_prefix_ignores_remaining_parent_route_prefixes() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRoute.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRoute.class, "absolute/levels", "Route 'absolute' was not registered correctly");
    }

    @Test
    public void routeRegistry_routeWithAlias_parentRoutePrefix() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRouteAlias.class, "absolute/levels", "Route 'absolute' was not registered correctly");
        Optional url = this.registry.getTargetUrl(MultiLevelRouteAlias.class);
        Assertions.assertTrue((boolean)url.isPresent());
        Assertions.assertEquals((Object)"absolute/levels", url.get());
        this.assertRouteTarget(MultiLevelRouteAlias.class, "parent/alias1", "RouteAlias 'alias1' was not registered correctly");
    }

    @Test
    public void routeRegistry_routeWithAlias_parent_prefix_ignores_remaining_parent_route_prefixes() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRouteAlias.class, "absolute/alias2", "RouteAlias 'alias2' was not registered correctly");
    }

    @Test
    public void routeRegistry_routeWithAlias_absoluteRoute() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRouteAlias.class, "alias3", "RouteAlias 'alias3' was not registered correctly");
    }

    @Test
    public void routeRegistry_routeWithAlias_noParent() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRouteAlias.class, "alias4", "RouteAlias 'alias4' was not registered correctly");
    }

    @Test
    public void routeRegistry_routeWithAlias_twoParentLevels() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        this.assertRouteTarget(MultiLevelRouteAlias.class, "parent/middle/alias5", "RouteAlias 'alias5' was not registered correctly");
    }

    @Test
    public void routeRegistry_route_returns_registered_string_for_get_url() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationTargetFoo.class, AbsoluteRoute.class, ExtendingPrefix.class).collect(Collectors.toSet()), this.servletContext);
        Assertions.assertEquals((Object)"", this.registry.getTargetUrl(NavigationTarget.class).get());
        Assertions.assertEquals((Object)"foo", this.registry.getTargetUrl(NavigationTargetFoo.class).get());
        Assertions.assertEquals((Object)"absolute", this.registry.getTargetUrl(AbsoluteRoute.class).get());
        Assertions.assertEquals((Object)"parent/prefix", this.registry.getTargetUrl(ExtendingPrefix.class).get());
    }

    @Test
    public void routeRegistry_routes_with_parameters_return_parameter_type_for_target_url() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(ParameterRoute.class, StringParameterRoute.class).collect(Collectors.toSet()), this.servletContext);
        Assertions.assertEquals((Object)String.format("parameter/:%s(%s)", "___url_parameter", "^[-+]?\\d+$"), this.registry.getTemplate(ParameterRoute.class).get());
        Assertions.assertEquals((Object)String.format("string/:%s", "___url_parameter"), this.registry.getTemplate(StringParameterRoute.class).get());
    }

    @Test
    public void routeRegistry_route_returns_string_not_ending_in_dash() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationRootWithParent.class).collect(Collectors.toSet()), this.servletContext);
        Assertions.assertEquals((Object)"parent", this.registry.getTargetUrl(NavigationRootWithParent.class).get(), (String)"The root target for a parent layout should not end with '/'");
    }

    @Test
    public void registration_fails_for_navigation_target_with_duplicate_title() throws ServletException {
        DuplicateNavigationTitleException thrown = (DuplicateNavigationTitleException)Assertions.assertThrows(DuplicateNavigationTitleException.class, () -> this.routeRegistryInitializer.process(Collections.singleton(FaultyNavigationTargetWithTitle.class), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("'%s' has a PageTitle annotation, but also implements HasDynamicTitle.", FaultyNavigationTargetWithTitle.class.getName())));
    }

    @Test
    public void registration_fails_for_navigation_target_with_inherited_dynamic_title() throws ServletException {
        DuplicateNavigationTitleException thrown = (DuplicateNavigationTitleException)Assertions.assertThrows(DuplicateNavigationTitleException.class, () -> this.routeRegistryInitializer.process(Collections.singleton(FaultyChildWithDuplicateTitle.class), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("'%s' has a PageTitle annotation, but also implements HasDynamicTitle.", FaultyChildWithDuplicateTitle.class.getName())));
    }

    @Test
    public void registration_succeeds_for_navigation_target_with_inherited_title_annotation() throws ServletException {
        this.routeRegistryInitializer.process(Collections.singleton(ChildWithDynamicTitle.class), this.servletContext);
        Assertions.assertEquals((Object)"bar", this.registry.getTargetUrl(ChildWithDynamicTitle.class).get());
    }

    private void assertRouteTarget(Class<?> routeClass, String path, String errorMessage) {
        Optional navigationTarget = this.registry.getNavigationTarget(path);
        Assertions.assertTrue((boolean)navigationTarget.isPresent(), (String)("Could not find navigation target for `" + path + "`"));
        Assertions.assertEquals(routeClass, navigationTarget.get(), (String)errorMessage);
    }

    @Test
    public void process_wrong_position_view_layout_throws() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(RootWithParents.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Viewport annotation should be on the top most route layout '%s'. Offending class: '%s'", Parent.class.getName(), MiddleParentLayout.class.getName())));
    }

    @Test
    public void process_check_only_one_viewport_in_route_chain() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(MultiViewport.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Only one Viewport annotation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + MultiMiddleParentLayout.class.getName() + ", " + MiddleParentLayout.class.getName()));
    }

    @Test
    public void process_route_can_not_contain_viewport_if_has_parent() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(RootViewportWithParent.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Viewport annotation needs to be on the top parent layout '%s' not on '%s'", Parent.class.getName(), RootViewportWithParent.class.getName())));
    }

    @Test
    public void process_one_viewport_in_chain_and_one_for_route_passes() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(SingleNavigationTarget.class, RootWithParent.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void process_check_also_faulty_alias_route() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(FailingAliasView.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Viewport annotation needs to be on the top parent layout '%s' not on '%s'", Parent.class.getName(), FailingAliasView.class.getName())));
    }

    @Test
    public void process_valid_alias_does_not_throw() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(AliasView.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void process_wrong_position_body_size_view_layout_throws() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(BodyRootWithParents.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("BodySize annotation should be on the top most route layout '%s'. Offending class: '%s'", BodyParent.class.getName(), BodyMiddleParentLayout.class.getName())));
    }

    @Test
    public void process_check_only_one_body_size_in_route_chain() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(BodyMultiViewport.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Only one BodySize annotation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + BodyMultiMiddleParentLayout.class.getName() + ", " + BodyMiddleParentLayout.class.getName()));
    }

    @Test
    public void process_route_can_not_contain_body_size_if_has_parent() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(BodyRootViewportWithParent.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("BodySize annotation needs to be on the top parent layout '%s' not on '%s'", BodyParent.class.getName(), BodyRootViewportWithParent.class.getName())));
    }

    @Test
    public void process_one_body_size_in_chain_and_one_for_route_passes() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(BodySingleNavigationTarget.class, BodyRootWithParent.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void process_check_also_faulty_body_size_alias_route() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(BodyFailingAliasView.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("BodySize annotation needs to be on the top parent layout '%s' not on '%s'", BodyParent.class.getName(), BodyFailingAliasView.class.getName())));
    }

    @Test
    public void process_valid_body_size_alias_does_not_throw() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(BodyAliasView.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void layout_annotation_on_non_routelayout_throws() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(FaultyParentLayout.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Found @Layout on classes { %s } not implementing RouterLayout.", FaultyParentLayout.class.getName())));
    }

    @Test
    public void same_layout_annotation_values_throws() {
        StringBuilder messageBuilder = new StringBuilder("Found duplicate @Layout values in classes:");
        messageBuilder.append("\n").append(" - ").append(AnnotatedParentLayout.class.getName()).append(" - ").append(AnotherAnnotatedParentLayout.class.getName());
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>(2);
            classes.add(AnnotatedParentLayout.class);
            classes.add(AnotherAnnotatedParentLayout.class);
            RouteRegistryInitializer.validateLayoutAnnotations(classes);
        });
        Assertions.assertTrue((boolean)thrown.getMessage().contains(messageBuilder.toString()));
    }

    @Test
    public void process_wrong_position_inline_view_layout_throws() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(InlineRootWithParents.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Inline annotation should be on the top most route layout '%s'. Offending class: '%s'", InlineParent.class.getName(), InlineMiddleParentLayout.class.getName())));
    }

    @Test
    public void process_check_only_one_inline_in_route_chain() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(InlineMultiViewport.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Only one Inline annotation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + InlineMultiMiddleParentLayout.class.getName() + ", " + InlineMiddleParentLayout.class.getName()));
    }

    @Test
    public void process_route_can_not_contain_inline_if_has_parent() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(InlineRootViewportWithParent.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Inline annotation needs to be on the top parent layout '%s' not on '%s'", InlineParent.class.getName(), InlineRootViewportWithParent.class.getName())));
    }

    @Test
    public void process_one_inline_in_chain_and_one_for_route_passes() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(InlineSingleNavigationTarget.class, InlineRootWithParent.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void process_check_also_faulty_inline_alias_route() throws ServletException {
        InvalidRouteLayoutConfigurationException thrown = (InvalidRouteLayoutConfigurationException)Assertions.assertThrows(InvalidRouteLayoutConfigurationException.class, () -> this.routeRegistryInitializer.process(Stream.of(InlineFailingAliasView.class).collect(Collectors.toSet()), this.servletContext));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Inline annotation needs to be on the top parent layout '%s' not on '%s'", InlineParent.class.getName(), InlineFailingAliasView.class.getName())));
    }

    @Test
    public void process_valid_inline_alias_does_not_throw() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(InlineAliasView.class).collect(Collectors.toSet()), this.servletContext);
    }

    @Test
    public void routeData_returns_all_registered_routes() throws ServletException {
        Set routes = Stream.of(NavigationTarget.class, NavigationTargetFoo.class, NavigationTargetBar.class).collect(Collectors.toSet());
        this.routeRegistryInitializer.process(routes, this.servletContext);
        List registeredRoutes = this.registry.getRegisteredRoutes();
        Assertions.assertEquals((int)3, (int)registeredRoutes.size(), (String)"Not all registered routes were returned");
        Set collectedRoutes = registeredRoutes.stream().map(RouteBaseData::getNavigationTarget).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)routes.containsAll(collectedRoutes), (String)"Not all targets were correct");
    }

    @Test
    public void routeData_gets_correct_urls_for_targets() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationRootWithParent.class, AbsoluteRoute.class, ExtendingPrefix.class, StringParameterRoute.class, ParameterRoute.class, MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        List registeredRoutes = this.registry.getRegisteredRoutes();
        Assertions.assertEquals((int)7, (int)registeredRoutes.size(), (String)"Not all registered routes were returned");
        Assertions.assertEquals((Object)"", (Object)((RouteData)registeredRoutes.get(0)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"absolute", (Object)((RouteData)registeredRoutes.get(1)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"absolute/levels", (Object)((RouteData)registeredRoutes.get(2)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)HasUrlParameterFormat.getTemplate((String)"parameter", ParameterRoute.class), (Object)((RouteData)registeredRoutes.get(3)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"parent", (Object)((RouteData)registeredRoutes.get(4)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"parent/prefix", (Object)((RouteData)registeredRoutes.get(5)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)HasUrlParameterFormat.getTemplate((String)"string", StringParameterRoute.class), (Object)((RouteData)registeredRoutes.get(6)).getTemplate(), (String)"Sort order was not the one expected");
    }

    @Test
    public void routeData_gets_correct_parents_for_targets() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationRootWithParent.class, AbsoluteRoute.class, ExtendingPrefix.class, StringParameterRoute.class, ParameterRoute.class, MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        List registeredRoutes = this.registry.getRegisteredRoutes();
        Assertions.assertEquals((int)7, (int)registeredRoutes.size(), (String)"Not all registered routes were returned");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteData)registeredRoutes.get(0)).getParentLayouts(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(ParentWithRoutePrefix.class, (Object)((RouteData)registeredRoutes.get(1)).getParentLayout(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(AbsoluteMiddleParent.class, (Object)((RouteData)registeredRoutes.get(2)).getParentLayout(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteData)registeredRoutes.get(3)).getParentLayouts(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(ParentWithRoutePrefix.class, (Object)((RouteData)registeredRoutes.get(4)).getParentLayout(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(ParentWithRoutePrefix.class, (Object)((RouteData)registeredRoutes.get(5)).getParentLayout(), (String)"Parent is wrongly set to data");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteData)registeredRoutes.get(6)).getParentLayouts(), (String)"Parent is wrongly set to data");
    }

    @Test
    public void routeData_gets_correct_parameters_for_targets() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(NavigationTarget.class, NavigationRootWithParent.class, AbsoluteRoute.class, ExtendingPrefix.class, StringParameterRoute.class, ParameterRoute.class, MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        List registeredRoutes = this.registry.getRegisteredRoutes();
        Assertions.assertEquals((int)7, (int)registeredRoutes.size(), (String)"Not all registered routes were returned");
        Assertions.assertEquals((int)0, (int)((RouteData)registeredRoutes.get(0)).getRouteParameters().size(), (String)"Unexpected parameters encountered");
        Assertions.assertEquals((int)0, (int)((RouteData)registeredRoutes.get(1)).getRouteParameters().size(), (String)"Unexpected parameters encountered");
        Assertions.assertEquals((int)0, (int)((RouteData)registeredRoutes.get(2)).getRouteParameters().size(), (String)"Unexpected parameters encountered");
        Assertions.assertEquals((int)1, (int)((RouteData)registeredRoutes.get(3)).getRouteParameters().size(), (String)"Missing parameters");
        Assertions.assertEquals((int)0, (int)((RouteData)registeredRoutes.get(4)).getRouteParameters().size(), (String)"Unexpected parameters encountered");
        Assertions.assertEquals((int)0, (int)((RouteData)registeredRoutes.get(5)).getRouteParameters().size(), (String)"Unexpected parameters encountered");
        Assertions.assertEquals((int)1, (int)((RouteData)registeredRoutes.get(6)).getRouteParameters().size(), (String)"Missing parameters");
        Assertions.assertEquals((Object)":___url_parameter(^[-+]?\\d+$)", (Object)((RouteParameterData)((RouteData)registeredRoutes.get(3)).getRouteParameters().get("___url_parameter")).getTemplate(), (String)"Unexpected parameter type encountered");
        Assertions.assertEquals((Object)":___url_parameter", (Object)((RouteParameterData)((RouteData)registeredRoutes.get(6)).getRouteParameters().get("___url_parameter")).getTemplate(), (String)"Unexpected parameter type encountered");
    }

    @Test
    public void routeData_for_alias_data_is_correct() throws ServletException {
        this.routeRegistryInitializer.process(Stream.of(MultiLevelRouteAlias.class).collect(Collectors.toSet()), this.servletContext);
        List registeredRoutes = this.registry.getRegisteredRoutes();
        Assertions.assertEquals((int)1, (int)registeredRoutes.size(), (String)"Not all registered routes were returned");
        RouteData routeData = (RouteData)registeredRoutes.get(0);
        Assertions.assertEquals((int)5, (int)routeData.getRouteAliases().size(), (String)"Not all registered routes were returned");
        List routeAliases = routeData.getRouteAliases();
        Assertions.assertEquals((Object)"absolute/alias2", (Object)((RouteAliasData)routeAliases.get(0)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"alias3", (Object)((RouteAliasData)routeAliases.get(1)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"alias4", (Object)((RouteAliasData)routeAliases.get(2)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"parent/alias1", (Object)((RouteAliasData)routeAliases.get(3)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals((Object)"parent/middle/alias5", (Object)((RouteAliasData)routeAliases.get(4)).getTemplate(), (String)"Sort order was not the one expected");
        Assertions.assertEquals(AbsoluteMiddleParent.class, (Object)((RouteAliasData)routeAliases.get(0)).getParentLayout(), (String)"Sort order was not the one expected");
        Assertions.assertEquals(ParentWithRoutePrefix.class, (Object)((RouteAliasData)routeAliases.get(1)).getParentLayout(), (String)"Sort order was not the one expected");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteAliasData)routeAliases.get(2)).getParentLayouts(), (String)"Sort order was not the one expected");
        Assertions.assertEquals(ParentWithRoutePrefix.class, (Object)((RouteAliasData)routeAliases.get(3)).getParentLayout(), (String)"Sort order was not the one expected");
        Assertions.assertEquals(MiddleParent.class, (Object)((RouteAliasData)routeAliases.get(4)).getParentLayout(), (String)"Sort order was not the one expected");
    }

    @Test
    public void routeFilter_ignoresRoutes() throws InvalidRouteConfigurationException, ServletException {
        this.routeRegistryInitializer.process(Stream.of(IgnoredView.class, NavigationTarget.class).collect(Collectors.toSet()), this.servletContext);
        List registeredTargets = this.registry.getRegisteredRoutes().stream().map(RouteBaseData::getNavigationTarget).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(NavigationTarget.class), registeredTargets);
    }

    @Test
    public void routeFilter_ignoresErrorTargets() throws InvalidRouteConfigurationException {
        this.registry.setErrorNavigationTargets(Stream.of(IgnoredErrorView.class, RouterTest.FileNotFound.class).collect(Collectors.toSet()));
        Assertions.assertTrue((boolean)this.registry.getErrorNavigationTarget((Exception)((Object)new NotFoundException())).isPresent());
        ErrorTargetEntry errorTargetEntry = (ErrorTargetEntry)this.registry.getErrorNavigationTarget(new Exception()).get();
        Assertions.assertNotEquals(IgnoredErrorView.class, (Object)errorTargetEntry.getNavigationTarget());
    }

    @Test
    public void registerClassesWithSameRoute_abstractClass_subclass_subclassIsRegistered() throws ServletException {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(AbstractRouteTarget.class);
        classes.add(BaseRouteTarget.class);
        this.routeRegistryInitializer.process(classes, this.servletContext);
        Assertions.assertEquals(BaseRouteTarget.class, this.registry.getNavigationTarget("foo").get());
    }

    @Test
    public void registerClassesWithSameRoute_class_abstractSuperClass_subclassIsRegistered() throws ServletException {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(BaseRouteTarget.class);
        classes.add(AbstractRouteTarget.class);
        this.routeRegistryInitializer.process(classes, this.servletContext);
        Assertions.assertEquals(BaseRouteTarget.class, this.registry.getNavigationTarget("foo").get());
    }

    @Test
    public void registerClassesWithSameRoute_class_subclass_subclassIsRegistered() throws ServletException {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(BaseRouteTarget.class);
        classes.add(SuperRouteTarget.class);
        this.routeRegistryInitializer.process(classes, this.servletContext);
        Assertions.assertEquals(SuperRouteTarget.class, this.registry.getNavigationTarget("foo").get());
    }

    @Test
    public void registerClassesWithSameRoute_class_superClass_subclassIsRegistered() throws ServletException {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(SuperRouteTarget.class);
        classes.add(BaseRouteTarget.class);
        this.routeRegistryInitializer.process(classes, this.servletContext);
        Assertions.assertEquals(SuperRouteTarget.class, this.registry.getNavigationTarget("foo").get());
    }

    @Test
    public void registerClassesWithSameRoute_absatrctClass_unrelatedClass_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            classes.add(AbstractRouteTarget.class);
            classes.add(OtherRouteTarget.class);
            this.routeRegistryInitializer.process(classes, this.servletContext);
        });
    }

    @Test
    public void registerClassesWithSameRoute_unrelatedClass_abstractClass_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            classes.add(OtherRouteTarget.class);
            classes.add(AbstractRouteTarget.class);
            this.routeRegistryInitializer.process(classes, this.servletContext);
        });
    }

    @Test
    public void registerClassesWithSameRoute_class_unrelatedClass_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            classes.add(BaseRouteTarget.class);
            classes.add(OtherRouteTarget.class);
            this.routeRegistryInitializer.process(classes, this.servletContext);
        });
    }

    @Test
    public void registerClassesWithSameRoute_unrelatedClass_class_throws() throws ServletException {
        Assertions.assertThrows(ServletException.class, () -> {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            classes.add(OtherRouteTarget.class);
            classes.add(BaseRouteTarget.class);
            this.routeRegistryInitializer.process(classes, this.servletContext);
        });
    }

    @Test
    public void initialize_predicateReturnsTrue_noPrevopusStaticRoutes_cleanIsNotCalled_removeMethodIsNotCalled() throws VaadinInitializerException {
        Mockito.when((Object)((OneTimeInitializerPredicate)this.lookup.lookup(OneTimeInitializerPredicate.class))).thenReturn(() -> true);
        TestApplicationRouteRegistry registry = new TestApplicationRouteRegistry();
        Mockito.when((Object)this.servletContext.getAttribute(registry.wrapper.getClass().getName())).thenReturn((Object)registry.wrapper);
        this.routeRegistryInitializer.initialize(Collections.singleton(BaseRouteTarget.class), (VaadinContext)this.vaadinContext);
        Assertions.assertFalse((boolean)registry.cleanCalled);
        Assertions.assertFalse((boolean)registry.removeCalled);
    }

    @Test
    public void initialize_predicateReturnsTrue_sameRouteIsReadded_eventHasNoReaddedRoute() throws VaadinInitializerException {
        Mockito.when((Object)((OneTimeInitializerPredicate)this.lookup.lookup(OneTimeInitializerPredicate.class))).thenReturn(() -> true);
        this.routeRegistryInitializer.initialize(new HashSet<Class>(Arrays.asList(OldRouteTarget.class)), (VaadinContext)this.vaadinContext);
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        Assertions.assertEquals((int)1, (int)registry.getRegisteredRoutes().size());
        AtomicReference event = new AtomicReference();
        registry.addRoutesChangeListener(event::set);
        this.routeRegistryInitializer.initialize(new HashSet<Class>(Arrays.asList(OldRouteTarget.class, BaseRouteTarget.class)), (VaadinContext)this.vaadinContext);
        Assertions.assertEquals((int)2, (int)registry.getRegisteredRoutes().size());
        Assertions.assertTrue((boolean)((RoutesChangedEvent)event.get()).getRemovedRoutes().isEmpty());
        Assertions.assertEquals((int)1, (int)((RoutesChangedEvent)event.get()).getAddedRoutes().size());
    }

    @Test
    public void initialize_noPredicate_noPrevopusStaticRoutes_cleanIsNotCalled_removeMethodIsNotCalled() throws VaadinInitializerException {
        TestApplicationRouteRegistry registry = new TestApplicationRouteRegistry();
        Mockito.when((Object)this.servletContext.getAttribute(registry.wrapper.getClass().getName())).thenReturn((Object)registry.wrapper);
        this.routeRegistryInitializer.initialize(Collections.singleton(BaseRouteTarget.class), (VaadinContext)this.vaadinContext);
        Assertions.assertFalse((boolean)registry.cleanCalled);
        Assertions.assertFalse((boolean)registry.removeCalled);
    }

    @Test
    public void initialize_noPredicate_hasPrevopusStaticRoutes_previousRoutesAreRemoved() throws VaadinInitializerException {
        ApplicationRouteRegistry registry = this.firstInitRouteRegistry();
        this.routeRegistryInitializer.initialize(Collections.singleton(BaseRouteTarget.class), (VaadinContext)this.vaadinContext);
        Assertions.assertEquals((int)1, (int)registry.getRegisteredRoutes().size());
        Assertions.assertTrue((boolean)registry.getTemplate(BaseRouteTarget.class).isPresent());
    }

    @Test
    public void initialize_noPredicate_hasPrevopusStaticRoutes_addRouteManually_previousRoutesAreRemoved_addedRouteIsPreserved() throws VaadinInitializerException {
        ApplicationRouteRegistry registry = this.firstInitRouteRegistry();
        registry.setRoute("manual-route", Component.class, Collections.emptyList());
        this.routeRegistryInitializer.initialize(Collections.singleton(BaseRouteTarget.class), (VaadinContext)this.vaadinContext);
        Assertions.assertTrue((boolean)registry.getTemplate(BaseRouteTarget.class).isPresent());
        Assertions.assertTrue((boolean)registry.getNavigationTarget(PathUtil.getPath((String)"manual-route", Collections.emptyList())).isPresent());
    }

    private ApplicationRouteRegistry firstInitRouteRegistry() throws VaadinInitializerException {
        this.vaadinContext = new VaadinServletContext(this.servletContext){
            private Map<Class<?>, Object> map;
            {
                this.map = new HashMap();
            }

            public <T> T getAttribute(Class<T> type) {
                if (Lookup.class.equals(type)) {
                    return type.cast(RouteRegistryInitializerTest.this.lookup);
                }
                return type.cast(this.map.get(type));
            }

            public <T> void setAttribute(Class<T> clazz, T value) {
                this.map.put(clazz, value);
            }
        };
        this.routeRegistryInitializer.initialize(Collections.singleton(OldRouteTarget.class), (VaadinContext)this.vaadinContext);
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        List routes = registry.getRegisteredRoutes();
        Assertions.assertEquals((int)1, (int)routes.size());
        RouteData data = (RouteData)routes.get(0);
        Assertions.assertEquals((Object)"foo-bar", (Object)data.getTemplate());
        List aliases = data.getRouteAliases();
        Assertions.assertEquals((int)1, (int)aliases.size());
        RouteAliasData alias = (RouteAliasData)aliases.get(0);
        Assertions.assertEquals((Object)"baz", (Object)alias.getTemplate());
        return registry;
    }

    @Route(value="")
    private static class NavigationTarget
    extends Component {
        private NavigationTarget() {
        }
    }

    @Route(value="foo")
    private static class NavigationTargetFoo
    extends Component {
        private NavigationTargetFoo() {
        }
    }

    @Route(value="bar")
    private static class NavigationTargetBar
    extends Component {
        private NavigationTargetBar() {
        }
    }

    @ParentLayout(value=RouteParentLayout.class)
    @Route(value="middle_parent")
    private static class MiddleParentWithRoute
    extends Component
    implements RouterLayout {
        private MiddleParentWithRoute() {
        }
    }

    @Route(value="prefix", layout=ParentWithRoutePrefix.class)
    private static class ExtendingPrefix
    extends Component {
        private ExtendingPrefix() {
        }
    }

    @Route(value="absolute", layout=ParentWithRoutePrefix.class, absolute=true)
    private static class AbsoluteRoute
    extends Component {
        private AbsoluteRoute() {
        }
    }

    @Route(value="levels", layout=AbsoluteMiddleParent.class)
    private static class MultiLevelRoute
    extends Component {
        private MultiLevelRoute() {
        }
    }

    @Route(value="levels", layout=AbsoluteMiddleParent.class)
    @RouteAlias.Container(value={@RouteAlias(value="alias1", layout=ParentWithRoutePrefix.class), @RouteAlias(value="alias2", layout=AbsoluteMiddleParent.class), @RouteAlias(value="alias3", absolute=true, layout=ParentWithRoutePrefix.class), @RouteAlias(value="alias4"), @RouteAlias(value="alias5", layout=MiddleParent.class)})
    private static class MultiLevelRouteAlias
    extends Component {
        private MultiLevelRouteAlias() {
        }
    }

    @Route(value="parameter")
    private static class ParameterRoute
    extends Component
    implements HasUrlParameter<Integer> {
        private ParameterRoute() {
        }

        public void setParameter(BeforeEvent event, Integer parameter) {
        }
    }

    @Route(value="string")
    private static class StringParameterRoute
    extends Component
    implements HasUrlParameter<String> {
        private StringParameterRoute() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="", layout=ParentWithRoutePrefix.class)
    private static class NavigationRootWithParent
    extends Component {
        private NavigationRootWithParent() {
        }
    }

    @Route(value="foo")
    @PageTitle(value="Custom Title")
    private static class FaultyNavigationTargetWithTitle
    extends Component
    implements HasDynamicTitle {
        private FaultyNavigationTargetWithTitle() {
        }

        public String getPageTitle() {
            return "";
        }
    }

    @Route(value="bar")
    @PageTitle(value="Child View")
    private static class FaultyChildWithDuplicateTitle
    extends ParentWithDynamicTitle {
        private FaultyChildWithDuplicateTitle() {
        }
    }

    @Route(value="bar")
    private static class ChildWithDynamicTitle
    extends ParentWithTitleAnnotation {
        private ChildWithDynamicTitle() {
        }

        @Override
        public String getPageTitle() {
            return "Child View";
        }
    }

    @Tag(value="div")
    public static class Parent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=Parent.class)
    @Viewport(value="width=device-width")
    public static class MiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=MiddleParentLayout.class)
    @Viewport(value="width=device-width")
    public static class MultiMiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    @Viewport(value="width=device-width")
    public static class RootViewportWithParent
    extends Component {
    }

    @Route(value="single")
    @Tag(value="div")
    @Viewport(value="width=device-width")
    public static class SingleNavigationTarget
    extends Component {
    }

    @Route(value="", layout=Parent.class)
    @Tag(value="div")
    public static class RootWithParent
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=Parent.class)
    @Tag(value="div")
    @Viewport(value="width=device-width")
    public static class FailingAliasView
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=Parent.class)
    @Tag(value="div")
    public static class AliasView
    extends Component {
    }

    @Tag(value="div")
    public static class BodyParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=BodyParent.class)
    @BodySize(width="100vw", height="100vh")
    public static class BodyMiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=BodyMiddleParentLayout.class)
    @BodySize(width="100vw", height="100vh")
    public static class BodyMultiMiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="", layout=BodyParent.class)
    @Tag(value="div")
    @BodySize(width="100vw", height="100vh")
    public static class BodyRootViewportWithParent
    extends Component {
    }

    @Route(value="single")
    @Tag(value="div")
    @BodySize(width="100vw", height="100vh")
    public static class BodySingleNavigationTarget
    extends Component {
    }

    @Route(value="", layout=BodyParent.class)
    @Tag(value="div")
    public static class BodyRootWithParent
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=BodyParent.class)
    @Tag(value="div")
    @BodySize(width="100vw", height="100vh")
    public static class BodyFailingAliasView
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=BodyParent.class)
    @Tag(value="div")
    public static class BodyAliasView
    extends Component {
    }

    @Layout
    @Tag(value="div")
    public static class FaultyParentLayout
    extends Component {
    }

    @Layout
    @Tag(value="div")
    public static class AnnotatedParentLayout
    extends Component
    implements RouterLayout {
    }

    @Layout
    @Tag(value="div")
    public static class AnotherAnnotatedParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class InlineParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=InlineParent.class)
    @Inline(value="inline.js")
    public static class InlineMiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @ParentLayout(value=InlineMiddleParentLayout.class)
    @Inline(value="inline.js")
    public static class InlineMultiMiddleParentLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="", layout=InlineParent.class)
    @Tag(value="div")
    @Inline(value="inline.js")
    public static class InlineRootViewportWithParent
    extends Component {
    }

    @Route(value="single")
    @Tag(value="div")
    @Inline.Container(value={@Inline(value="inline.js", position=Inline.Position.PREPEND), @Inline(value="inline.css")})
    public static class InlineSingleNavigationTarget
    extends Component {
    }

    @Route(value="", layout=InlineParent.class)
    @Tag(value="div")
    public static class InlineRootWithParent
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=InlineParent.class)
    @Tag(value="div")
    @Inline(value="inline.js")
    public static class InlineFailingAliasView
    extends Component {
    }

    @Route(value="")
    @RouteAlias(value="alias", layout=InlineParent.class)
    @Tag(value="div")
    public static class InlineAliasView
    extends Component {
    }

    @RoutePrefix(value="parent")
    private static class ParentWithRoutePrefix
    extends Component
    implements RouterLayout {
        private ParentWithRoutePrefix() {
        }
    }

    @RoutePrefix(value="absolute", absolute=true)
    @ParentLayout(value=ParentWithRoutePrefix.class)
    private static class AbsoluteMiddleParent
    extends Component
    implements RouterLayout {
        private AbsoluteMiddleParent() {
        }
    }

    @RoutePrefix(value="middle")
    @ParentLayout(value=ParentWithRoutePrefix.class)
    private static class MiddleParent
    extends Component
    implements RouterLayout {
        private MiddleParent() {
        }
    }

    @Route(value="ignored")
    public static class IgnoredView
    extends Component {
    }

    public static class IgnoredErrorView
    extends Component
    implements HasErrorParameter<Exception> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<Exception> parameter) {
            return 0;
        }
    }

    @Tag(value="div")
    @Route(value="foo")
    private static abstract class AbstractRouteTarget
    extends Component {
        private AbstractRouteTarget() {
        }
    }

    @Tag(value="div")
    @Route(value="foo")
    private static class BaseRouteTarget
    extends AbstractRouteTarget {
        private BaseRouteTarget() {
        }
    }

    @Tag(value="div")
    @Route(value="foo")
    private static class SuperRouteTarget
    extends BaseRouteTarget {
        private SuperRouteTarget() {
        }
    }

    private static class TestApplicationRouteRegistry
    extends ApplicationRouteRegistry {
        ApplicationRouteRegistry.ApplicationRouteRegistryWrapper wrapper = new ApplicationRouteRegistry.ApplicationRouteRegistryWrapper((ApplicationRouteRegistry)this);
        boolean cleanCalled;
        boolean removeCalled;

        TestApplicationRouteRegistry() {
            super((VaadinContext)new MockVaadinContext());
        }

        public void clean() {
            this.cleanCalled = true;
        }

        public void removeRoute(Class<? extends Component> navigationTarget) {
            this.removeCalled = true;
        }

        public void removeRoute(String path) {
            this.removeCalled = true;
        }

        public void removeRoute(String path, Class<? extends Component> navigationTarget) {
            this.removeCalled = true;
        }
    }

    @Tag(value="div")
    @Route(value="foo-bar")
    @RouteAlias(value="baz")
    private static class OldRouteTarget
    extends AbstractRouteTarget {
        private OldRouteTarget() {
        }
    }

    @Tag(value="div")
    @Route(value="foo")
    private static class OtherRouteTarget
    extends Component {
        private OtherRouteTarget() {
        }
    }

    @Route(value="", layout=InlineMultiMiddleParentLayout.class)
    @Tag(value="div")
    public static class InlineMultiViewport
    extends Component {
    }

    @Route(value="", layout=InlineMiddleParentLayout.class)
    @Tag(value="div")
    public static class InlineRootWithParents
    extends Component {
    }

    @Route(value="", layout=BodyMultiMiddleParentLayout.class)
    @Tag(value="div")
    public static class BodyMultiViewport
    extends Component {
    }

    @Route(value="", layout=BodyMiddleParentLayout.class)
    @Tag(value="div")
    public static class BodyRootWithParents
    extends Component {
    }

    @Route(value="", layout=MultiMiddleParentLayout.class)
    @Tag(value="div")
    public static class MultiViewport
    extends Component {
    }

    @Route(value="", layout=MiddleParentLayout.class)
    @Tag(value="div")
    public static class RootWithParents
    extends Component {
    }

    @RouteAlias(value="wrong")
    private static class RouteAliasAlone
    extends Component {
        private RouteAliasAlone() {
        }
    }

    @Route(value="foo")
    private static class NavigationTargetFoo2
    extends Component {
        private NavigationTargetFoo2() {
        }
    }

    @Route(value="bar2")
    @RouteAlias(value="bar")
    private static class NavigationTargetBar2
    extends Component {
        private NavigationTargetBar2() {
        }
    }

    public static class AlwaysTrueRouterFilter
    implements NavigationTargetFilter {
        public boolean testNavigationTarget(Class<? extends Component> navigationTarget) {
            return true;
        }

        public boolean testErrorNavigationTarget(Class<?> errorNavigationTarget) {
            return true;
        }
    }

    public static class TestRouteFilter
    implements NavigationTargetFilter {
        public boolean testNavigationTarget(Class<? extends Component> navigationTarget) {
            return !navigationTarget.getSimpleName().startsWith("Ignored");
        }

        public boolean testErrorNavigationTarget(Class<?> errorNavigationTarget) {
            return !errorNavigationTarget.getSimpleName().startsWith("Ignored");
        }
    }

    @Route(value="foo")
    @PageTitle(value="Parent View")
    private static class ParentWithTitleAnnotation
    extends Component
    implements HasDynamicTitle {
        private ParentWithTitleAnnotation() {
        }

        public String getPageTitle() {
            return "";
        }
    }

    @Route(value="foo")
    private static class ParentWithDynamicTitle
    extends Component
    implements HasDynamicTitle {
        private ParentWithDynamicTitle() {
        }

        public String getPageTitle() {
            return "Parent View";
        }
    }

    private static class RouteParentLayout
    extends Component
    implements RouterLayout {
        private RouteParentLayout() {
        }
    }
}

