/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinServletContext;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class VaadinServletContextTest {
    private VaadinServletContext context;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private Map<String, String> properties;

    VaadinServletContextTest() {
    }

    private static String testAttributeProvider() {
        return "RELAX_THIS_IS_A_TEST";
    }

    @BeforeEach
    public void setup() {
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttribute(Mockito.anyString())).then(invocationOnMock -> this.attributeMap.get(invocationOnMock.getArguments()[0].toString()));
        ((ServletContext)Mockito.doAnswer(invocationOnMock -> {
            this.attributeMap.remove(invocationOnMock.getArguments()[0].toString());
            return null;
        }).when((Object)servletContext)).removeAttribute(Mockito.anyString());
        ((ServletContext)Mockito.doAnswer(invocationOnMock -> this.attributeMap.put(invocationOnMock.getArguments()[0].toString(), invocationOnMock.getArguments()[1])).when((Object)servletContext)).setAttribute(Mockito.anyString(), Mockito.any());
        this.properties = new HashMap<String, String>();
        this.properties.put("productionMode", "true");
        this.properties.put("frontend.hotdeploy", "false");
        Mockito.when((Object)servletContext.getInitParameterNames()).thenReturn(Collections.enumeration(this.properties.keySet()));
        Mockito.when((Object)servletContext.getInitParameter(Mockito.anyString())).then(invocation -> this.properties.get(invocation.getArguments()[0]));
        this.context = new VaadinServletContext(servletContext);
    }

    @Test
    public void getAttributeWithProvider() {
        Assertions.assertNull((Object)this.context.getAttribute(String.class));
        String value = (String)this.context.getAttribute(String.class, VaadinServletContextTest::testAttributeProvider);
        Assertions.assertEquals((Object)VaadinServletContextTest.testAttributeProvider(), (Object)value);
        Assertions.assertEquals((Object)VaadinServletContextTest.testAttributeProvider(), (Object)this.context.getAttribute(String.class), (String)"Value from provider should be persisted");
    }

    @Test
    public void setNullAttributeNotAllowed() {
        Assertions.assertThrows(AssertionError.class, () -> this.context.setAttribute(null));
    }

    @Test
    public void getMissingAttributeWithoutProvider() {
        String value = (String)this.context.getAttribute(String.class);
        Assertions.assertNull((Object)value);
    }

    @Test
    public void setAndGetAttribute() {
        String value = VaadinServletContextTest.testAttributeProvider();
        this.context.setAttribute((Object)value);
        String result = (String)this.context.getAttribute(String.class);
        Assertions.assertEquals((Object)value, (Object)result);
        String newValue = "this is a new value";
        this.context.setAttribute((Object)newValue);
        result = (String)this.context.getAttribute(String.class);
        Assertions.assertEquals((Object)newValue, (Object)result);
        result = (String)this.context.getAttribute(String.class, () -> {
            throw new AssertionError((Object)"Should not be called");
        });
        Assertions.assertEquals((Object)newValue, (Object)result);
    }

    @Test
    public void setValueBasedOnSuperType_implicitClass_notFound() {
        String value = VaadinServletContextTest.testAttributeProvider();
        this.context.setAttribute((Object)value);
        CharSequence retrieved = (CharSequence)this.context.getAttribute(CharSequence.class);
        Assertions.assertNull((Object)retrieved, (String)"Value set base on its own type should not be found based on a super type");
    }

    @Test
    public void setValueBasedOnSuperType_explicitClass_found() {
        String value = VaadinServletContextTest.testAttributeProvider();
        this.context.setAttribute(CharSequence.class, (Object)value);
        CharSequence retrieved = (CharSequence)this.context.getAttribute(CharSequence.class);
        Assertions.assertSame((Object)value, (Object)retrieved, (String)"Value should be found based on the type used when setting");
    }

    @Test
    public void removeValue_removeMethod_valueIsRemoved() {
        this.context.setAttribute((Object)VaadinServletContextTest.testAttributeProvider());
        this.context.removeAttribute(String.class);
        Assertions.assertNull((Object)this.context.getAttribute(String.class), (String)"Value should be removed");
    }

    @Test
    public void removeValue_setWithClass_valueIsRemoved() {
        this.context.setAttribute((Object)VaadinServletContextTest.testAttributeProvider());
        this.context.setAttribute(String.class, null);
        Assertions.assertNull((Object)this.context.getAttribute(String.class), (String)"Value should be removed");
    }

    @Test
    public void getPropertyNames_returnsExpectedProperties() {
        ArrayList list = Collections.list(this.context.getContextParameterNames());
        Assertions.assertEquals((int)this.properties.size(), (int)list.size(), (String)"Context should return only keys defined in ServletContext");
        for (String key : this.properties.keySet()) {
            Assertions.assertEquals((Object)this.properties.get(key), (Object)this.context.getContextParameter(key), (String)String.format("Value should be same from context for key '%s'", key));
        }
    }
}

