/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.MockServletConfig;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class MockVaadinServletService
extends VaadinServletService {
    private Instantiator instantiator;
    private Router router;
    private DeploymentConfiguration configuration;
    private Lookup lookup;

    public MockVaadinServletService() {
        this((DeploymentConfiguration)new MockDeploymentConfiguration());
    }

    public MockVaadinServletService(boolean init) {
        this((DeploymentConfiguration)new MockDeploymentConfiguration(), init);
    }

    public MockVaadinServletService(DeploymentConfiguration deploymentConfiguration) {
        this(deploymentConfiguration, true);
    }

    public MockVaadinServletService(DeploymentConfiguration deploymentConfiguration, boolean init) {
        super((VaadinServlet)new MockVaadinServlet(deploymentConfiguration), deploymentConfiguration);
        if (init) {
            this.init();
        }
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router != null ? this.router : super.getRouter();
    }

    protected List<RequestHandler> createRequestHandlers() throws ServiceException {
        return Collections.emptyList();
    }

    public void init(Instantiator instantiator) {
        this.instantiator = instantiator;
        this.init();
    }

    protected Instantiator createInstantiator() throws ServiceException {
        if (this.instantiator != null) {
            return this.instantiator;
        }
        return super.createInstantiator();
    }

    public void init() {
        try {
            this.resetSignalEnvironment();
            MockVaadinServlet servlet = (MockVaadinServlet)this.getServlet();
            servlet.service = this;
            if (this.getServlet().getServletConfig() == null) {
                this.getServlet().init((ServletConfig)new MockServletConfig());
            }
            if (this.lookup == null && this.getContext().getAttribute(Lookup.class) == null) {
                this.lookup = (Lookup)Mockito.mock(Lookup.class);
                Mockito.when((Object)((RoutePathProvider)this.lookup.lookup(RoutePathProvider.class))).thenReturn((Object)new DefaultRoutePathProvider());
                this.instrumentMockLookup(this.lookup);
                this.getContext().setAttribute(Lookup.class, (Object)this.lookup);
            }
            super.init();
        }
        catch (ServiceException | ServletException e) {
            throw new RuntimeException(e);
        }
    }

    protected void instrumentMockLookup(Lookup lookup) {
    }

    public void setConfiguration(DeploymentConfiguration configuration) {
        this.configuration = configuration;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.configuration != null ? this.configuration : super.getDeploymentConfiguration();
    }

    private void resetSignalEnvironment() {
        try {
            Field environments = SignalEnvironment.class.getDeclaredField("environments");
            environments.setAccessible(true);
            ((List)environments.get(null)).clear();
        }
        catch (Exception e) {
            throw new AssertionError("Failed to reset Signal environment", e);
        }
    }

    Thread.Builder.OfVirtual defaultExecutorFactory() {
        return super.defaultExecutorFactory().uncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("An uncaught exception occurred in thread {}", (Object)t.getName(), (Object)e));
    }

    private static class MockVaadinServlet
    extends VaadinServlet {
        private final DeploymentConfiguration configuration;
        private VaadinServletService service;

        private MockVaadinServlet(DeploymentConfiguration configuration) {
            this.configuration = configuration;
        }

        protected DeploymentConfiguration createDeploymentConfiguration() throws ServletException {
            return this.configuration;
        }

        protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
            return this.service;
        }
    }
}

