/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockServletContext;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@NotThreadSafe
class RouteConfigurationTest {
    private ApplicationRouteRegistry registry;
    private MockService vaadinService;
    private VaadinSession session;
    private ServletContext servletContext;
    private VaadinServletContext vaadinContext;

    RouteConfigurationTest() {
    }

    @BeforeEach
    public void init() {
        this.servletContext = new MockServletContext();
        this.vaadinContext = new MockVaadinContext(this.servletContext);
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)configuration.getFrontendFolder()).thenReturn((Object)new File("/frontend"));
        this.vaadinService = (MockService)((Object)Mockito.mock(MockService.class));
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)configuration);
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        this.session = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return RouteConfigurationTest.this.vaadinService;
            }
        };
    }

    private SessionRouteRegistry getRegistry(VaadinSession session) {
        try {
            session.lock();
            SessionRouteRegistry sessionRouteRegistry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)session);
            return sessionRouteRegistry;
        }
        finally {
            session.unlock();
        }
    }

    @Test
    public void routeConfigurationUpdateLock_configurationIsUpdatedOnlyAfterUnlock() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        final RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.getRegistry(this.session));
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                RouteConfigurationTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)routeConfiguration.getAvailableRoutes().isEmpty(), (String)"Registry should still remain empty");
                RouteConfigurationTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)routeConfiguration.getAvailableRoutes().isEmpty(), (String)"Registry should still remain empty");
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.setRoute("", MyRoute.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            routeConfiguration.setRoute("path", Secondary.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            try {
                waitReaderThread.await();
            }
            catch (InterruptedException e) {
                Assertions.fail();
            }
        });
        Assertions.assertEquals((int)2, (int)routeConfiguration.getAvailableRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
    }

    @Test
    public void isRouteRegistered_returnsCorrectly() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.getRegistry(this.session));
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.setRoute("", MyRoute.class, Collections.emptyList());
            routeConfiguration.setRoute("path", Secondary.class, Collections.emptyList());
        });
        Assertions.assertTrue((boolean)routeConfiguration.isRouteRegistered(MyRoute.class), (String)"Registered 'MyRoute.class' should return true");
        Assertions.assertTrue((boolean)routeConfiguration.isRouteRegistered(Secondary.class), (String)"Registered 'Secondary.class' should return true");
        Assertions.assertFalse((boolean)routeConfiguration.isRouteRegistered(Url.class), (String)"Unregistered 'Url.class' should return false");
    }

    @Test
    public void routeConfiguration_getMethodsReturnCorrectly() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.getRegistry(this.session));
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.setRoute("", MyRoute.class);
            routeConfiguration.setRoute("path", Secondary.class);
            routeConfiguration.setRoute("parents", MiddleLayout.class, new Class[]{MainLayout.class});
            routeConfiguration.setAnnotatedRoute(ParameterView.class);
        });
        Assertions.assertEquals((int)4, (int)routeConfiguration.getAvailableRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
        Assertions.assertTrue((boolean)routeConfiguration.isPathAvailable(""), (String)"Expected path '' to be registered");
        Assertions.assertTrue((boolean)routeConfiguration.isPathAvailable("path"), (String)"Expected path 'path' to be registered");
        Assertions.assertTrue((boolean)routeConfiguration.isPathAvailable("parents"), (String)"Expected path 'parents' to be registered");
        Assertions.assertEquals((Object)"parents", (Object)routeConfiguration.getUrl(MiddleLayout.class), (String)"Url should have only been 'parents'");
        Optional template = routeConfiguration.getTemplate(MiddleLayout.class);
        Assertions.assertTrue((boolean)template.isPresent(), (String)"Missing template");
        Assertions.assertEquals((Object)"parents", template.get(), (String)"Url should have only been 'parents'");
        Optional pathRoute = routeConfiguration.getRoute("path");
        Assertions.assertTrue((boolean)pathRoute.isPresent(), (String)"'path' should have returned target class");
        Assertions.assertEquals(Secondary.class, pathRoute.get(), (String)"'path' registration should be Secondary");
        template = routeConfiguration.getTemplate(ParameterView.class);
        Assertions.assertTrue((boolean)template.isPresent(), (String)"Missing template for ParameterView");
        Assertions.assertEquals((Object)"category/:int(^[-+]?\\d+$)/item/:long(^[+-]?[0-9]{1,19}$)", template.get(), (String)"ParameterView template is not correctly generated from Route and RoutePrefix");
        Assertions.assertTrue((boolean)routeConfiguration.isPathAvailable("category/:int(^[-+]?\\d+$)/item/:long(^[+-]?[0-9]{1,19}$)"), (String)"ParameterView template not registered.");
        Assertions.assertEquals((Object)"category/1234567890/item/12345678900", (Object)routeConfiguration.getUrl(ParameterView.class, new RouteParameters(new RouteParam[]{new RouteParam("int", "1234567890"), new RouteParam("long", "12345678900")})), (String)"ParameterView url with RouteParameters not generated correctly.");
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.removeRoute("path");
            routeConfiguration.setRoute("url", Url.class);
        });
        Assertions.assertFalse((boolean)routeConfiguration.isPathAvailable("path"), (String)"Removing the path 'path' should have cleared it from the registry");
        Assertions.assertTrue((boolean)routeConfiguration.isPathAvailable(HasUrlParameterFormat.getTemplate((String)"url", Url.class)), (String)"Expected path 'url' to be registered");
        Optional urlRoute = routeConfiguration.getRoute("url");
        Assertions.assertFalse((boolean)urlRoute.isPresent(), (String)"'url' with no parameters should not have returned a class");
        urlRoute = routeConfiguration.getRoute("url", Collections.singletonList("param"));
        Assertions.assertTrue((boolean)urlRoute.isPresent(), (String)"'url' with parameters should have returned a class");
        Assertions.assertEquals(Url.class, urlRoute.get(), (String)"'url' registration should be Url");
    }

    @Test
    public void routeConfiguration_routeTemplatesWorkCorrectly() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.getRegistry(this.session));
        routeConfiguration.update((Command & Serializable)() -> routeConfiguration.setAnnotatedRoute(ComponentView.class));
        Optional template = routeConfiguration.getTemplate(ComponentView.class);
        Assertions.assertTrue((boolean)template.isPresent(), (String)"Missing template");
        Assertions.assertEquals((Object)"component/:identifier/:path*", template.get());
        Assertions.assertEquals((Object)"component/button/api/com/vaadin/flow/button", (Object)routeConfiguration.getUrl(ComponentView.class, new RouteParameters(new RouteParam[]{new RouteParam("identifier", "button"), new RouteParam("tab", "api"), new RouteParam("path", "com/vaadin/flow/button")})));
        Assertions.assertEquals((Object)"component/button/com/vaadin/flow/button", (Object)routeConfiguration.getUrl(ComponentView.class, new RouteParameters(new RouteParam[]{new RouteParam("identifier", "button"), new RouteParam("path", "com/vaadin/flow/button")})));
        Assertions.assertEquals((Object)"component/button/reviews", (Object)routeConfiguration.getUrl(ComponentView.class, new RouteParameters(new RouteParam[]{new RouteParam("identifier", "button"), new RouteParam("tab", "reviews")})));
        Assertions.assertEquals((Object)"component/button/overview", (Object)routeConfiguration.getUrl(ComponentView.class, new RouteParameters(new RouteParam[]{new RouteParam("identifier", "button"), new RouteParam("tab", "overview")})));
        try {
            routeConfiguration.getUrl(ComponentView.class, new RouteParameters(new RouteParam[]{new RouteParam("identifier", "button"), new RouteParam("tab", "examples")}));
            Assertions.fail((String)"`tab` parameter doesn't accept `examples` as value.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addListenerToApplicationScoped_noEventForSessionChange() {
        VaadinServlet servlet = (VaadinServlet)Mockito.mock(VaadinServlet.class);
        Mockito.when((Object)servlet.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.vaadinService.getServlet()).thenReturn((Object)servlet);
        try {
            CurrentInstance.set(VaadinService.class, (Object)((Object)this.vaadinService));
            VaadinSession.setCurrent((VaadinSession)this.session);
            this.session.lock();
            RouteConfiguration routeConfiguration = RouteConfiguration.forApplicationScope();
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            routeConfiguration.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
                added.clear();
                removed.clear();
                added.addAll(event.getAddedRoutes());
                removed.addAll(event.getRemovedRoutes());
            });
            routeConfiguration.setRoute("old", MyRoute.class);
            Assertions.assertEquals((int)1, (int)added.size());
            Assertions.assertEquals((int)0, (int)removed.size());
            added.clear();
            removed.clear();
            routeConfiguration = RouteConfiguration.forSessionScope();
            routeConfiguration.setRoute("new", MyRoute.class);
            Assertions.assertEquals((int)0, (int)added.size());
            Assertions.assertEquals((int)0, (int)removed.size());
        }
        finally {
            this.session.unlock();
            CurrentInstance.clearAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addListenerToSessionScoped_alsoEventsForApplicationScope() {
        VaadinServlet servlet = (VaadinServlet)Mockito.mock(VaadinServlet.class);
        Mockito.when((Object)servlet.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.vaadinService.getServlet()).thenReturn((Object)servlet);
        try {
            CurrentInstance.set(VaadinService.class, (Object)((Object)this.vaadinService));
            VaadinSession.setCurrent((VaadinSession)this.session);
            this.session.lock();
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            RouteConfiguration routeConfiguration = RouteConfiguration.forSessionScope();
            routeConfiguration.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
                added.clear();
                removed.clear();
                added.addAll(event.getAddedRoutes());
                removed.addAll(event.getRemovedRoutes());
            });
            routeConfiguration.setRoute("old", MyRoute.class);
            Assertions.assertEquals((int)1, (int)added.size());
            Assertions.assertEquals((int)0, (int)removed.size());
            added.clear();
            removed.clear();
            routeConfiguration = RouteConfiguration.forApplicationScope();
            routeConfiguration.setRoute("new", MyRoute.class);
            Assertions.assertEquals((int)1, (int)added.size());
            Assertions.assertEquals((int)0, (int)removed.size());
        }
        finally {
            this.session.unlock();
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void configurationForSessionRegistry_buildsWithCorrectRegistry() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        registry.update((Command & Serializable)() -> {
            registry.setRoute("", MyRoute.class, Collections.emptyList());
            registry.setRoute("path", Secondary.class, Collections.emptyList());
        });
        try {
            VaadinSession.setCurrent((VaadinSession)this.session);
            this.session.lock();
            RouteConfiguration routeConfiguration = RouteConfiguration.forSessionScope();
            Assertions.assertEquals((int)2, (int)routeConfiguration.getAvailableRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
        }
        finally {
            this.session.unlock();
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void configurationForApplicationScope_buildsWithCorrectRegistry() {
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("path", Secondary.class, Collections.emptyList());
        });
        VaadinServlet servlet = (VaadinServlet)Mockito.mock(VaadinServlet.class);
        Mockito.when((Object)servlet.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.vaadinService.getServlet()).thenReturn((Object)servlet);
        try {
            CurrentInstance.set(VaadinService.class, (Object)((Object)this.vaadinService));
            this.session.lock();
            RouteConfiguration routeConfiguration = RouteConfiguration.forApplicationScope();
            Assertions.assertEquals((int)2, (int)routeConfiguration.getAvailableRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
        }
        finally {
            this.session.unlock();
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void setRoutes_allExpectedRoutesAreSet() {
        RouteRegistry registry = this.mockRegistry();
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        ((RouteRegistry)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            ((Command)args[0]).execute();
            return null;
        }).when((Object)registry)).update((Command)Mockito.any(Command.class));
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(MyRoute.class, MyInfo.class, MyPalace.class, MyModular.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
        ((RouteRegistry)Mockito.verify((Object)registry)).update((Command)Mockito.any());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("home", MyRoute.class, Collections.emptyList());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("info", MyInfo.class, Collections.emptyList());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("palace", MyPalace.class, Collections.emptyList());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("modular", MyModular.class, Collections.emptyList());
    }

    @Test
    public void registeredRouteWithAlias_allPathsAreRegistered() {
        RouteRegistry registry = this.mockRegistry();
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        routeConfiguration.setAnnotatedRoute(MyRouteWithAliases.class);
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("withAliases", MyRouteWithAliases.class, Collections.emptyList());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("person", MyRouteWithAliases.class, Collections.emptyList());
    }

    @Test
    public void routeWithParent_parentsAreCollectedCorrectly() {
        RouteRegistry registry = this.mockRegistry();
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        routeConfiguration.setAnnotatedRoute(SingleLayout.class);
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("single", SingleLayout.class, Collections.singletonList(MainLayout.class));
        routeConfiguration.setAnnotatedRoute(DoubleLayout.class);
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("double", DoubleLayout.class, Arrays.asList(MiddleLayout.class, MainLayout.class));
    }

    @Test
    public void parentLayoutAnnotatedClass_parentsCorrecltCollected() {
        RouteRegistry registry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        routeConfiguration.setParentAnnotatedRoute("middle", MiddleLayout.class);
        ((RouteRegistry)Mockito.verify((Object)registry)).setRoute("middle", MiddleLayout.class, Collections.singletonList(MainLayout.class));
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assertions.fail();
        }
    }

    private RouteRegistry mockRegistry() {
        RouteRegistry registry = (RouteRegistry)Mockito.mock(RouteRegistry.class);
        MockVaadinContext context = new MockVaadinContext();
        Mockito.when((Object)registry.getContext()).thenReturn((Object)context);
        return registry;
    }

    private static class MockService
    extends VaadinServletService {
        private MockService() {
        }

        public RouteRegistry getRouteRegistry() {
            return super.getRouteRegistry();
        }
    }

    @Tag(value="div")
    @Route(value="home")
    private static class MyRoute
    extends Component {
        private MyRoute() {
        }
    }

    @Tag(value="div")
    private static class Secondary
    extends Component {
        private Secondary() {
        }
    }

    @Tag(value="div")
    private static class Url
    extends Component
    implements HasUrlParameter<String> {
        private Url() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Tag(value="div")
    @ParentLayout(value=MainLayout.class)
    private static class MiddleLayout
    extends Component
    implements RouterLayout {
        private MiddleLayout() {
        }
    }

    @Route(value="item/:long(^[+-]?[0-9]{1,19}$)", layout=MainView.class)
    @Tag(value="div")
    private static class ParameterView
    extends Component {
        private ParameterView() {
        }
    }

    @Route(value=":path*")
    @RouteAlias.Container(value={@RouteAlias(value=":tab(api)/:path*"), @RouteAlias(value=":tab(overview|samples|links|reviews|discussions)")})
    @RoutePrefix(value="component/:identifier")
    @Tag(value="div")
    public static class ComponentView
    extends Component {
    }

    @Tag(value="div")
    @Route(value="info")
    private static class MyInfo
    extends Component {
        private MyInfo() {
        }
    }

    @Tag(value="div")
    @Route(value="palace")
    private static class MyPalace
    extends Component {
        private MyPalace() {
        }
    }

    @Tag(value="div")
    @Route(value="modular")
    private static class MyModular
    extends Component {
        private MyModular() {
        }
    }

    @Tag(value="div")
    @Route(value="withAliases")
    @RouteAlias.Container(value={@RouteAlias(value="version"), @RouteAlias(value="person")})
    private static class MyRouteWithAliases
    extends Component {
        private MyRouteWithAliases() {
        }
    }

    @Tag(value="div")
    @Route(value="single", layout=MainLayout.class)
    private static class SingleLayout
    extends Component {
        private SingleLayout() {
        }
    }

    @Tag(value="div")
    private static class MainLayout
    extends Component
    implements RouterLayout {
        private MainLayout() {
        }
    }

    @Tag(value="div")
    @Route(value="double", layout=MiddleLayout.class)
    private static class DoubleLayout
    extends Component {
        private DoubleLayout() {
        }
    }

    @RoutePrefix(value="category/:int(^[-+]?\\d+$)")
    @Tag(value="div")
    private static class MainView
    extends Component
    implements RouterLayout {
        private MainView() {
        }
    }
}

