/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.server.VaadinService;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@NotThreadSafe
class InternalServerErrorTest {
    private BeforeEnterEvent event = (BeforeEnterEvent)Mockito.mock(BeforeEnterEvent.class);
    private VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
    private DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);

    InternalServerErrorTest() {
    }

    @BeforeEach
    public void setUp() {
        VaadinService.setCurrent((VaadinService)this.service);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        Location location = new Location("bar");
        Mockito.when((Object)this.event.getLocation()).thenReturn((Object)location);
    }

    @AfterEach
    public void tearDown() {
        VaadinService.setCurrent(null);
    }

    @Test
    public void productionMode_noWarningAndStacktrace() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)true);
        InternalServerError testInstance = new InternalServerError();
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assertions.assertEquals((int)1, (int)testInstance.getElement().getChildCount(), (String)"Only a text node with exception message should be shown");
    }

    @Test
    public void nonProductionMode_noLogBinding_showWaringAndStacktrace() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        InternalServerError testInstance = new InternalServerError(){

            protected boolean hasLogBinding() {
                return false;
            }
        };
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assertions.assertEquals((int)3, (int)testInstance.getElement().getChildCount(), (String)"3 elements should be shown: exception text, warning about log binding absence and exception stacktrace");
        Element warning = testInstance.getElement().getChild(1);
        Assertions.assertEquals((Object)"div", (Object)warning.getTag());
        Assertions.assertTrue((boolean)warning.getText().contains("SLF4J"));
        Element stacktrace = testInstance.getElement().getChild(2);
        Assertions.assertEquals((Object)"pre", (Object)stacktrace.getTag());
        Assertions.assertTrue((boolean)stacktrace.getText().contains(NullPointerException.class.getName()));
        Assertions.assertTrue((boolean)stacktrace.getText().contains("foo"));
    }

    @Test
    public void nonProductionMode_hasLogBinding_showStacktraceAndNoWarning() {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        InternalServerError testInstance = new InternalServerError(){

            protected boolean hasLogBinding() {
                return true;
            }
        };
        testInstance.setErrorParameter(this.event, new ErrorParameter(Exception.class, (Exception)new NullPointerException("foo")));
        Assertions.assertEquals((int)2, (int)testInstance.getElement().getChildCount(), (String)"2 elements should be shown: exception text and exception stacktrace");
        Element stacktrace = testInstance.getElement().getChild(1);
        Assertions.assertEquals((Object)"pre", (Object)stacktrace.getTag());
        Assertions.assertTrue((boolean)stacktrace.getText().contains(NullPointerException.class.getName()));
        Assertions.assertTrue((boolean)stacktrace.getText().contains("foo"));
    }
}

