/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StateNodeNodeListTest
extends AbstractNodeFeatureTest<ElementChildrenList> {
    private NodeList<StateNode> nodeList = (NodeList)this.createFeature();

    StateNodeNodeListTest() {
    }

    @Test
    void testAddingAndRemoving() {
        StateNode value1 = StateNodeTest.createEmptyNode("value1");
        StateNode value2 = StateNodeTest.createEmptyNode("value2");
        this.nodeList.add((Serializable)value1);
        Assertions.assertEquals((int)1, (int)this.nodeList.size());
        Assertions.assertSame((Object)value1, (Object)this.nodeList.get(0));
        List<NodeChange> firstAddChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)firstAddChanges.size());
        ListAddChange firstAddChange = (ListAddChange)firstAddChanges.get(0);
        Assertions.assertEquals((int)0, (int)firstAddChange.getIndex());
        Assertions.assertEquals(Arrays.asList(value1), (Object)firstAddChange.getNewItems());
        this.nodeList.add(0, (Serializable)value2);
        Assertions.assertEquals((int)2, (int)this.nodeList.size());
        Assertions.assertSame((Object)value2, (Object)this.nodeList.get(0));
        Assertions.assertSame((Object)value1, (Object)this.nodeList.get(1));
        List<NodeChange> secondAddChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)secondAddChanges.size());
        ListAddChange secondAddChange = (ListAddChange)secondAddChanges.get(0);
        Assertions.assertEquals((int)0, (int)secondAddChange.getIndex());
        Assertions.assertEquals(Arrays.asList(value2), (Object)secondAddChange.getNewItems());
        StateNode removedItem = (StateNode)this.nodeList.remove(0);
        Assertions.assertEquals((int)1, (int)this.nodeList.size());
        Assertions.assertSame((Object)value1, (Object)this.nodeList.get(0));
        Assertions.assertSame((Object)value2, (Object)removedItem);
        List<NodeChange> removeChanges = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)removeChanges.size());
        ListRemoveChange removeChange = (ListRemoveChange)removeChanges.get(0);
        Assertions.assertEquals((int)0, (int)removeChange.getIndex());
    }

    @Test
    void testChangesAfterReset() {
        StateNode value1 = StateNodeTest.createEmptyNode("value1");
        StateNode value2 = StateNodeTest.createEmptyNode("value2");
        this.nodeList.add((Serializable)value1);
        this.nodeList.add((Serializable)value2);
        this.nodeList.getNode().clearChanges();
        this.nodeList.generateChangesFromEmpty();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        ListAddChange change = (ListAddChange)changes.get(0);
        Assertions.assertEquals((int)0, (int)change.getIndex());
        Assertions.assertEquals(Arrays.asList(value1, value2), (Object)change.getNewItems());
    }

    @Test
    void testAttachDetachChildren() {
        StateNode child = StateNodeTest.createEmptyNode("child");
        Assertions.assertNull((Object)child.getParent());
        this.nodeList.add((Serializable)child);
        Assertions.assertSame((Object)this.nodeList.getNode(), (Object)child.getParent());
        this.nodeList.remove(0);
        Assertions.assertNull((Object)child.getParent());
    }

    @Test
    void testIndexOf() {
        StateNode one = StateNodeTest.createEmptyNode("one");
        StateNode two = StateNodeTest.createEmptyNode("two");
        StateNode three = StateNodeTest.createEmptyNode("three");
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        Assertions.assertEquals((int)0, (int)this.nodeList.indexOf((Serializable)one));
        Assertions.assertEquals((int)1, (int)this.nodeList.indexOf((Serializable)two));
        Assertions.assertEquals((int)-1, (int)this.nodeList.indexOf((Serializable)three));
    }

    @Test
    void testClear() {
        StateNode one = StateNodeTest.createEmptyNode("one");
        StateNode two = StateNodeTest.createEmptyNode("two");
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        Assertions.assertEquals((int)2, (int)this.nodeList.size());
        this.nodeList.clear();
        Assertions.assertEquals((int)0, (int)this.nodeList.size());
    }

    @Test
    void nullNotAllowed() {
        Assertions.assertThrows(AssertionError.class, () -> this.nodeList.add(null));
    }

    @Test
    void testSerializable() {
        int i;
        StateNode one = StateNodeTest.createTestNode("one", ElementClassList.class);
        ((ElementClassList)one.getFeature(ElementClassList.class)).add((Serializable)((Object)"foo"));
        ((ElementClassList)one.getFeature(ElementClassList.class)).add((Serializable)((Object)"bar"));
        StateNode two = StateNodeTest.createTestNode("two", ElementClassList.class);
        ((ElementClassList)two.getFeature(ElementClassList.class)).add((Serializable)((Object)"baz"));
        this.nodeList.add((Serializable)one);
        this.nodeList.add((Serializable)two);
        ArrayList<StateNode> values = new ArrayList<StateNode>();
        int size = this.nodeList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            values.add((StateNode)this.nodeList.get(i2));
        }
        NodeList copy = (NodeList)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(this.nodeList));
        Assertions.assertNotSame(this.nodeList, (Object)copy);
        Assertions.assertEquals((int)values.size(), (int)copy.size());
        for (i = 0; i < size; ++i) {
            this.assertNodeEquals((StateNode)values.get(i), (StateNode)copy.get(i));
        }
        Assertions.assertEquals((int)values.size(), (int)this.nodeList.size());
        for (i = 0; i < size; ++i) {
            this.assertNodeEquals((StateNode)values.get(i), (StateNode)this.nodeList.get(i));
        }
    }
}

