/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.ArrayNode;

class ReturnChannelMapTest {
    private StateNode node = new StateNode(new Class[]{ReturnChannelMap.class});
    private ReturnChannelMap returnChannelMap = (ReturnChannelMap)this.node.getFeature(ReturnChannelMap.class);

    ReturnChannelMapTest() {
    }

    @Test
    void registerHandler_regstrationHasCorrectData() {
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableBiConsumer & Serializable)(arguments, channel) -> {});
        Assertions.assertEquals((int)this.node.getId(), (int)registration.getStateNodeId(), (String)"Node id should match");
        Assertions.assertSame((Object)registration, (Object)this.returnChannelMap.get(registration.getChannelId()), (String)"Registration should be findable based on id");
        Assertions.assertEquals((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)registration.getDisabledUpdateMode(), (String)"Default disabled update mode should be to allow when enabled");
    }

    @Test
    void twoArgsHandler_invoked() {
        AtomicReference observedArguments = new AtomicReference();
        AtomicReference observedRegistration = new AtomicReference();
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableBiConsumer & Serializable)(arguments, channel) -> {
            Assertions.assertNotNull((Object)arguments, (String)"Arguments should not be null");
            Assertions.assertNull((Object)observedArguments.getAndSet(arguments), (String)"There should be no previous arguments");
            Assertions.assertNull((Object)observedRegistration.getAndSet(channel), (String)"There should be no previous channel");
        });
        Assertions.assertNull(observedArguments.get(), (String)"Handler should not yet be invoked");
        ArrayNode arguments2 = JacksonUtils.createArrayNode();
        registration.invoke(arguments2);
        Assertions.assertSame((Object)arguments2, observedArguments.get());
        Assertions.assertSame((Object)registration, observedRegistration.get());
    }

    @Test
    void shorthandHandler_invoked() {
        AtomicReference observedArguments = new AtomicReference();
        ReturnChannelRegistration registration = this.returnChannelMap.registerChannel((SerializableConsumer & Serializable)arguments -> {
            Assertions.assertNotNull((Object)arguments, (String)"Arguments should not be null");
            Assertions.assertNull((Object)observedArguments.getAndSet(arguments), (String)"There should be no previous arguments");
        });
        Assertions.assertNull(observedArguments.get(), (String)"Handler should not yet be invoked");
        ArrayNode arguments2 = JacksonUtils.createArrayNode();
        registration.invoke(arguments2);
        Assertions.assertSame((Object)arguments2, observedArguments.get());
    }
}

