/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ElementPropertyMapTest {
    ElementPropertyMapTest() {
    }

    @Test
    void addPropertyChangeListener_fireServerEvent_listenerIsNotified() {
        this.listenerIsNotified(false);
    }

    @Test
    void addPropertyChangeListener_fireClientEvent_listenerIsNotified() {
        this.listenerIsNotified(true);
    }

    @Test
    void removeProperty_fireEvent_listenerIsNotNotified() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setProperty("foo", (Serializable)((Object)"bar"));
        AtomicReference event = new AtomicReference();
        PropertyChangeListener & Serializable listener = (PropertyChangeListener & Serializable)ev -> {
            Assertions.assertNull(event.get());
            event.set(ev);
        };
        map.addPropertyChangeListener("foo", (PropertyChangeListener)listener);
        map.remove("foo");
        Assertions.assertNull((Object)((PropertyChangeEvent)event.get()).getValue());
        Assertions.assertEquals((Object)"bar", (Object)((PropertyChangeEvent)event.get()).getOldValue());
        Assertions.assertEquals((Object)"foo", (Object)((PropertyChangeEvent)event.get()).getPropertyName());
        Assertions.assertEquals((Object)Element.get((StateNode)map.getNode()), (Object)((PropertyChangeEvent)event.get()).getSource());
        Assertions.assertTrue((boolean)((PropertyChangeEvent)event.get()).isUserOriginated());
    }

    @Test
    void removePropertyChangeListener_fireEvent_listenerIsNotNotified() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        PropertyChangeListener & Serializable listener = (PropertyChangeListener & Serializable)ev -> Assertions.fail();
        Registration registration = map.addPropertyChangeListener("foo", (PropertyChangeListener)listener);
        registration.remove();
        map.setProperty("foo", (Serializable)((Object)"bar"), true);
    }

    @Test
    void addSeveralPropertyChangeListeners_fireEvent_listenersAreNotified() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        AtomicBoolean first = new AtomicBoolean();
        AtomicBoolean second = new AtomicBoolean();
        PropertyChangeListener & Serializable listener1 = (PropertyChangeListener & Serializable)ev -> first.set(!first.get());
        PropertyChangeListener & Serializable listener2 = (PropertyChangeListener & Serializable)ev -> second.set(!second.get());
        map.addPropertyChangeListener("foo", (PropertyChangeListener)listener1);
        map.addPropertyChangeListener("foo", (PropertyChangeListener)listener2);
        map.setProperty("foo", (Serializable)((Object)"bar"), true);
        Assertions.assertTrue((boolean)first.get());
        Assertions.assertTrue((boolean)second.get());
    }

    @Test
    void resolveModelList_modelListStateNodeHasReportedFeature() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.resolveModelList("foo");
        StateNode stateNode = (StateNode)map.get("foo");
        Assertions.assertTrue((boolean)stateNode.isReportedFeature(ModelList.class));
    }

    @Test
    void resolveModelMap_modelMapStateNodeHasReportedFeature() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.resolveModelMap("foo");
        StateNode stateNode = (StateNode)map.get("foo");
        Assertions.assertTrue((boolean)stateNode.isReportedFeature(ElementPropertyMap.class));
    }

    @Test
    void put_ignoreSameValue() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        AtomicReference value = new AtomicReference();
        map.addPropertyChangeListener("foo", (PropertyChangeListener & Serializable)event -> {
            Assertions.assertNull(value.get());
            value.set(event.getValue());
        });
        map.setProperty("foo", (Serializable)((Object)"bar"));
        Assertions.assertEquals((Object)"bar", value.get());
        map.setProperty("foo", (Serializable)((Object)"bar"));
    }

    @Test
    void basicUpdateFromClientFilter() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        HashSet clientFilterQueries = new HashSet();
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> clientFilterQueries.add(name));
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
    }

    @Test
    void updateSynchronizedPropertyDespiteFilter() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> false);
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
        DomListenerRegistration domListenerRegistration = Element.get((StateNode)map.getNode()).addPropertyChangeListener("foo", "event", (PropertyChangeListener & Serializable)event -> {});
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
        domListenerRegistration.remove();
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
        DomListenerRegistration registration = Element.get((StateNode)map.getNode()).addEventListener("dummy", (DomEventListener & Serializable)event -> {}).synchronizeProperty("foo");
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
        registration.remove();
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"bar")));
    }

    @Test
    void updateFromClientFilter_replaceFilter() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setUpdateFromClientFilter("foo"::equals);
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"a")));
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        map.setUpdateFromClientFilter("bar"::equals);
        Assertions.assertFalse((boolean)map.mayUpdateFromClient("foo", (Serializable)((Object)"a")));
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
    }

    @Test
    void childPropertyUpdateFilter_setFilterBeforeChild() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.setUpdateFromClientFilter("foo.bar"::equals);
        map.put("foo", (Serializable)child);
        Assertions.assertTrue((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        Assertions.assertFalse((boolean)childModel.mayUpdateFromClient("baz", (Serializable)((Object)"a")));
    }

    @Test
    void deferredUpdateFromClient_filterAllowsUpdate() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.setUpdateFromClientFilter("foo.bar"::equals);
        map.put("foo", (Serializable)child);
        this.assertDeferredUpdate_putResult(childModel, "bar");
    }

    @Test
    void deferredUpdateFromClient_noFilter_throws() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.put("foo", (Serializable)child);
        Assertions.assertThrows(PropertyChangeDeniedException.class, () -> childModel.deferredUpdateFromClient("bar", (Serializable)((Object)"a")));
    }

    @Test
    void deferredUpdateFromClient_filterDisallowsUpdate() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)key -> false);
        map.put("foo", (Serializable)child);
        this.assertDeferredUpdate_noOp(childModel, "bar");
    }

    @Test
    void listChildPropertyUpdateFilter_setFilterBeforeChild() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        ModelList list = map.resolveModelList("foo");
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        map.setUpdateFromClientFilter("foo.bar"::equals);
        list.add(child);
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        Assertions.assertTrue((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        Assertions.assertFalse((boolean)childModel.mayUpdateFromClient("baz", (Serializable)((Object)"a")));
    }

    @Test
    void deferredUpdateFromClient_listChild_filterAllowsUpdate() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        ModelList list = map.resolveModelList("foo");
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        map.setUpdateFromClientFilter("foo.bar"::equals);
        list.add(child);
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        this.assertDeferredUpdate_putResult(childModel, "bar");
    }

    @Test
    void deferredUpdateFromClient_listItem_noFilter_throws() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        ModelList list = map.resolveModelList("foo");
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        list.add(child);
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        Assertions.assertThrows(PropertyChangeDeniedException.class, () -> childModel.deferredUpdateFromClient("bar", (Serializable)((Object)"a")));
    }

    @Test
    void deferredUpdateFromClient_listChild_filterDisallowsUpdate() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        ModelList list = map.resolveModelList("foo");
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)key -> false);
        list.add(child);
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        this.assertDeferredUpdate_noOp(childModel, "bar");
    }

    @Test
    void childPropertyUpdateFilter_setFilterAfterChild() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.put("foo", (Serializable)child);
        map.setUpdateFromClientFilter("foo.bar"::equals);
        Assertions.assertTrue((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        Assertions.assertFalse((boolean)childModel.mayUpdateFromClient("baz", (Serializable)((Object)"a")));
    }

    @Test
    void childPropertyUpdateFilter_renameProperty() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)child);
        map.put("foo", (Serializable)child);
        map.setUpdateFromClientFilter("foo.bar"::equals);
        Assertions.assertTrue((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        map.remove("foo");
        Assertions.assertFalse((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
        map.put("bar", (Serializable)child);
        Assertions.assertFalse((boolean)childModel.mayUpdateFromClient("bar", (Serializable)((Object)"a")));
    }

    @Test
    void childPropertyUpdateFilter_deepNesting() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setUpdateFromClientFilter("a.b.c.d.e.f.g.h.i.j.property"::equals);
        for (int i = 0; i < 10; ++i) {
            StateNode child = new StateNode(new Class[]{ElementPropertyMap.class});
            map.setProperty(Character.toString((char)(97 + i)), (Serializable)child);
            map = ElementPropertyMap.getModel((StateNode)child);
        }
        Assertions.assertTrue((boolean)map.mayUpdateFromClient("property", (Serializable)((Object)"foo")));
    }

    @Test
    void deferredUpdateFromClient_updateNotAllowed_throw() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        Assertions.assertThrows(PropertyChangeDeniedException.class, () -> map.deferredUpdateFromClient("foo", (Serializable)((Object)"value")));
    }

    @Test
    void deferredUpdateFromClient_filterDisallowUpdate_eventIsSynchronized() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        Element.get((StateNode)map.getNode()).addEventListener("dummy", (DomEventListener & Serializable)event -> {}).synchronizeProperty("foo");
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)key -> false);
        this.assertDeferredUpdate_putResult(map, "foo");
    }

    @Test
    void deferredUpdateFromClient_filterAllowsUpdate_propertyIsForbidden_throw() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.put("classList", (Serializable)((Object)"a"));
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)key -> true);
        Assertions.assertThrows(PropertyChangeDeniedException.class, () -> map.deferredUpdateFromClient("classList", (Serializable)((Object)"value")));
    }

    @Test
    void deferredUpdateFromClient_clientFiltersOutUpdate_noOpRunnable() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> !name.equals("foo"));
        AtomicReference eventCapture = new AtomicReference();
        map.addPropertyChangeListener("foo", eventCapture::set);
        Runnable runnable = map.deferredUpdateFromClient("foo", (Serializable)((Object)"value"));
        MatcherAssert.assertThat((Object)runnable.getClass().getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)(ElementPropertyMap.class.getName() + "$PutResult"))));
        runnable.run();
        Assertions.assertNull(eventCapture.get());
    }

    @Test
    void deferredUpdateFromClient_clientFilterAcceptUpdate_putResultRunnable() throws PropertyChangeDeniedException {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setUpdateFromClientFilter((SerializablePredicate & Serializable)name -> name.equals("foo"));
        AtomicReference eventCapture = new AtomicReference();
        map.addPropertyChangeListener("foo", eventCapture::set);
        Runnable runnable = this.assertDeferredUpdate_putResult(map, "foo");
        runnable.run();
        Assertions.assertNotNull(eventCapture.get());
    }

    @Test
    void producePutChange_innerHTMLProperty_valueIsTheSame_returnsTrue() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setProperty("innerHTML", (Serializable)((Object)"foo"));
        Assertions.assertTrue((boolean)map.producePutChange("innerHTML", true, (Serializable)((Object)"foo")));
        Assertions.assertTrue((boolean)map.producePutChange("innerHTML", false, (Serializable)((Object)"foo")));
    }

    @Test
    void producePutChange_notInnerHTMLProperty_valueIsTheSame_returnsFalse() {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        map.setProperty("foo", (Serializable)((Object)"bar"));
        Assertions.assertFalse((boolean)map.producePutChange("foo", true, (Serializable)((Object)"bar")));
    }

    private void listenerIsNotified(boolean clientEvent) {
        ElementPropertyMap map = ElementPropertyMapTest.createSimplePropertyMap();
        StateNode node = map.getNode();
        AtomicReference event = new AtomicReference();
        PropertyChangeListener & Serializable listener = (PropertyChangeListener & Serializable)ev -> {
            Assertions.assertNull(event.get());
            event.set(ev);
        };
        map.addPropertyChangeListener("foo", (PropertyChangeListener)listener);
        map.setProperty("foo", (Serializable)((Object)"bar"), !clientEvent);
        Assertions.assertNull((Object)((PropertyChangeEvent)event.get()).getOldValue());
        Assertions.assertEquals((Object)"bar", (Object)((PropertyChangeEvent)event.get()).getValue());
        Assertions.assertEquals((Object)"foo", (Object)((PropertyChangeEvent)event.get()).getPropertyName());
        Assertions.assertEquals((Object)Element.get((StateNode)node), (Object)((PropertyChangeEvent)event.get()).getSource());
        Assertions.assertEquals((Object)clientEvent, (Object)((PropertyChangeEvent)event.get()).isUserOriginated());
        map.setProperty("bar", (Serializable)((Object)"foo"));
    }

    private Runnable assertDeferredUpdate_putResult(ElementPropertyMap map, String property) throws PropertyChangeDeniedException {
        Runnable runnable = map.deferredUpdateFromClient(property, (Serializable)((Object)"a"));
        MatcherAssert.assertThat((Object)runnable.getClass().getName(), (Matcher)CoreMatchers.equalTo((Object)(ElementPropertyMap.class.getName() + "$PutResult")));
        return runnable;
    }

    private void assertDeferredUpdate_noOp(ElementPropertyMap map, String property) throws PropertyChangeDeniedException {
        Runnable runnable = map.deferredUpdateFromClient(property, (Serializable)((Object)"a"));
        MatcherAssert.assertThat((Object)runnable.getClass().getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)(ElementPropertyMap.class.getName() + "$PutResult"))));
    }

    private static ElementPropertyMap createSimplePropertyMap() {
        return (ElementPropertyMap)BasicElementStateProvider.createStateNode((String)"div").getFeature(ElementPropertyMap.class);
    }
}

