/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.change.NodeDetachChange;
import com.vaadin.flow.internal.change.NodeFeatureChange;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.TestUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ObjectNode;

class StateTreeTest {
    private StateTree tree = new UI().getInternals().getStateTree();

    StateTreeTest() {
    }

    @Test
    public void rootNodeState() {
        StateNode rootNode = this.tree.getRootNode();
        Assertions.assertNull((Object)rootNode.getParent(), (String)"Root node should have no parent");
        Assertions.assertTrue((boolean)rootNode.isAttached(), (String)"Root node should always be attached");
        Assertions.assertEquals((int)1, (int)rootNode.getId(), (String)"Root node should always have the same id");
        Assertions.assertSame((Object)this.tree, (Object)rootNode.getOwner());
    }

    @Test
    public void rootNode_setStateNodeAsParent_throws() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.tree.getRootNode().setParent(new StateNode(new Class[0])));
    }

    @Test
    public void rootNode_setNullAsParent_nodeIsDetached() {
        AtomicInteger detachCount = new AtomicInteger();
        Assertions.assertTrue((boolean)this.tree.hasNode(this.tree.getRootNode()));
        this.tree.getRootNode().addDetachListener((Command & Serializable)() -> detachCount.incrementAndGet());
        this.tree.getRootNode().setParent(null);
        Assertions.assertEquals((int)1, (int)detachCount.get());
        Assertions.assertFalse((boolean)this.tree.getRootNode().isAttached());
        Assertions.assertFalse((boolean)this.tree.hasNode(this.tree.getRootNode()));
    }

    @Test
    public void attachedNodeIsAttached() {
        StateNode node = StateNodeTest.createEmptyNode();
        Assertions.assertFalse((boolean)node.isAttached(), (String)"New node should not be attached");
        StateNodeTest.setParent(node, this.tree.getRootNode());
        Assertions.assertTrue((boolean)node.isAttached(), (String)"Node with parent set should be attached");
        StateNodeTest.setParent(node, null);
        Assertions.assertFalse((boolean)node.isAttached(), (String)"Node without parent should not be attached");
    }

    @Test
    public void moveNodeToOtherRoot_throws() {
        StateNode node = StateNodeTest.createEmptyNode();
        StateNodeTest.setParent(node, this.tree.getRootNode());
        StateNodeTest.setParent(node, null);
        StateTree anotherTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        Assertions.assertThrows(IllegalStateException.class, () -> StateNodeTest.setParent(node, anotherTree.getRootNode()));
    }

    @Test
    public void moveNodeToOtherRoot_removeFromTree_doesNotThrow() {
        StateNode node = StateNodeTest.createEmptyNode();
        StateNodeTest.setParent(node, this.tree.getRootNode());
        node.removeFromTree();
        StateTree anotherTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        StateNodeTest.setParent(node, anotherTree.getRootNode());
    }

    @Test
    public void testNoRootAttachChange() {
        List<NodeChange> changes = this.collectChangesExceptChildrenAddRemove();
        for (NodeChange change : changes) {
            if (change instanceof NodeFeatureChange) {
                Class feature = ((NodeFeatureChange)change).getFeature();
                Assertions.assertNotEquals(ElementChildrenList.class, (Object)feature);
                continue;
            }
            if (!(change instanceof NodeAttachChange)) continue;
            StateNode node = ((NodeAttachChange)change).getNode();
            Assertions.assertNotEquals((Object)this.tree.getRootNode(), (Object)node);
        }
    }

    @Test
    public void testTreeChangeCollection() {
        StateNode node2 = StateNodeTest.createEmptyNode();
        StateNodeTest.setParent(node2, this.tree.getRootNode());
        List<NodeChange> changes = this.collectChangesExceptChildrenAddRemove();
        ArrayList<NodeChange> notChildrenChanges = new ArrayList<NodeChange>();
        for (NodeChange change : changes) {
            if (change instanceof NodeFeatureChange) {
                Class feature = ((NodeFeatureChange)change).getFeature();
                Assertions.assertNotEquals(ElementChildrenList.class, (Object)feature);
                continue;
            }
            notChildrenChanges.add(change);
        }
        Assertions.assertEquals((int)2, (int)notChildrenChanges.size());
        NodeAttachChange nodeChange = (NodeAttachChange)notChildrenChanges.get(0);
        Assertions.assertTrue((boolean)nodeChange.getNode().hasFeature(PushConfigurationMap.PushConfigurationParametersMap.class));
        NodeAttachChange attachChange = (NodeAttachChange)notChildrenChanges.get(1);
        Assertions.assertSame((Object)node2, (Object)attachChange.getNode());
    }

    @Test
    public void testDirtyNodeCollection() {
        StateNode node1 = this.tree.getRootNode();
        StateNode node2 = StateNodeTest.createEmptyNode("node2");
        StateNodeTest.setParent(node2, node1);
        NodeOwner owner = node1.getOwner();
        Assertions.assertSame((Object)owner, (Object)node2.getOwner(), (String)"Both nodes should have the same owner");
        Set initialDirty = this.tree.collectDirtyNodes();
        HashSet dirty = initialDirty.stream().filter(node -> !node.hasFeature(PushConfigurationMap.PushConfigurationParametersMap.class)).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertEquals(new HashSet<StateNode>(Arrays.asList(node1, node2)), (Object)dirty, (String)"Both nodes should initially be empty");
        this.tree.collectChanges(change -> {});
        node2.markAsDirty();
        Set collectAfterOneMarked = this.tree.collectDirtyNodes();
        Assertions.assertTrue((boolean)collectAfterOneMarked.contains(node2), (String)"Marked node should be in collect result");
    }

    @Test
    public void testDirtyNodeCollectionOrder() {
        StateNode rootNode = this.tree.getRootNode();
        ArrayList<StateNode> nodes = new ArrayList<StateNode>();
        for (int i = 0; i < 10; ++i) {
            StateNode node2 = StateNodeTest.createEmptyNode("node" + i);
            nodes.add(node2);
            StateNodeTest.setParent(node2, rootNode);
        }
        nodes.forEach(StateNode::markAsDirty);
        ArrayList<StateNode> expected = new ArrayList<StateNode>();
        expected.add(rootNode);
        expected.addAll(nodes);
        Object[] dirty = this.tree.collectDirtyNodes().stream().filter(node -> !node.hasFeature(PushConfigurationMap.PushConfigurationParametersMap.class)).toArray();
        Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])dirty);
        this.tree.collectChanges(change -> {});
        nodes.forEach(StateNode::markAsDirty);
        expected = new ArrayList(nodes);
        Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])this.tree.collectDirtyNodes().toArray());
    }

    @Test
    public void testDetachInChanges() {
        StateNode node1 = this.tree.getRootNode();
        StateNode node2 = StateNodeTest.createEmptyNode();
        StateNodeTest.setParent(node2, node1);
        this.collectChangesExceptChildrenAddRemove();
        StateNodeTest.setParent(node2, null);
        List<NodeChange> changes = this.collectChangesExceptChildrenAddRemove();
        Assertions.assertEquals((int)1, (int)changes.size(), (String)"Should be one change.");
        Assertions.assertTrue((boolean)(changes.get(0) instanceof NodeDetachChange), (String)"Should have a detach change");
    }

    @Test
    public void allValuesAfterReattach() {
        StateNode node1 = this.tree.getRootNode();
        StateNode node2 = new StateNode(new Class[]{ElementData.class});
        StateNodeTest.setParent(node2, node1);
        ((ElementData)node2.getFeature(ElementData.class)).setTag("foo");
        this.collectChangesExceptChildrenAddRemove();
        StateNodeTest.setParent(node2, null);
        this.collectChangesExceptChildrenAddRemove();
        StateNodeTest.setParent(node2, node1);
        List<NodeChange> changes = this.collectChangesExceptChildrenAddRemove();
        Assertions.assertEquals((int)2, (int)changes.size(), (String)"Should be three changes.");
        Assertions.assertTrue((boolean)(changes.get(0) instanceof NodeAttachChange), (String)"First change should re-attach the node.");
        Assertions.assertTrue((boolean)(changes.get(1) instanceof MapPutChange), (String)"Second change should put the tag or payload value.");
        Optional<MapPutChange> tagFound = changes.stream().filter(MapPutChange.class::isInstance).map(MapPutChange.class::cast).filter(chang -> chang.getKey().equals("tag")).findFirst();
        Assertions.assertTrue((boolean)tagFound.isPresent(), (String)"No tag change found");
        MapPutChange nodeChange = tagFound.get();
        Assertions.assertEquals(ElementData.class, (Object)nodeChange.getFeature());
        Assertions.assertEquals((Object)"tag", (Object)nodeChange.getKey());
        Assertions.assertEquals((Object)"foo", (Object)nodeChange.getValue());
    }

    private List<NodeChange> collectChangesExceptChildrenAddRemove() {
        ArrayList<NodeChange> changes = new ArrayList<NodeChange>();
        this.tree.collectChanges(change -> {
            if ((change instanceof ListAddChange || change instanceof ListRemoveChange) && ((NodeFeatureChange)change).getFeature() == ElementChildrenList.class) {
                return;
            }
            changes.add((NodeChange)change);
        });
        return changes;
    }

    @Test
    public void testSerializable() {
        Class[] features = new Class[]{ElementChildrenList.class, ElementData.class, ElementAttributeMap.class, ElementPropertyMap.class};
        StateTree tree = new StateTree(new UI().getInternals(), features);
        StateNode root = tree.getRootNode();
        ((ElementData)root.getFeature(ElementData.class)).setTag("body");
        StateNode child = new StateNode(features);
        ((ElementChildrenList)root.getFeature(ElementChildrenList.class)).add(0, child);
        ((ElementData)child.getFeature(ElementData.class)).setTag("div");
        byte[] serialized = SerializationUtils.serialize((Serializable)tree);
        StateTree d1 = (StateTree)SerializationUtils.deserialize((byte[])serialized);
        Assertions.assertNotNull((Object)d1);
    }

    @Test
    public void reattachedNodeRetainsId() throws InterruptedException {
        StateNode child = new StateNode(new Class[]{ElementChildrenList.class});
        StateNode grandChild = new StateNode(new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)child.getFeature(ElementChildrenList.class)).add(0, grandChild);
        ElementChildrenList children = (ElementChildrenList)this.tree.getRootNode().getFeature(ElementChildrenList.class);
        children.add(0, child);
        int childId = child.getId();
        int grandChildId = grandChild.getId();
        Assertions.assertTrue((boolean)child.isAttached());
        Assertions.assertTrue((boolean)grandChild.isAttached());
        Assertions.assertSame((Object)child, (Object)this.tree.getNodeById(childId));
        Assertions.assertSame((Object)grandChild, (Object)this.tree.getNodeById(grandChildId));
        children.remove(0);
        Assertions.assertFalse((boolean)child.isAttached());
        Assertions.assertFalse((boolean)grandChild.isAttached());
        Assertions.assertNull((Object)this.tree.getNodeById(childId));
        Assertions.assertNull((Object)this.tree.getNodeById(grandChildId));
        children.add(0, child);
        Assertions.assertTrue((boolean)child.isAttached());
        Assertions.assertTrue((boolean)grandChild.isAttached());
        Assertions.assertEquals((int)childId, (int)child.getId());
        Assertions.assertEquals((int)grandChildId, (int)grandChild.getId());
        Assertions.assertSame((Object)child, (Object)this.tree.getNodeById(childId));
        Assertions.assertSame((Object)grandChild, (Object)this.tree.getNodeById(grandChildId));
    }

    @Test
    public void detachedNodeGarbageCollected() throws InterruptedException {
        StateNode child = new StateNode(new Class[]{ElementChildrenList.class});
        StateNode grandChild = new StateNode(new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)child.getFeature(ElementChildrenList.class)).add(0, grandChild);
        ElementChildrenList children = (ElementChildrenList)this.tree.getRootNode().getFeature(ElementChildrenList.class);
        children.add(0, child);
        WeakReference<StateNode> childRef = new WeakReference<StateNode>(child);
        child = null;
        WeakReference<StateNode> grandChildRef = new WeakReference<StateNode>(grandChild);
        grandChild = null;
        children.remove(0);
        this.tree.collectChanges(c -> {});
        Assertions.assertTrue((boolean)TestUtil.isGarbageCollected(childRef));
        Assertions.assertTrue((boolean)TestUtil.isGarbageCollected(grandChildRef));
    }

    @Test
    public void beforeClientResponse_regularOrder() {
        AttachableNode rootNode = new AttachableNode(true);
        ArrayList results = new ArrayList();
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(0));
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(1));
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(2));
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"There should be 3 results in the list");
        for (int i = 0; i < results.size(); ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)results.get(i)), (String)("The result at index '" + i + "' should be " + i));
        }
    }

    @Test
    public void beforeClientResponse_initiallyAttachedToOneUI_executedWithAnother_executionDoesNotHappen() {
        StateTree initialTree = new UI().getInternals().getStateTree();
        StateNode child = new StateNode(new Class[]{ElementChildrenList.class});
        StateNodeTest.setParent(child, initialTree.getRootNode());
        AtomicBoolean isExecuted = new AtomicBoolean();
        initialTree.beforeClientResponse(child, (SerializableConsumer & Serializable)context -> isExecuted.set(true));
        child.removeFromTree();
        StateNodeTest.setParent(child, this.tree.getRootNode());
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertFalse((boolean)isExecuted.get());
    }

    @Test
    public void beforeClientResponse_initiallyNotAttached_executedWithUI_executionRun() {
        StateTree someTree = new UI().getInternals().getStateTree();
        StateNode child = new StateNode(new Class[]{ElementChildrenList.class});
        AtomicBoolean isExecuted = new AtomicBoolean();
        someTree.beforeClientResponse(child, (SerializableConsumer & Serializable)context -> isExecuted.set(true));
        StateNodeTest.setParent(child, this.tree.getRootNode());
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertTrue((boolean)isExecuted.get());
    }

    @Test
    public void beforeClientResponse_withInnerRunnables() {
        AttachableNode rootNode = new AttachableNode(true);
        ArrayList results = new ArrayList();
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(0));
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> {
            results.add(1);
            this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context2 -> results.add(3));
            this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context2 -> results.add(4));
        });
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(2));
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 5 ? 1 : 0) != 0, (String)"There should be 5 results in the list");
        for (int i = 0; i < results.size(); ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)results.get(i)), (String)("The result at index '" + i + "' should be " + i));
        }
    }

    @Test
    public void beforeClientResponse_withUnattachedNodes() {
        AttachableNode rootNode = new AttachableNode(true);
        AttachableNode emptyNode = new AttachableNode();
        ArrayList results = new ArrayList();
        this.tree.beforeClientResponse((StateNode)emptyNode, (SerializableConsumer & Serializable)context -> results.add(0));
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(1));
        this.tree.beforeClientResponse((StateNode)emptyNode, (SerializableConsumer & Serializable)context -> results.add(2));
        this.tree.beforeClientResponse((StateNode)rootNode, (SerializableConsumer & Serializable)context -> results.add(3));
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"There should be 2 results in the list");
        Assertions.assertEquals((int)1, (int)((Integer)results.get(0)), (String)"The result at index '0' should be 1");
        Assertions.assertEquals((int)3, (int)((Integer)results.get(1)), (String)"The result at index '1' should be 3");
    }

    @Test
    public void beforeClientResponse_withAttachedNodesDuringExecution() {
        StateNode rootNode = this.tree.getRootNode();
        StateNode emptyNode1 = StateNodeTest.createEmptyNode("node1");
        StateNode emptyNode2 = StateNodeTest.createEmptyNode("node2");
        ArrayList results = new ArrayList();
        this.tree.beforeClientResponse(emptyNode1, (SerializableConsumer & Serializable)context -> {
            results.add(0);
            StateNodeTest.setParent(emptyNode2, rootNode);
        });
        this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> {
            results.add(1);
            StateNodeTest.setParent(emptyNode1, rootNode);
        });
        this.tree.beforeClientResponse(emptyNode2, (SerializableConsumer & Serializable)context -> results.add(2));
        this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> results.add(3));
        this.tree.runExecutionsBeforeClientResponse();
        Assertions.assertTrue((results.size() == 4 ? 1 : 0) != 0, (String)"There should be 4 results in the list");
        Assertions.assertEquals((int)1, (int)((Integer)results.get(0)), (String)"The result at index '0' should be 1");
        Assertions.assertEquals((int)3, (int)((Integer)results.get(1)), (String)"The result at index '1' should be 3");
        Assertions.assertEquals((int)0, (int)((Integer)results.get(2)), (String)"The result at index '2' should be 0");
        Assertions.assertEquals((int)2, (int)((Integer)results.get(3)), (String)"The result at index '3' should be 2");
    }

    @Test
    public void beforeClientResponse_failingExecutionWithNullErrorHandler_NoNPE() {
        StateNode rootNode = this.tree.getRootNode();
        this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> {
            throw new IllegalStateException("Throw before client response");
        });
        Assertions.assertNull((Object)this.tree.getUI().getSession());
        VaadinSession mockSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)mockSession.getErrorHandler()).thenReturn(null);
        try {
            this.tree.getUI().getInternals().setSession(mockSession);
            this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> {
                throw new IllegalStateException("Throw before client response");
            });
            Assertions.assertThrows(IllegalStateException.class, () -> this.tree.runExecutionsBeforeClientResponse());
        }
        finally {
            this.tree.getUI().getInternals().setSession(null);
        }
    }

    @Test
    public void beforeClientResponse_failingExecutionWithNullSession_NoNPE() {
        StateNode rootNode = this.tree.getRootNode();
        this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> {
            throw new IllegalStateException("Throw before client response");
        });
        Assertions.assertNull((Object)this.tree.getUI().getSession());
        this.tree.beforeClientResponse(rootNode, (SerializableConsumer & Serializable)context -> {
            throw new IllegalStateException("Throw before client response");
        });
        Assertions.assertThrows(IllegalStateException.class, () -> this.tree.runExecutionsBeforeClientResponse());
    }

    @Test
    public void beforeClientResponse_nodeGarbageCollectedDespiteClosure() throws InterruptedException {
        StateNode node1 = this.tree.getRootNode();
        StateNode node2 = StateNodeTest.createEmptyNode("node2");
        StateNodeTest.setParent(node2, node1);
        class CapturingConsumer
        implements SerializableConsumer<ExecutionContext> {
            private final Object captured;

            public CapturingConsumer(Object captured) {
                this.captured = captured;
            }

            public void accept(ExecutionContext t) {
            }
        }
        this.tree.beforeClientResponse(node2, (SerializableConsumer)new CapturingConsumer(node2));
        StateNodeTest.setParent(node2, null);
        WeakReference<StateNode> ref = new WeakReference<StateNode>(node2);
        node2 = null;
        this.tree.collectChanges(value -> {});
        Assertions.assertTrue((boolean)TestUtil.isGarbageCollected(ref));
    }

    @Test
    public void collectChanges_updateActiveState() {
        StateNode node1 = (StateNode)Mockito.mock(StateNode.class);
        StateNode node2 = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)node1.getOwner()).thenReturn((Object)this.tree);
        Mockito.when((Object)node2.getOwner()).thenReturn((Object)this.tree);
        this.tree.markAsDirty(node1);
        this.tree.markAsDirty(node2);
        this.tree.collectChanges(node -> {});
        ((StateNode)Mockito.verify((Object)node1)).updateActiveState();
        ((StateNode)Mockito.verify((Object)node2)).updateActiveState();
    }

    @Test
    public void collectChanges_parentIsInactive_childrenAreCollected() {
        CollectableNode node1 = new CollectableNode();
        CollectableNode node2 = new CollectableNode();
        CollectableNode node3 = new CollectableNode();
        node1.setTree(this.tree);
        node2.setTree(this.tree);
        node3.setTree(this.tree);
        ((ElementChildrenList)node1.getFeature(ElementChildrenList.class)).add(0, (StateNode)node2);
        ((ElementChildrenList)node2.getFeature(ElementChildrenList.class)).add(0, (StateNode)node3);
        this.tree.collectChanges(node -> {});
        ((ElementData)node1.getFeature(ElementData.class)).setVisible(false);
        ArrayList collectedNodes = new ArrayList(3);
        this.tree.collectChanges(change -> collectedNodes.add(change.getNode()));
        Assertions.assertEquals((int)3, (int)collectedNodes.size());
        Assertions.assertTrue((boolean)collectedNodes.contains((Object)node1));
        Assertions.assertTrue((boolean)collectedNodes.contains((Object)node2));
        Assertions.assertTrue((boolean)collectedNodes.contains((Object)node3));
    }

    @Test
    public void prepareForResync_nodeHasAttachAndDetachListeners_treeIsDirtyAndListenersAreCalled() {
        StateNode node1 = this.tree.getRootNode();
        StateNode node2 = StateNodeTest.createEmptyNode("node2");
        StateNodeTest.setParent(node2, node1);
        AtomicInteger attachCount = new AtomicInteger();
        node2.addAttachListener(attachCount::incrementAndGet);
        AtomicInteger detachCount = new AtomicInteger();
        node2.addDetachListener(detachCount::incrementAndGet);
        this.tree.collectChanges(c -> {});
        Assertions.assertEquals((int)0, (int)this.tree.collectDirtyNodes().size());
        Assertions.assertTrue((boolean)node2.isClientSideInitialized());
        Assertions.assertTrue((boolean)node2.isAttached());
        this.tree.getRootNode().prepareForResync();
        Assertions.assertFalse((boolean)node2.isClientSideInitialized());
        Assertions.assertTrue((boolean)node2.isAttached());
        Assertions.assertEquals((int)1, (int)attachCount.get());
        Assertions.assertEquals((int)1, (int)detachCount.get());
        Assertions.assertEquals((int)3, (int)this.tree.collectDirtyNodes().size());
        HashSet dirtyNodes = new HashSet(this.tree.collectDirtyNodes());
        Assertions.assertTrue((boolean)dirtyNodes.remove(node1));
        Assertions.assertTrue((boolean)dirtyNodes.remove(node2));
        StateNode remaining = (StateNode)dirtyNodes.iterator().next();
        Assertions.assertTrue((boolean)remaining.hasFeature(PushConfigurationMap.PushConfigurationParametersMap.class));
        this.tree.collectChanges(change -> {});
        Assertions.assertTrue((boolean)node2.isClientSideInitialized());
        node2.setParent(null);
        Assertions.assertEquals((int)2, (int)detachCount.get(), (String)"Detach listener was not called on final detach");
    }

    @Test
    public void pendingJavascriptExecutionForInitiallyInvisibleNode() {
        UI ui = new UI();
        VaadinSession mockSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        ui.getInternals().setSession(mockSession);
        StateTree initialTree = ui.getInternals().getStateTree();
        Element element = ElementFactory.createAnchor();
        element.setVisible(false);
        ui.getElement().appendChild(new Element[]{element});
        element.executeJs("js", new Object[0]);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)0, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
        element.removeFromParent();
        initialTree.collectChanges(nodeChange -> {});
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertFalse((boolean)ui.getInternals().isDirty(), (String)"Pending JS executions are not removed on detach");
    }

    @Test
    public void pendingJavascriptExecutionForVisibleAndInvisibleNode() {
        UI ui = new UI();
        VaadinSession mockSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        ui.getInternals().setSession(mockSession);
        StateTree initialTree = ui.getInternals().getStateTree();
        Element element = ElementFactory.createAnchor();
        ui.getElement().appendChild(new Element[]{element});
        element.executeJs("js", new Object[0]);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)1, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
        element.setVisible(false);
        element.executeJs("js", new Object[0]);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)0, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
        element.setVisible(true);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)1, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
    }

    @Test
    public void pendingJavascriptExecutionForVisibleAndInvisibleParentNode() {
        UI ui = new UI();
        VaadinSession mockSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        ui.getInternals().setSession(mockSession);
        StateTree initialTree = ui.getInternals().getStateTree();
        Element element = ElementFactory.createAnchor();
        Element parentElement = ElementFactory.createDiv();
        ui.getElement().appendChild(new Element[]{parentElement});
        parentElement.appendChild(new Element[]{element});
        parentElement.setVisible(false);
        element.executeJs("js", new Object[0]);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)0, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
        parentElement.setVisible(true);
        initialTree.runExecutionsBeforeClientResponse();
        Assertions.assertEquals((int)1, (int)ui.getInternals().dumpPendingJavaScriptInvocations().size());
    }

    public static class AttachableNode
    extends StateNode {
        private boolean attached;

        public AttachableNode() {
            super(new Class[0]);
        }

        public AttachableNode(boolean attached) {
            super(new Class[0]);
            this.attached = attached;
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isAttached() {
            return this.attached;
        }
    }

    public static class CollectableNode
    extends StateNode {
        public CollectableNode() {
            super(new Class[]{ElementData.class, ElementChildrenList.class});
        }

        public void collectChanges(Consumer<NodeChange> collector) {
            collector.accept(new NodeChange(this){

                protected void populateJson(ObjectNode json, ConstantPool constantPool) {
                }
            });
        }
    }
}

