/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.ThemeListImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThemeListImplTest {
    ThemeListImplTest() {
    }

    @Test
    public void themeListCreatedWithNoThemes() {
        ThemeListImpl emptyList = new ThemeListImpl((Element)new MockElement(new String[0]));
        Assertions.assertTrue((boolean)emptyList.isEmpty(), (String)"ThemeList created from the element without themes should be empty");
        Assertions.assertEquals((int)emptyList.size(), (int)0, (String)"ThemeList created from the element without themes should be empty");
    }

    @Test
    public void themeListCreatedWithOneThemes() {
        String themeName = "theme1";
        ThemeListImpl elementWithOneTheme = new ThemeListImpl((Element)new MockElement(themeName));
        Assertions.assertEquals((int)elementWithOneTheme.size(), (int)1, (String)"ThemeList created from the element with one theme should contain single element");
        Assertions.assertTrue((boolean)elementWithOneTheme.contains((Object)themeName), (String)"ThemeList created from the element with one theme should contain this theme as its single element");
    }

    @Test
    public void themeListCreatedWithMultipleThemes() {
        String[] themeNames = new String[]{"theme1", "theme2"};
        ThemeListImpl elementWithMultipleThemes = new ThemeListImpl((Element)new MockElement(themeNames));
        Assertions.assertFalse((boolean)elementWithMultipleThemes.isEmpty(), (String)"ThemeList created from the element with multiple distinct themes should not be empty");
        Assertions.assertEquals((int)elementWithMultipleThemes.size(), (int)themeNames.length, (String)"ThemeList created from the element with multiple distinct themes should be of the same size as number of the themes");
        Assertions.assertTrue((boolean)elementWithMultipleThemes.containsAll(Arrays.asList(themeNames)), (String)"ThemeList created from the element with multiple distinct themes should contain them all and oly them");
    }

    @Test
    public void themeListCreatedWithDuplicateThemes() {
        String[] themeNames = new String[]{"theme1", "theme1", "theme1"};
        ThemeListImpl elementWithMultipleThemes = new ThemeListImpl((Element)new MockElement(themeNames));
        Assertions.assertEquals((int)elementWithMultipleThemes.size(), (int)1, (String)"ThemeList created from the element with multiple themes should be of the same size as number of unique themes");
        Assertions.assertTrue((boolean)elementWithMultipleThemes.contains((Object)themeNames[0]), (String)"ThemeList created from the element with multiple themes should be contain all unique themes");
    }

    @Test
    public void clear() {
        MockElement element = new MockElement("theme1", "theme2");
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.clear();
        Assertions.assertTrue((boolean)themeList.isEmpty(), (String)"ThemeList should be empty after it's cleared");
        Assertions.assertNull((Object)element.getAttribute("theme"), (String)"If corresponding ThemeList is cleared, no themes should be preset in the corresponding element");
    }

    @Test
    public void remove() {
        String themeToRemove = "theme2";
        String themeToLeave = "theme1";
        MockElement element = new MockElement(themeToLeave, themeToRemove);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.remove((Object)themeToRemove);
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"Only one theme should be present in ThemeList after removal");
        Assertions.assertTrue((boolean)themeList.contains((Object)themeToLeave), (String)"ThemeList should contain theme that was not removed");
        Assertions.assertEquals((Object)element.getAttribute("theme"), (Object)themeToLeave, (String)"Corresponding element should contain only the theme that was not removed");
    }

    @Test
    public void removeAll() {
        String themeToRemove1 = "theme3";
        String themeToRemove2 = "theme2";
        String themeToLeave = "theme1";
        MockElement element = new MockElement(themeToLeave, themeToRemove1, themeToRemove2);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.removeAll(Arrays.asList(themeToRemove1, themeToRemove2));
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"Only one theme should be present in ThemeList after removal");
        Assertions.assertTrue((boolean)themeList.contains((Object)themeToLeave), (String)"ThemeList should contain theme that was not removed");
        Assertions.assertEquals((Object)element.getAttribute("theme"), (Object)themeToLeave, (String)"Corresponding element should contain only the theme that was not removed");
    }

    @Test
    public void removeAllThemes() {
        String[] themeNames = new String[]{"theme1", "theme2"};
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.removeAll(Arrays.asList(themeNames));
        Assertions.assertTrue((boolean)themeList.isEmpty(), (String)"ThemeList should be empty after all it's themes are removed");
        Assertions.assertNull((Object)element.getAttribute("theme"), (String)"If corresponding ThemeList is cleared, no themes should be preset in the corresponding element");
    }

    @Test
    public void retainAll() {
        List<String> elementsToRetain = Arrays.asList("retained", "notRetained");
        String[] themeNames = new String[]{elementsToRetain.get(0), "theme2", "theme3"};
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.retainAll(elementsToRetain);
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"ThemeList should contain one retained theme");
        Assertions.assertEquals((Object)element.getAttribute("theme"), themeList.iterator().next(), (String)"Corresponding element should contain the only element present in ThemeList");
    }

    @Test
    public void add() {
        String themeToAdd = "theme";
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.add(themeToAdd);
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"ThemeList should not be empty after adding a theme");
        Assertions.assertTrue((boolean)themeList.contains((Object)themeToAdd), (String)"ThemeList should contain theme added");
        Assertions.assertEquals((Object)element.getAttribute("theme"), (Object)themeToAdd, (String)"Corresponding element should contain the theme added");
    }

    @Test
    public void addAll() {
        List<String> themesToAdd = Arrays.asList("theme1", "theme2", "theme3");
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.addAll(themesToAdd);
        Assertions.assertFalse((boolean)themeList.isEmpty(), (String)"ThemeList should not be empty after adding themes");
        Assertions.assertEquals((int)themeList.size(), (int)themesToAdd.size(), (String)"ThemeList size should be equal to number of distinct themes added if it was empty before");
        Assertions.assertTrue((boolean)themeList.containsAll(themesToAdd), (String)"ThemeList should contain all distinct themes added");
        themesToAdd.forEach(themeName -> Assertions.assertTrue((boolean)element.getAttribute("theme").contains((CharSequence)themeName), (String)"Each distinct theme added to ThemeList should be present in correspondent element's 'theme' attribute"));
    }

    @Test
    public void addDuplicates() {
        List<String> themesToAdd = Arrays.asList("theme1", "theme1", "theme1");
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.addAll(themesToAdd);
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"ThemeList should not be empty after themes have been added");
        Assertions.assertTrue((boolean)themeList.contains((Object)themesToAdd.get(0)), (String)"ThemeList should contain all distinct themes added");
        Assertions.assertEquals((Object)element.getAttribute("theme"), (Object)themesToAdd.get(0), (String)"Corresponding element should have all distinct themes added");
    }

    @Test
    public void iteratorRemoval() {
        String[] themeNames = new String[]{"theme1", "theme2", "theme3"};
        List<String> originalThemes = Arrays.asList(themeNames);
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        HashSet<String> removedElements = new HashSet<String>();
        Iterator iterator = themeList.iterator();
        removedElements.add((String)iterator.next());
        iterator.remove();
        removedElements.add((String)iterator.next());
        iterator.remove();
        Assertions.assertEquals((int)themeList.size(), (int)1, (String)"ThemeList should have one element left after removal");
        String notRemovedTheme = (String)themeList.iterator().next();
        Assertions.assertTrue((boolean)originalThemes.containsAll(removedElements), (String)"Themes returned by ThemeList's iterator.next() should be present in the original list of themes");
        Assertions.assertTrue((boolean)originalThemes.contains(notRemovedTheme), (String)"Theme left in ThemeList after removal should be present in the original list of themes");
        Assertions.assertFalse((boolean)removedElements.contains(notRemovedTheme), (String)"Removed themes should not contain theme left in the ThemeList");
        Assertions.assertEquals((Object)element.getAttribute("theme"), (Object)notRemovedTheme, (String)"Theme left in ThemeList after removal should be the only theme preset in the corresponding element");
    }

    private static class MockElement
    extends Element {
        private final Map<String, String> attributesMap = new HashMap<String, String>();

        private MockElement(String ... themeNames) {
            super("mock-element");
            if (themeNames.length > 0) {
                this.attributesMap.put("theme", Stream.of(themeNames).collect(Collectors.joining(" ")));
            }
        }

        public Element setAttribute(String attribute, String value) {
            this.attributesMap.put(attribute, value);
            return this;
        }

        public String getAttribute(String attribute) {
            return this.attributesMap.get(attribute);
        }

        public Element removeAttribute(String attribute) {
            this.attributesMap.remove(attribute);
            return this;
        }
    }
}

