/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class HasOrderedComponentsTest {
    private HasOrderedComponents components = (HasOrderedComponents)Mockito.spy(TestOrderedComponents.class);
    private TestComponentContianer contianer = new TestComponentContianer();

    HasOrderedComponentsTest() {
    }

    @Test
    public void indexOf_componentIsChild_returnsIndexOfChild() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), comp, (Component)Mockito.mock(Component.class)).stream());
        Assertions.assertEquals((int)1, (int)this.components.indexOf(comp));
        this.contianer = new TestComponentContianer();
        comp = new Anchor();
        this.contianer.add(new Component[]{new Text(""), comp});
        Assertions.assertEquals((int)1, (int)this.contianer.indexOf(comp));
    }

    @Test
    public void indexOf_componentIsNotChild_returnsNegative() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        Assertions.assertEquals((int)-1, (int)this.components.indexOf(comp));
    }

    @Test
    public void indexOf_componentIsNull_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Stream.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.components.indexOf(null));
    }

    @Test
    public void getComponentCount_returnsChildrenSize() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        Assertions.assertEquals((int)2, (int)this.components.getComponentCount());
        this.contianer = new TestComponentContianer();
        this.contianer.add(new Component[]{new Text(""), new Anchor()});
        Assertions.assertEquals((int)2, (int)this.contianer.getComponentCount());
    }

    @Test
    public void getComponentAt_returnsComponentAtIndex() {
        Component comp = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), comp, (Component)Mockito.mock(Component.class)).stream());
        Assertions.assertSame((Object)comp, (Object)this.components.getComponentAt(1));
        this.contianer = new TestComponentContianer();
        comp = new Anchor();
        this.contianer.add(new Component[]{new Text(""), comp});
        Assertions.assertSame((Object)comp, (Object)this.contianer.getComponentAt(1));
    }

    @Test
    public void getComponentAt_negativeIndex_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Arrays.asList((Component)Mockito.mock(Component.class), (Component)Mockito.mock(Component.class)).stream());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.components.getComponentAt(-1));
    }

    @Test
    public void getComponentAt_indexIsGreaterThanSize_throws() {
        Mockito.when((Object)this.components.getChildren()).thenReturn(Stream.of((Component)Mockito.mock(Component.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.components.getComponentAt(2));
    }

    static class TestOrderedComponents
    implements HasOrderedComponents {
        TestOrderedComponents() {
        }

        public Element getElement() {
            return null;
        }

        public Stream<Component> getChildren() {
            return null;
        }
    }

    @Tag(value="div")
    static class TestComponentContianer
    extends Component
    implements HasOrderedComponents {
        TestComponentContianer() {
        }
    }

    @Tag(value="a")
    static class Anchor
    extends Component {
        Anchor() {
        }
    }
}

