/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HasEnabledTest {
    HasEnabledTest() {
    }

    @Test
    public void enabledComponent_isEnabledReturnsTrue() {
        TestComponent component = new TestComponent();
        Assertions.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void explicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        component.setEnabled(false);
        Assertions.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void implicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        TestComponent parent = new TestComponent();
        parent.setEnabled(false);
        parent.add(new Component[]{component});
        Assertions.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void implicitlyDisabledComponent_detach_componentBecomesEnabled() {
        TestComponent component = new TestComponent();
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        parent.setEnabled(false);
        parent.remove(new Component[]{component});
        Assertions.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void explicitlyDisabledComponent_enableParent_componentRemainsDisabled() {
        TestComponent component = new TestComponent();
        component.setEnabled(false);
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        parent.setEnabled(false);
        Assertions.assertFalse((boolean)component.isEnabled());
        parent.setEnabled(true);
        Assertions.assertFalse((boolean)component.isEnabled());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        private TestComponent() {
        }
    }
}

