/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.dom.DisabledUpdateMode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ComponentMetaDataTest {
    ComponentMetaDataTest() {
    }

    @Test
    public void synchronizedProperties_methodInClass() {
        this.assertFooProperty(Sample.class);
    }

    @Test
    public void synchronizedProperties_methodInInterface() {
        this.assertFooProperty(HasFooImpl.class, DisabledUpdateMode.ALWAYS);
    }

    @Test
    public void synchronizedProperties_protectedMethod() {
        this.assertFooProperty(HasFooProtected.class);
    }

    @Test
    public void synchronizedProperties_packagePrivateMethod() {
        this.assertFooProperty(HasFooPackagePrivate.class);
    }

    @Test
    public void synchronizedProperties_privateMethod() {
        this.assertFooProperty(HasFooPrivate.class);
    }

    @Test
    public void synchronizedProperties_hasOverriddenMethod() {
        ComponentMetaData data = new ComponentMetaData(SubClass.class);
        Collection props = data.getSynchronizedProperties();
        Assertions.assertEquals((int)2, (int)props.size());
        List bazProps = props.stream().filter(prop -> prop.getProperty().equals("baz")).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)bazProps.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)bazProps.get(0);
        List events = info.getEventNames().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)"bar", events.get(0));
        Assertions.assertTrue((boolean)props.stream().anyMatch(prop -> prop.getProperty().equals("bar")));
    }

    @Test
    public void synchronizedProperties_overridesMethodAndProperty() {
        ComponentMetaData data = new ComponentMetaData(ChangeSyncProperty.class);
        Collection props = data.getSynchronizedProperties();
        Assertions.assertEquals((int)1, (int)props.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)props.iterator().next();
        Assertions.assertEquals((Object)"foo", (Object)info.getProperty());
        List events = info.getEventNames().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)"baz", events.get(0));
    }

    private void assertFooProperty(Class<? extends Component> clazz) {
        this.assertFooProperty(clazz, DisabledUpdateMode.ONLY_WHEN_ENABLED);
    }

    private void assertFooProperty(Class<? extends Component> clazz, DisabledUpdateMode mode) {
        ComponentMetaData data = new ComponentMetaData(clazz);
        Collection props = data.getSynchronizedProperties();
        Assertions.assertEquals((int)1, (int)props.size());
        ComponentMetaData.SynchronizedPropertyInfo info = (ComponentMetaData.SynchronizedPropertyInfo)props.iterator().next();
        Assertions.assertEquals((Object)"baz", (Object)info.getProperty());
        Assertions.assertEquals((Object)mode, (Object)info.getUpdateMode());
        List events = info.getEventNames().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)"bar", events.get(0));
    }

    @Tag(value="a")
    public static class Sample
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        public String getFoo() {
            return null;
        }

        public String getBar() {
            return null;
        }
    }

    @Tag(value="a")
    public static class HasFooImpl
    extends Component
    implements HasFoo {
        @Override
        public String getFoo() {
            return null;
        }
    }

    public static class HasFooProtected
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        protected String getFoo() {
            return null;
        }
    }

    public static class HasFooPackagePrivate
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        String getFoo() {
            return null;
        }
    }

    public static class HasFooPrivate
    extends Component {
        @Synchronize(value={"bar"}, property="baz")
        private String getFoo() {
            return null;
        }
    }

    public static class SubClass
    extends Sample {
        @Override
        public String getFoo() {
            return null;
        }

        @Synchronize(value={"foo"}, property="bar")
        public String getBaz() {
            return null;
        }
    }

    public static class ChangeSyncProperty
    extends Sample {
        @Override
        @Synchronize(value={"baz"}, property="foo")
        public String getFoo() {
            return null;
        }
    }

    public static interface HasFoo {
        @Synchronize(value={"bar"}, property="baz", allowUpdates=DisabledUpdateMode.ALWAYS)
        public String getFoo();
    }
}

