/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractFieldBindValueTest
extends SignalsUnitTest {
    AbstractFieldBindValueTest() {
    }

    @Test
    public void bindValue_elementAttachedBefore_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        Assertions.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttachedAfter_bindingActive() {
        TestInput input = new TestInput();
        Assertions.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        UI.getCurrent().add(new Component[]{input});
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttached_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
        signal.set(null);
        Assertions.assertNull((Object)input.getValue());
        Assertions.assertEquals((int)3, (int)input.setValueCounter);
    }

    @Test
    public void bindValue_elementNotAttached_bindingInactive() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementDetached_bindingInactive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.removeFromParent();
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementReAttached_bindingActivate() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.removeFromParent();
        signal.set((Object)"bar");
        UI.getCurrent().add(new Component[]{input});
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_bindValueWhileBindingIsActive_throwException() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal1 = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal1, arg_0 -> ((ValueSignal)signal1).set(arg_0));
        ValueSignal signal2 = new ValueSignal((Object)"bar");
        Assertions.assertThrows(BindingActiveException.class, () -> input.bindValue((Signal)signal2, arg_0 -> ((ValueSignal)signal2).set(arg_0)));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_setValueWhileBindingIsActive_signalUpdated() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.setValue("bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
        Assertions.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_nullSignal_throwsNPE() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        Assertions.assertThrows(NullPointerException.class, () -> input.bindValue(null, null));
    }

    @Test
    public void bindValue_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        SignalBindingFeature feature = (SignalBindingFeature)input.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("value");
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        input.setValue("baz");
        Assertions.assertEquals((Object)"baz", (Object)input.getValue());
        Assertions.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_lazyInitSignalBindingFeature() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        input.setValue("foo");
        input.getValue();
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assertions.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindValue_addValueChangeListener_signalValueChangeTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assertions.assertNull(listenerValue.get());
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"bar", listenerValue.get());
    }

    @Test
    public void bindValue_addValueChangeListener_bindValueTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assertions.assertNull(listenerValue.get());
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"foo", listenerValue.get());
    }

    @Test
    public void bindValue_setValue_countEffectExecutions() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicInteger counter = new AtomicInteger(0);
        Signal.effect((Component)input, (EffectAction & Serializable)() -> {
            signal.get();
            counter.incrementAndGet();
        });
        Assertions.assertEquals((int)0, (int)counter.get());
        UI.getCurrent().add(new Component[]{input});
        Assertions.assertEquals((int)1, (int)counter.get());
        input.setValue("bar");
        Assertions.assertEquals((int)2, (int)counter.get());
        input.setValue("bar");
        Assertions.assertEquals((int)2, (int)counter.get());
        input.setValue("foo");
        Assertions.assertEquals((int)3, (int)counter.get());
        signal.set((Object)"baz");
        Assertions.assertEquals((int)4, (int)counter.get());
        input.setValue("baz");
        Assertions.assertEquals((int)4, (int)counter.get());
    }

    @Test
    public void bindValue_forElementProperty_addValueChangeListener_bindingValueChangeTriggersEvent() {
        TestPropertyInput input = new TestPropertyInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assertions.assertEquals((Object)"", (Object)input.getValue());
        Assertions.assertNull(listenerValue.get());
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        Assertions.assertEquals((Object)"foo", listenerValue.get());
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
        Assertions.assertEquals((Object)"bar", listenerValue.get());
        signal.set(null);
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
        Assertions.assertEquals((Object)"bar", listenerValue.get());
        Assertions.assertEquals((int)1, (int)this.events.size());
        this.events.clear();
    }

    @Test
    public void bindValue_readOnlyBinding_setValueThrows() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        Assertions.assertThrows(IllegalStateException.class, () -> input.setValue("bar"));
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        Assertions.assertEquals((Object)"foo", (Object)signal.peek());
    }

    @Test
    public void bindValue_readOnlyBinding_signalChangesStillWork() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        signal.set((Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_readOnlyBinding_detachedSetValueDoesNotThrow() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, null);
        input.setValue("bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_noOpCallback_revertsToSignalValue() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> {});
        input.setValue("bar");
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        Assertions.assertEquals((Object)"foo", (Object)signal.peek());
    }

    @Test
    public void bindValue_transformingCallback_componentShowsTransformed() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> signal.set((Object)v.toUpperCase()));
        input.setValue("bar");
        Assertions.assertEquals((Object)"BAR", (Object)signal.peek());
        Assertions.assertEquals((Object)"BAR", (Object)input.getValue());
    }

    @Test
    public void bindValue_normalCallback_setValueUpdatesBoth() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        input.setValue("bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
        Assertions.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_readOnlySignal_signalToComponentDirection() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal writable = new ValueSignal((Object)"foo");
        Signal readOnly = writable.asReadonly();
        input.bindValue(readOnly, null);
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        writable.set((Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_writeCallbackThrows() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)value -> {
            throw new RuntimeException("test");
        });
        Assertions.assertEquals((Object)"foo", (Object)input.getValue());
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assertions.fail((String)"Value change listener should not be triggered when write callback throws"));
        Assertions.assertThrows(RuntimeException.class, () -> input.setValue("bar"));
    }

    @Test
    public void bindValue_normalCallback_valueChangeEventTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            eventValue.set((String)event.getValue());
            counter.incrementAndGet();
        });
        input.setValue("bar");
        Assertions.assertEquals((Object)"bar", eventValue.get());
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void bindValue_transformingCallback_valueChangeEventTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)v -> signal.set((Object)v.toUpperCase()));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            eventValue.set((String)event.getValue());
            counter.incrementAndGet();
        });
        input.setValue("bar");
        Assertions.assertEquals((Object)"BAR", eventValue.get());
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void bindValue_noOpCallback_valueChangeEventNotTriggered() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((Signal)signal, (SerializableConsumer & Serializable)value -> {});
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assertions.fail((String)"Value change listener should not be triggered with a no-op callback"));
        input.setValue("bar");
    }

    @Test
    public void bindValue_updaterHelper_immutableRecord() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        record Person(String name, int age) {
            Person withName(String name) {
                return new Person(name, this.age);
            }
        }
        ValueSignal personSignal = new ValueSignal((Object)new Person("Alice", 30));
        input.bindValue(personSignal.map(Person::name), personSignal.updater(Person::withName));
        Assertions.assertEquals((Object)"Alice", (Object)input.getValue());
        Assertions.assertEquals((int)30, (int)((Person)personSignal.get()).age());
        input.setValue("Bob");
        Assertions.assertEquals((Object)"Bob", (Object)input.getValue());
        Assertions.assertEquals((Object)"Bob", (Object)((Person)personSignal.get()).name());
        Assertions.assertEquals((int)30, (int)((Person)personSignal.get()).age());
        personSignal.update((SignalUpdater & Serializable)p -> new Person("Charlie", 35));
        Assertions.assertEquals((Object)"Charlie", (Object)input.getValue());
        Assertions.assertEquals((int)35, (int)((Person)personSignal.get()).age());
    }

    @Test
    public void bindValue_modifierHelper_mutableBean() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        class Person {
            private String name;
            private int age;

            Person(AbstractFieldBindValueTest this$0, String name, int age) {
                this.name = name;
                this.age = age;
            }

            String getName() {
                return this.name;
            }

            void setName(String name) {
                this.name = name;
            }

            int getAge() {
                return this.age;
            }
        }
        Person person = new Person(this, "Alice", 30);
        ValueSignal personSignal = new ValueSignal((Object)person);
        input.bindValue(personSignal.map(Person::getName), personSignal.modifier(Person::setName));
        Assertions.assertEquals((Object)"Alice", (Object)input.getValue());
        Assertions.assertEquals((int)30, (int)((Person)personSignal.get()).getAge());
        input.setValue("Bob");
        Assertions.assertEquals((Object)"Bob", (Object)input.getValue());
        Assertions.assertEquals((Object)"Bob", (Object)((Person)personSignal.get()).getName());
        Assertions.assertEquals((int)30, (int)((Person)personSignal.get()).getAge());
        Assertions.assertSame((Object)person, (Object)personSignal.get());
        personSignal.modify((ValueModifier & Serializable)p -> p.setName("Charlie"));
        Assertions.assertEquals((Object)"Charlie", (Object)input.getValue());
    }

    @Test
    public void bindValue_updaterHelper_valueChangeEvents() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        record Person(String name) {
            Person withName(String name) {
                return new Person(name);
            }
        }
        ValueSignal personSignal = new ValueSignal((Object)new Person("Alice"));
        input.bindValue(personSignal.map(Person::name), personSignal.updater(Person::withName));
        AtomicInteger counter = new AtomicInteger(0);
        AtomicReference lastValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            counter.incrementAndGet();
            lastValue.set((String)event.getValue());
        });
        input.setValue("Bob");
        Assertions.assertEquals((int)1, (int)counter.get());
        Assertions.assertEquals((Object)"Bob", lastValue.get());
        personSignal.update((SignalUpdater & Serializable)p -> new Person("Charlie"));
        Assertions.assertEquals((int)2, (int)counter.get());
        Assertions.assertEquals((Object)"Charlie", lastValue.get());
    }

    @Tag(value="input")
    private static class TestInput
    extends AbstractField<TestInput, String> {
        int setValueCounter = 0;

        public TestInput() {
            this("");
        }

        public TestInput(String defaultValue) {
            super((Object)defaultValue);
        }

        protected void setPresentationValue(String newPresentationValue) {
        }

        public void setValue(String value) {
            super.setValue((Object)value);
            ++this.setValueCounter;
        }
    }

    @Tag(value="input")
    private static class TestPropertyInput
    extends AbstractSinglePropertyField<TestInput, String> {
        public TestPropertyInput() {
            super("value", (Object)"", false);
        }
    }
}

