/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow;

import com.vaadin.flow.ComponentTrackerTest;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DisableComponentTrackerTest {
    private Object previousDisabled;
    private Field disabledField;

    DisableComponentTrackerTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.disabledField = ComponentTracker.class.getDeclaredField("disabled");
        this.disabledField.setAccessible(true);
        this.previousDisabled = this.disabledField.get(null);
        this.disabledField.set(null, null);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.disabledField.set(null, this.previousDisabled);
    }

    @Test
    public void trackCreate_disabledInProductionMode() {
        this.withVaadinEnvironment(appCfg -> {
            Mockito.when((Object)appCfg.isProductionMode()).thenReturn((Object)true);
            Mockito.when((Object)appCfg.getBooleanProperty((String)ArgumentMatchers.eq((Object)"devmode.componentTracker.enabled"), ArgumentMatchers.anyBoolean())).then(i -> i.getArgument(1));
            ComponentTrackerTest.Component1 c1 = new ComponentTrackerTest.Component1();
            Assertions.assertNull((Object)ComponentTracker.findCreate((Component)c1));
        });
    }

    @Test
    public void trackAttach_disabledInProductionMode() {
        this.withVaadinEnvironment(appCfg -> {
            Mockito.when((Object)appCfg.isProductionMode()).thenReturn((Object)true);
            Mockito.when((Object)appCfg.getBooleanProperty((String)ArgumentMatchers.eq((Object)"devmode.componentTracker.enabled"), ArgumentMatchers.anyBoolean())).then(i -> i.getArgument(1));
            ComponentTrackerTest.Component1 c1 = new ComponentTrackerTest.Component1();
            ComponentTrackerTest.Layout layout = new ComponentTrackerTest.Layout(c1);
            Assertions.assertNull((Object)ComponentTracker.findAttach((Component)c1));
        });
    }

    @Test
    public void trackCreate_disabledByConfiguration() {
        this.withVaadinEnvironment(appCfg -> {
            Mockito.when((Object)appCfg.isProductionMode()).thenReturn((Object)false);
            Mockito.when((Object)appCfg.getBooleanProperty((String)ArgumentMatchers.eq((Object)"devmode.componentTracker.enabled"), ArgumentMatchers.anyBoolean())).thenReturn((Object)false);
            ComponentTrackerTest.Component1 c1 = new ComponentTrackerTest.Component1();
            Assertions.assertNull((Object)ComponentTracker.findCreate((Component)c1));
        });
    }

    @Test
    public void trackAttach_disabledByConfiguration() {
        this.withVaadinEnvironment(appCfg -> {
            Mockito.when((Object)appCfg.isProductionMode()).thenReturn((Object)false);
            Mockito.when((Object)appCfg.getBooleanProperty((String)ArgumentMatchers.eq((Object)"devmode.componentTracker.enabled"), ArgumentMatchers.anyBoolean())).thenReturn((Object)false);
            ComponentTrackerTest.Component1 c1 = new ComponentTrackerTest.Component1();
            ComponentTrackerTest.Layout layout = new ComponentTrackerTest.Layout(c1);
            Assertions.assertNull((Object)ComponentTracker.findAttach((Component)c1));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withVaadinEnvironment(Consumer<ApplicationConfiguration> action) {
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Map instances = CurrentInstance.getInstances();
        CurrentInstance.clearAll();
        MockVaadinServletService service = new MockVaadinServletService(configuration);
        service.getContext().setAttribute(ApplicationConfiguration.class, (Object)applicationConfiguration);
        try {
            CurrentInstance.set(VaadinService.class, (Object)((Object)service));
            action.accept(applicationConfiguration);
        }
        finally {
            CurrentInstance.restoreInstances((Map)instances);
        }
    }
}

