/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow;

import com.vaadin.flow.component.internal.ComponentTracker;
import java.util.ArrayList;
import java.util.stream.Stream;

public class ComponentTrackerPerformanceTest {
    private static final int WARMUP_ITERATIONS = 100;
    private static final int COMPONENT_COUNT = 10000;
    private static final int ACCESS_COUNT = 5;
    private static final int TEST_ROUNDS = 3;
    private static final StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public static void main(String[] args) {
        new ComponentTrackerPerformanceTest().compareRealisticScenario();
    }

    public void compareRealisticScenario() {
        System.out.println("=== ComponentTracker Performance Comparison ===\n");
        System.out.println("Realistic scenario: Create 10000 components, access location for 5\n");
        System.out.println("Warming up JIT compiler...");
        for (int i = 0; i < 100; ++i) {
            this.originalEagerApproach();
            this.stackWalkerEagerApproach();
            this.lazyThrowableApproach();
        }
        System.out.println("Warmup complete.\n");
        System.out.println("Running benchmark (3 rounds)...");
        System.out.println("---\n");
        long originalTime = 0L;
        long stackWalkerTime = 0L;
        long lazyTime = 0L;
        long originalMemory = 0L;
        long stackWalkerMemory = 0L;
        long lazyMemory = 0L;
        for (int round = 1; round <= 3; ++round) {
            this.forceGC();
            long start = System.nanoTime();
            BenchmarkResult originalResult = this.originalEagerApproach();
            originalTime += System.nanoTime() - start;
            originalMemory += originalResult.memoryUsed;
            this.forceGC();
            start = System.nanoTime();
            BenchmarkResult stackWalkerResult = this.stackWalkerEagerApproach();
            stackWalkerTime += System.nanoTime() - start;
            stackWalkerMemory += stackWalkerResult.memoryUsed;
            this.forceGC();
            start = System.nanoTime();
            BenchmarkResult lazyResult = this.lazyThrowableApproach();
            lazyTime += System.nanoTime() - start;
            lazyMemory += lazyResult.memoryUsed;
            System.out.printf("Round %d complete\n", round);
        }
        double avgOriginal = (double)originalTime / 3.0 / 1000000.0;
        double avgStackWalker = (double)stackWalkerTime / 3.0 / 1000000.0;
        double avgLazy = (double)lazyTime / 3.0 / 1000000.0;
        double avgOriginalMemory = (double)originalMemory / 3.0 / 1024.0 / 1024.0;
        double avgStackWalkerMemory = (double)stackWalkerMemory / 3.0 / 1024.0 / 1024.0;
        double avgLazyMemory = (double)lazyMemory / 3.0 / 1024.0 / 1024.0;
        System.out.println("\n=== Time Results ===");
        System.out.printf("Original (Thread.getStackTrace + eager): %.2f ms average\n", avgOriginal);
        System.out.printf("StackWalker (eager processing):         %.2f ms average\n", avgStackWalker);
        System.out.printf("Lazy (Throwable + deferred):            %.2f ms average\n", avgLazy);
        System.out.println("\n=== Memory Results ===");
        System.out.printf("Original (Thread.getStackTrace + eager): %.2f MB average\n", avgOriginalMemory);
        System.out.printf("StackWalker (eager processing):         %.2f MB average\n", avgStackWalkerMemory);
        System.out.printf("Lazy (Throwable + deferred):            %.2f MB average\n", avgLazyMemory);
        System.out.println("\n=== Time Comparison ===");
        this.printComparison("StackWalker vs Original", originalTime, stackWalkerTime);
        this.printComparison("Lazy vs Original", originalTime, lazyTime);
        this.printComparison("Lazy vs StackWalker", stackWalkerTime, lazyTime);
        System.out.println("\n=== Memory Comparison ===");
        this.printMemoryComparison("StackWalker vs Original", originalMemory, stackWalkerMemory);
        this.printMemoryComparison("Lazy vs Original", originalMemory, lazyMemory);
        this.printMemoryComparison("Lazy vs StackWalker", stackWalkerMemory, lazyMemory);
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void forceGC() {
        System.gc();
        this.sleep(50);
        System.gc();
        this.sleep(50);
        System.gc();
        this.sleep(100);
    }

    private void printComparison(String label, long baselineTime, long newTime) {
        double ratio = (double)baselineTime / (double)newTime;
        if (ratio >= 1.0) {
            double percentFaster = (double)(baselineTime - newTime) * 100.0 / (double)baselineTime;
            System.out.printf("%s: %.2fx faster (%.1f%% reduction)\n", label, ratio, percentFaster);
        } else {
            double slowerRatio = (double)newTime / (double)baselineTime;
            double percentSlower = (double)(newTime - baselineTime) * 100.0 / (double)baselineTime;
            System.out.printf("%s: %.2fx SLOWER (%.1f%% increase)\n", label, slowerRatio, percentSlower);
        }
    }

    private void printMemoryComparison(String label, long baselineMemory, long newMemory) {
        double ratio = (double)baselineMemory / (double)newMemory;
        if (ratio >= 1.0) {
            double percentLess = (double)(baselineMemory - newMemory) * 100.0 / (double)baselineMemory;
            System.out.printf("%s: %.2fx less memory (%.1f%% reduction)\n", label, ratio, percentLess);
        } else {
            double moreRatio = (double)newMemory / (double)baselineMemory;
            double percentMore = (double)(newMemory - baselineMemory) * 100.0 / (double)baselineMemory;
            System.out.printf("%s: %.2fx MORE memory (%.1f%% increase)\n", label, moreRatio, percentMore);
        }
    }

    private long measureMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private BenchmarkResult originalEagerApproach() {
        int i;
        long memoryBefore = this.measureMemory();
        ArrayList<StackInfo> components = new ArrayList<StackInfo>();
        for (i = 0; i < 10000; ++i) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            ComponentTracker.Location[] allLocations = (ComponentTracker.Location[])Stream.of(stack).map(this::toLocationFromStackTraceElement).toArray(ComponentTracker.Location[]::new);
            ComponentTracker.Location location = this.findRelevant(allLocations);
            components.add(new StackInfo(location));
        }
        for (i = 0; i < 5; ++i) {
            ComponentTracker.Location location = ((StackInfo)components.get((int)(i * 2000))).location;
        }
        long memoryAfter = this.measureMemory();
        return new BenchmarkResult(components, memoryAfter - memoryBefore);
    }

    private BenchmarkResult stackWalkerEagerApproach() {
        int i;
        long memoryBefore = this.measureMemory();
        ArrayList<StackInfo> components = new ArrayList<StackInfo>();
        for (i = 0; i < 10000; ++i) {
            ComponentTracker.Location[] allLocations = stackWalker.walk(frames -> (ComponentTracker.Location[])frames.map(this::toLocationFromStackFrame).toArray(ComponentTracker.Location[]::new));
            ComponentTracker.Location location = this.findRelevant(allLocations);
            components.add(new StackInfo(location));
        }
        for (i = 0; i < 5; ++i) {
            ComponentTracker.Location location = ((StackInfo)components.get((int)(i * 2000))).location;
        }
        long memoryAfter = this.measureMemory();
        return new BenchmarkResult(components, memoryAfter - memoryBefore);
    }

    private BenchmarkResult lazyThrowableApproach() {
        int i;
        long memoryBefore = this.measureMemory();
        ArrayList<Throwable> components = new ArrayList<Throwable>();
        for (i = 0; i < 10000; ++i) {
            components.add(new Throwable());
        }
        for (i = 0; i < 5; ++i) {
            Throwable t = (Throwable)components.get(i * 2000);
            StackTraceElement[] stack = t.getStackTrace();
            ComponentTracker.Location[] allLocations = (ComponentTracker.Location[])Stream.of(stack).map(this::toLocationFromStackTraceElement).toArray(ComponentTracker.Location[]::new);
            ComponentTracker.Location location = this.findRelevant(allLocations);
        }
        long memoryAfter = this.measureMemory();
        return new BenchmarkResult(components, memoryAfter - memoryBefore);
    }

    private ComponentTracker.Location findRelevant(ComponentTracker.Location[] locations) {
        for (ComponentTracker.Location location : locations) {
            if (location == null || location.className().startsWith("com.vaadin.flow.") || location.className().startsWith("java.") || location.className().startsWith("jdk.")) continue;
            return location;
        }
        return null;
    }

    private ComponentTracker.Location toLocationFromStackTraceElement(StackTraceElement element) {
        if (element == null) {
            return null;
        }
        return new ComponentTracker.Location(element.getClassName(), element.getFileName(), element.getMethodName(), element.getLineNumber());
    }

    private ComponentTracker.Location toLocationFromStackFrame(StackWalker.StackFrame frame) {
        if (frame == null) {
            return null;
        }
        return new ComponentTracker.Location(frame.getClassName(), frame.getFileName(), frame.getMethodName(), frame.getLineNumber());
    }

    static class BenchmarkResult {
        Object data;
        long memoryUsed;

        BenchmarkResult(Object data, long memoryUsed) {
            this.data = data;
            this.memoryUsed = memoryUsed;
        }
    }

    static class StackInfo {
        ComponentTracker.Location location;

        StackInfo(ComponentTracker.Location location) {
            this.location = location;
        }
    }
}

