/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.local.AbstractLocalSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ListSignal<T>
extends AbstractLocalSignal<List<ValueSignal<T>>> {
    public ListSignal() {
        super(List.of());
    }

    @Override
    public List<ValueSignal<T>> get() {
        return Objects.requireNonNull((List)super.get());
    }

    @Override
    public List<ValueSignal<T>> peek() {
        return Objects.requireNonNull((List)super.peek());
    }

    @Override
    protected void checkPreconditions() {
        this.assertLockHeld();
        super.checkPreconditions();
        if (Transaction.inTransaction()) {
            throw new IllegalStateException("ListSignal cannot be used inside signal transactions because it can hold a reference to a mutable object that can be mutated directly, bypassing transaction control. Use SharedListSignal instead.");
        }
    }

    public ValueSignal<T> insertFirst(T value) {
        this.lock();
        try {
            this.checkPreconditions();
            ValueSignal<T> valueSignal = this.insertAtInternal(0, value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    public ValueSignal<T> insertLast(T value) {
        this.lock();
        try {
            this.checkPreconditions();
            ValueSignal<T> valueSignal = this.insertAtInternal(Objects.requireNonNull((List)this.getSignalValue()).size(), value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSignal<T> insertAt(int index, T value) {
        this.lock();
        try {
            this.checkPreconditions();
            List entries = Objects.requireNonNull((List)this.getSignalValue());
            if (index < 0 || index > entries.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + entries.size());
            }
            ValueSignal<T> valueSignal = this.insertAtInternal(index, value);
            return valueSignal;
        }
        finally {
            this.unlock();
        }
    }

    private ValueSignal<T> insertAtInternal(int index, T value) {
        this.assertLockHeld();
        ValueSignal<T> entry = new ValueSignal<T>(value);
        ArrayList<ValueSignal<T>> newEntries = new ArrayList<ValueSignal<T>>(Objects.requireNonNull((List)this.getSignalValue()));
        newEntries.add(index, entry);
        this.setSignalValue(Collections.unmodifiableList(newEntries));
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ValueSignal<T> entry) {
        this.lock();
        try {
            this.checkPreconditions();
            List entries = Objects.requireNonNull((List)this.getSignalValue());
            List<ValueSignal> newEntries = entries.stream().filter(e -> e != entry).toList();
            if (newEntries.size() < entries.size()) {
                this.setSignalValue(newEntries);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            this.checkPreconditions();
            if (!Objects.requireNonNull((List)this.getSignalValue()).isEmpty()) {
                this.setSignalValue(List.of());
            }
        }
        finally {
            this.unlock();
        }
    }

    public String toString() {
        return this.peek().stream().map(AbstractLocalSignal::peek).map(Objects::toString).collect(Collectors.joining(", ", "ListSignal[", "]"));
    }
}

