/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AccessCheckResultTest {
    AccessCheckResultTest() {
    }

    @Test
    public void create_getsResultInstance() {
        for (AccessCheckDecision decision : AccessCheckDecision.values()) {
            AccessCheckResult result = AccessCheckResult.create((AccessCheckDecision)decision, (String)decision.name());
            Assertions.assertEquals((Object)decision, (Object)result.decision());
            Assertions.assertEquals((Object)decision.name(), (Object)result.reason());
        }
    }

    @Test
    public void create_nullReason_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AccessCheckResult.create(null, (String)"Something"));
    }

    @Test
    public void create_denyWithoutReason_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AccessCheckResult.create((AccessCheckDecision)AccessCheckDecision.DENY, null));
    }

    @Test
    public void create_rejectWithoutReason_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AccessCheckResult.create((AccessCheckDecision)AccessCheckDecision.REJECT, null));
    }

    @Test
    public void deny_noReason_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AccessCheckResult.deny(null));
    }

    @Test
    public void reject_noReason_throws() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AccessCheckResult.reject(null));
    }
}

