/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.DevToolsToken;
import com.vaadin.flow.server.VaadinService;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class DevToolsTokenTest {
    @TempDir
    Path projectFolder;
    private VaadinService service;
    private DeploymentConfiguration configuration;
    private String initialToken;
    private String systemTempDir;

    DevToolsTokenTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn((Object)this.projectFolder.toFile());
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        this.initialToken = DevToolsToken.getToken();
        this.systemTempDir = System.getProperty("java.io.tmpdir");
        System.setProperty("java.io.tmpdir", this.projectFolder.toFile().getAbsolutePath());
    }

    @AfterEach
    public void tearDown() {
        this.overwriteToken(this.initialToken);
        System.setProperty("java.io.tmpdir", this.systemTempDir);
    }

    @Test
    public void init_tokenFileNotExising_createTokenFile() {
        DevToolsToken.init((VaadinService)this.service);
        Assertions.assertEquals((Object)this.initialToken, (Object)DevToolsToken.getToken());
        this.overwriteToken("EMPTY");
        DevToolsToken.init((VaadinService)this.service);
        Assertions.assertEquals((Object)this.initialToken, (Object)DevToolsToken.getToken());
    }

    @Test
    public void init_nullProjectFolder_useInMemoryToken() {
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn(null);
        String testToken = UUID.randomUUID().toString();
        this.overwriteToken(testToken);
        DevToolsToken.init((VaadinService)this.service);
        Assertions.assertEquals((Object)testToken, (Object)DevToolsToken.getToken());
    }

    private void overwriteToken(String token) {
        try {
            ReflectTools.setJavaFieldValue(null, (Field)DevToolsToken.class.getDeclaredField("randomDevToolsToken"), (Object)token);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

