/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.internal.PathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PathUtilTest {
    PathUtilTest() {
    }

    @Test
    public void methods_output_expected_values() {
        List<String> segments = Arrays.asList("path", "to", "foo");
        String path = "path/to/foo";
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.getPath(segments), (String)"Unexpected result");
        Assertions.assertEquals((Object)"", (Object)PathUtil.getPath(null), (String)"Unexpected result");
        Assertions.assertEquals((Object)"", (Object)PathUtil.getPath(Collections.emptyList()), (String)"Unexpected result");
        Assertions.assertEquals((Object)"prefix/path/to/foo", (Object)PathUtil.getPath((String)"prefix", segments), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.getPath((String)"", segments), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.getPath(null, segments), (String)"Unexpected result");
        Assertions.assertEquals(segments, (Object)PathUtil.getSegmentsList((String)"path/to/foo"), (String)"Unexpected result");
        Assertions.assertEquals(segments, (Object)PathUtil.getSegmentsList((String)"path/to/foo/"), (String)"Unexpected result");
        ArrayList<String> emptyStartSegment = new ArrayList<String>();
        emptyStartSegment.add("");
        emptyStartSegment.addAll(segments);
        Assertions.assertEquals(emptyStartSegment, (Object)PathUtil.getSegmentsList((String)"/path/to/foo"), (String)"Unexpected result");
        Assertions.assertEquals(emptyStartSegment, (Object)PathUtil.getSegmentsList((String)"/path/to/foo/"), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.trimPath((String)"path/to/foo"), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.trimPath((String)"/path/to/foo"), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.trimPath((String)"path/to/foo/"), (String)"Unexpected result");
        Assertions.assertEquals((Object)"path/to/foo", (Object)PathUtil.trimPath((String)"/path/to/foo/"), (String)"Unexpected result");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesEncodedSlashes() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fwith%2Fslashes");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"path/with/slashes", segments.get(0), (String)"Should decode %2F to /");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesSpaces() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"hello%20world");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"hello world", segments.get(0), (String)"Should decode %20 to space");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesSpecialCharacters() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"test%3Fquestion/value%26data");
        Assertions.assertEquals((int)2, (int)segments.size(), (String)"Should have two segments");
        Assertions.assertEquals((Object)"test?question", segments.get(0), (String)"Should decode %3F to ?");
        Assertions.assertEquals((Object)"value&data", segments.get(1), (String)"Should decode %26 to &");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesPlus() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"a%2Bb/c%2Bd");
        Assertions.assertEquals((int)2, (int)segments.size(), (String)"Should have two segments");
        Assertions.assertEquals((Object)"a+b", segments.get(0), (String)"Should decode %2B to +");
        Assertions.assertEquals((Object)"c+d", segments.get(1), (String)"Should decode %2B to +");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesHash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"item%23123");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"item#123", segments.get(0), (String)"Should decode %23 to #");
    }

    @Test
    public void getSegmentsListWithDecoding_decodesPercent() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"50%25off");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"50%off", segments.get(0), (String)"Should decode %25 to %");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesMultipleEncodedSegments() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fwith%2Fslashes/normal/another%2Fencoded");
        Assertions.assertEquals((int)3, (int)segments.size(), (String)"Should have three segments");
        Assertions.assertEquals((Object)"path/with/slashes", segments.get(0), (String)"First segment should be decoded");
        Assertions.assertEquals((Object)"normal", segments.get(1), (String)"Second segment should be normal");
        Assertions.assertEquals((Object)"another/encoded", segments.get(2), (String)"Third segment should be decoded");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesEmptyPath() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"");
        Assertions.assertTrue((boolean)segments.isEmpty(), (String)"Empty path should return empty list");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesNullPath() {
        List segments = PathUtil.getSegmentsListWithDecoding(null);
        Assertions.assertTrue((boolean)segments.isEmpty(), (String)"Null path should return empty list");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesLeadingSlash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"/path%2Fencoded/normal");
        Assertions.assertEquals((int)3, (int)segments.size(), (String)"Should have three segments");
        Assertions.assertEquals((Object)"", segments.get(0), (String)"First segment should be empty");
        Assertions.assertEquals((Object)"path/encoded", segments.get(1), (String)"Second segment should be decoded");
        Assertions.assertEquals((Object)"normal", segments.get(2), (String)"Third segment should be normal");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesTrailingSlash() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"path%2Fencoded/");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"path/encoded", segments.get(0), (String)"Segment should be decoded");
    }

    @Test
    public void getSegmentsListWithDecoding_handlesUtf8Characters() {
        List segments = PathUtil.getSegmentsListWithDecoding((String)"hello%C3%A4%C3%B6%C3%BC");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"hello\u00e4\u00f6\u00fc", segments.get(0), (String)"Should decode UTF-8 characters");
    }

    @Test
    public void getSegmentsList_doesNotDecode() {
        List segments = PathUtil.getSegmentsList((String)"path%2Fwith%2Fslashes");
        Assertions.assertEquals((int)1, (int)segments.size(), (String)"Should have one segment");
        Assertions.assertEquals((Object)"path%2Fwith%2Fslashes", segments.get(0), (String)"Should NOT decode %2F");
    }
}

