/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.AccessDeniedException;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAccessDeniedError;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.router.RoutingTestBase;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.RouteModelTest;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class RouterTest
extends RoutingTestBase {
    private static final String DYNAMIC_TITLE = "I am dynamic!";
    public static final String EXCEPTION_WRAPPER_MESSAGE = "There was an exception while trying to navigate to '%s' with the exception message '%s'";
    private UI ui;
    private VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
    private DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
    public static final String EXCEPTION_TEXT = "My custom not found class!";

    @Override
    @BeforeEach
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        super.init();
        this.ui = new RoutingTestBase.RouterTestMockUI(this.router);
        this.ui.getSession().lock();
        VaadinService.setCurrent((VaadinService)this.service);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)this.service.getRouter()).thenReturn((Object)this.router);
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)true);
    }

    @AfterEach
    public void tearDown() {
        CurrentInstance.clearAll();
        ForwardWithQueryParams.clear();
        RerouteWithQueryParams.clear();
    }

    @Test
    public void basic_navigation() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RootNavigationTarget.class, FooNavigationTarget.class, FooBarNavigationTarget.class);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(RootNavigationTarget.class, this.getUIComponentClass());
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(FooNavigationTarget.class, this.getUIComponentClass());
        this.router.navigate(this.ui, new Location("foo/bar"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(FooBarNavigationTarget.class, this.getUIComponentClass());
    }

    @Test
    public void resolveNavigation_pathContainsDots_dotSegmentIsNotParentReference_noException() {
        this.router.resolveNavigationTarget("/.../dsfsdfsdf", Collections.emptyMap());
    }

    @Test
    public void resolveNavigation_pathContainsDots_pathIsRelative_noException() {
        Assertions.assertThrows(InvalidLocationException.class, () -> this.router.resolveNavigationTarget("/../dsfsdfsdf", Collections.emptyMap()));
    }

    @Test
    public void page_title_set_from_annotation() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NavigationTargetWithTitle.class);
        this.router.navigate(this.ui, new Location("navigation-target-with-title"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"Custom Title", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void page_title_not_set_from_annotation_in_parent() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ChildWithoutTitle.class);
        this.router.navigate(this.ui, new Location("parent-with-title/child"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"", (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void page_title_set_from_dynamic_title_in_parent() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ChildWithoutTitle2.class);
        this.router.navigate(this.ui, new Location("parent-with-dynamic-title/child2"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)DYNAMIC_TITLE, (Object)this.ui.getInternals().getTitle());
    }

    @Test
    public void page_title_set_dynamically() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NavigationTargetWithDynamicTitle.class);
        this.router.navigate(this.ui, new Location("navigation-target-with-dynamic-title"), NavigationTrigger.PROGRAMMATIC);
        MatcherAssert.assertThat((String)"Dynamic title is wrong", (Object)this.ui.getInternals().getTitle(), (Matcher)CoreMatchers.is((Object)DYNAMIC_TITLE));
    }

    @Test
    public void page_title_set_dynamically_from_url_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NavigationTargetWithDynamicTitleFromUrl.class);
        this.router.navigate(this.ui, new Location("url/hello"), NavigationTrigger.PROGRAMMATIC);
        MatcherAssert.assertThat((String)"Dynamic title is wrong", (Object)this.ui.getInternals().getTitle(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test
    public void page_title_set_dynamically_from_event_handler() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NavigationTargetWithDynamicTitleFromNavigation.class);
        this.router.navigate(this.ui, new Location("url"), NavigationTrigger.PROGRAMMATIC);
        MatcherAssert.assertThat((String)"Dynamic title is wrong", (Object)this.ui.getInternals().getTitle(), (Matcher)CoreMatchers.is((Object)"ACTIVATING"));
    }

    @Test
    public void before_navigation_event_is_triggered() throws InvalidRouteConfigurationException {
        FooBarNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, FooNavigationTarget.class, FooBarNavigationTarget.class);
        this.router.navigate(this.ui, new Location("foo/bar"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)FooBarNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeEnterEvent.class, FooBarNavigationTarget.events.get(0).getClass(), (String)"Unexpected event type");
    }

    @Test
    public void leave_and_enter_listeners_only_receive_correct_state() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(LeavingNavigationTarget.class, EnteringNavigationTarget.class, RootNavigationTarget.class);
        this.router.navigate(this.ui, new Location("enteringTarget"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)EnteringNavigationTarget.events.size(), (String)"BeforeEnterObserver should have fired.");
        this.router.navigate(this.ui, new Location("leavingTarget"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)EnteringNavigationTarget.events.size(), (String)"No leave or enter target should have fired.");
        Assertions.assertEquals((int)0, (int)LeavingNavigationTarget.events.size(), (String)"No leave or enter target should have fired.");
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)LeavingNavigationTarget.events.size(), (String)"BeforeLeaveObserver should have fired");
    }

    @Test
    public void leave_navigate_and_enter_listeners_execute_in_correct_order() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(CombinedObserverTarget.class, RootNavigationTarget.class);
        this.router.navigate(this.ui, new Location("combined"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)CombinedObserverTarget.Enter.events.size(), (String)"BeforeEnterObserver should have fired.");
        Assertions.assertEquals((int)1, (int)CombinedObserverTarget.Before.events.size(), (String)"BeforeNavigationObserver should have fired.");
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)CombinedObserverTarget.Leave.events.size(), (String)"BeforeLeaveObserver target should have fired.");
        Assertions.assertEquals((int)2, (int)CombinedObserverTarget.Before.events.size(), (String)"BeforeNavigationObserver target should have fired.");
        Assertions.assertEquals(BeforeLeaveEvent.class, CombinedObserverTarget.Before.events.get(1).getClass(), (String)"LeaveListener got event");
    }

    @Test
    public void before_navigation_event_is_triggered_for_attach_and_detach() throws InvalidRouteConfigurationException {
        FooBarNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, FooNavigationTarget.class, FooBarNavigationTarget.class);
        this.router.navigate(this.ui, new Location("foo/bar"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)FooBarNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeEnterEvent.class, FooBarNavigationTarget.events.get(0).getClass());
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)FooBarNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeLeaveEvent.class, FooBarNavigationTarget.events.get(1).getClass());
    }

    @Test
    public void reroute_on_before_navigation_event() throws InvalidRouteConfigurationException {
        FooBarNavigationTarget.events.clear();
        ReroutingNavigationTarget.events.clear();
        RootNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, ReroutingNavigationTarget.class, FooBarNavigationTarget.class);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("foo", "bar");
        QueryParameters queryParameters = QueryParameters.simple(params);
        this.router.navigate(this.ui, new Location("reroute", queryParameters), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)ReroutingNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((int)1, (int)FooBarNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(FooBarNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals(BeforeEnterEvent.class, ReroutingNavigationTarget.events.get(0).getClass());
        Assertions.assertEquals(BeforeEnterEvent.class, FooBarNavigationTarget.events.get(0).getClass());
        QueryParameters rerouteQueryParameters = FooBarNavigationTarget.events.get(0).getLocation().getQueryParameters();
        Assertions.assertNotNull((Object)rerouteQueryParameters);
        List foo = (List)rerouteQueryParameters.getParameters().get("foo");
        Assertions.assertNotNull((Object)foo);
        Assertions.assertFalse((boolean)foo.isEmpty());
        Assertions.assertEquals(foo.get(0), (Object)"bar");
    }

    @Test
    public void before_and_after_event_fired_in_correct_order() throws InvalidRouteConfigurationException {
        NavigationEvents.events.clear();
        this.setNavigationTargets(NavigationEvents.class);
        this.router.navigate(this.ui, new Location("navigationEvents"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)NavigationEvents.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeEnterEvent.class, NavigationEvents.events.get(0).getClass(), (String)"Before navigation event was wrong.");
        Assertions.assertEquals(AfterNavigationEvent.class, NavigationEvents.events.get(1).getClass(), (String)"After navigation event was wrong.");
    }

    @Test
    public void after_event_not_fired_on_detach() throws InvalidRouteConfigurationException {
        NavigationEvents.events.clear();
        this.setNavigationTargets(NavigationEvents.class, FooNavigationTarget.class);
        this.router.navigate(this.ui, new Location("navigationEvents"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)NavigationEvents.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeEnterEvent.class, NavigationEvents.events.get(0).getClass(), (String)"Before navigation event was wrong.");
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)3, (int)NavigationEvents.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals(BeforeLeaveEvent.class, NavigationEvents.events.get(2).getClass(), (String)"After navigation event was wrong.");
    }

    @Test
    public void reroute_with_url_parameter() throws InvalidRouteConfigurationException {
        RouteWithParameter.events.clear();
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithParameter.class, RerouteToRouteWithParam.class);
        this.router.navigate(this.ui, new Location("redirect/to/param"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)RouteWithParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"hello", (Object)RouteWithParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void reroute_with_url_parameter_in_url() throws InvalidRouteConfigurationException {
        RouteWithParameter.events.clear();
        RedirectToRouteWithParamInUrl.forward = false;
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithParameter.class, RedirectToRouteWithParamInUrl.class);
        this.router.navigate(this.ui, new Location("redirect/to/param"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)RouteWithParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"hello", (Object)RouteWithParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void forward_with_url_parameter_in_url() throws InvalidRouteConfigurationException {
        RouteWithParameter.events.clear();
        RedirectToRouteWithParamInUrl.forward = true;
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithParameter.class, RedirectToRouteWithParamInUrl.class);
        this.router.navigate(this.ui, new Location("redirect/to/param"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)RouteWithParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"hello", (Object)RouteWithParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void reroute_fails_with_no_url_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, ParameterRouteNoParameter.class, RerouteToRouteWithParam.class);
        String locationString = "redirect/to/param";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Routing with mismatching parameters should have failed -");
        String message = "No route 'param' accepting the parameters [hello] was found.";
        String exceptionText = String.format(EXCEPTION_WRAPPER_MESSAGE, locationString, message);
        this.assertExceptionComponent(exceptionText);
    }

    @Test
    public void reroute_fails_with_faulty_url_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithParameter.class, FailRerouteWithParam.class);
        String locationString = "fail/param";
        this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        String message = "Given route parameter 'class java.lang.Boolean' is of the wrong type. Required 'class java.lang.String'.";
        String exceptionText = String.format(EXCEPTION_WRAPPER_MESSAGE, locationString, message);
        this.assertExceptionComponent(exceptionText);
    }

    @Test
    public void reroute_with_multiple_route_parameters() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithMultipleParameters.class, RerouteToRouteWithMultipleParams.class);
        this.router.navigate(this.ui, new Location("redirect/to/params"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)RouteWithMultipleParameters.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"this/must/work", (Object)RouteWithMultipleParameters.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void reroute_fails_with_faulty_route_parameters() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithMultipleParameters.class, FailRerouteWithParams.class);
        String locationString = "fail/params";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Routing with mismatching parameters should have failed -");
        String message = "Given route parameter 'class java.lang.Long' is of the wrong type. Required 'class java.lang.String'.";
        String exceptionText = String.format(EXCEPTION_WRAPPER_MESSAGE, locationString, message);
        this.assertExceptionComponent(exceptionText);
    }

    @Test
    public void reroute_with_multiple_route_parameters_fails_to_parameterless_target() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, ParameterRouteNoParameter.class, RerouteToRouteWithMultipleParams.class);
        String locationString = "redirect/to/params";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Routing with mismatching parameters should have failed -");
        String message = "No route 'param' accepting the parameters [this, must, work] was found.";
        String exceptionText = String.format(EXCEPTION_WRAPPER_MESSAGE, locationString, message);
        this.assertExceptionComponent(exceptionText);
    }

    @Test
    public void reroute_with_multiple_route_parameters_fails_to_single_parameter_target() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RouteWithParameter.class, RerouteToRouteWithMultipleParams.class);
        String locationString = "redirect/to/params";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Routing with mismatching parameters should have failed -");
        String message = "No route 'param' accepting the parameters [this, must, work] was found.";
        String exceptionText = String.format(EXCEPTION_WRAPPER_MESSAGE, locationString, message);
        this.assertExceptionComponent(exceptionText);
    }

    @Test
    public void route_precedence_when_one_has_parameter() throws InvalidRouteConfigurationException {
        RouteWithParameter.events.clear();
        this.setNavigationTargets(RouteWithParameter.class, StaticParameter.class);
        this.router.navigate(this.ui, new Location("param/param"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(RouteWithParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((int)2, (int)RouteWithParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"param", (Object)RouteWithParameter.param, (String)"Before navigation event was wrong.");
        this.router.navigate(this.ui, new Location("param/static"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(StaticParameter.class, this.getUIComponentClass(), (String)"Did not get correct class even though StaticParameter should have precedence over RouteWithParameter due to exact url match.");
    }

    @Test
    public void optional_parameter_gets_parameter() throws InvalidRouteConfigurationException {
        OptionalParameter.events.clear();
        this.setNavigationTargets(OptionalParameter.class);
        this.router.navigate(this.ui, new Location("optional/parameter"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)OptionalParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"parameter", (Object)OptionalParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void optional_parameter_matches_no_parameter() throws InvalidRouteConfigurationException {
        OptionalParameter.events.clear();
        OptionalParameter.param = null;
        this.setNavigationTargets(OptionalParameter.class);
        this.router.navigate(this.ui, new Location("optional"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)OptionalParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertNull((Object)OptionalParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void correctly_return_route_with_one_base_route_with_optionals() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteWithParameter.class, ParameterRouteNoParameter.class);
        this.router.navigate(this.ui, new Location("param/parameter"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(RouteWithParameter.class, this.getUIComponentClass(), (String)"Failed");
    }

    @Test
    public void base_route_and_optional_parameter_throws_configuration_error() throws InvalidRouteConfigurationException {
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.setNavigationTargets(OptionalParameter.class, OptionalNoParameter.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", OptionalNoParameter.class.getName(), OptionalParameter.class.getName(), OptionalParameter.class.getName())));
    }

    @Test
    public void navigateToRoot_errorCode_dontRedirect() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(FooNavigationTarget.class);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC));
    }

    @Test
    public void navigating_to_route_with_wildcard_parameter() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"", (Object)WildParameter.param, (String)"Parameter should be empty");
        this.router.navigate(this.ui, new Location("wild/single"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"single", (Object)WildParameter.param, (String)"Parameter should be empty");
        this.router.navigate(this.ui, new Location("wild/multi/part/parameter"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)3, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"multi/part/parameter", (Object)WildParameter.param, (String)"Parameter should be empty");
    }

    @Test
    public void route_with_wildcard_parameter_should_be_last_hit() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class, WildHasParameter.class, WildNormal.class);
        this.router.navigate(this.ui, new Location("wild"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)0, (int)WildHasParameter.events.size(), (String)"Expected event amount was wrong");
        this.router.navigate(this.ui, new Location("wild/parameter"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)WildHasParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"parameter", (Object)WildHasParameter.param, (String)"Parameter didn't match expected value");
        this.router.navigate(this.ui, new Location("wild/multi/part/parameter"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"multi/part/parameter", (Object)WildParameter.param, (String)"Parameter didn't match expected value");
    }

    @Test
    public void wildcard_parameter_with_encoded_slashes() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild/path%2Fwith%2Fslashes"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"path/with/slashes", (Object)WildParameter.param, (String)"Encoded slashes should be decoded and preserved in parameter");
    }

    @Test
    public void wildcard_parameter_with_encoded_special_characters() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild/test%3Fquestion"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"test?question", (Object)WildParameter.param, (String)"Should decode %3F to ?");
        this.router.navigate(this.ui, new Location("wild/value%26data"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"value&data", (Object)WildParameter.param, (String)"Should decode %26 to &");
        this.router.navigate(this.ui, new Location("wild/hello%20world"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"hello world", (Object)WildParameter.param, (String)"Should decode %20 to space");
    }

    @Test
    public void wildcard_parameter_with_mixed_encoded_segments() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild/path%2Fencoded/normal/another%2Fone"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)WildParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"path/encoded/normal/another/one", (Object)WildParameter.param, (String)"Should decode individual segments but preserve literal slashes");
    }

    @Test
    public void wildcard_parameter_encoded_vs_literal_slashes() throws InvalidRouteConfigurationException {
        WildParameter.events.clear();
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild/a/b/c"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"a/b/c", (Object)WildParameter.param, (String)"Literal slashes create path structure");
        this.router.navigate(this.ui, new Location("wild/a%2Fb%2Fc"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)"a/b/c", (Object)WildParameter.param, (String)"Encoded slashes should be decoded but not split segments");
    }

    @Test
    public void root_navigation_target_with_required_parameter() throws InvalidRouteConfigurationException {
        RootParameter.events.clear();
        this.setNavigationTargets(RootParameter.class);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)0, (int)RootParameter.events.size(), (String)"Has url with required parameter should not match to \"\"");
    }

    @Test
    public void reroute_on_hasParameter_step() throws InvalidRouteConfigurationException {
        RootParameter.events.clear();
        this.setNavigationTargets(RootParameter.class, RedirectOnSetParam.class);
        this.router.navigate(this.ui, new Location("param/reroute/hello"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)RootParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)"hello", (Object)RootParameter.param, (String)"Parameter should match the one in url");
    }

    @Test
    public void has_url_with_supported_parameters_navigation() throws InvalidRouteConfigurationException {
        IntegerParameter.events.clear();
        LongParameter.events.clear();
        BooleanParameter.events.clear();
        this.setNavigationTargets(IntegerParameter.class, LongParameter.class, BooleanParameter.class);
        this.router.navigate(this.ui, new Location("integer/5"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)IntegerParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((int)5, (int)IntegerParameter.param, (String)"Parameter should match the one in url");
        this.router.navigate(this.ui, new Location("long/5"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)LongParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((long)5L, (long)LongParameter.param, (String)"Parameter should match the one in url");
        this.router.navigate(this.ui, new Location("boolean/true"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)BooleanParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)true, (Object)BooleanParameter.param, (String)"Parameter should match the one in url");
    }

    @Test
    public void longParameter_deserialization() throws InvalidRouteConfigurationException {
        LongParameter.events.clear();
        this.setNavigationTargets(LongParameter.class);
        this.router.navigate(this.ui, new Location("long/+9223372036854775807"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)LongParameter.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)LongParameter.param, (String)"Parameter should accept long max with +");
        this.router.navigate(this.ui, new Location("long/-9223372036854775808"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)LongParameter.events.size(), (String)"Expected negative and positive event");
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)LongParameter.param, (String)"Parameter should accept long max with +");
        Assertions.assertEquals((int)404, (int)this.router.navigate(this.ui, new Location("long/9223372036854775817"), NavigationTrigger.PROGRAMMATIC));
        Assertions.assertEquals((int)2, (int)LongParameter.events.size(), (String)"No faulty event recorded");
    }

    @Test
    public void default_wildcard_support_only_for_string() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(UnsupportedWildParameter.class);
        String locationString = "usupported/wildcard/3/4/1";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        String message = String.format("Invalid wildcard parameter in class %s. Only String is supported for wildcard parameters.", UnsupportedWildParameter.class.getName());
        String exceptionText1 = String.format("Could not navigate to '%s'", locationString);
        String exceptionText2 = String.format("Reason: Failed to parse url parameter, exception: %s", new UnsupportedOperationException(message));
        this.assertExceptionComponent(RouteNotFoundError.class, exceptionText1, exceptionText2);
    }

    @Test
    public void unparsable_url_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(LongParameter.class);
        String locationString = "long/unsupportedParam";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        String exceptionText1 = String.format("Could not navigate to '%s'", locationString);
        String exceptionText2 = String.format("Reason: Couldn't find route for '%s'", locationString);
        this.assertExceptionComponent(RouteNotFoundError.class, exceptionText1, exceptionText2);
    }

    @Test
    public void redirect_to_routeNotFound_error_view_when_no_route_found() throws InvalidRouteConfigurationException {
        ErrorTarget.events.clear();
        this.setNavigationTargets(FooNavigationTarget.class);
        this.setErrorNavigationTargets(ErrorTarget.class);
        String locationString = "error";
        int result = this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        Assertions.assertEquals((int)1, (int)ErrorTarget.events.size(), (String)"Expected event amount was wrong");
        String errorMessage = ErrorTarget.message;
        Assertions.assertTrue((boolean)errorMessage.contains(String.format("Could not navigate to '%s'", locationString)));
        Assertions.assertTrue((boolean)errorMessage.contains(String.format("Couldn't find route for '%s'", locationString)));
    }

    @Test
    public void exception_during_navigation_is_caught_and_show_in_internalServerError() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(FailOnException.class);
        int result = this.router.navigate(this.ui, new Location("exception"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Non existent route should have returned.");
    }

    @Test
    public void fail_for_multiple_classes_extending_the_same_exception_class() throws InvalidRouteConfigurationException {
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.setErrorNavigationTargets(ErrorTarget.class, CustomNotFoundTarget.class));
    }

    @Test
    public void pick_custom_from_multiple_error_targets_when_other_is_default_annotated() {
        this.setNavigationTargets(NpeNavigationTarget.class);
        this.setErrorNavigationTargets(DefaultNullPointerException.class, NullPointerExceptionHandler.class);
        int result = this.router.navigate(this.ui, new Location("npe"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Null pointer should return the server error of the custom implementation.");
        Assertions.assertEquals(NullPointerExceptionHandler.class, this.getUIComponentClass(), (String)"Expected the extending class to be used instead of the super class");
    }

    @Test
    public void do_not_accept_same_exception_targets() {
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.setErrorNavigationTargets(NonExtendingNotFoundTarget.class, DuplicateNotFoundTarget.class));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Only one target for an exception should be defined. Found "));
    }

    @Test
    public void custom_exception_target_should_override_default_ones() {
        this.setErrorNavigationTargets(NonExtendingNotFoundTarget.class, RouteNotFoundError.class);
        int result = this.router.navigate(this.ui, new Location("exception"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        Assertions.assertEquals(NonExtendingNotFoundTarget.class, this.getUIComponentClass(), (String)"Expected the extending class to be used instead of the super class");
        this.assertExceptionComponent(NonExtendingNotFoundTarget.class, EXCEPTION_TEXT);
    }

    @Test
    public void custom_access_denied_exception_target_should_override_default_ones() {
        this.setNavigationTargets(FailOnAccessDeniedException.class);
        this.setErrorNavigationTargets(NonExtendingAccessDeniedTarget.class, RouteAccessDeniedError.class);
        int result = this.router.navigate(this.ui, new Location("accessdenied"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.UNAUTHORIZED.getCode(), (int)result, (String)"Unauthorized route should have returned.");
        Assertions.assertEquals(NonExtendingAccessDeniedTarget.class, this.getUIComponentClass(), (String)"Expected the extending class to be used instead of the super class");
        this.assertExceptionComponent(NonExtendingAccessDeniedTarget.class, EXCEPTION_TEXT);
    }

    @Test
    public void custom_exception_target_is_used() {
        this.setErrorNavigationTargets(CustomNotFoundTarget.class, RouteNotFoundError.class);
        int result = this.router.navigate(this.ui, new Location("exception"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        Assertions.assertEquals(CustomNotFoundTarget.class, this.getUIComponentClass(), (String)"Expected the extending class to be used instead of the super class");
        this.assertExceptionComponent(CustomNotFoundTarget.class, EXCEPTION_TEXT);
    }

    @Test
    public void custom_accessdenied_target_is_used() {
        this.setNavigationTargets(FailOnAccessDeniedException.class);
        this.setErrorNavigationTargets(CustomAccessDeniedError.class, RouteAccessDeniedError.class);
        int result = this.router.navigate(this.ui, new Location("accessdenied"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.UNAUTHORIZED.getCode(), (int)result, (String)"Unauthorized route should have returned.");
        Assertions.assertEquals(CustomAccessDeniedError.class, this.getUIComponentClass(), (String)"Expected the extending class to be used instead of the super class");
        this.assertExceptionComponent(CustomAccessDeniedError.class, EXCEPTION_TEXT);
    }

    @Test
    public void error_target_has_parent_layout() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(LoneRoute.class);
        this.setErrorNavigationTargets(ErrorTargetWithParent.class, RouteNotFoundError.class);
        int result = this.router.navigate(this.ui, new Location("exception"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        Component parenComponent = (Component)ComponentUtil.findParentComponent((Element)this.ui.getElement().getChild(0)).get();
        Assertions.assertEquals(RouteParent.class, parenComponent.getClass());
        List childClasses = parenComponent.getChildren().map(Object::getClass).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(RouterLink.class, ErrorTargetWithParent.class), childClasses);
    }

    @Test
    public void reroute_to_error_opens_expected_error_target() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RerouteToError.class);
        this.setErrorNavigationTargets(IllegalTarget.class);
        int result = this.router.navigate(this.ui, new Location("beforeToError/exception"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Target should have rerouted to exception target.");
        Assertions.assertEquals(IllegalTarget.class, this.getUIComponentClass());
        Optional visibleComponent = this.ui.getElement().getChild(0).getComponent();
        Assertions.assertEquals((Object)"Illegal argument exception.", (Object)((Component)visibleComponent.get()).getElement().getText());
    }

    @Test
    public void reroute_to_error_with_custom_message_message_is_used() throws InvalidRouteConfigurationException {
        IllegalTarget.events.clear();
        this.setNavigationTargets(RerouteToErrorWithMessage.class);
        this.setErrorNavigationTargets(IllegalTarget.class);
        int result = this.router.navigate(this.ui, new Location("beforeToError/message/CustomMessage"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Target should have rerouted to exception target.");
        Assertions.assertEquals(IllegalTarget.class, this.getUIComponentClass());
        Optional visibleComponent = this.ui.getElement().getChild(0).getComponent();
        Assertions.assertEquals((Object)"CustomMessage", (Object)((Component)visibleComponent.get()).getElement().getText());
        Assertions.assertEquals((int)1, (int)IllegalTarget.events.size(), (String)"Expected only one event message from error view");
        BeforeEnterEvent event = (BeforeEnterEvent)IllegalTarget.events.get(0);
        Assertions.assertEquals((Object)"beforeToError/message/CustomMessage", (Object)event.getLocation().getPath(), (String)"Parameter should be empty");
    }

    @Test
    public void reroute_to_error_from_has_param() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RedirectToNotFoundInHasParam.class);
        int result = this.router.navigate(this.ui, new Location("toNotFound/error"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Target should have rerouted to exception target.");
        Assertions.assertEquals(RouteNotFoundError.class, this.getUIComponentClass());
    }

    @Test
    public void rerouteToDefaultAccessDeniedHandler_rerouteToNotFoundPreservingMessage() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RedirectToAccessDenied.class);
        int result = this.router.navigate(this.ui, new Location("toAccessDenied"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Target should have rerouted to not found target.");
        Assertions.assertEquals(RouteNotFoundError.class, this.getUIComponentClass());
        this.assertExceptionComponent(RouteNotFoundError.class, "You are not allowed");
    }

    @Test
    public void forward_and_reroute_at_the_same_time_exception() throws InvalidRouteConfigurationException {
        String location = "forwardAndReroute/exception";
        FooBarNavigationTarget.events.clear();
        ForwardingAndReroutingNavigationTarget.events.clear();
        RootNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, ForwardingAndReroutingNavigationTarget.class, FooBarNavigationTarget.class);
        this.router.navigate(this.ui, new Location(location), NavigationTrigger.PROGRAMMATIC);
        String validationMessage = "Error forward & reroute can not be set at the same time";
        String errorMessage = String.format(EXCEPTION_WRAPPER_MESSAGE, location, validationMessage);
        this.assertExceptionComponent(InternalServerError.class, errorMessage);
    }

    @Test
    public void faulty_error_response_code_should_throw_exception() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RerouteToError.class);
        this.setErrorNavigationTargets(FaultyErrorView.class);
        String location = "beforeToError/exception";
        int result = this.router.navigate(this.ui, new Location(location), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Target should have failed on an internal exception.");
        String validationMessage = String.format("Error state code must be a valid HttpStatusCode value. Received invalid value of '%s' for '%s'", 0, FaultyErrorView.class.getName());
        String errorMessage = String.format(EXCEPTION_WRAPPER_MESSAGE, location, validationMessage);
        this.assertExceptionComponent(InternalServerError.class, errorMessage);
    }

    @Test
    public void repeatedly_navigating_to_same_ur_through_ui_navigate_should_not_loop() throws InvalidRouteConfigurationException {
        LoopByUINavigate.events.clear();
        this.setNavigationTargets(LoopByUINavigate.class);
        this.ui.navigate("loop");
        Assertions.assertEquals((int)1, (int)LoopByUINavigate.events.size(), (String)"Expected only one request to loop");
        Assertions.assertNull((Object)this.ui.getInternals().getLastHandledLocation(), (String)"Last handled location should have been cleared");
    }

    @Test
    public void ui_navigate_should_only_have_one_history_marking_on_loop() throws InvalidRouteConfigurationException {
        ((MockDeploymentConfiguration)this.ui.getSession().getService().getDeploymentConfiguration()).setReactEnabled(false);
        this.setNavigationTargets(LoopByUINavigate.class);
        this.ui.navigate("loop");
        long historyInvocations = this.ui.getInternals().dumpPendingJavaScriptInvocations().stream().filter(js -> js.getInvocation().getExpression().contains("history.pushState")).count();
        Assertions.assertEquals((long)1L, (long)historyInvocations);
        Assertions.assertNull((Object)this.ui.getInternals().getLastHandledLocation(), (String)"Last handled location should have been cleared");
    }

    @Test
    public void router_navigate_should_not_loop() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(LoopOnRouterNavigate.class);
        this.ui.navigate("loop");
        Assertions.assertEquals((int)1, (int)LoopOnRouterNavigate.events.size(), (String)"Expected only one request");
        Assertions.assertNull((Object)this.ui.getInternals().getLastHandledLocation(), (String)"Last handled location should have been cleared");
    }

    @Test
    public void exception_while_navigating_should_succeed_and_clear_last_handled() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(FailOnException.class);
        this.ui.navigate("exception");
        Assertions.assertNull((Object)this.ui.getInternals().getLastHandledLocation(), (String)"Last handled location should have been cleared");
    }

    @Test
    public void exception_in_exception_handler_while_navigating_should_clear_last_handled() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(FailOnException.class);
        this.setErrorNavigationTargets(FailingErrorHandler.class);
        this.ui.navigate("exception");
        Assertions.assertNull((Object)this.ui.getInternals().getLastHandledLocation(), (String)"Last handled location should have been cleared even though navigation failed");
    }

    @Test
    public void postpone_then_resume_on_before_navigation_event() throws InvalidRouteConfigurationException, InterruptedException {
        RootNavigationTarget.events.clear();
        PostponingAndResumingNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, PostponingAndResumingNavigationTarget.class);
        int status1 = this.router.navigate(this.ui, new Location("postpone"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status1, (String)"First transition failed");
        Assertions.assertEquals(PostponingAndResumingNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals((int)0, (int)PostponingAndResumingNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        int status2 = this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status2, (String)"Second transition failed");
        Assertions.assertEquals(RootNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals((int)1, (int)PostponingAndResumingNavigationTarget.events.size(), (String)"Expected event in the first target amount was wrong");
        Assertions.assertEquals((int)1, (int)RootNavigationTarget.events.size(), (String)"Expected event amount in the last target was wrong");
    }

    @Test
    public void postpone_forever_on_before_navigation_event() throws InvalidRouteConfigurationException {
        RootNavigationTarget.events.clear();
        PostponingAndResumingNavigationTarget.events.clear();
        this.setNavigationTargets(RootNavigationTarget.class, PostponingForeverNavigationTarget.class);
        int status1 = this.router.navigate(this.ui, new Location("postpone"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status1, (String)"First transition failed");
        Assertions.assertEquals(PostponingForeverNavigationTarget.class, this.getUIComponentClass());
        int status2 = this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status2, (String)"Second transition failed");
        Assertions.assertEquals(PostponingForeverNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals((int)1, (int)PostponingForeverNavigationTarget.events.size(), (String)"Expected event amount in the target was wrong");
        Assertions.assertEquals((int)0, (int)RootNavigationTarget.events.size(), (String)"Expected event amount in the root was wrong");
    }

    @Test
    public void postpone_obsoleted_by_new_navigation_transition() throws InvalidRouteConfigurationException, InterruptedException {
        FooBarNavigationTarget.events.clear();
        FooBarNavigationTarget.events.clear();
        this.setNavigationTargets(FooNavigationTarget.class, FooBarNavigationTarget.class, PostponingFirstTimeNavigationTarget.class);
        int status1 = this.router.navigate(this.ui, new Location("postpone"), NavigationTrigger.PROGRAMMATIC);
        int status2 = this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)PostponingFirstTimeNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        BeforeLeaveEvent event = PostponingFirstTimeNavigationTarget.events.get(0);
        int status3 = this.router.navigate(this.ui, new Location("foo/bar"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status1, (String)"First transition failed");
        Assertions.assertEquals(FooBarNavigationTarget.class, this.getUIComponentClass());
        event.postpone().proceed();
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status2, (String)"Second transition failed");
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status3, (String)"Third transition failed");
        Assertions.assertEquals(FooBarNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals((int)2, (int)PostponingFirstTimeNavigationTarget.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((int)1, (int)FooBarNavigationTarget.events.size(), (String)"Expected event amount was wrong");
    }

    @Test
    public void postpone_then_resume_with_multiple_listeners() throws InvalidRouteConfigurationException, InterruptedException {
        this.setNavigationTargets(RootNavigationTarget.class, PostponingAndResumingCompoundNavigationTarget.class);
        int status1 = this.router.navigate(this.ui, new Location("postpone"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status1, (String)"First transition failed");
        Assertions.assertEquals(PostponingAndResumingCompoundNavigationTarget.class, this.getUIComponentClass());
        int status2 = this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.OK.getCode(), (int)status2, (String)"Second transition failed");
        Assertions.assertNotNull((Object)PostponingAndResumingCompoundNavigationTarget.postpone);
        PostponingAndResumingCompoundNavigationTarget.postpone.proceed();
        Assertions.assertEquals(RootNavigationTarget.class, this.getUIComponentClass());
        Assertions.assertEquals((int)1, (int)PostponingAndResumingCompoundNavigationTarget.events.size());
        Assertions.assertEquals((int)2, (int)ChildListener.events.size());
        Assertions.assertEquals(BeforeEnterEvent.class, ChildListener.events.get(0).getClass());
        Assertions.assertEquals(BeforeLeaveEvent.class, ChildListener.events.get(1).getClass());
    }

    @Test
    public void navigation_should_fire_locale_change_observer() throws InvalidRouteConfigurationException {
        Translations.events.clear();
        this.setNavigationTargets(Translations.class);
        this.ui.navigate("");
        Assertions.assertEquals((int)1, (int)Translations.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)Translations.events.get(0).getLocale());
    }

    @Test
    public void away_navigation_should_not_inform_observer() throws InvalidRouteConfigurationException, InterruptedException {
        Translations.events.clear();
        this.setNavigationTargets(FooNavigationTarget.class, Translations.class);
        this.ui.navigate("");
        Assertions.assertEquals((int)1, (int)Translations.events.size(), (String)"Expected event amount was wrong");
        Assertions.assertEquals((Object)Locale.getDefault(), (Object)Translations.events.get(0).getLocale());
        this.ui.navigate("foo");
        Assertions.assertEquals((int)1, (int)Translations.events.size(), (String)"Recorded event amount should have stayed the same");
    }

    @Test
    public void route_as_parent_layout_handles_as_expected() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(BaseLayout.class, SubLayout.class);
        this.ui.navigate("base");
        Assertions.assertEquals(MainLayout.class, this.getUIComponentClass());
        List children = this.ui.getChildren().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals(MainLayout.class, ((Component)children.get(0)).getClass());
        children = ((Component)children.get(0)).getChildren().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals(BaseLayout.class, ((Component)children.get(0)).getClass());
        children = ((Component)children.get(0)).getChildren().collect(Collectors.toList());
        Assertions.assertTrue((boolean)children.isEmpty());
        this.ui.navigate("sub");
        Assertions.assertEquals(MainLayout.class, this.getUIComponentClass());
        children = this.ui.getChildren().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals(MainLayout.class, ((Component)children.get(0)).getClass());
        children = ((Component)children.get(0)).getChildren().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals(BaseLayout.class, ((Component)children.get(0)).getClass());
        children = ((Component)children.get(0)).getChildren().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals(SubLayout.class, ((Component)children.get(0)).getClass());
        children = ((Component)children.get(0)).getChildren().collect(Collectors.toList());
        Assertions.assertTrue((boolean)children.isEmpty());
    }

    @Test
    public void proceedRightAfterPostpone_navigationIsDone() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ProceedRightAfterPospone.class, RootNavigationTarget.class);
        RootNavigationTarget.events.clear();
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)RootNavigationTarget.events.size());
        Assertions.assertEquals(AfterNavigationEvent.class, RootNavigationTarget.events.get(0).getClass());
    }

    @Test
    public void navigateWithinOneParent_oneLeaveEventOneEnterEvent() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteChild.class, LoneRoute.class);
        this.router.navigate(this.ui, new Location("parent/child"), NavigationTrigger.PROGRAMMATIC);
        RouteChild.events.clear();
        this.router.navigate(this.ui, new Location("single"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)RouteChild.events.size());
        Assertions.assertEquals(BeforeLeaveEvent.class, RouteChild.events.get(0).getClass());
        Assertions.assertEquals((int)1, (int)LoneRoute.events.size());
        Assertions.assertEquals(BeforeEnterEvent.class, LoneRoute.events.get(0).getClass());
    }

    @Test
    public void navigateWithinOneParent_oneAfterNavigationEventOneEventOnly() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(AfterNavigationChild.class, AfterNavigationWithinSameParent.class, LoneRoute.class);
        this.router.navigate(this.ui, new Location("parent/after-navigation-child"), NavigationTrigger.PROGRAMMATIC);
        AfterNavigationChild.events.clear();
        this.router.navigate(this.ui, new Location("parent/after-navigation-within-same-parent"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)0, (int)AfterNavigationChild.events.size(), (String)("After navigation event should not be fired for " + AfterNavigationChild.class.getSimpleName()));
        Assertions.assertEquals((int)1, (int)AfterNavigationWithinSameParent.events.size(), (String)("Only one navigation event should be fired for " + AfterNavigationWithinSameParent.class.getSimpleName()));
        Assertions.assertEquals(AfterNavigationEvent.class, AfterNavigationWithinSameParent.events.get(0).getClass(), (String)("The fired event type should be " + AfterNavigationEvent.class.getSimpleName()));
    }

    @Test
    public void manually_registered_listeners_should_fire_for_every_navigation() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RootNavigationTarget.class, FooNavigationTarget.class, FooBarNavigationTarget.class);
        AtomicInteger leaveCount = new AtomicInteger(0);
        AtomicInteger enterCount = new AtomicInteger(0);
        AtomicInteger afterCount = new AtomicInteger(0);
        this.ui.addBeforeLeaveListener((BeforeLeaveListener & Serializable)event -> leaveCount.incrementAndGet());
        this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)event -> enterCount.incrementAndGet());
        this.ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> afterCount.incrementAndGet());
        Assertions.assertEquals((int)0, (int)leaveCount.get(), (String)"No event should have happened due to adding listener.");
        Assertions.assertEquals((int)0, (int)enterCount.get(), (String)"No event should have happened due to adding listener.");
        Assertions.assertEquals((int)0, (int)afterCount.get(), (String)"No event should have happened due to adding listener.");
        this.router.navigate(this.ui, new Location("foo/bar"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)leaveCount.get(), (String)"BeforeLeaveListener should have been invoked.");
        Assertions.assertEquals((int)1, (int)enterCount.get(), (String)"BeforeEnterListener should have been invoked.");
        Assertions.assertEquals((int)1, (int)afterCount.get(), (String)"AfterNavigationListener should have been invoked.");
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)leaveCount.get(), (String)"BeforeLeaveListener should have been invoked.");
        Assertions.assertEquals((int)2, (int)enterCount.get(), (String)"BeforeEnterListener should have been invoked.");
        Assertions.assertEquals((int)2, (int)afterCount.get(), (String)"AfterNavigationListener should have been invoked.");
    }

    @Test
    public void after_navigation_listener_is_only_invoked_once_for_redirect() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ReroutingNavigationTarget.class, FooBarNavigationTarget.class);
        AtomicInteger afterCount = new AtomicInteger(0);
        this.ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> afterCount.incrementAndGet());
        this.router.navigate(this.ui, new Location("reroute"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)1, (int)afterCount.get(), (String)"AfterNavigationListener should have been invoked only after redirect.");
    }

    @Test
    public void before_leave_listener_is_invoked_for_each_redirect() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ReroutingNavigationTarget.class, FooBarNavigationTarget.class);
        AtomicInteger leaveCount = new AtomicInteger(0);
        this.ui.addBeforeLeaveListener((BeforeLeaveListener & Serializable)event -> leaveCount.incrementAndGet());
        this.router.navigate(this.ui, new Location("reroute"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)leaveCount.get(), (String)"BeforeLeaveListener should have been invoked for initial navigation and redirect.");
    }

    @Test
    public void before_enter_listener_is_invoked_for_each_redirect_when_redirecting_on_before_enter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(ReroutingNavigationTarget.class, FooBarNavigationTarget.class);
        AtomicInteger enterCount = new AtomicInteger(0);
        this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)event -> enterCount.incrementAndGet());
        this.router.navigate(this.ui, new Location("reroute"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)enterCount.get(), (String)"BeforeEnterListener should have been invoked for initial navigation and redirect.");
    }

    @Test
    public void before_enter_listener_is_invoked_once_and_before_leave_twice_when_redirecting_on_before_leave() throws InvalidRouteConfigurationException {
        ReroutingOnLeaveNavigationTarget.events.clear();
        this.setNavigationTargets(ReroutingOnLeaveNavigationTarget.class, FooBarNavigationTarget.class, FooNavigationTarget.class);
        this.router.navigate(this.ui, new Location("reroute"), NavigationTrigger.PROGRAMMATIC);
        AtomicInteger leaveCount = new AtomicInteger(0);
        AtomicInteger enterCount = new AtomicInteger(0);
        this.ui.addBeforeLeaveListener((BeforeLeaveListener & Serializable)event -> leaveCount.incrementAndGet());
        this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)event -> enterCount.incrementAndGet());
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)leaveCount.get(), (String)"BeforeLeaveListener should have been invoked for initial navigation and redirect.");
        Assertions.assertEquals((int)1, (int)enterCount.get(), (String)"BeforeEnterListener should have been invoked for initial navigation and redirect.");
    }

    @Test
    public void manual_before_listeners_are_fired_before_observers() throws InvalidRouteConfigurationException {
        ManualNavigationTarget.events.clear();
        this.setNavigationTargets(ManualNavigationTarget.class, FooNavigationTarget.class);
        Registration beforeEnter = this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)event -> ManualNavigationTarget.events.add("Manual event"));
        this.router.navigate(this.ui, new Location("manual"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)ManualNavigationTarget.events.size(), (String)"not enough events");
        Assertions.assertEquals((Object)"Manual event", (Object)ManualNavigationTarget.events.get(0));
        Assertions.assertEquals((Object)"Before enter", (Object)ManualNavigationTarget.events.get(1));
        beforeEnter.remove();
        this.ui.addBeforeLeaveListener((BeforeLeaveListener & Serializable)event -> ManualNavigationTarget.events.add("Manual event"));
        this.router.navigate(this.ui, new Location("foo"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)4, (int)ManualNavigationTarget.events.size(), (String)"not enough events");
        Assertions.assertEquals((Object)"Manual event", (Object)ManualNavigationTarget.events.get(2));
        Assertions.assertEquals((Object)"Before leave", (Object)ManualNavigationTarget.events.get(3));
    }

    @Test
    public void manual_after_listener_is_fired_before_observer() throws InvalidRouteConfigurationException {
        AfterNavigationTarget.events.clear();
        this.setNavigationTargets(AfterNavigationTarget.class);
        this.ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> AfterNavigationTarget.events.add("Manual event"));
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)2, (int)AfterNavigationTarget.events.size(), (String)"not enough events");
        Assertions.assertEquals((Object)"Manual event", (Object)AfterNavigationTarget.events.get(0));
        Assertions.assertEquals((Object)"AfterNavigation Observer", (Object)AfterNavigationTarget.events.get(1));
    }

    @Test
    public void navigating_with_class_gets_correct_component() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RootNavigationTarget.class, FooNavigationTarget.class, FooBarNavigationTarget.class);
        Optional target = this.ui.navigate(RootNavigationTarget.class);
        Assertions.assertEquals((Object)this.getUIComponent(), target.get());
        Assertions.assertEquals(RootNavigationTarget.class, this.getUIComponentClass());
        this.ui.navigate(FooNavigationTarget.class);
        Assertions.assertEquals(FooNavigationTarget.class, this.getUIComponentClass());
        this.ui.navigate(FooBarNavigationTarget.class);
        Assertions.assertEquals(FooBarNavigationTarget.class, this.getUIComponentClass());
    }

    @Test
    public void navigating_with_class_and_parameter_gets_correct_component() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteWithParameter.class, BooleanParameter.class, WildParameter.class, OptionalParameter.class);
        Optional newView = this.ui.navigate(RouteWithParameter.class, (Object)"Parameter");
        Assertions.assertEquals(ComponentUtil.findParentComponent((Element)this.ui.getElement().getChild(0)).get(), newView.get());
        Assertions.assertEquals(RouteWithParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"Parameter", (Object)RouteWithParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(OptionalParameter.class, (Object)"optional");
        Assertions.assertEquals(OptionalParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"optional", (Object)OptionalParameter.param, (String)"Before navigation event was wrong.");
        Optional target = this.ui.navigate(OptionalParameter.class);
        Assertions.assertEquals((Object)this.getUIComponent(), target.get());
        Assertions.assertEquals(OptionalParameter.class, this.getUIComponentClass());
        Assertions.assertEquals(null, (Object)OptionalParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(OptionalParameter.class, (Object)null);
        Assertions.assertEquals(OptionalParameter.class, this.getUIComponentClass());
        Assertions.assertEquals(null, (Object)OptionalParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(BooleanParameter.class, (Object)false);
        Assertions.assertEquals(BooleanParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)false, (Object)BooleanParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(WildParameter.class);
        Assertions.assertEquals(WildParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"", (Object)WildParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(WildParameter.class, (Object)null);
        Assertions.assertEquals(WildParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"", (Object)WildParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(WildParameter.class, (Object)"");
        Assertions.assertEquals(WildParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"", (Object)WildParameter.param, (String)"Before navigation event was wrong.");
        this.ui.navigate(WildParameter.class, (Object)"my/wild/param");
        Assertions.assertEquals(WildParameter.class, this.getUIComponentClass());
        Assertions.assertEquals((Object)"my/wild/param", (Object)WildParameter.param, (String)"Before navigation event was wrong.");
    }

    @Test
    public void exception_event_should_keep_original_trigger() {
        this.setErrorNavigationTargets(FileNotFound.class);
        int result = this.router.navigate(this.ui, new Location("programmatic"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.NOT_FOUND.getCode(), (int)result, (String)"Non existent route should have returned.");
        Assertions.assertEquals((Object)NavigationTrigger.PROGRAMMATIC, (Object)FileNotFound.trigger);
        ObjectNode state = new ObjectMapper().createObjectNode();
        state.put("href", "router_link");
        state.put("scrollPositionX", 0.0);
        state.put("scrollPositionY", 0.0);
        this.router.navigate(this.ui, new Location("router_link"), NavigationTrigger.ROUTER_LINK, (BaseJsonNode)state);
        Assertions.assertEquals((Object)NavigationTrigger.ROUTER_LINK, (Object)FileNotFound.trigger);
        this.router.navigate(this.ui, new Location("history"), NavigationTrigger.HISTORY);
        Assertions.assertEquals((Object)NavigationTrigger.HISTORY, (Object)FileNotFound.trigger);
        this.router.navigate(this.ui, new Location("page_load"), NavigationTrigger.PAGE_LOAD);
        Assertions.assertEquals((Object)NavigationTrigger.PAGE_LOAD, (Object)FileNotFound.trigger);
    }

    private String resolve(Class<?> clazz) {
        return new DefaultRoutePathProvider().getRoutePath(clazz);
    }

    @Test
    public void test_router_resolve() {
        Assertions.assertEquals((Object)"", (Object)this.resolve(Main.class));
        Assertions.assertEquals((Object)"", (Object)this.resolve(MainView.class));
        Assertions.assertEquals((Object)"", (Object)this.resolve(View.class));
        Assertions.assertEquals((Object)"namingconvention", (Object)this.resolve(NamingConvention.class));
        Assertions.assertEquals((Object)"namingconvention", (Object)this.resolve(NamingConventionView.class));
    }

    @Test
    public void basic_naming_based_routes() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NamingConvention.class, Main.class);
        Assertions.assertEquals(Main.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/", Collections.emptyMap()).get()).getNavigationTarget());
        Assertions.assertEquals(NamingConvention.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/namingconvention", Collections.emptyMap()).get()).getNavigationTarget());
    }

    @Test
    public void customRoutePathProvider_naming_based_routes() throws InvalidRouteConfigurationException {
        this.router = new Router((RouteRegistry)new TestRouteRegistry(new RoutePathProvider(this){

            public String getRoutePath(Class<?> navigationTarget) {
                if (navigationTarget.equals(NamingConvention.class)) {
                    return "bar";
                }
                if (navigationTarget.equals(Main.class)) {
                    return "foo";
                }
                return null;
            }
        }));
        this.setNavigationTargets(NamingConvention.class, Main.class);
        Assertions.assertEquals(Main.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/foo", Collections.emptyMap()).get()).getNavigationTarget());
        Assertions.assertEquals(NamingConvention.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/bar", Collections.emptyMap()).get()).getNavigationTarget());
    }

    @Test
    public void basic_naming_based_routes_with_trailing_view() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(NamingConventionView.class, MainView.class);
        Assertions.assertEquals(MainView.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/", Collections.emptyMap()).get()).getNavigationTarget());
        Assertions.assertEquals(NamingConventionView.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/namingconvention", Collections.emptyMap()).get()).getNavigationTarget());
    }

    @Test
    public void test_naming_based_routes_with_name_view() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(View.class);
        Assertions.assertEquals(View.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/", Collections.emptyMap()).get()).getNavigationTarget());
    }

    @Test
    public void customRoutePathProvider_name_view() throws InvalidRouteConfigurationException {
        this.router = new Router((RouteRegistry)new TestRouteRegistry(new RoutePathProvider(this){

            public String getRoutePath(Class<?> navigationTarget) {
                if (navigationTarget.equals(View.class)) {
                    return "foo";
                }
                return null;
            }
        }));
        this.setNavigationTargets(View.class);
        Assertions.assertEquals(View.class, (Object)((NavigationState)this.router.resolveNavigationTarget("/foo", Collections.emptyMap()).get()).getNavigationTarget());
    }

    @Test
    public void alias_has_two_parents_even_if_route_doesnt() {
        RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry()).setAnnotatedRoute(AliasLayout.class);
        List parents = this.router.getRegistry().getNavigationRouteTarget("noParent").getRouteTarget().getParentLayouts();
        Assertions.assertTrue((boolean)parents.isEmpty(), (String)"Main route should have no parents.");
        parents = this.router.getRegistry().getNavigationRouteTarget("twoParents").getRouteTarget().getParentLayouts();
        Assertions.assertEquals((int)2, (int)parents.size(), (String)"Route alias should have two parents");
    }

    @Test
    public void verify_collisions_not_allowed_with_naming_convention() {
        InvalidRouteConfigurationException exception = null;
        try {
            this.setNavigationTargets(NamingConvention.class, NamingConventionView.class);
        }
        catch (InvalidRouteConfigurationException e) {
            exception = e;
        }
        Assertions.assertNotNull((Object)((Object)exception), (String)"Routes with same navigation target should not be allowed");
    }

    @Test
    public void preserve_initial_ui_contents() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(View.class);
        Element specialChild = new Element("div");
        this.ui.getElement().appendChild(new Element[]{specialChild});
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((Object)this.ui.getElement(), (Object)specialChild.getParent());
    }

    @Test
    public void noRemoveLayout_oldContentRetained() {
        this.setNavigationTargets(NoRemoveContent1.class, NoRemoveContent2.class);
        this.ui.navigate(NoRemoveContent1.class);
        NoRemoveLayout layout = (NoRemoveLayout)((Object)this.ui.getChildren().findFirst().get());
        Assertions.assertEquals(Arrays.asList(NoRemoveContent1.class), layout.getChildren().map(Object::getClass).collect(Collectors.toList()));
        this.ui.navigate(NoRemoveContent2.class);
        Assertions.assertEquals(Arrays.asList(NoRemoveContent1.class, NoRemoveContent2.class), layout.getChildren().map(Object::getClass).collect(Collectors.toList()));
    }

    @Test
    public void layout_chain_is_included_in_before_events() {
        this.setNavigationTargets(LoneRoute.class, RouteChildWithParameter.class);
        RouteChildWithParameter.events.clear();
        this.ui.navigate(RouteChildWithParameter.class, (Object)"foobar");
        BeforeEnterEvent beforeEnterEvent = (BeforeEnterEvent)RouteChildWithParameter.events.get(0);
        Assertions.assertEquals((int)1, (int)beforeEnterEvent.getLayouts().size(), (String)"There is not exactly one layout in the layout chain");
        Assertions.assertTrue((boolean)beforeEnterEvent.getLayouts().contains(RouteParent.class), (String)"RouteParent was not included in the layout chain");
        RouteChildWithParameter.events.clear();
        this.ui.navigate(LoneRoute.class);
        BeforeLeaveEvent beforeLeaveEvent = (BeforeLeaveEvent)RouteChildWithParameter.events.get(0);
        Assertions.assertEquals((int)1, (int)beforeLeaveEvent.getLayouts().size(), (String)"There is not exactly one layout in the layout chain");
        Assertions.assertTrue((boolean)beforeLeaveEvent.getLayouts().contains(RouteParent.class), (String)"RouteParent was not included in the layout chain");
    }

    @Test
    public void optional_parameter_non_existing_route() throws InvalidRouteConfigurationException {
        OptionalParameter.events.clear();
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)this.configuration.getFrontendFolder()).thenReturn((Object)new File("front"));
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn((Object)new File("./"));
        Mockito.when((Object)this.configuration.getBuildFolder()).thenReturn((Object)"build");
        this.setNavigationTargets(OptionalParameter.class);
        String locationString = "optional/doesnotExist/parameter";
        this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        String exceptionText1 = String.format("Could not navigate to '%s'", locationString);
        String exceptionText2 = String.format("Couldn't find route for '%s'", locationString);
        String optionalTemplate = HasUrlParameterFormat.getTemplate((String)"optional", OptionalParameter.class);
        String exceptionText3 = "<li>" + optionalTemplate + " (supports optional parameter)</li>";
        this.assertExceptionComponent(RouteNotFoundError.class, exceptionText1, exceptionText2, exceptionText3);
    }

    @Test
    public void without_optional_parameter() throws InvalidRouteConfigurationException {
        OptionalParameter.events.clear();
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        Mockito.when((Object)this.configuration.getFrontendFolder()).thenReturn((Object)new File("front"));
        Mockito.when((Object)this.configuration.getProjectFolder()).thenReturn((Object)new File("./"));
        Mockito.when((Object)this.configuration.getBuildFolder()).thenReturn((Object)"build");
        this.setNavigationTargets(WithoutOptionalParameter.class);
        String locationString = "optional";
        this.router.navigate(this.ui, new Location(locationString), NavigationTrigger.PROGRAMMATIC);
        String exceptionText1 = String.format("Could not navigate to '%s'", locationString);
        String exceptionText2 = String.format("Reason: Couldn't find route for '%s'", locationString);
        String template = HasUrlParameterFormat.getTemplate((String)"optional", WithoutOptionalParameter.class);
        String exceptionText3 = "<li>" + template + " (requires parameter)</li>";
        this.assertExceptionComponent(RouteNotFoundError.class, exceptionText1, exceptionText2, exceptionText3);
    }

    @Test
    public void reroute_and_forward_from_parent_layout() {
        ProcessEventsBase.clear();
        this.setNavigationTargets(SecurityDocument.class, SecurityLogin.class);
        List<String> expectedInitially = Arrays.asList("SecurityParent", "SecurityParent", "SecurityLogin");
        List<String> expected = Arrays.asList("SecurityParent", "SecurityLogin");
        this.router.navigate(this.ui, new Location("security/document"), NavigationTrigger.PROGRAMMATIC);
        this.assertEventOrder(expectedInitially, null, expectedInitially, expected);
        ProcessEventsBase.clear();
        this.router.navigate(this.ui, new Location("security/login"), NavigationTrigger.PROGRAMMATIC);
        this.assertExistingChainEventOrder(expected);
    }

    @Test
    public void event_listeners_are_invoked_starting_with_parent_component() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        this.setNavigationTargets(ProcessEventsFlower.class);
        this.router.navigate(this.ui, new Location("event/flower"), NavigationTrigger.PROGRAMMATIC);
        this.assertInitialChainEventOrder(this.getProcessEventsBranchChainNames("ProcessEventsFlower"));
    }

    @Test
    public void event_listeners_are_invoked_starting_with_parent_component_when_preserved_on_refresh() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        ExtendedClientDetails previousClientDetails = this.ui.getInternals().getExtendedClientDetails();
        ExtendedClientDetails clientDetails = (ExtendedClientDetails)Mockito.mock(ExtendedClientDetails.class);
        this.ui.getInternals().setExtendedClientDetails(clientDetails);
        Mockito.when((Object)clientDetails.getWindowName()).thenReturn((Object)"mock");
        this.setNavigationTargets(ProcessEventsFruit.class);
        this.router.navigate(this.ui, new Location("event/fruit"), NavigationTrigger.PROGRAMMATIC);
        ProcessEventsBase.clear();
        this.router.navigate(this.ui, new Location("event/fruit"), NavigationTrigger.PROGRAMMATIC);
        this.assertExistingChainEventOrder(this.getProcessEventsBranchChainNames("ProcessEventsFruit"));
        this.ui.getInternals().setExtendedClientDetails(previousClientDetails);
    }

    @Test
    public void parent_layouts_are_reused_when_change_url() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        this.setNavigationTargets(ProcessEventsFlower.class, ProcessEventsLeaf.class);
        this.router.navigate(this.ui, new Location("event/flower"), NavigationTrigger.PROGRAMMATIC);
        ProcessEventsBase.clear();
        String parameter = "green";
        this.router.navigate(this.ui, new Location("event/leaf/green"), NavigationTrigger.PROGRAMMATIC);
        this.assertEventOrder(Arrays.asList("ProcessEventsLeaf", "leafChild"), this.getProcessEventsBranchChainNames("ProcessEventsFlower"), this.getProcessEventsBranchChainNames("green", "ProcessEventsLeaf", "leafChild"), this.getProcessEventsBranchChainNames("ProcessEventsLeaf", "leafChild"));
    }

    @Test
    public void components_are_not_created_when_parent_layout_redirects() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        this.setNavigationTargets(ProcessEventsFlower.class, ProcessEventsTwig.class);
        this.router.navigate(this.ui, new Location("event/twig"), NavigationTrigger.PROGRAMMATIC);
        List<String> expectedOnReroute = this.getProcessEventsBranchChainNames("ProcessEventsFlower");
        List<String> expected = Stream.concat(this.getProcessEventsTrunkChainNames("ProcessEventsRotten").stream(), expectedOnReroute.stream()).collect(Collectors.toList());
        this.assertEventOrder(expected, null, expected, expectedOnReroute);
    }

    @Test
    public void url_parameter_is_invoked_right_before_enter_events() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        this.setNavigationTargets(ProcessEventsLeaf.class);
        String parameter = "red";
        this.router.navigate(this.ui, new Location("event/leaf/red"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(this.getProcessEventsBranchChainNames("red", "ProcessEventsLeaf", "leafChild"), ProcessEventsBase.beforeEnter, (String)"BeforeEnter events aren't triggered in correct order");
    }

    @Test
    public void url_parameter_is_invoked_where_before_enter_is_not_observed() throws InvalidRouteConfigurationException {
        ProcessEventsBase.clear();
        this.setNavigationTargets(ProcessEventsNeedle.class);
        String parameter = "green";
        this.router.navigate(this.ui, new Location("event/needle/green"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(this.getProcessEventsBranchChainNames("green", "needleChild"), ProcessEventsBase.beforeEnter, (String)"BeforeEnter events aren't triggered in correct order");
    }

    @Test
    public void navigate_incorrectParameter_shouldNotBeResolved() {
        this.setNavigationTargets(ChainLinkWithParameter.class, TargetWithOptionalParameters.class, TargetWithParameter.class, AnotherTargetWithParameter.class, ChainLinkWithParameterAndTarget.class);
        this.assertRouteParameters("qwe/123/link", null);
        this.assertRouteParameters("link/qwe/123/456", null);
        this.assertRouteParameters("123/link/456/789/target/bar", null);
        this.assertRouteParameters("123/targetLink/456/789/chainLink/987/foo/a/b/c/d/e/f", null);
        this.assertRouteParameters("987/765/targetLink/chainLink/543", null);
    }

    @Test
    public void navigateToChainLinkWithParameter_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ChainLinkWithParameter.class);
        this.assertRouteParameters("qwe/link/123", RouteModelTest.parameters("parentID", "qwe", "chainLinkID", "123"));
    }

    @Test
    public void navigateToTargetWithOptionalParameters_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(TargetWithOptionalParameters.class);
        this.assertRouteParameters("qwe/link/123/456", RouteModelTest.parameters("parentID", "qwe", "chainLinkID", "123", "optional", "456"));
        this.assertRouteParameters("qwe/link/123/456/789", RouteModelTest.parameters("parentID", "qwe", "chainLinkID", "123", "optional", "456", "anotherOptional", "789"));
    }

    @Test
    public void navigateToTargetWithParameter_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(TargetWithParameter.class);
        this.assertRouteParameters("123/link/456/target/789/bar", RouteModelTest.parameters("parentID", "123", "chainLinkID", "456", "targetChainLinkID", "789"));
    }

    @Test
    public void navigateToAnotherTargetWithParameter_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(AnotherTargetWithParameter.class);
        this.assertRouteParameters("123/targetLink/456/chainLink/789/987/foo/a/b/c/d/e/f", RouteModelTest.parameters("parentID", "123", "chainLinkID", "456", "anotherTargetID", "789", "yetAnotherID", "987", "varargsFoo", RouteModelTest.varargs("a", "b", "c", "d", "e", "f")));
        this.assertRouteParameters("abc/targetLink/def/chainLink/ghi/jkl/foo", RouteModelTest.parameters("parentID", "abc", "chainLinkID", "def", "anotherTargetID", "ghi", "yetAnotherID", "jkl"));
        this.assertRouteParameters("012/targetLink/chainLink/345/678/foo/1/2/3/4", RouteModelTest.parameters("parentID", "012", "anotherTargetID", "345", "yetAnotherID", "678", "varargsFoo", RouteModelTest.varargs("1", "2", "3", "4")));
        this.assertRouteParameters("012/targetLink/chainLink/345/678/foo", RouteModelTest.parameters("parentID", "012", "anotherTargetID", "345", "yetAnotherID", "678"));
    }

    @Test
    public void navigateToChainLinkWithParameterAndTarget_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ChainLinkWithParameterAndTarget.class);
        this.assertRouteParameters("987/targetLink/765/chainLink/543", RouteModelTest.parameters("parentID", "987", "chainLinkID", "765", "targetChainLinkID", "543"));
        this.assertRouteParameters("987/targetLink/chainLink/543", RouteModelTest.parameters("parentID", "987", "targetChainLinkID", "543"));
    }

    @Test
    public void navigateToParameterTypesView_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ParameterTypesView.class);
        this.assertRouteParameters("param/types/123", RouteModelTest.parameters("intType", "123"));
        this.assertRouteParameters("param/types/thinking", RouteModelTest.parameters("stringType", "thinking"));
        this.assertRouteParameters("param/types/1/am/thinking/of/U/and/I", RouteModelTest.parameters("intType", "1", "stringType", "am", "varargs", "thinking/of/U/and/I"));
        Assertions.assertEquals(Arrays.asList("thinking", "of", "U", "and", "I"), (Object)RouteParametersBase.parameters.getWildcard("varargs"), (String)"Invalid varargs");
        this.assertRouteParameters("param/types/12345678900/long", RouteModelTest.parameters("intType", "12345678900", "stringType", "long"));
        this.assertRouteParameters("param/types/long/12345678900", null);
        this.assertRouteParameters("param/types/thinking/of/U/and/I", RouteModelTest.parameters("stringType", "thinking", "varargs", "of/U/and/I"));
        this.assertRouteParameters("param/types/I/am/thinking", null);
    }

    @Test
    public void navigateToParametersForumThreadView_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ParametersForumThreadView.class);
        this.assertRouteParameters("forum/thread/123/456", RouteModelTest.parameters("threadID", "123", "messageID", "456"));
        this.assertRouteParameters("forum/thread/123/last", RouteModelTest.parameters("threadID", "123"));
        this.assertRouteParameters("forum/thread/123", RouteModelTest.parameters("threadID", "123"));
        this.assertRouteParameters("forum/thread/123/thread-name", RouteModelTest.parameters("threadID", "123", "something", "thread-name"));
    }

    @Test
    public void navigateToParametersApiView_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ParametersApiView.class);
        this.assertRouteParameters("api", RouteModelTest.parameters(new String[0]));
        this.assertRouteParameters("api/com/vaadin/client/package-summary.html", RouteModelTest.parameters("path", RouteModelTest.varargs("com", "vaadin", "client", "package-summary.html")));
        this.assertRouteParameters("api/framework/com/vaadin/client/package-summary.html", RouteModelTest.parameters("alias", "framework", "path", RouteModelTest.varargs("com", "vaadin", "client", "package-summary.html")));
        this.assertRouteParameters("api/framework/8.9.4/com/vaadin/client/package-summary.html", RouteModelTest.parameters("alias", "framework", "version", "8.9.4", "path", RouteModelTest.varargs("com", "vaadin", "client", "package-summary.html")));
        this.assertRouteParameters("api/com.vaadin/vaadin-all/com/vaadin/client/package-summary.html", RouteModelTest.parameters("groupId", "com.vaadin", "artifactId", "vaadin-all", "path", RouteModelTest.varargs("com", "vaadin", "client", "package-summary.html")));
        this.assertRouteParameters("api/com.vaadin/vaadin-all/8.9.4/com/vaadin/client/package-summary.html", RouteModelTest.parameters("groupId", "com.vaadin", "version", "8.9.4", "artifactId", "vaadin-all", "path", RouteModelTest.varargs("com", "vaadin", "client", "package-summary.html")));
    }

    @Test
    public void navigateToDetailsView_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(DetailsView.class);
        this.assertRouteParameters("directory/component/url-parameter-mapping", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping"));
        this.assertRouteParameters("directory/component/url-parameter-mapping/discussions", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping", "tabIdentifier", "discussions"));
        this.assertRouteParameters("directory/component/url-parameter-mapping/api/org/vaadin/flow/helper/HasAbsoluteUrlParameterMapping.html", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping", "tabIdentifier", "api", "apiPath", RouteModelTest.varargs("org", "vaadin", "flow", "helper", "HasAbsoluteUrlParameterMapping.html")));
        this.assertRouteParameters("directory/component/url-parameter-mapping/1.0.0-alpha7/api/org/vaadin/flow/helper/HasAbsoluteUrlParameterMapping.html", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping", "versionIdentifier", "1.0.0-alpha7", "tabIdentifier", "api", "apiPath", RouteModelTest.varargs("org", "vaadin", "flow", "helper", "HasAbsoluteUrlParameterMapping.html")));
        this.assertRouteParameters("directory/component/url-parameter-mapping/1.0.0-alpha7/discussions", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping", "versionIdentifier", "1.0.0-alpha7", "tabIdentifier", "discussions"));
        this.assertRouteParameters("directory/component/url-parameter-mapping/1.0.0-alpha7", RouteModelTest.parameters("urlIdentifier", "url-parameter-mapping", "versionIdentifier", "1.0.0-alpha7"));
        this.assertRouteParameters("directory/component", null);
    }

    @Test
    public void navigateToParametersRegexView_routeParametersAreExtractedCorrectly() {
        this.setNavigationTargets(ParametersRegexView.class);
        this.assertRouteParameters("param/123", RouteModelTest.parameters("regex", "123"));
        this.assertRouteParameters("param/abc", null);
        this.assertRouteParameters("param/-123", null);
        this.assertRouteParameters("param/123/edit", RouteModelTest.parameters("regex", "123"));
        this.assertRouteParameters("param/abc/edit", null);
        this.assertRouteParameters("param/-123/edit", null);
        this.assertRouteParameters("param", RouteModelTest.parameters(new String[0]));
        this.assertRouteParameters("param/edit", RouteModelTest.parameters(new String[0]));
    }

    @Test
    public void routes_withAlternateOptionalParameter_failToRegister() {
        this.assertFailingRouteConfiguration(SearchView.class);
        this.assertFailingRouteConfiguration(ShowAllView.class, RedirectRouteParametersView.class);
        this.assertFailingRouteConfiguration(RedirectRouteParametersView.class, ShowAllView.class);
    }

    @Test
    public void reroute_withRouteParameters_succeed() {
        this.setNavigationTargets(RedirectRouteParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertRouteParametersRedirect();
    }

    @Test
    public void reroute_withRouteAndQueryParameters_succeed() {
        this.setNavigationTargets(RedirectRouteAndQueryParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertRouteAndQueryParametersRedirect();
    }

    @Test
    public void forward_withRouteParameters_succeed() {
        RedirectRouteParametersView.doForward = true;
        this.setNavigationTargets(RedirectRouteParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertRouteParametersRedirect();
    }

    @Test
    public void forward_withRouteAndQueryParameters_succeed() {
        RedirectRouteParametersView.doForward = true;
        this.setNavigationTargets(RedirectRouteAndQueryParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertRouteAndQueryParametersRedirect();
    }

    @Test
    public void reroute_withWrongRouteParameters_fails() {
        this.setNavigationTargets(RedirectRouteParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertWrongRouteParametersRedirect();
    }

    @Test
    public void forward_withWrongRouteParameters_fails() {
        RedirectRouteParametersView.doForward = true;
        this.setNavigationTargets(RedirectRouteParametersView.class, RedirectToView.class, RedirectWithRouteParametersView.class);
        this.assertWrongRouteParametersRedirect();
    }

    @Test
    public void forward_fromSetParameters_withoutBeforeEnterObserver() {
        ForwardSetParameterView.clear();
        this.setNavigationTargets(ForwardSetParameterView.class, ForwardSetParameterBackView.class);
        this.navigate("forward/setParameter/test");
        Assertions.assertFalse((boolean)ForwardSetParameterView.afterNavigationInvoked, (String)"afterNavigation must not be invoked after forwardTo in setParameter");
        Assertions.assertTrue((boolean)ForwardSetParameterView.backBeforeEnterInvoked, (String)"forwardTo ForwardSetParameterBackView failed");
    }

    @Test
    public void forward_toSameTarget_withDifferentURL() {
        this.setNavigationTargets(ForwardView.class);
        this.navigate("forward");
        Assertions.assertEquals((Object)"forward/default_sub_route", (Object)ForwardView.path);
    }

    @Test
    public void forwardToExternalUrl_preventsViewFromBeingCreated() {
        this.setNavigationTargets(RedirectToExternalUrl.class);
        this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)e -> e.forwardToUrl("https://external/enter"));
        this.navigate("forwardtourl");
        Assertions.assertEquals((int)0, (int)RedirectToExternalUrl.instancesCreated.get());
    }

    @Test
    public void forwardToExternalUrl_forwardsToUrl() {
        String externalForwardUrl = "https://external/enter";
        this.setNavigationTargets(RedirectToExternalUrl.class);
        this.ui.addBeforeEnterListener((BeforeEnterListener & Serializable)e -> e.forwardToUrl(externalForwardUrl));
        this.navigate("forwardtourl");
        long historyInvocations = this.ui.getInternals().dumpPendingJavaScriptInvocations().stream().filter(js -> js.getInvocation().getExpression().contains("window.open") && ((String)js.getInvocation().getParameters().get(0)).contains(externalForwardUrl)).count();
        Assertions.assertEquals((long)1L, (long)historyInvocations);
    }

    @Test
    public void reroute_queryParameters() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(RerouteWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("rerouteWithQueryParams"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(ShowAllView.class, RouteParametersBase.target, (String)("Expected reroute to ShowAll view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)1, (int)RerouteWithQueryParams.events, (String)"Expecting reroute view to be entered once");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("newParam").orElse(null);
        Assertions.assertEquals((Object)"hello", (Object)singleParameter, (String)"Missing parameter after reroute");
    }

    @Test
    public void reroute_queryParameters_sameNavigationTarget() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(RerouteWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("rerouteWithQueryParams?updateQueryParams=true"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(RerouteWithQueryParams.class, RouteParametersBase.target, (String)("Expected reroute to same view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)2, (int)RerouteWithQueryParams.events, (String)"Expecting reroute view to be entered twice");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("newParam").orElse(null);
        Assertions.assertEquals((Object)"hello", (Object)singleParameter, (String)"Missing parameter after reroute");
        Assertions.assertTrue((boolean)RouteParametersBase.queryParameters.getSingleParameter("updateQueryParams").isEmpty(), (String)"Expecting original parameter not be present after reroute");
    }

    @Test
    public void reroute_sameQueryParameters_sameNavigationTarget() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(RerouteWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("rerouteWithQueryParams?updateQueryParams=false"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(RerouteWithQueryParams.class, RouteParametersBase.target, (String)("Expected reroute to same view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)1, (int)RerouteWithQueryParams.events, (String)"Expecting reroute view to be entered once");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("updateQueryParams").orElse(null);
        Assertions.assertEquals((Object)"false", (Object)singleParameter, (String)"Expecting original parameter after reroute");
        Assertions.assertTrue((boolean)RouteParametersBase.queryParameters.getSingleParameter("newParam").isEmpty(), (String)"Expecting new parameter not to be present after reroute");
    }

    @Test
    public void forward_queryParameters() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(ForwardWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("forwardWithQueryParams"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(ShowAllView.class, RouteParametersBase.target, (String)("Expected forward to ShowAll view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)1, (int)ForwardWithQueryParams.events, (String)"Expecting forward view to be entered once");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("newParam").orElse(null);
        Assertions.assertEquals((Object)"hello", (Object)singleParameter, (String)"Missing query parameter after forward");
    }

    @Test
    public void forward_queryParameters_sameNavigationTarget() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(ForwardWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("forwardWithQueryParams?updateQueryParams=true"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(ForwardWithQueryParams.class, RouteParametersBase.target, (String)("Expected forward to same view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)2, (int)ForwardWithQueryParams.events, (String)"Expecting forward view to be entered twice");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("newParam").orElse(null);
        Assertions.assertEquals((Object)"hello", (Object)singleParameter, (String)"Missing query parameter after forward");
        Assertions.assertTrue((boolean)RouteParametersBase.queryParameters.getSingleParameter("updateQueryParams").isEmpty(), (String)"Expecting original parameter not be present after forward");
    }

    @Test
    public void forward_sameQueryParameters_sameNavigationTarget() throws InvalidRouteConfigurationException {
        RouteParametersBase.clear();
        this.setNavigationTargets(ForwardWithQueryParams.class, ShowAllView.class);
        this.router.navigate(this.ui, new Location("forwardWithQueryParams?updateQueryParams=false"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals(ForwardWithQueryParams.class, RouteParametersBase.target, (String)("Expected forward to same view but was " + String.valueOf(RouteParametersBase.target)));
        Assertions.assertEquals((int)1, (int)ForwardWithQueryParams.events, (String)"Expecting forward view to be entered once");
        String singleParameter = RouteParametersBase.queryParameters.getSingleParameter("updateQueryParams").orElse(null);
        Assertions.assertEquals((Object)"false", (Object)singleParameter, (String)"Missing original query parameter after forward");
        Assertions.assertTrue((boolean)RouteParametersBase.queryParameters.getSingleParameter("newParam").isEmpty(), (String)"Expecting new parameter not be present after forward");
    }

    @Test
    public void after_navigation_event_has_route_parameters() {
        RouteParametersBase.clear();
        this.setNavigationTargets(ParametersForumThreadView.class);
        this.assertRouteParameters("forum/thread/123/456", RouteModelTest.parameters("threadID", "123", "messageID", "456"), null, () -> RouteParametersBase.afterNavigationRouteParameters);
    }

    private void assertWrongRouteParametersRedirect() {
        this.assertRouteParameters("show/wrong", null, null);
    }

    private void assertRouteParametersRedirect() {
        this.assertRouteParameters("show/all", RouteModelTest.parameters(new String[0]), RedirectToView.class);
        this.assertRouteParameters("show/some", RouteModelTest.parameters("text", "some"), RedirectWithRouteParametersView.class);
        this.assertRouteParameters("show", RouteModelTest.parameters(new String[0]), RedirectRouteParametersView.class);
        this.assertRouteParameters("show/original", RouteModelTest.parameters("filter", "original"), RedirectRouteParametersView.class);
    }

    private void assertRouteAndQueryParametersRedirect() {
        QueryParameters queryParameters = QueryParameters.simple(Map.of("qp1", "value"));
        this.assertRouteAndQueryParameters("show/all", RouteModelTest.parameters(new String[0]), RedirectToView.class, queryParameters);
        this.assertRouteAndQueryParameters("show/some", RouteModelTest.parameters("text", "some"), RedirectWithRouteParametersView.class, queryParameters);
        this.assertRouteAndQueryParameters("show", RouteModelTest.parameters(new String[0]), RedirectRouteAndQueryParametersView.class, QueryParameters.empty());
        this.assertRouteAndQueryParameters("show/original", RouteModelTest.parameters("filter", "original"), RedirectRouteAndQueryParametersView.class, QueryParameters.empty());
    }

    private void assertFailingRouteConfiguration(Class<? extends Component> ... navigationTargets) {
        try {
            this.setNavigationTargets(navigationTargets);
            Assertions.fail((String)"Route configuration should fail");
        }
        catch (InvalidRouteConfigurationException invalidRouteConfigurationException) {
            // empty catch block
        }
    }

    private void assertRouteParameters(String url, RouteParameters parameters) {
        this.assertRouteParameters(url, parameters, null);
    }

    private void assertRouteParameters(String url, RouteParameters parameters, Class<? extends Component> target) {
        this.assertRouteParameters(url, parameters, target, () -> RouteParametersBase.parameters);
    }

    private void assertRouteParameters(String url, RouteParameters parameters, Class<? extends Component> target, Supplier<RouteParameters> expectedRouteParameters) {
        RouteParametersBase.clear();
        this.navigate(url);
        Assertions.assertEquals((Object)parameters, (Object)expectedRouteParameters.get(), (String)"Incorrect parameters");
        if (target != null) {
            Assertions.assertEquals(target, RouteParametersBase.target, (String)"Incorrect target");
        }
    }

    private void assertRouteAndQueryParameters(String url, RouteParameters parameters, Class<? extends Component> target, QueryParameters queryParameters) {
        this.assertRouteParameters(url, parameters, target);
        Assertions.assertEquals((Object)queryParameters, (Object)RouteParametersBase.queryParameters, (String)"Incorrect query parameters");
    }

    private List<String> getProcessEventsTrunkChainNames(String ... leaf) {
        ArrayList<String> chainNames = new ArrayList<String>(Arrays.asList("ProcessEventsRoot", "rootChild1", "rootChild11", "rootChild2", "ProcessEventsTrunk"));
        chainNames.addAll(Arrays.asList(leaf));
        return chainNames;
    }

    private List<String> getProcessEventsBranchChainNames(String ... leaf) {
        List<String> chainNames = this.getProcessEventsTrunkChainNames("ProcessEventsBranch", "branchChild1", "branchChild2", "branchChild21");
        chainNames.addAll(Arrays.asList(leaf));
        return chainNames;
    }

    private void assertInitialChainEventOrder(List<String> expected) {
        this.assertEventOrder(expected, null, expected, expected);
    }

    private void assertExistingChainEventOrder(List<String> expected) {
        this.assertEventOrder(null, expected, expected, expected);
    }

    private void assertEventOrder(List<String> expectedInit, List<String> expectedBeforeLeave, List<String> expectedBeforeEnter, List<String> expectedAfterNavigation) {
        if (expectedInit == null) {
            Assertions.assertTrue((boolean)ProcessEventsBase.init.isEmpty(), (String)"There should be no component initialization");
        } else {
            Assertions.assertEquals(expectedInit, ProcessEventsBase.init, (String)"Component initialization is done in incorrect order");
        }
        if (expectedBeforeLeave == null) {
            Assertions.assertTrue((boolean)ProcessEventsBase.beforeLeave.isEmpty(), (String)"There should be no BeforeLeave events triggered");
        } else {
            Assertions.assertEquals(expectedBeforeLeave, ProcessEventsBase.beforeLeave, (String)"BeforeLeave events aren't triggered in correct order");
        }
        Assertions.assertEquals(expectedBeforeEnter, ProcessEventsBase.beforeEnter, (String)"BeforeEnter events aren't triggered in correct order");
        Assertions.assertEquals(expectedAfterNavigation, ProcessEventsBase.afterNavigation, (String)"AfterNavigation events aren't triggered in correct order");
    }

    private void setNavigationTargets(Class<? extends Component> ... navigationTargets) throws InvalidRouteConfigurationException {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry());
        routeConfiguration.update((Command & Serializable)() -> {
            routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(navigationTargets).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        });
    }

    private void setErrorNavigationTargets(Class<? extends Component> ... errorNavigationTargets) {
        ((ApplicationRouteRegistry)this.router.getRegistry()).setErrorNavigationTargets(new HashSet<Class<? extends Component>>(Arrays.asList(errorNavigationTargets)));
    }

    private Class<? extends Component> getUIComponentClass() {
        return this.getUIComponent().getClass();
    }

    private Component getUIComponent() {
        return (Component)ComponentUtil.findParentComponent((Element)this.ui.getElement().getChild(0)).get();
    }

    private void assertExceptionComponent(String exceptionText) {
        this.assertExceptionComponent(InternalServerError.class, exceptionText);
    }

    private void assertExceptionComponent(Class<?> errorClass, String ... exceptionTexts) {
        Optional visibleComponent = this.ui.getElement().getChild(0).getComponent();
        Assertions.assertTrue((boolean)visibleComponent.isPresent(), (String)"No navigation component visible");
        Component routeNotFoundError = (Component)visibleComponent.get();
        Assertions.assertEquals(errorClass, routeNotFoundError.getClass());
        String errorText = this.getErrorText(routeNotFoundError);
        for (String exceptionText : exceptionTexts) {
            Assertions.assertTrue((boolean)errorText.contains(exceptionText), (String)("Expected the error text to contain '" + exceptionText + "', but it is '" + errorText + "'"));
        }
    }

    private String getErrorText(Component routeNotFoundError) {
        if (routeNotFoundError.getClass() == RouteNotFoundError.class) {
            Component errorContent = (Component)routeNotFoundError.getChildren().findFirst().get();
            Assertions.assertEquals(Html.class, errorContent.getClass());
            return ((Html)errorContent).getInnerHtml().toString();
        }
        return routeNotFoundError.getElement().getText();
    }

    private void navigate(String url) {
        this.router.navigate(this.ui, new Location(url), NavigationTrigger.PROGRAMMATIC);
    }

    @Test
    public void exception_in_error_view_parent_layout_afterNavigation_falls_back_to_InternalServerError() throws InvalidRouteConfigurationException {
        ThrowingMainLayout.events.clear();
        this.setNavigationTargets(TriggerErrorView.class);
        this.setErrorNavigationTargets(ErrorViewWithThrowingLayout.class);
        int result = this.router.navigate(this.ui, new Location("error"), NavigationTrigger.PROGRAMMATIC);
        Assertions.assertEquals((int)HttpStatusCode.INTERNAL_SERVER_ERROR.getCode(), (int)result, (String)"Navigation should complete with internal server error status.");
        this.assertExceptionComponent(InternalServerError.class, "There was an exception while trying to navigate to 'error' with the exception message 'Exception in MainLayout afterNavigation'");
        Assertions.assertEquals((int)2, (int)ThrowingMainLayout.events.size(), (String)"MainLayout's afterNavigation should have been called twice");
    }

    @Route(value="forwardWithQueryParams")
    @Tag(value="div")
    public static class ForwardWithQueryParams
    extends RouteParametersBase
    implements BeforeEnterObserver {
        static int events = 0;

        static void clear() {
            RouteParametersBase.clear();
            events = 0;
        }

        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            ++events;
            super.beforeEnter(event);
            QueryParameters queryParameters = event.getLocation().getQueryParameters();
            String updateQueryParams = queryParameters.getSingleParameter("updateQueryParams").orElse(null);
            QueryParameters newParams = QueryParameters.of((String)"newParam", (String)"hello");
            if (queryParameters.getParameters().isEmpty()) {
                event.forwardTo("show", newParams);
            } else if ("true".equals(updateQueryParams)) {
                event.forwardTo("forwardWithQueryParams", newParams);
            } else if ("false".equals(updateQueryParams)) {
                event.forwardTo("forwardWithQueryParams", queryParameters);
            }
        }
    }

    @Route(value="rerouteWithQueryParams")
    @Tag(value="div")
    public static class RerouteWithQueryParams
    extends RouteParametersBase
    implements BeforeEnterObserver {
        static int events = 0;

        static void clear() {
            RouteParametersBase.clear();
            events = 0;
        }

        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            ++events;
            super.beforeEnter(event);
            QueryParameters queryParameters = event.getLocation().getQueryParameters();
            String updateQueryParams = queryParameters.getSingleParameter("updateQueryParams").orElse(null);
            QueryParameters newParams = QueryParameters.of((String)"newParam", (String)"hello");
            if (queryParameters.getParameters().isEmpty()) {
                event.rerouteTo("show", newParams);
            } else if ("true".equals(updateQueryParams)) {
                event.rerouteTo("rerouteWithQueryParams", newParams);
            } else if ("false".equals(updateQueryParams)) {
                event.rerouteTo("rerouteWithQueryParams", queryParameters);
            }
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootNavigationTarget
    extends Component
    implements AfterNavigationObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void afterNavigation(AfterNavigationEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="foo")
    @Tag(value="div")
    public static class FooNavigationTarget
    extends Component {
    }

    @Route(value="foo/bar")
    @Tag(value="div")
    public static class FooBarNavigationTarget
    extends Component
    implements BeforeEnterObserver,
    BeforeLeaveObserver {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((BeforeEvent)event);
        }
    }

    @Route(value="navigation-target-with-title")
    @PageTitle(value="Custom Title")
    @Tag(value="div")
    public static class NavigationTargetWithTitle
    extends Component {
    }

    @Route(value="child", layout=ParentWithTitle.class)
    @Tag(value="div")
    public static class ChildWithoutTitle
    extends Component {
    }

    @Route(value="child2", layout=ParentWithDynamicTitle.class)
    @Tag(value="div")
    public static class ChildWithoutTitle2
    extends Component {
    }

    @Route(value="navigation-target-with-dynamic-title")
    @Tag(value="div")
    public static class NavigationTargetWithDynamicTitle
    extends Component
    implements HasDynamicTitle {
        public String getPageTitle() {
            return RouterTest.DYNAMIC_TITLE;
        }
    }

    @Route(value="url")
    @Tag(value="div")
    public static class NavigationTargetWithDynamicTitleFromUrl
    extends Component
    implements HasDynamicTitle,
    HasUrlParameter<String> {
        private String title = "I am dynamic!";

        public String getPageTitle() {
            return this.title;
        }

        public void setParameter(BeforeEvent event, @com.vaadin.flow.router.OptionalParameter String parameter) {
            this.title = parameter;
        }
    }

    @Route(value="url")
    @Tag(value="div")
    public static class NavigationTargetWithDynamicTitleFromNavigation
    extends Component
    implements HasDynamicTitle,
    BeforeEnterObserver {
        private String title = "I am dynamic!";

        public String getPageTitle() {
            return this.title;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            this.title = "ACTIVATING";
        }
    }

    @Route(value="leavingTarget")
    @Tag(value="div")
    public static class LeavingNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((BeforeEvent)event);
        }
    }

    @Route(value="enteringTarget")
    @Tag(value="div")
    public static class EnteringNavigationTarget
    extends Component
    implements BeforeEnterObserver {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }
    }

    @Route(value="combined")
    @Tag(value="div")
    public static class CombinedObserverTarget
    extends Component {
        public CombinedObserverTarget() {
            this.getElement().appendChild(new Element[]{new Enter().getElement(), new Leave().getElement(), new Before().getElement()});
        }

        @Tag(value="div")
        public static class Enter
        extends Component
        implements BeforeEnterObserver {
            private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

            public void beforeEnter(BeforeEnterEvent event) {
                events.add((BeforeEvent)event);
            }
        }

        @Tag(value="div")
        public static class Leave
        extends Component
        implements BeforeLeaveObserver {
            private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

            public void beforeLeave(BeforeLeaveEvent event) {
                events.add((BeforeEvent)event);
            }
        }

        @Tag(value="div")
        public static class Before
        extends Component
        implements BeforeEnterObserver,
        BeforeLeaveObserver {
            private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

            public void beforeEnter(BeforeEnterEvent event) {
                events.add((BeforeEvent)event);
            }

            public void beforeLeave(BeforeLeaveEvent event) {
                events.add((BeforeEvent)event);
            }
        }
    }

    @Route(value="reroute")
    @Tag(value="div")
    public static class ReroutingNavigationTarget
    extends Component
    implements BeforeEnterObserver {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
            event.rerouteTo(new NavigationStateBuilder(event.getSource()).withTarget(FooBarNavigationTarget.class).build());
        }
    }

    @Route(value="navigationEvents")
    @Tag(value="div")
    public static class NavigationEvents
    extends Component {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public NavigationEvents() {
            this.getElement().appendChild(new Element[]{new AfterNavigation().getElement()});
            this.getElement().appendChild(new Element[]{new BeforeNavigation().getElement()});
        }
    }

    @Route(value="param")
    @Tag(value="div")
    public static class RouteWithParameter
    extends Component
    implements BeforeEnterObserver,
    HasUrlParameter<String> {
        private static String param;
        private static List<BeforeEvent> events;

        public void setParameter(BeforeEvent event, String parameter) {
            events.add(event);
            param = parameter;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }

        static {
            events = new ArrayList<BeforeEvent>();
        }
    }

    @Route(value="redirect/to/param")
    @Tag(value="div")
    public static class RerouteToRouteWithParam
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteTo("param", (Object)"hello");
        }
    }

    @Route(value="redirect/to/param")
    @Tag(value="div")
    public static class RedirectToRouteWithParamInUrl
    extends Component
    implements BeforeEnterObserver {
        static boolean forward;

        public void beforeEnter(BeforeEnterEvent event) {
            if (forward) {
                event.forwardTo("param/hello");
            } else {
                event.rerouteTo("param/hello");
            }
        }
    }

    @Route(value="param")
    @Tag(value="div")
    public static class ParameterRouteNoParameter
    extends Component {
    }

    @Route(value="fail/param")
    @Tag(value="div")
    public static class FailRerouteWithParam
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteTo("param", (Object)Boolean.TRUE);
        }
    }

    @Route(value="param")
    @Tag(value="div")
    public static class RouteWithMultipleParameters
    extends Component
    implements BeforeEnterObserver,
    HasUrlParameter<String> {
        private static String param;
        private static List<BeforeEvent> events;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add(event);
            param = parameter;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }

        static {
            events = new ArrayList<BeforeEvent>();
        }
    }

    @Route(value="redirect/to/params")
    @Tag(value="div")
    public static class RerouteToRouteWithMultipleParams
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteTo("param", Arrays.asList("this", "must", "work"));
        }
    }

    @Route(value="fail/params")
    @Tag(value="div")
    public static class FailRerouteWithParams
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteTo("param", Arrays.asList(1L, 2L));
        }
    }

    @Route(value="param/static")
    @Tag(value="div")
    public static class StaticParameter
    extends Component {
    }

    @Route(value="optional")
    @Tag(value="div")
    public static class OptionalParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, @com.vaadin.flow.router.OptionalParameter String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="optional")
    @Tag(value="div")
    public static class OptionalNoParameter
    extends Component {
    }

    @Route(value="wild")
    @Tag(value="div")
    public static class WildParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="wild")
    @Tag(value="div")
    public static class WildHasParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="wild")
    @Tag(value="div")
    public static class WildNormal
    extends Component {
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String param;

        public void setParameter(BeforeEvent event, String parameter) {
            events.add((EventObject)event);
            param = parameter;
        }
    }

    @Route(value="param/reroute")
    @Tag(value="div")
    public static class RedirectOnSetParam
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
            event.rerouteTo("", (Object)parameter);
        }
    }

    @Route(value="integer")
    @Tag(value="div")
    public static class IntegerParameter
    extends Component
    implements HasUrlParameter<Integer> {
        protected static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Integer param;

        public void setParameter(BeforeEvent event, Integer parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="long")
    @Tag(value="div")
    public static class LongParameter
    extends Component
    implements HasUrlParameter<Long> {
        protected static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Long param;

        public void setParameter(BeforeEvent event, Long parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="boolean")
    @Tag(value="div")
    public static class BooleanParameter
    extends Component
    implements HasUrlParameter<Boolean> {
        protected static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Boolean param;

        public void setParameter(BeforeEvent event, Boolean parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="usupported/wildcard")
    @Tag(value="div")
    public static class UnsupportedWildParameter
    extends Component
    implements HasUrlParameter<Integer> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Integer param;

        public void setParameter(BeforeEvent event, @WildcardParameter Integer parameter) {
            events.add(event);
            param = parameter;
        }
    }

    public static class ErrorTarget
    extends RouteNotFoundError
    implements BeforeEnterObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String message;

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
            message = ((Html)this.getChildren().findFirst().get()).getInnerHtml();
        }
    }

    @Route(value="exception")
    @Tag(value="div")
    public static class FailOnException
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            throw new RuntimeException("Failed on an exception");
        }
    }

    @Route(value="npe")
    @Tag(value="div")
    public static class NpeNavigationTarget
    extends Component {
        public NpeNavigationTarget() {
            throw new NullPointerException("Null was found");
        }
    }

    @Tag(value="div")
    @DefaultErrorHandler
    public static class DefaultNullPointerException
    extends Component
    implements HasErrorParameter<NullPointerException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NullPointerException> parameter) {
            return HttpStatusCode.UNAUTHORIZED.getCode();
        }
    }

    @Tag(value="div")
    public static class NullPointerExceptionHandler
    extends Component
    implements HasErrorParameter<NullPointerException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NullPointerException> parameter) {
            return HttpStatusCode.INTERNAL_SERVER_ERROR.getCode();
        }
    }

    @Tag(value="div")
    public static class NonExtendingNotFoundTarget
    extends Component
    implements HasErrorParameter<NotFoundException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.NOT_FOUND.getCode();
        }
    }

    @Route(value="accessdenied")
    @Tag(value="div")
    public static class FailOnAccessDeniedException
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            throw new AccessDeniedException();
        }
    }

    @Tag(value="div")
    public static class NonExtendingAccessDeniedTarget
    extends Component
    implements HasErrorParameter<AccessDeniedException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<AccessDeniedException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.UNAUTHORIZED.getCode();
        }
    }

    public static class CustomNotFoundTarget
    extends RouteNotFoundError {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.NOT_FOUND.getCode();
        }
    }

    public static class CustomAccessDeniedError
    extends RouteAccessDeniedError {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<AccessDeniedException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.UNAUTHORIZED.getCode();
        }
    }

    @Route(value="single", layout=RouteParent.class, absolute=true)
    @Tag(value="div")
    public static class LoneRoute
    extends Component
    implements BeforeEnterObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }
    }

    @Tag(value="div")
    @ParentLayout(value=RouteParent.class)
    public static class ErrorTargetWithParent
    extends Component
    implements HasErrorParameter<NotFoundException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.NOT_FOUND.getCode();
        }
    }

    @RoutePrefix(value="parent")
    @Tag(value="div")
    public static class RouteParent
    extends Component
    implements RouterLayout {
        private final RouterLink loneLink = new RouterLink("lone", LoneRoute.class);

        public RouteParent() {
            this.getElement().appendChild(new Element[]{this.loneLink.getElement()});
        }
    }

    @Route(value="beforeToError/exception")
    @Tag(value="div")
    public static class RerouteToError
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteToError(IllegalArgumentException.class);
        }
    }

    @Tag(value="div")
    public static class IllegalTarget
    extends Component
    implements HasErrorParameter<IllegalArgumentException> {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<IllegalArgumentException> parameter) {
            events.add((EventObject)event);
            if (parameter.hasCustomMessage()) {
                this.getElement().setText(parameter.getCustomMessage());
            } else {
                this.getElement().setText("Illegal argument exception.");
            }
            return HttpStatusCode.INTERNAL_SERVER_ERROR.getCode();
        }
    }

    @Route(value="beforeToError/message")
    @Tag(value="div")
    public static class RerouteToErrorWithMessage
    extends Component
    implements BeforeEnterObserver,
    HasUrlParameter<String> {
        private String message;

        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteToError(IllegalArgumentException.class, this.message);
        }

        public void setParameter(BeforeEvent event, String parameter) {
            this.message = parameter;
        }
    }

    @Route(value="toNotFound")
    @Tag(value="div")
    public static class RedirectToNotFoundInHasParam
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
            event.rerouteToError(NotFoundException.class);
        }
    }

    @Route(value="toAccessDenied")
    @Tag(value="div")
    public static class RedirectToAccessDenied
    extends Component
    implements BeforeEnterObserver {
        private static final String MESSAGE = "You are not allowed";

        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteToError(AccessDeniedException.class, MESSAGE);
        }
    }

    @Route(value="forwardAndReroute/exception")
    @Tag(value="div")
    public static class ForwardingAndReroutingNavigationTarget
    extends Component
    implements BeforeEnterObserver {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
            event.forwardTo(new NavigationStateBuilder(event.getSource()).withTarget(FooBarNavigationTarget.class).build());
            event.rerouteTo(new NavigationStateBuilder(event.getSource()).withTarget(FooBarNavigationTarget.class).build());
        }
    }

    @Tag(value="div")
    public static class FaultyErrorView
    extends Component
    implements HasErrorParameter<IllegalArgumentException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<IllegalArgumentException> parameter) {
            return 0;
        }
    }

    @Route(value="loop")
    @Tag(value="div")
    public static class LoopByUINavigate
    extends Component
    implements BeforeEnterObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
            UI.getCurrent().navigate("loop");
        }
    }

    @Route(value="loop")
    @Tag(value="div")
    public static class LoopOnRouterNavigate
    extends Component
    implements BeforeEnterObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
            UI ui = UI.getCurrent();
            ui.getInternals().getRouter().navigate(ui, new Location("loop"), NavigationTrigger.PROGRAMMATIC);
        }
    }

    @Tag(value="div")
    public static class FailingErrorHandler
    extends Component
    implements HasErrorParameter<RuntimeException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<RuntimeException> parameter) {
            throw new RuntimeException(parameter.getException());
        }
    }

    @Route(value="postpone")
    @Tag(value="div")
    public static class PostponingAndResumingNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeLeave(BeforeLeaveEvent event) {
            BeforeLeaveEvent.ContinueNavigationAction action = event.postpone();
            events.add((EventObject)event);
            action.proceed();
        }
    }

    @Route(value="postpone")
    @Tag(value="div")
    public static class PostponingForeverNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeLeave(BeforeLeaveEvent event) {
            event.postpone();
            events.add((EventObject)event);
        }
    }

    @Route(value="postpone")
    @Tag(value="div")
    public static class PostponingFirstTimeNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private int counter = 0;
        private static List<BeforeLeaveEvent> events = new ArrayList<BeforeLeaveEvent>();

        public void beforeLeave(BeforeLeaveEvent event) {
            ++this.counter;
            if (this.counter < 2) {
                event.postpone();
            }
            events.add(event);
        }
    }

    @Route(value="postpone")
    @Tag(value="div")
    public static class PostponingAndResumingCompoundNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private static List<BeforeLeaveEvent> events = new ArrayList<BeforeLeaveEvent>();
        private static BeforeLeaveEvent.ContinueNavigationAction postpone;

        public PostponingAndResumingCompoundNavigationTarget() {
            this.getElement().appendChild(new Element[]{new ChildListener().getElement()});
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            postpone = event.postpone();
            events.add(event);
        }
    }

    @Tag(value="div")
    public static class ChildListener
    extends Component
    implements BeforeEnterObserver,
    BeforeLeaveObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class Translations
    extends Component
    implements LocaleChangeObserver {
        private static List<LocaleChangeEvent> events = new ArrayList<LocaleChangeEvent>();

        public void localeChange(LocaleChangeEvent event) {
            events.add(event);
        }
    }

    @Route(value="base", layout=MainLayout.class)
    @ParentLayout(value=MainLayout.class)
    @Tag(value="div")
    public static class BaseLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="sub", layout=BaseLayout.class)
    @Tag(value="div")
    public static class SubLayout
    extends Component {
    }

    @Tag(value="div")
    public static class MainLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="foo")
    @Tag(value="div")
    public static class ProceedRightAfterPospone
    extends Component
    implements BeforeLeaveObserver {
        public void beforeLeave(BeforeLeaveEvent event) {
            event.postpone().proceed();
        }
    }

    @Route(value="child", layout=RouteParent.class)
    @Tag(value="div")
    public static class RouteChild
    extends Component
    implements BeforeLeaveObserver,
    BeforeEnterObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="after-navigation-child", layout=RouteParent.class)
    @Tag(value="div")
    public static class AfterNavigationChild
    extends Component
    implements AfterNavigationObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void afterNavigation(AfterNavigationEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="after-navigation-within-same-parent", layout=RouteParent.class)
    @Tag(value="div")
    public static class AfterNavigationWithinSameParent
    extends Component
    implements AfterNavigationObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void afterNavigation(AfterNavigationEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="reroute")
    @Tag(value="div")
    public static class ReroutingOnLeaveNavigationTarget
    extends Component
    implements BeforeLeaveObserver {
        private static List<BeforeLeaveEvent> events = new ArrayList<BeforeLeaveEvent>();

        public void beforeLeave(BeforeLeaveEvent event) {
            if (events.isEmpty()) {
                events.add(event);
                event.rerouteTo(new NavigationStateBuilder(event.getSource()).withTarget(FooBarNavigationTarget.class).build());
            }
        }
    }

    @Route(value="manual")
    @Tag(value="div")
    public static class ManualNavigationTarget
    extends Component
    implements BeforeEnterObserver,
    BeforeLeaveObserver {
        private static List<String> events = new ArrayList<String>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add("Before enter");
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add("Before leave");
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class AfterNavigationTarget
    extends Component
    implements AfterNavigationObserver {
        static List<String> events = new ArrayList<String>();

        public void afterNavigation(AfterNavigationEvent event) {
            events.add("AfterNavigation Observer");
        }
    }

    @Tag(value="div")
    public static class FileNotFound
    extends Component
    implements HasErrorParameter<NotFoundException> {
        private static NavigationTrigger trigger;

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            trigger = event.getTrigger();
            return HttpStatusCode.NOT_FOUND.getCode();
        }
    }

    @Route
    @Tag(value="div")
    public static class Main
    extends Component {
    }

    @Route
    @Tag(value="div")
    public static class MainView
    extends Component {
    }

    @Route
    @Tag(value="div")
    public static class View
    extends Component {
    }

    @Route
    @Tag(value="div")
    public static class NamingConvention
    extends Component {
    }

    @Route
    @Tag(value="div")
    public static class NamingConventionView
    extends Component {
    }

    @Tag(value="div")
    @Route(value="noParent")
    @RouteAlias(value="twoParents", layout=BaseLayout.class)
    public static class AliasLayout
    extends Component {
    }

    @Route(value="1", layout=NoRemoveLayout.class)
    @Tag(value="div")
    public static class NoRemoveContent1
    extends Component {
    }

    @Route(value="2", layout=NoRemoveLayout.class)
    @Tag(value="div")
    public static class NoRemoveContent2
    extends Component {
    }

    @Tag(value="div")
    public static class NoRemoveLayout
    extends Component
    implements RouterLayout {
        public void removeRouterLayoutContent(HasElement oldContent) {
        }
    }

    @Route(value="childWithParameter", layout=RouteParent.class)
    @Tag(value="div")
    public static class RouteChildWithParameter
    extends Component
    implements BeforeLeaveObserver,
    BeforeEnterObserver,
    HasUrlParameter<String> {
        static List<EventObject> events = new ArrayList<EventObject>();
        static List<String> parameters = new ArrayList<String>();

        public void setParameter(BeforeEvent event, String parameter) {
            parameters.add(parameter);
        }

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="optional")
    @Tag(value="div")
    public static class WithoutOptionalParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Tag(value="div")
    public static class ProcessEventsBase
    extends Component
    implements BeforeLeaveObserver,
    BeforeEnterObserver,
    AfterNavigationObserver,
    HasComponents {
        static List<String> init = new ArrayList<String>();
        static List<String> beforeLeave = new ArrayList<String>();
        static List<String> beforeEnter = new ArrayList<String>();
        static List<String> afterNavigation = new ArrayList<String>();
        private String id;

        static void clear() {
            init.clear();
            beforeLeave.clear();
            beforeEnter.clear();
            afterNavigation.clear();
        }

        public ProcessEventsBase() {
            this(null);
        }

        public ProcessEventsBase(String id) {
            this.id = id != null ? id : ((Object)((Object)this)).getClass().getSimpleName();
            init.add(this.id);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            beforeLeave.add(this.id);
        }

        public void beforeEnter(BeforeEnterEvent event) {
            beforeEnter.add(this.id);
        }

        public void setParameter(BeforeEvent event, String parameter) {
            beforeEnter.add(parameter);
        }

        public void afterNavigation(AfterNavigationEvent event) {
            afterNavigation.add(this.id);
        }
    }

    @Route(value="security/document", layout=SecurityParent.class)
    public static class SecurityDocument
    extends ProcessEventsBase {
    }

    @Route(value="security/login", layout=SecurityParent.class)
    public static class SecurityLogin
    extends ProcessEventsBase {
    }

    @Route(value="event/flower", layout=ProcessEventsBranch.class)
    public static class ProcessEventsFlower
    extends ProcessEventsBase {
    }

    @Route(value="event/fruit", layout=ProcessEventsBranch.class)
    @PreserveOnRefresh
    public static class ProcessEventsFruit
    extends ProcessEventsBase {
    }

    @Route(value="event/leaf", layout=ProcessEventsBranch.class)
    public static class ProcessEventsLeaf
    extends ProcessEventsBase
    implements HasUrlParameter<String> {
        public ProcessEventsLeaf() {
            this.add(new Component[]{new ProcessEventsBase("leafChild")});
        }

        @Override
        public void setParameter(BeforeEvent event, String parameter) {
            super.setParameter(event, parameter);
        }
    }

    @Route(value="event/twig", layout=ProcessEventsStick.class)
    public static class ProcessEventsTwig
    extends ProcessEventsBase {
    }

    @Route(value="event/needle", layout=ProcessEventsBranch.class)
    @Tag(value="div")
    public static class ProcessEventsNeedle
    extends Component
    implements HasComponents,
    HasUrlParameter<String> {
        public ProcessEventsNeedle() {
            ProcessEventsBase.init.add(((Object)((Object)this)).getClass().getSimpleName());
            this.add(new Component[]{new ProcessEventsBase("needleChild")});
        }

        public void setParameter(BeforeEvent event, String parameter) {
            ProcessEventsBase.beforeEnter.add(parameter);
        }
    }

    @Route(value="", layout=ParentWithParameter.class)
    @RoutePrefix(value="link/:chainLinkID")
    @ParentLayout(value=ParentWithParameter.class)
    public static class ChainLinkWithParameter
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Route(value=":optional?/:anotherOptional?", layout=ChainLinkWithParameter.class)
    public static class TargetWithOptionalParameters
    extends RouteParametersBase {
    }

    @Route(value="target/:targetChainLinkID/bar", layout=ChainLinkWithParameter.class)
    public static class TargetWithParameter
    extends RouteParametersBase {
    }

    @Route(value=":anotherTargetID/:yetAnotherID/foo/:varargsFoo*", layout=ChainLinkWithParameterAndTarget.class)
    public static class AnotherTargetWithParameter
    extends RouteParametersBase {
    }

    @Route(value=":targetChainLinkID", layout=ParentWithParameter.class)
    @RoutePrefix(value="targetLink/:chainLinkID?/chainLink")
    @ParentLayout(value=ParentWithParameter.class)
    public static class ChainLinkWithParameterAndTarget
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Route(value=":intType(^[-+]?\\d+$)")
    @RouteAlias.Container(value={@RouteAlias(value=":stringType"), @RouteAlias(value=":intType?(^[-+]?\\d+$)/:stringType?/:varargs*(thinking|of|U|and|I)")})
    @RoutePrefix(value="param/types")
    public static class ParameterTypesView
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class RouteParametersBase
    extends Component
    implements BeforeEnterObserver,
    AfterNavigationObserver {
        static RouteParameters parameters;
        static QueryParameters queryParameters;
        static Class<? extends Component> target;
        static RouteParameters afterNavigationRouteParameters;

        static void clear() {
            parameters = null;
            queryParameters = null;
            target = null;
            afterNavigationRouteParameters = null;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            parameters = event.getRouteParameters();
            queryParameters = event.getLocation().getQueryParameters();
            target = ((Object)((Object)this)).getClass();
        }

        public void afterNavigation(AfterNavigationEvent event) {
            afterNavigationRouteParameters = event.getRouteParameters();
        }
    }

    @Route(value=":something?")
    @RouteAlias.Container(value={@RouteAlias(value=":messageID(^[-+]?\\d+$)"), @RouteAlias(value="last")})
    @RoutePrefix(value="forum/thread/:threadID(^[-+]?\\d+$)")
    public static class ParametersForumThreadView
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Route(value=":alias(framework|platform|vaadin-spring|vaadin-spring-boot)/:version?(v?\\d.*)/:path*")
    @RouteAlias.Container(value={@RouteAlias(value=":groupId(\\w[\\w\\d]+\\.[\\w\\d\\-\\.]+)/:artifactId/:version?(v?\\d.*)/:path*"), @RouteAlias(value=":path*")})
    @RoutePrefix(value="api")
    public static class ParametersApiView
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Route(value=":tabIdentifier?(api)/:apiPath*")
    @RouteAlias(value=":tabIdentifier?(overview|samples|links|reviews|discussions)")
    @RoutePrefix(value="directory/component/:urlIdentifier/:versionIdentifier?(v?\\d.*)")
    public static class DetailsView
    extends RouteParametersBase
    implements RouterLayout {
    }

    @Route(value="")
    @RouteAlias.Container(value={@RouteAlias(value="param/:regex?([0-9]*)"), @RouteAlias(value="param/:regex?([0-9]*)/edit")})
    public static class ParametersRegexView
    extends RouteParametersBase {
    }

    @Route(value="")
    @RouteAlias(value=":search?")
    @RoutePrefix(value="search")
    public static class SearchView
    extends RouteParametersBase {
    }

    @Route(value="show")
    public static class ShowAllView
    extends RouteParametersBase {
    }

    @Route(value="show/:filter?")
    public static class RedirectRouteParametersView
    extends RouteParametersBase {
        static boolean doForward = false;

        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            super.beforeEnter(event);
            event.getRouteParameters().get("filter").ifPresent(value -> {
                if (!value.equals("original")) {
                    RouteParametersBase.clear();
                    if (value.equals("wrong")) {
                        this.redirect(event, RedirectWithRouteParametersView.class, new RouteParameters("noParameter", value));
                    } else if (value.equals("all")) {
                        this.redirect(event, RedirectToView.class);
                    } else {
                        this.redirect(event, RedirectWithRouteParametersView.class, new RouteParameters("text", value));
                    }
                }
            });
        }

        private void redirect(BeforeEnterEvent event, Class<? extends Component> target) {
            if (doForward) {
                event.forwardTo(target);
            } else {
                event.rerouteTo(target);
            }
        }

        private void redirect(BeforeEnterEvent event, Class<? extends Component> target, RouteParameters parameters) {
            if (doForward) {
                event.forwardTo(target, parameters);
            } else {
                event.rerouteTo(target, parameters);
            }
        }
    }

    @Route(value="filter")
    public static class RedirectToView
    extends RouteParametersBase {
    }

    @Route(value="filter/:text")
    public static class RedirectWithRouteParametersView
    extends RouteParametersBase {
    }

    @Route(value="show/:filter?")
    public static class RedirectRouteAndQueryParametersView
    extends RouteParametersBase {
        static boolean doForward = false;

        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            super.beforeEnter(event);
            event.getRouteParameters().get("filter").ifPresent(value -> {
                if (!value.equals("original")) {
                    RouteParametersBase.clear();
                    QueryParameters queryParameters = QueryParameters.simple(Map.of("qp1", "value"));
                    if (value.equals("wrong")) {
                        this.redirect(event, RedirectWithRouteParametersView.class, new RouteParameters("noParameter", value), queryParameters);
                    } else if (value.equals("all")) {
                        this.redirect(event, RedirectToView.class, queryParameters);
                    } else {
                        this.redirect(event, RedirectWithRouteParametersView.class, new RouteParameters("text", value), queryParameters);
                    }
                }
            });
        }

        private void redirect(BeforeEnterEvent event, Class<? extends Component> target, QueryParameters queryParameters) {
            if (doForward) {
                event.forwardTo(target, queryParameters);
            } else {
                event.rerouteTo(target, queryParameters);
            }
        }

        private void redirect(BeforeEnterEvent event, Class<? extends Component> target, RouteParameters parameters, QueryParameters queryParameters) {
            if (doForward) {
                event.forwardTo(target, parameters, queryParameters);
            } else {
                event.rerouteTo(target, parameters, queryParameters);
            }
        }
    }

    @Route(value="forward/setParameter")
    @Tag(value="div")
    public static class ForwardSetParameterView
    extends Component
    implements HasUrlParameter<String>,
    AfterNavigationObserver {
        static boolean afterNavigationInvoked = false;
        static boolean backBeforeEnterInvoked = false;

        private static void clear() {
            afterNavigationInvoked = false;
            backBeforeEnterInvoked = false;
        }

        public void setParameter(BeforeEvent event, String parameter) {
            afterNavigationInvoked = false;
            event.forwardTo(ForwardSetParameterBackView.class);
        }

        public void afterNavigation(AfterNavigationEvent event) {
            afterNavigationInvoked = true;
        }
    }

    @Route(value="forward/setParameter/back")
    @Tag(value="div")
    public static class ForwardSetParameterBackView
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            ForwardSetParameterView.backBeforeEnterInvoked = true;
        }
    }

    @Route(value="forward/:path*")
    @Tag(value="div")
    public static class ForwardView
    extends Component
    implements BeforeEnterObserver {
        static String path = "";

        public ForwardView() {
            path = "";
        }

        public void beforeEnter(BeforeEnterEvent event) {
            if (event.getLocation().getSegments().size() == 1) {
                event.forwardTo("forward/default_sub_route");
            }
            path = event.getLocation().getPath();
        }
    }

    @Route(value="forwardtourl")
    @Tag(value="div")
    public static class RedirectToExternalUrl
    extends Component {
        static AtomicInteger instancesCreated = new AtomicInteger(0);

        public RedirectToExternalUrl() {
            instancesCreated.incrementAndGet();
        }
    }

    @Tag(value="div")
    @Layout
    public static class ThrowingMainLayout
    extends Component
    implements RouterLayout,
    AfterNavigationObserver {
        static List<AfterNavigationEvent> events = new ArrayList<AfterNavigationEvent>();

        public void afterNavigation(AfterNavigationEvent event) {
            events.add(event);
            throw new RuntimeException("Exception in MainLayout afterNavigation");
        }
    }

    @Route(value="error", layout=ThrowingMainLayout.class)
    @Tag(value="div")
    public static class TriggerErrorView
    extends Component {
    }

    @Tag(value="div")
    @ParentLayout(value=ThrowingMainLayout.class)
    public static class ErrorViewWithThrowingLayout
    extends Component
    implements HasErrorParameter<RuntimeException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<RuntimeException> parameter) {
            this.getElement().setText("An unexpected error occurred");
            return HttpStatusCode.INTERNAL_SERVER_ERROR.getCode();
        }
    }

    @Tag(value="div")
    public static class DuplicateNotFoundTarget
    extends Component
    implements HasErrorParameter<NotFoundException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            this.getElement().setText(RouterTest.EXCEPTION_TEXT);
            return HttpStatusCode.NOT_FOUND.getCode();
        }
    }

    @RoutePrefix(value=":parentID")
    public static class ParentWithParameter
    extends RouteParametersBase
    implements RouterLayout {
    }

    public static class SecurityParent
    extends ProcessEventsBase
    implements RouterLayout {
        @Override
        public void beforeLeave(BeforeLeaveEvent event) {
            super.beforeLeave(event);
            event.forwardTo("security/login");
        }

        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            super.beforeEnter(event);
            event.rerouteTo("security/login");
        }
    }

    @ParentLayout(value=ProcessEventsRotten.class)
    public static class ProcessEventsStick
    extends ProcessEventsBase
    implements RouterLayout {
    }

    @ParentLayout(value=ProcessEventsTrunk.class)
    public static class ProcessEventsRotten
    extends ProcessEventsBase
    implements RouterLayout {
        @Override
        public void beforeEnter(BeforeEnterEvent event) {
            super.beforeEnter(event);
            event.rerouteTo("event/flower");
        }
    }

    @ParentLayout(value=ProcessEventsTrunk.class)
    public static class ProcessEventsBranch
    extends ProcessEventsBase
    implements RouterLayout {
        public ProcessEventsBranch() {
            this.add(new Component[]{new ProcessEventsBase("branchChild1")});
            ProcessEventsBase child1 = new ProcessEventsBase("branchChild2");
            this.add(new Component[]{child1});
            child1.add(new Component[]{new ProcessEventsBase("branchChild21")});
        }
    }

    @ParentLayout(value=ProcessEventsRoot.class)
    public static class ProcessEventsTrunk
    extends ProcessEventsBase
    implements RouterLayout {
    }

    public static class ProcessEventsRoot
    extends ProcessEventsBase
    implements RouterLayout {
        public ProcessEventsRoot() {
            ProcessEventsBase child1 = new ProcessEventsBase("rootChild1");
            child1.add(new Component[]{new ProcessEventsBase("rootChild11")});
            this.add(new Component[]{child1});
            this.add(new Component[]{new ProcessEventsBase("rootChild2")});
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class ExtendingView
    extends AbstractMain {
    }

    @Tag(value="div")
    public static abstract class AbstractMain
    extends Component {
    }

    @Route(value="redirect/loop")
    @Tag(value="div")
    public static class RedirectToLoopByReroute
    extends Component
    implements BeforeEnterObserver {
        private static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
            UI.getCurrent().navigate("loop");
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class OptionalRootParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String param;

        public void setParameter(BeforeEvent event, @com.vaadin.flow.router.OptionalParameter String parameter) {
            events.add((EventObject)event);
            param = parameter;
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class WildRootParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String param;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add((EventObject)event);
            param = parameter;
        }
    }

    @Tag(value="div")
    private static class BeforeNavigation
    extends Component
    implements BeforeEnterObserver,
    BeforeLeaveObserver {
        private BeforeNavigation() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            NavigationEvents.events.add((EventObject)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            NavigationEvents.events.add((EventObject)event);
        }
    }

    @Tag(value="div")
    private static class AfterNavigation
    extends Component
    implements AfterNavigationObserver {
        private AfterNavigation() {
        }

        public void afterNavigation(AfterNavigationEvent event) {
            NavigationEvents.events.add((EventObject)event);
        }
    }

    @RoutePrefix(value="parent-with-dynamic-title")
    @Tag(value="div")
    public static class ParentWithDynamicTitle
    extends Component
    implements RouterLayout,
    HasDynamicTitle {
        public String getPageTitle() {
            return RouterTest.DYNAMIC_TITLE;
        }
    }

    @RoutePrefix(value="parent-with-title")
    @PageTitle(value="Parent Title")
    @Tag(value="div")
    public static class ParentWithTitle
    extends Component
    implements RouterLayout {
    }
}

