/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializableNodeListTest
extends AbstractNodeFeatureTest<ElementClassList> {
    private ElementClassList nodeList = (ElementClassList)this.createFeature();

    SerializableNodeListTest() {
    }

    @Test
    void testSerializable() {
        int i;
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.add(null);
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        int size = this.nodeList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            values.add(this.nodeList.get(i2));
        }
        NodeList copy = (NodeList)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)this.nodeList));
        Assertions.assertNotSame((Object)this.nodeList, (Object)copy);
        Assertions.assertEquals((int)values.size(), (int)copy.size());
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals(values.get(i), (Object)copy.get(i));
        }
        Assertions.assertEquals((int)values.size(), (int)this.nodeList.size());
        for (i = 0; i < size; ++i) {
            Assertions.assertEquals(values.get(i), (Object)this.nodeList.get(i));
        }
    }

    @Test
    void testRemoveUsingIterator() {
        this.nodeList.add((Serializable)((Object)"1"));
        this.nodeList.add((Serializable)((Object)"2"));
        this.nodeList.add((Serializable)((Object)"3"));
        this.nodeList.add((Serializable)((Object)"4"));
        this.nodeList.add((Serializable)((Object)"5"));
        this.collectChanges((NodeFeature)this.nodeList);
        Iterator i = this.nodeList.iterator();
        i.next();
        i.remove();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals((int)0, (int)((ListRemoveChange)changes.get(0)).getIndex());
        i.next();
        i.next();
        i.remove();
        changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals((int)1, (int)((ListRemoveChange)changes.get(0)).getIndex());
        ArrayList<String> actual = new ArrayList<String>();
        for (int j = 0; j < this.nodeList.size(); ++j) {
            actual.add((String)((Object)this.nodeList.get(j)));
        }
        Assertions.assertArrayEquals((Object[])new String[]{"2", "4", "5"}, (Object[])actual.toArray());
    }

    @Test
    void clearUsingIterator() {
        this.nodeList.add((Serializable)((Object)"1"));
        this.nodeList.add((Serializable)((Object)"2"));
        this.collectChanges((NodeFeature)this.nodeList);
        Iterator i = this.nodeList.iterator();
        i.next();
        i.remove();
        i.next();
        i.remove();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertEquals((int)0, (int)((ListRemoveChange)changes.get(0)).getIndex());
        Assertions.assertEquals((int)0, (int)((ListRemoveChange)changes.get(1)).getIndex());
        Assertions.assertEquals((int)0, (int)this.nodeList.size());
    }
}

