/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.BasicTypeValue;
import com.vaadin.flow.internal.nodefeature.NodeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NodeValueEmptyRequiredFeatureTest {
    private StateNode node;
    private NodeValue<Serializable> nodeValue;

    NodeValueEmptyRequiredFeatureTest() {
    }

    @BeforeEach
    void setUp() {
        this.node = new StateNode(Arrays.asList(BasicTypeValue.class), new Class[0]){

            public boolean isAttached() {
                return true;
            }
        };
        this.nodeValue = (NodeValue)this.node.getFeature(BasicTypeValue.class);
    }

    @Test
    void generateChangesFromEmpty_featureHasChangesToCollect() {
        this.nodeValue.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.node.collectChanges(change::set);
        Assertions.assertTrue((boolean)(change.get() instanceof EmptyChange));
        this.nodeValue.generateChangesFromEmpty();
        change.set(null);
        this.node.collectChanges(change::set);
        Assertions.assertNull(change.get());
    }

    @Test
    void generateChangesFromEmpty_noEmptyChange() {
        this.nodeValue.setValue((Serializable)((Object)"foo"));
        this.node.clearChanges();
        this.nodeValue.generateChangesFromEmpty();
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }

    @Test
    void collectChanges_featureHasEmptyChange() {
        this.nodeValue.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.nodeValue.collectChanges(change::set);
        Assertions.assertTrue((boolean)(change.get() instanceof EmptyChange));
        change.set(null);
        this.nodeValue.collectChanges(change::set);
        Assertions.assertNull(change.get());
    }

    @Test
    void collectChanges_noEmptyChange() {
        this.nodeValue.setValue((Serializable)((Object)"foo"));
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof MapPutChange));
    }
}

