/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StyleBindTest {
    private static MockVaadinServletService service;

    StyleBindTest() {
    }

    @BeforeAll
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterAll
    public static void clean() {
        VaadinService.setCurrent(null);
        service.destroy();
    }

    @BeforeEach
    public void before() {
        this.mockLockedSessionWithErrorHandler();
    }

    @AfterEach
    public void after() {
        VaadinService.setCurrent(null);
    }

    @Test
    public void bindingMirrorsSignalWhileAttached_updatesStyleValue() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assertions.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        color.set((Object)"blue");
        Assertions.assertEquals((Object)"blue", (Object)element.getStyle().get("backgroundColor"));
        color.set(null);
        Assertions.assertNull((Object)element.getStyle().get("backgroundColor"));
    }

    @Test
    public void detached_noUpdates_lastAppliedPreservedOnReattach() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assertions.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        color.set((Object)"green");
        Assertions.assertEquals((Object)"red", (Object)element.getStyle().get("backgroundColor"));
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertEquals((Object)"green", (Object)element.getStyle().get("backgroundColor"));
    }

    @Test
    public void conflict_setRemoveThrowWhileBoundAndActive() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"red");
        element.getStyle().bind("background-color", (Signal)color);
        Assertions.assertThrows(BindingActiveException.class, () -> element.getStyle().set("background-color", "black"));
        Assertions.assertThrows(BindingActiveException.class, () -> element.getStyle().remove("background-color"));
    }

    @Test
    public void clear_removesBindingsAndStopsUpdates() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)"1");
        ValueSignal b = new ValueSignal((Object)"2");
        element.getStyle().bind("border-top-width", (Signal)a);
        element.getStyle().bind("border-bottom-width", (Signal)b);
        Assertions.assertEquals((Object)"1", (Object)element.getStyle().get("borderTopWidth"));
        Assertions.assertEquals((Object)"2", (Object)element.getStyle().get("borderBottomWidth"));
        element.getStyle().clear();
        Assertions.assertNull((Object)element.getStyle().get("borderTopWidth"));
        Assertions.assertNull((Object)element.getStyle().get("borderBottomWidth"));
        a.set((Object)"3");
        b.set((Object)"4");
        Assertions.assertNull((Object)element.getStyle().get("borderTopWidth"));
        Assertions.assertNull((Object)element.getStyle().get("borderBottomWidth"));
    }

    @Test
    public void bind_nullSignal_throwsNPE() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertThrows(NullPointerException.class, () -> element.getStyle().bind("background-color", null));
    }

    @Test
    public void getters_returnLastAppliedAndNamesWithValues() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal a = new ValueSignal((Object)"10px");
        ValueSignal b = new ValueSignal((Object)"initial");
        element.getStyle().bind("margin-top", (Signal)a);
        element.getStyle().bind("margin-bottom", (Signal)b);
        Assertions.assertEquals((Object)"10px", (Object)element.getStyle().get("marginTop"));
        b.set(null);
        Assertions.assertNull((Object)element.getStyle().get("marginBottom"));
        Set names = element.getStyle().getNames().collect(Collectors.toSet());
        Assertions.assertTrue((boolean)names.contains("margin-top"));
        Assertions.assertTrue((boolean)names.contains("margin-bottom"));
        ValueSignal c = new ValueSignal((Object)"5px");
        UI.getCurrent().getElement().removeChild(new Element[]{element});
        element.getStyle().bind("padding-top", (Signal)c);
        Assertions.assertNull((Object)element.getStyle().get("paddingTop"));
        names = element.getStyle().getNames().collect(Collectors.toSet());
        Assertions.assertTrue((boolean)names.contains("padding-top"));
    }

    @Test
    public void nullSignalValue_removesStyleAndHasReturnsFalse() {
        Element element = new Element("div");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal color = new ValueSignal((Object)"rgba(255, 0, 0, 1)");
        element.getStyle().bind("background-color", (Signal)color);
        Assertions.assertEquals((Object)"rgba(255, 0, 0, 1)", (Object)element.getStyle().get("backgroundColor"));
        color.set(null);
        Assertions.assertNull((Object)element.getStyle().get("backgroundColor"));
        Assertions.assertFalse((boolean)element.getStyle().has("background-color"));
        Set names = element.getStyle().getNames().collect(Collectors.toSet());
        Assertions.assertTrue((boolean)names.contains("background-color"));
        color.set((Object)"rgba(0, 0, 255, 1)");
        Assertions.assertEquals((Object)"rgba(0, 0, 255, 1)", (Object)element.getStyle().get("backgroundColor"));
    }

    private void mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        new MockUI(session);
        LinkedList list = new LinkedList();
        session.setErrorHandler(list::add);
    }
}

