/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class SignalsUnitTest {
    private static MockVaadinServletService service;
    protected LinkedList<ErrorEvent> events;
    private MockUI ui;

    @BeforeAll
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterAll
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @BeforeEach
    public void before() {
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @AfterEach
    public void after() {
        Assertions.assertTrue((boolean)this.events.isEmpty());
        CurrentInstance.clearAll();
        this.events = null;
        this.ui = null;
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        VaadinSession.setCurrent((VaadinSession)session);
        this.ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }
}

