/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShortcutSerializationTest {
    ShortcutSerializationTest() {
    }

    @Test
    public void addShortcutForLifecycleOwner_serializationWorks() throws Exception {
        FakeComponent owner = new FakeComponent();
        UI ui = new UI();
        Component[] components = new Component[]{ui};
        ui.add(new Component[]{owner});
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        UI ui2 = (UI)this.deserialize(this.serialize(ui));
        Assertions.assertNotNull((Object)ui2);
    }

    @Test
    public void addAndRemoverShortcutForLifecycleOwner_serializationWorks() throws Exception {
        FakeComponent owner = new FakeComponent();
        UI ui = new UI();
        Component[] components = new Component[]{ui};
        ui.add(new Component[]{owner});
        new ShortcutRegistration((Component)owner, (SerializableSupplier & Serializable)() -> components, (ShortcutEventListener & Serializable)event -> {}, Key.KEY_A);
        ui.remove(new Component[]{owner});
        UI ui2 = (UI)this.deserialize(this.serialize(ui));
        Assertions.assertNotNull((Object)ui2);
    }

    private byte[] serialize(Object object) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(object);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
    }

    @Tag(value="imaginary-tag")
    private static class FakeComponent
    extends Component
    implements ClickNotifier<FakeComponent>,
    Focusable<FakeComponent> {
        private FakeComponent() {
        }
    }
}

