/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CleanupCallback;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.flow.signals.shared.impl.Snapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;

public abstract class SignalTree
implements Serializable {
    private final Map<Id, List<TransientListener>> observers = new HashMap<Id, List<TransientListener>>();
    private final Id id = Id.random();
    private final ReentrantLock lock = new ReentrantLock();
    private final Type type;
    private final List<CommandSubscriber> subscribers = new ArrayList<CommandSubscriber>();

    protected SignalTree(Type type) {
        assert (type != null);
        this.type = type;
    }

    public Id id() {
        return this.id;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    protected boolean hasLock() {
        return this.lock.isHeldByCurrentThread();
    }

    protected <T> @Nullable T getWithLock(ValueSupplier<T> action) {
        this.lock.lock();
        try {
            T t = action.supply();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void runWithLock(SerializableRunnable action) {
        this.lock.lock();
        try {
            action.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected CleanupCallback wrapWithLock(SerializableRunnable action) {
        return () -> this.runWithLock(action);
    }

    public CleanupCallback observeNextChange(Id nodeId, TransientListener observer) {
        assert (nodeId != null);
        assert (observer != null);
        return Objects.requireNonNull(this.getWithLock(() -> {
            assert (this.submitted().nodes().containsKey(nodeId));
            List list = this.observers.computeIfAbsent(nodeId, ignore -> new ArrayList());
            list.add(observer);
            return this.wrapWithLock(() -> list.remove(observer));
        }));
    }

    protected void notifyObservers(Snapshot oldSnapshot, Snapshot newSnapshot) {
        if (oldSnapshot == newSnapshot) {
            return;
        }
        this.runWithLock(() -> Map.copyOf(this.observers).forEach((nodeId, list) -> {
            Node.Data newNode;
            Node.Data oldNode = oldSnapshot.data((Id)nodeId).orElse(Node.EMPTY);
            if (oldNode != (newNode = newSnapshot.data((Id)nodeId).orElse(Node.EMPTY))) {
                List<TransientListener> copy = List.copyOf(list);
                list.clear();
                for (TransientListener observer : copy) {
                    boolean listenToNext = observer.invoke(false);
                    if (!listenToNext) continue;
                    list.add(observer);
                }
            }
        }));
    }

    public abstract Snapshot submitted();

    public abstract Snapshot confirmed();

    public void commitSingleCommand(SignalCommand command, @Nullable CommandsAndHandlers.CommandResultHandler resultHandler) {
        assert (command != null);
        CommandsAndHandlers commands = new CommandsAndHandlers(command, resultHandler);
        this.runWithLock(() -> {
            PendingCommit commit = this.prepareCommit(commands);
            if (commit.canCommit()) {
                commit.applyChanges();
                commit.publishChanges();
            } else {
                commit.markAsAborted();
            }
        });
    }

    public void commitSingleCommand(SignalCommand command) {
        this.commitSingleCommand(command, null);
    }

    public abstract PendingCommit prepareCommit(CommandsAndHandlers var1);

    public Type type() {
        return this.type;
    }

    public CleanupCallback subscribeToProcessed(CommandSubscriber subscriber) {
        assert (subscriber != null);
        return Objects.requireNonNull(this.getWithLock(() -> {
            this.subscribers.add(subscriber);
            return this.wrapWithLock(() -> this.subscribers.remove(subscriber));
        }));
    }

    protected void notifyProcessedCommandSubscribers(List<SignalCommand> commands, Map<Id, CommandResult> results) {
        assert (this.hasLock());
        for (SignalCommand command : commands) {
            CommandResult result = results.get(command.commandId());
            if (result == null) {
                throw new IllegalStateException("Missing result for command " + String.valueOf(command.commandId()));
            }
            for (CommandSubscriber subscriber : this.subscribers) {
                subscriber.onCommandProcessed(command, result);
            }
        }
    }

    public static enum Type {
        ASYNCHRONOUS,
        COMPUTED,
        SYNCHRONOUS;

    }

    @FunctionalInterface
    public static interface CommandSubscriber
    extends Serializable {
        public void onCommandProcessed(SignalCommand var1, CommandResult var2);
    }

    public static interface PendingCommit
    extends Serializable {
        public boolean canCommit();

        public void applyChanges();

        public void markAsAborted();

        public void publishChanges();
    }
}

