/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.flow.signals.function.CleanupCallback;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.function.SerializableExecutor;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

public class Effect
implements Serializable {
    private static final ThreadLocal<LinkedList<Effect>> activeEffects = ThreadLocal.withInitial(() -> new LinkedList());
    private SerializableExecutor dispatcher;
    private final List<CleanupCallback> registrations = new ArrayList<CleanupCallback>();
    private @Nullable SerializableRunnable action;
    private final AtomicBoolean invalidateScheduled = new AtomicBoolean(false);

    public Effect(EffectAction action) {
        this(action, SignalEnvironment.getDefaultEffectDispatcher()::execute);
    }

    public Effect(EffectAction action, SerializableExecutor dispatcher) {
        assert (action != null);
        this.action = () -> {
            try {
                action.execute();
            }
            catch (Exception e) {
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
            }
            catch (Error e) {
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, new Error("Uncaught error from effect. The effect will no longer be active.", e));
                this.dispose();
            }
        };
        assert (dispatcher != null);
        this.dispatcher = dispatcher;
        dispatcher.execute(() -> {
            Effect effect = this;
            synchronized (effect) {
                this.revalidate();
            }
        });
    }

    private void revalidate() {
        assert (this.registrations.isEmpty());
        if (this.action == null) {
            return;
        }
        activeEffects.get().add(this);
        try {
            UsageTracker.track(this.action, usage -> {
                TransientListener usageListener = new TransientListener(){

                    @Override
                    public boolean invoke(boolean immediate) {
                        return Effect.this.onDependencyChange(immediate);
                    }
                };
                this.registrations.add(usage.onNextChange(usageListener));
            });
        }
        finally {
            Effect removed = activeEffects.get().removeLast();
            assert (removed == this);
        }
    }

    private boolean onDependencyChange(boolean immediate) {
        if (!immediate && activeEffects.get().contains(this)) {
            this.dispose();
            throw new IllegalStateException("Infinite loop detected between effect updates. This effect is deactivated.");
        }
        this.scheduleInvalidate();
        return false;
    }

    private void scheduleInvalidate() {
        if (this.invalidateScheduled.compareAndSet(false, true)) {
            LinkedList inheritedActive = new LinkedList(activeEffects.get());
            this.dispatcher.execute(() -> {
                LinkedList<Effect> oldActive = activeEffects.get();
                activeEffects.set(inheritedActive);
                try {
                    this.invalidate();
                }
                finally {
                    activeEffects.set(oldActive);
                }
            });
        }
    }

    private synchronized void invalidate() {
        this.invalidateScheduled.set(false);
        this.clearRegistrations();
        this.revalidate();
    }

    private void clearRegistrations() {
        this.registrations.forEach(CleanupCallback::cleanup);
        this.registrations.clear();
    }

    public synchronized void dispose() {
        this.clearRegistrations();
        this.action = null;
    }
}

