/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.flow.signals.function.EffectAction;
import com.vaadin.flow.signals.impl.Effect;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ElementEffect
implements Serializable {
    private final SerializableRunnable effectFunction;
    private boolean closed = false;
    private Effect effect = null;
    private Registration detachRegistration;

    public ElementEffect(Element owner, SerializableRunnable effectFunction) {
        Objects.requireNonNull(owner, "Owner element cannot be null");
        Objects.requireNonNull(effectFunction, "Effect function cannot be null");
        this.effectFunction = effectFunction;
        owner.addAttachListener(attach -> {
            this.enableEffect(attach.getSource());
            this.detachRegistration = owner.addDetachListener(detach -> {
                this.disableEffect();
                this.detachRegistration.remove();
                this.detachRegistration = null;
            });
        });
        if (owner.getNode().isAttached()) {
            this.enableEffect(owner);
            this.detachRegistration = owner.addDetachListener(detach -> {
                this.disableEffect();
                this.detachRegistration.remove();
                this.detachRegistration = null;
            });
        }
    }

    public static Registration effect(Element owner, SerializableRunnable effectFunction) {
        ElementEffect effect = new ElementEffect(owner, effectFunction);
        return effect::close;
    }

    public static <T> Registration bind(Element owner, Signal<T> signal, SerializableBiConsumer<Element, T> setter) {
        return ElementEffect.effect(owner, () -> setter.accept(owner, signal.get()));
    }

    private void enableEffect(Element owner) {
        if (this.closed) {
            return;
        }
        Component parentComponent = ComponentUtil.findParentComponent(owner).get();
        UI ui = parentComponent.getUI().get();
        EffectAction errorHandlingEffectFunction = () -> {
            try {
                this.effectFunction.run();
            }
            catch (Exception e) {
                ui.getSession().getErrorHandler().error(new ErrorEvent(e, owner.getNode()));
            }
        };
        assert (this.effect == null);
        this.effect = new Effect(errorHandlingEffectFunction, command -> {
            if (UI.getCurrent() == ui) {
                command.run();
            } else {
                SignalEnvironment.getDefaultEffectDispatcher().execute(() -> {
                    try {
                        if (this.effect != null) {
                            ui.access(command::run);
                        }
                    }
                    catch (UIDetachedException uIDetachedException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private void disableEffect() {
        if (this.effect != null) {
            this.effect.dispose();
            this.effect = null;
        }
    }

    public void close() {
        this.disableEffect();
        this.closed = true;
    }

    public static <T, S extends Signal<T>> Registration bindChildren(Element parentElement, Signal<List<S>> list, SerializableFunction<S, Element> childFactory) {
        Objects.requireNonNull(parentElement, "Parent element cannot be null");
        Objects.requireNonNull(parentElement, "Parent element cannot be null");
        Objects.requireNonNull(list, "List signal cannot be null");
        Objects.requireNonNull(childFactory, "Child element factory cannot be null");
        if (parentElement.getChildCount() > 0) {
            throw new IllegalStateException("Parent element must not have children when binding a list signal to it");
        }
        HashMap valueSignalToChildCache = new HashMap();
        return new ElementEffect(parentElement, () -> ElementEffect.runEffect(new BindChildrenEffectContext(parentElement, (List)list.get(), childFactory, valueSignalToChildCache)))::close;
    }

    private static <T, S extends Signal<T>> void runEffect(BindChildrenEffectContext<T, S> context) {
        LinkedList<Element> remainingChildren = context.parentChildrenToLinkedList();
        HashSet<Element> remainingChildrenSet = new HashSet<Element>(remainingChildren);
        if (remainingChildren.size() != context.getCachedChildrenSize()) {
            throw new IllegalStateException("Parent element must have children matching the list signal. Unexpected child count: " + remainingChildren.size() + ", expected: " + context.getCachedChildrenSize());
        }
        ElementEffect.removeNotPresentChildren(context, remainingChildrenSet);
        ElementEffect.updateByChildSignals(context, remainingChildren, remainingChildrenSet);
        ElementEffect.validate(context);
    }

    private static <T, S extends Signal<T>> void validate(BindChildrenEffectContext<T, S> context) {
        LinkedList<Element> children = context.parentChildrenToLinkedList();
        int index = 0;
        for (Element actualElement : children) {
            if (index >= context.childSignalsList.size()) {
                throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Unexpected child at index %1$s: %2$s, expected: %3$s", index, actualElement, "none"));
            }
            Element expectedElement = context.valueSignalToChildCache.get(context.childSignalsList.get(index));
            if (!Objects.equals(actualElement, expectedElement)) {
                throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Unexpected child at index %1$s: %2$s, expected: %3$s", index, actualElement, expectedElement));
            }
            ++index;
        }
        if (children.size() > context.getCachedChildrenSize()) {
            throw new IllegalStateException(String.format("Parent element must have children matching the list signal. Too many children: %1$s, expected: %2$s", children.size(), context.getCachedChildrenSize()));
        }
    }

    private static <T, S extends Signal<T>> void removeNotPresentChildren(BindChildrenEffectContext<T, S> context, HashSet<Element> remainingChildrenSet) {
        HashSet toRemove = new HashSet(context.valueSignalToChildCache.keySet());
        context.childSignalsList.forEach(toRemove::remove);
        for (Signal removedItem : toRemove) {
            Element element = context.valueSignalToChildCache.remove(removedItem);
            element.removeFromParent();
            remainingChildrenSet.remove(element);
        }
    }

    private static <T, S extends Signal<T>> void updateByChildSignals(BindChildrenEffectContext<T, S> context, LinkedList<Element> remainingChildren, HashSet<Element> remainingChildrenSet) {
        for (int i = 0; i < context.childSignalsList.size(); ++i) {
            Signal item = (Signal)context.childSignalsList.get(i);
            Element expectedChild = context.getElement(item);
            if (remainingChildrenSet.isEmpty() || !Objects.equals(expectedChild.getParent(), context.parentElement)) {
                context.parentElement.insertChild(i, expectedChild);
                continue;
            }
            Element actualChild = remainingChildren.pollFirst();
            while (actualChild != null && !remainingChildrenSet.contains(actualChild)) {
                actualChild = remainingChildren.pollFirst();
            }
            if (actualChild == null || Objects.equals(actualChild, expectedChild)) continue;
            if (Objects.equals(expectedChild, remainingChildren.peek())) {
                actualChild.removeFromParent();
                remainingChildren.pollFirst();
                continue;
            }
            context.parentElement.insertChild(i, expectedChild);
            remainingChildrenSet.remove(expectedChild);
            remainingChildren.addFirst(actualChild);
        }
    }

    private record BindChildrenEffectContext<T, S extends Signal<T>>(Element parentElement, List<S> childSignalsList, SerializableFunction<S, Element> childElementFactory, HashMap<S, Element> valueSignalToChildCache) implements Serializable
    {
        private Element getElement(S item) {
            return this.valueSignalToChildCache.computeIfAbsent(item, this.childElementFactory);
        }

        private int getCachedChildrenSize() {
            return this.valueSignalToChildCache.size();
        }

        private LinkedList<Element> parentChildrenToLinkedList() {
            return this.parentElement.getChildren().collect(Collectors.toCollection(LinkedList::new));
        }
    }
}

